//#include <windows.h>
//#include <shlobj.h>
#include <stdio.h>
#include "file.h"

OPENFILENAME								FileDialog;

// Initialises the file dialog 
void InitFileDialog(HWND hwnd, char *pInitialDir, char *pFilter, DWORD Flags)
{
	FileDialog.lStructSize		= sizeof(OPENFILENAME);
	FileDialog.hwndOwner		= hwnd;
	FileDialog.hInstance		= 0;
	FileDialog.lpstrFilter		= pFilter;
	FileDialog.lpstrCustomFilter= 0;
	FileDialog.nMaxCustFilter	= 0;
	FileDialog.nFilterIndex		= 0;
	FileDialog.lpstrFile		= 0;
	FileDialog.nMaxFile			= _MAX_PATH;
	FileDialog.lpstrFileTitle	= NULL;
	FileDialog.nMaxFileTitle	= _MAX_FNAME + _MAX_EXT;
	FileDialog.lpstrInitialDir	= pInitialDir;
	FileDialog.lpstrTitle		= NULL;
	FileDialog.Flags			= Flags;
	FileDialog.nFileOffset		= 0;
	FileDialog.nFileExtension	= 0;
	FileDialog.lpstrDefExt		= NULL;
	FileDialog.lCustData		= 0L;
	FileDialog.lpfnHook			= NULL;
	FileDialog.lpTemplateName	= NULL;
}

// Sets up a file dialog for a load, and obtains the load name
BOOL GetLoadFileFromDialog(HWND hwnd, char *pTitle, char *pBuffer)
{
	memset(pBuffer, 0, strlen(pBuffer));

	FileDialog.hwndOwner		= hwnd;
	FileDialog.lpstrFile		= pBuffer;
	FileDialog.Flags			&= (~OFN_HIDEREADONLY);
	FileDialog.lpstrTitle		= pTitle;

	return GetOpenFileName(&FileDialog);
}

// Sets up a file dialog for a save, and obtains the save name
BOOL GetSaveFileFromDialog(HWND hwnd, char *pTitle, char *pBuffer)
{
	memset(pBuffer, 0, strlen(pBuffer));

	FileDialog.hwndOwner		= hwnd;
	FileDialog.lpstrFile		= pBuffer;
	FileDialog.Flags			|= OFN_HIDEREADONLY;
	FileDialog.lpstrTitle		= pTitle;

	return GetSaveFileName(&FileDialog);
}

BOOL BrowseForDirectory(HWND hwnd, LPSTR DirName, LPCSTR Prompt)
{ 
	BROWSEINFO bi;
	LPITEMIDLIST pidlDrives;	// PIDL for Drives folder
	LPITEMIDLIST pidlBrowse;	// PIDL selected by user
	LPMALLOC g_pMalloc; 

	/* Get the shell's allocator */
	if (!SUCCEEDED(SHGetMalloc(&g_pMalloc)))
		return FALSE;
 
	/* Get the PIDL for the Drives folder. */
	if (!SUCCEEDED(SHGetSpecialFolderLocation(hwnd, /*CSIDL_DRIVES*/ /*CSIDL_NETWORK*/ CSIDL_DESKTOP, &pidlDrives))) {
		g_pMalloc->lpVtbl->Release(g_pMalloc);
		return FALSE;
	}

	/* Fill in the BROWSEINFO structure. */
	bi.hwndOwner = hwnd;
	bi.pidlRoot = pidlDrives;
	bi.pszDisplayName = DirName;		// no path output
	if (Prompt == NULL)
		bi.lpszTitle = "Chosen Directory:";
	else
		bi.lpszTitle = Prompt;
	bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_STATUSTEXT;
	bi.lpfn = GetDirFunc;
	bi.lParam = (long)DirName;

	/* Browser Dialog (And Get Directories PIDL) */
	pidlBrowse = SHBrowseForFolder(&bi);
	if (pidlBrowse == NULL) {
		g_pMalloc->lpVtbl->Free(g_pMalloc, pidlDrives);
		g_pMalloc->lpVtbl->Release(g_pMalloc);
		return FALSE;
	}

	/* Get Full Path Name */
	SHGetPathFromIDList(pidlBrowse, DirName);

	/* Free the browse PIDL */
	g_pMalloc->lpVtbl->Free(g_pMalloc, pidlBrowse);

	/* Free the Drives pidl */
	g_pMalloc->lpVtbl->Free(g_pMalloc, pidlDrives);

	/* Release the shell's allocator */
	g_pMalloc->lpVtbl->Release(g_pMalloc);
  
	if (DirName[strlen(DirName) - 1] != '\\') strcat(DirName, "\\");

	return TRUE;
}


int CALLBACK GetDirFunc(HWND hwnd, UINT uMsg, LPARAM lpData, LPARAM lParam)
{
	char str[MAX_PATH];

	if (uMsg == BFFM_INITIALIZED) {
		SendMessage(hwnd, BFFM_SETSELECTION, TRUE, lParam);
	} else if (uMsg == BFFM_SELCHANGED) {
		SHGetPathFromIDList((LPITEMIDLIST)lpData, str);
		if (str[0]==(char)0)
			SendMessage(hwnd, BFFM_SETSTATUSTEXT, (WPARAM)0, (LPARAM)"<None>");
		else
			SendMessage(hwnd, BFFM_SETSTATUSTEXT, (WPARAM)0, (LPARAM)str);
	}
	return 0;
}
