#include "timer.h"

uint8 timer_regs[2];
int32 timer_cycles;
bool   timer_activated;

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void timer_init()
{
	//fprintf(log_get(), "timer: init\n");
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void timer_done()
{
	//fprintf(log_get(), "timer: done\n");
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void timer_reset()
{
	//fprintf(log_get(), "timer: reset\n");
	memset(timer_regs, 0, 2);
	timer_cycles = 0;
	timer_activated = false;
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void timer_write(uint32 addr, uint8 data)
{
//	fprintf(log_get(), "timer: writing 0x%.2x at 0x%.4x\n", data, addr);
	timer_regs[addr&0x01] = data;

	if (addr&0x01)
	{
		timer_cycles = ((uint32)data)*256;
		timer_activated = true;
		timer_regs[0]&=0xfe;
	}
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint8 timer_read(uint32 addr)
{
	return(timer_regs[addr&0x01]);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void timer_exec(uint32 cycles)
{
	if (timer_activated)
	{
		timer_cycles-=cycles;
		
		if (timer_cycles<0)
		{
			timer_regs[0]|=0x01;
//			fprintf(log_get(), "timer: irq\n");
			interrupts_irq();
			timer_activated=false;
		}
	}
}
