////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
__inline void supervision_drawDoubledScanline(int16 *vs, int16 *backbuffer_alias)
{
	register int32	*vs_alias=(int32*)vs;
	register int32	data;

	for (int pixel=0;pixel<160;pixel+=8)
	{
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
	}
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
__inline void supervision_drawDoubledRotatedScanline(int16 *vs, int16 *backbuffer_alias)
{
	register int32	*vs_alias=(int32*)vs;
	register int32	data;

	for (int pixel=0;pixel<160;pixel+=8)
	{
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
	}
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint16	supervision_halfBrightnessTable[32];
#define M_HALFBRIGHTNESS(D) (supervision_halfBrightnessTable[(D>>10)&0x1f]<<10)|(supervision_halfBrightnessTable[(D>>5)&0x1f]<<5)|(supervision_halfBrightnessTable[D&0x1f]);

__inline void supervision_drawDoubledHalfBrightnessScanline(int16 *vs, int16 *backbuffer_alias)
{
	register int32	*vs_alias=(int32*)vs;
	register int32	data;
	
	for (int pixel=0;pixel<160;pixel+=4)
	{
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
	}
}

__inline void supervision_drawDoubledHalfBrightnessScanlineSpecialEven(int16 *vs, int16 *backbuffer_alias)
{
	register int32	*vs_alias=(int32*)vs;
	register int32	data;
	
	for (int pixel=0;pixel<160;pixel+=4)
	{
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
	}
}
__inline void supervision_drawDoubledHalfBrightnessScanlineSpecialOdd(int16 *vs, int16 *backbuffer_alias)
{
	register int32	*vs_alias=(int32*)vs;
	register int32	data;
	
	for (int pixel=0;pixel<160;pixel+=4)
	{
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
	}
}
__inline void supervision_drawDoubledHalfBrightnessRotatedScanline(int16 *vs, int16 *backbuffer_alias)
{
	register int32	*vs_alias=(int32*)vs;
	register int32	data;
	
	for (int pixel=0;pixel<160;pixel+=4)
	{
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
	}
}

__inline void supervision_drawDoubledHalfBrightnessRotatedScanlineSpecialEven(int16 *vs, int16 *backbuffer_alias)
{
	register int32	*vs_alias=(int32*)vs;
	register int32	data;
	
	for (int pixel=0;pixel<160;pixel+=4)
	{
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
	}
}
__inline void supervision_drawDoubledHalfBrightnessRotatedScanlineSpecialOdd(int16 *vs, int16 *backbuffer_alias)
{
	register int32	*vs_alias=(int32*)vs;
	register int32	data;
	
	for (int pixel=0;pixel<160;pixel+=4)
	{
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data|=(data<<16); *vs_alias++=data; 
		data=*backbuffer_alias++; data=M_HALFBRIGHTNESS(data); data|=(data<<16); *vs_alias++=data; 
	}
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void supervision_emulate_doubled(void)
{
	#include "filter_partA.h"
	if (app_rotated)
	{
		surface=new Surface(160*2,160*2,format);
		#include "filter_partB.h"
		console.open(app_window_title,160*2,160*2,format);
		while (1)
		{
				#include "filter_partC.h"
				console.open(app_window_title,160*2,160*2,format);
				#include "filter_partD.h"
				supervision_rotate_backbuffer(backbuffer);
				int16 *vs = (int16 *)surface->lock();
				int16	*backbuffer_alias=backbuffer;
				for (int line=0;line<160;line++)
				{
					supervision_drawDoubledRotatedScanline(vs,backbuffer_alias);
					vs+=surfacePitch;
					supervision_drawDoubledRotatedScanline(vs,backbuffer_alias);
					vs+=surfacePitch;
					backbuffer_alias+=160;
				}
				surface->unlock();
				surface->copy(console);
				console.update();
			}
		}
		#include "filter_partE.h"
	}
	else
	{
		surface=new Surface(160*2,160*2,format);
		#include "filter_partB.h"
		console.open(app_window_title,160*2,160*2,format);
		while (1)
		{
				#include "filter_partC.h"
				console.open(app_window_title,160*2,160*2,format);
				#include "filter_partD.h"
				int16 *vs = (int16 *)surface->lock();
				int16	*backbuffer_alias=backbuffer;
				for (int line=0;line<160;line++)
				{
					supervision_drawDoubledScanline(vs,backbuffer_alias);
					vs+=surfacePitch;
					supervision_drawDoubledScanline(vs,backbuffer_alias);
					vs+=surfacePitch;
					backbuffer_alias+=160;
				}
				surface->unlock();
				surface->copy(console);
				console.update();
			}
		}
		#include "filter_partE.h"
	}
}
