/*
 * VisualBoyAdvanced - Nintendo Gameboy/GameboyAdvance (TM) emulator
 * Copyrigh(c) 1999-2002 Forgotten (vb@emuhq.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
extern int gbRomSizeMask2;
extern int gbRomSize2;
extern int gbRamSize2;
extern int gbRamSizeMask2;

extern u8 *gbRom2;
extern u8 *gbRam2;
extern u8 *gbVram2;
extern u8 *gbWram2;
extern u8 *gbMemory2;
extern u16 *gbLineBuffer2;

extern u8 *gbMemoryMap2[16];

extern int gbFrameSkip2;
extern u16 gbColorFilter2[32768];
extern int gbColorOption2;
extern int gbPaletteOption2;
extern int gbEmulatorType2;
extern int gbBorderOn2;
extern int gbBorderAutomatic2;
extern int gbCgbMode2;
extern int gbSgbMode2;
extern int gbWindowLine2;
extern int gbSpeed2;
extern u8 gbBgp2[4];
extern u8 gbObp02[4];
extern u8 gbObp12[4];
extern u16 gbPalette2[128];

extern u8 register_LCDC2;
extern u8 register_LY2;
extern u8 register_SCY2;
extern u8 register_SCX2;
extern u8 register_WY2;
extern u8 register_WX2;
extern u8 register_VBK2;

extern int emulating;

extern int gbBorderLineSkip2;
extern int gbBorderRowSkip2;
extern int gbBorderColumnSkip2;
extern int gbDmaTicks2;

extern void gbRenderLine2();
extern void gbDrawSprites2();

extern u8 (*gbSerialFunction2)(u8);



#define gbRomSizeMask           gbRomSizeMask2              
#define gbRomSize               gbRomSize2                  
#define gbRamSize               gbRamSize2                  
#define gbRamSizeMask           gbRamSizeMask2              
                                                             
#define gbRom                   gbRom2                      
#define gbRam                   gbRam2                      
#define gbVram                  gbVram2                     
#define gbWram                  gbWram2                     
#define gbMemory                gbMemory2                   
#define gbLineBuffer            gbLineBuffer2               
                                                             
#define gbMemoryMap             gbMemoryMap2                
                                                             
#define gbFrameSkip             gbFrameSkip2                
#define gbColorFilter           gbColorFilter2              
#define gbColorOption           gbColorOption2              
#define gbPaletteOption         gbPaletteOption2            
#define gbEmulatorType          gbEmulatorType2             
#define gbBorderOn              gbBorderOn2                 
#define gbBorderAutomatic       gbBorderAutomatic2          
#define gbCgbMode               gbCgbMode2                  
#define gbSgbMode               gbSgbMode2                  
#define gbWindowLine            gbWindowLine2               
#define gbSpeed                 gbSpeed2                    
#define gbBgp                   gbBgp2                      
#define gbObp0                  gbObp02                     
#define gbObp1                  gbObp12                     
#define gbPalette               gbPalette2                  
                                                             
#define register_LCDC           register_LCDC2              
#define register_LY             register_LY2                
#define register_SCY            register_SCY2               
#define register_SCX            register_SCX2               
#define register_WY             register_WY2                
#define register_WX             register_WX2                
#define register_VBK            register_VBK2               
                                                             
//#define emulating               emulating2                  
                                                             
#define gbBorderLineSkip        gbBorderLineSkip2           
#define gbBorderRowSkip         gbBorderRowSkip2            
#define gbBorderColumnSkip      gbBorderColumnSkip2         
#define gbDmaTicks              gbDmaTicks2                 
                                                             
#define gbRenderLine            gbRenderLine2               
#define gbDrawSprites           gbDrawSprites2              
                                                             
#define gbSerialFunction        gbSerialFunction2           



