// VisualBoyAdvance - Nintendo Gameboy/GameboyAdvance (TM) emulator.
// Copyright (C) 1999-2003 Forgotten
// Copyright (C) 2005 Forgotten and the VBA development team

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or(at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "hq_shared32.h"

void hq3x32(unsigned char * pIn,  unsigned int srcPitch,
			unsigned char *,
			unsigned char * pOut, unsigned int dstPitch,
			int Xres, int Yres)
{
	unsigned int YUV1, YUV2;
	int i, j, k;
	unsigned int line;
	unsigned int c[10];

	// +----+----+----+
	// |    |    |    |
	// | c1 | c2 | c3 |
	// +----+----+----+
	// |    |    |    |
	// | c4 | c5 | c6 |
	// +----+----+----+
	// |    |    |    |
	// | c7 | c8 | c9 |
	// +----+----+----+

	for (j=0; j<Yres; j++)
	{
		if ( (j>0) || (j<Yres-1) ) line = srcPitch; else line = 0;

		for (i=0; i<Xres; i++)
		{
			c[2] = *((unsigned int*)(pIn - line));
			c[5] = *((unsigned int*)(pIn        ));
			c[8] = *((unsigned int*)(pIn + line));

			if (i>0)
			{
				c[1] = *((unsigned int*)(pIn - line - SIZE_PIXEL));
				c[4] = *((unsigned int*)(pIn        - SIZE_PIXEL));
				c[7] = *((unsigned int*)(pIn + line - SIZE_PIXEL));
			}
			else
			{
				c[1] = c[2];
				c[4] = c[5];
				c[7] = c[8];
			}

			if (i<Xres-1)
			{
				c[3] = *((unsigned int*)(pIn - line + SIZE_PIXEL));
				c[6] = *((unsigned int*)(pIn        + SIZE_PIXEL));
				c[9] = *((unsigned int*)(pIn + line + SIZE_PIXEL));
			}
			else
			{
				c[3] = c[2];
				c[6] = c[5];
				c[9] = c[8];
			}

			int pattern = 0;
			int flag = 1;

			YUV1 = RGBtoYUV(c[5]);

			for (k=1; k<=9; k++)
			{
				if (k==5) continue;

				if ( c[k] != c[5] )
				{
					YUV2 = RGBtoYUV(c[k]);
					if (
						( abs32((YUV1 & Ymask) - (YUV2 & Ymask)) > trY ) ||
						( abs32((YUV1 & Umask) - (YUV2 & Umask)) > trU ) ||
						( abs32((YUV1 & Vmask) - (YUV2 & Vmask)) > trV )
						)
						pattern |= flag;
				}
				flag <<= 1;
			}

#include "hq3x32.h"
			pIn+=SIZE_PIXEL;
			pOut+=3<<2;
		}
		pIn+=srcPitch-(Xres<<2);
		pOut+=dstPitch-(3*Xres<<2);
		pOut+=dstPitch<<1;
		//	pIn+=SIZE_PIXEL;
		//	pOut+=3*SIZE_PIXEL;
		//}
		//pIn+=srcPitch-(4*Xres);
		//pOut+=dstPitch-(3*Xres*SIZE_PIXEL);
		//pOut+=2*dstPitch;
	}
}