// VisualBoyAdvance - Nintendo Gameboy / Gameboy Advance (TM) emulator
// Copyright (C) 1999-2003 Forgotten
// Copyright (C) 2006 VBA development team
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#pragma once

enum IMAGE_TYPE
{
	IMAGE_UNKNOWN = -1,
	IMAGE_GBA     = 0,
	IMAGE_GB      = 1
};

// save game
typedef struct
{
	void *address;
	int size;
} variable_desc;

bool utilWritePNGFile(const char *, int, int, u8 *);
bool utilWriteBMPFile(const char *, int, int, u8 *);
void utilApplyIPS(const char *ips, u8 **rom, int *size);
void utilWriteBMP(char *, int, int, u8 *);
bool utilIsGBAImage(const char *);
bool utilIsGBImage(const char *);
bool utilIsZipFile(const char *);
bool utilIsGzipFile(const char *);
bool utilIsRarFile(const char *);
void utilGetBaseName(const char *, char *);
IMAGE_TYPE utilFindType(const char *);
u8 *utilLoad(const char *, bool (*)(const char*), u8 *, int &);
void utilPutDword(u8 *, u32);
void utilPutWord(u8 *, u16);
void utilWriteData(gzFile, variable_desc *);
void utilReadData(gzFile, variable_desc *);
int utilReadInt(gzFile);
void utilWriteInt(gzFile, int);
gzFile utilGzOpen(const char *file, const char *mode);
gzFile utilMemGzOpen(char *memory, int available, char *mode);
int utilGzWrite(gzFile file, const voidp buffer, unsigned int len);
int utilGzRead(gzFile file, voidp buffer, unsigned int len);
int utilGzClose(gzFile file);
long utilGzMemTell(gzFile file);
void utilGBAFindSave(const u8 *, const int);
void utilUpdateSystemColorMaps();