// OptionsInput.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "VBA.h"
#include "OptionsInput.h"
#include ".\optionsinput.h"

#include "Joypad.h"
#include "RewindInterval.h"
#include "Reg.h"


// COptionsInput-Dialogfeld

IMPLEMENT_DYNAMIC(COptionsInput, CPropertyPage)
COptionsInput::COptionsInput()
	: CPropertyPage(COptionsInput::IDD)
	, radio_configuration(FALSE)
	, check_autoa(FALSE)
	, check_autob(FALSE)
	, check_autol(FALSE)
	, check_autor(FALSE)
{
}

COptionsInput::~COptionsInput()
{
}

void COptionsInput::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_CONFIG1, radio_configuration);
	DDX_Check(pDX, IDC_AUTOA, check_autoa);
	DDX_Check(pDX, IDC_AUTOB, check_autob);
	DDX_Check(pDX, IDC_AUTOL, check_autol);
	DDX_Check(pDX, IDC_AUTOR, check_autor);
}


BEGIN_MESSAGE_MAP(COptionsInput, CPropertyPage)
	ON_BN_CLICKED(IDC_SETKEYS, OnBnClickedSetkeys)
	ON_BN_CLICKED(IDC_SETREWINDINTERVAL, OnBnClickedSetrewindinterval)
	ON_BN_CLICKED(IDC_MOTIONSENSOR, OnBnClickedMotionsensor)
END_MESSAGE_MAP()


// COptionsInput-Meldungshandler

void COptionsInput::OnBnClickedSetkeys()
{
	UpdateData(TRUE);
	theApp.winCheckFullscreen();
	JoypadConfig dlg(radio_configuration);
	dlg.DoModal();
}

void COptionsInput::OnBnClickedSetrewindinterval()
{
	RewindInterval dlg(theApp.rewindTimer/6);
	int v = dlg.DoModal();

	if(v >= 0)
	{
		theApp.rewindTimer = v*6; // convert to a multiple of 10 frames
		regSetDwordValue("rewindTimer", v);
		if(v == 0)
		{
			if(theApp.rewindMemory)
				free(theApp.rewindMemory);
			theApp.rewindMemory = NULL;
			theApp.rewindCount = 0;
			theApp.rewindCounter = 0;
			theApp.rewindSaveNeeded = false;
		}
		else
		{
			if(theApp.rewindMemory == NULL)
				theApp.rewindMemory = (char *)malloc(8*REWIND_SIZE);
		}
	}
}

void COptionsInput::OnBnClickedMotionsensor()
{
	theApp.winCheckFullscreen();
	MotionConfig dlg;
	dlg.DoModal();
}
