// OptionsEmulator.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "VBA.h"
#include "OptionsEmulator.h"

#include "Associate.h"
#include "Directories.h"
#include "FileDlg.h"
#include "WinResUtil.h"
#include "GBColorDlg.h"

#include "gbGlobals.h"
#include "Util.h"


// COptionsEmulator-Dialogfeld

IMPLEMENT_DYNAMIC(COptionsEmulator, CPropertyPage)
COptionsEmulator::COptionsEmulator()
	: CPropertyPage(COptionsEmulator::IDD)
	, check_usebios_value(FALSE)
	, check_skipbios_value(FALSE)
	, check_autohidemenu_value(FALSE)
	, check_pausewheninactive_value(FALSE)
	, check_automaticipspatching_value(FALSE)
	, combo_priority_value(0)
	, combo_savetype_value(0)
	, combo_screenshotformat_value(0)
	, check_genericflashcard_value(FALSE)
	, combo_emulatedsystem_value(0)
	, check_pallidcolors_value(FALSE)
{
}

COptionsEmulator::~COptionsEmulator()
{
}

void COptionsEmulator::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_USEBIOS, check_usebios_value);
	DDX_Check(pDX, IDC_SKIPBIOS, check_skipbios_value);
	DDX_Check(pDX, IDC_AUTOHIDEMENU, check_autohidemenu_value);
	DDX_Check(pDX, IDC_PAUSEWHENINACTIVE, check_pausewheninactive_value);
	DDX_Check(pDX, IDC_AUTOMATICIPSPATCHING, check_automaticipspatching_value);
	DDX_CBIndex(pDX, IDC_PRIORITY, combo_priority_value);
	DDX_CBIndex(pDX, IDC_SAVETYPE, combo_savetype_value);
	DDX_CBIndex(pDX, IDC_SCREENSHOTFORMAT, combo_screenshotformat_value);
	DDX_Check(pDX, IDC_GENERICFLASHCARD, check_genericflashcard_value);
	DDX_CBIndex(pDX, IDC_EMULATEDSYSTEM, combo_emulatedsystem_value);
	DDX_Check(pDX, IDC_PALLIDCOLORS, check_pallidcolors_value);
}


BEGIN_MESSAGE_MAP(COptionsEmulator, CPropertyPage)
	ON_BN_CLICKED(IDC_FILTETYPES, OnBnClickedFiltetypes)
	ON_BN_CLICKED(IDC_DIRECTORIES, OnBnClickedDirectories)
	ON_BN_CLICKED(IDC_SELECTBIOS, OnBnClickedSelectbios)
	ON_BN_CLICKED(IDC_COLORPALETTE, OnBnClickedColorpalette)
END_MESSAGE_MAP()


// COptionsEmulator-Meldungshandler

void COptionsEmulator::OnBnClickedFiltetypes()
{
  theApp.winCheckFullscreen();
  Associate dlg;
  dlg.DoModal();
}

void COptionsEmulator::OnBnClickedDirectories()
{
  theApp.winCheckFullscreen();
  Directories dlg;
  dlg.DoModal();
}

void COptionsEmulator::OnBnClickedSelectbios()
{
	theApp.winCheckFullscreen();
	LPCTSTR exts[] = { "" };
	CString filter = theApp.winLoadFilter(IDS_FILTER_BIOS);
	CString title = winResLoadString(IDS_SELECT_BIOS_FILE);

	FileDlg dlg(this,
		theApp.biosFileName,
		filter,
		0,
		"BIOS",
		exts,
		"", 
		title,
		false);

	if(dlg.DoModal() == IDOK)
		theApp.biosFileName = dlg.GetPathName();
}
void COptionsEmulator::OnBnClickedColorpalette()
{
	theApp.winCheckFullscreen();
	GBColorDlg dlg;
	if(dlg.DoModal())
	{
		gbPaletteOption = dlg.getWhich();
		memcpy(systemGbPalette, dlg.getColors(), 24*sizeof(u16));
		if(emulating && (theApp.cartridgeType == IMAGE_GB) && (gbCgbMode == 0) && (gbSgbMode == 0) )
		{
			memcpy(gbPalette, &systemGbPalette[dlg.getWhich()*8], 8*sizeof(u16));
		}
	}
}