#ifdef MSS
#include <mss.h>
#endif


#include <stdio.h>
#include <stdlib.h>

#include "vb_types.h"
#include "vb_set.h"
#include "port.h"
#include "vb_gui.h" //for options file stuff
#include "vb_debug.h"

#define CL_DISP		"-display"
#define CL_DISP_320	"320"
#define CL_DISP_640	"640"
#define CL_DISP_800	"800"
#define CL_DISP_1024	"1024"

#define CL_DSPMODE	"-dspmode"
#define CL_DSPMODE_NORM	"normal"
#define CL_DSPMODE_R_B	"red_blue"
#define CL_DSPMODE_INT	"interlace"
#define CL_DSPMODE_OV	"over_under"
#define CL_DSPMODE_SS	"side"
#define CL_DSPMODE_CSCOPE "cscope"

#define CL_FRMSKP		"-frmskp"

#define CL_PALLET		"-pallet"
#define CL_PALLET_NORM	"normal"
#define CL_PALLET_RED	"red"
#define CL_PALLET_RB	"rb"
#define CL_PALLET_RG	"rg"
#define CL_PALLET_RBG	"rbg"

#define CL_BRTNES		"-brite"
#define CL_FLIP		"-flip"
#define CL_DEBUG		"-debug"
#define CL_STDOUT		"-stdout"
#define CL_FIXPAL		"-fixpal"
#define CL_DISASM		"-disasm"

#define CL_HELP1		"-?"
#define CL_HELP2		"-help"


VB_OPT         tVBOpt;
int            vbkey[15];

void setOptions(int argc, char *argv[]) {
#if 0
   int tmp=-1;
   char buf[256];
   int done = 0;
   int vIndex = 2;

   if ((argc < 2)||(strcmp(argv[1], CL_HELP1) == 0)||(strcmp(argv[1], CL_HELP2) == 0)) {
      printf(" Usage: vb_98 <rom_name.vb> [-options]\n");
      printf(" Options: \n");
      printf("  -display (320, 640, 800, 1024) \n");
      printf("  -dspmode (normal, red_blue, interlace, over_under, side, cscope)\n");
      printf("  -frmskp (0-9)\n");
      printf("  -pallet (normal, red, rb, rg, rbg)\n");
      printf("  -brite (0-127)\n");
      printf("  -flip\n");
      printf("  -fixpal\n");
      printf("  -disasm\n");
      printf("  -debug\n");
      printf("  -stdout\n");
      exit(0); //Does this work?
   }

   tVBOpt.PROG_NAME = argv[0];
   tVBOpt.ROM_NAME  = argv[1];

   //Break if we have no optional params...
   if(argc <= 2) done = 1;

   while(!done) {
      if (strcmp(argv[vIndex], CL_DISP) == 0) {
         if (strcmp(argv[vIndex+1], CL_DISP_320) == 0) {
            tVBOpt.SCR_MODE = VBgfx_driver[0]; //d_VGA; //VGA
            tVBOpt.SCR_X   = 320;
            tVBOpt.SCR_Y   = 200;
         } else if (strcmp(argv[vIndex+1], CL_DISP_640) == 0) {
            tVBOpt.SCR_MODE = VBgfx_driver[0]; //d_VESA1; //Vesa1
            tVBOpt.SCR_X   = 640;
            tVBOpt.SCR_Y   = 480;
         } else if (strcmp(argv[vIndex+1], CL_DISP_800) == 0) {
            tVBOpt.SCR_MODE = VBgfx_driver[0]; //d_VESA1; //Vesa1
            tVBOpt.SCR_X   = 800;
            tVBOpt.SCR_Y   = 600;
         } else if (strcmp(argv[vIndex+1], CL_DISP_1024) == 0) {
            tVBOpt.SCR_MODE = VBgfx_driver[0]; //d_VESA1; //Vesa1
            tVBOpt.SCR_X   = 1024;
            tVBOpt.SCR_Y   = 768;
         }
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_DSPMODE) == 0){
         if (strcmp(argv[vIndex+1], CL_DSPMODE_NORM) == 0) {
            tVBOpt.DSPMODE = dm_NORMAL;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_R_B) == 0) {
            tVBOpt.DSPMODE = dm_RedBlue;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_INT) == 0) {
            tVBOpt.DSPMODE = dm_INTERLACED;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_OV) == 0) {
            tVBOpt.DSPMODE = dm_OVRUNDR;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_SS) == 0) {
            tVBOpt.DSPMODE = dm_SIDESIDE;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_CSCOPE) == 0) {
            tVBOpt.DSPMODE = dm_CYBERSCOPE;
         }
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_PALLET) == 0){
         if (strcmp(argv[vIndex+1], CL_PALLET_NORM) == 0) {
            tVBOpt.PALMODE = pal_NORMAL;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RED) == 0) {
            tVBOpt.PALMODE = pal_RED;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RB) == 0) {
            tVBOpt.PALMODE = pal_RB;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RG) == 0) {
            tVBOpt.PALMODE = pal_RG;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RBG) == 0) {
            tVBOpt.PALMODE = pal_RBG;
         }
         vIndex+=2;

      }else if (strcmp(argv[vIndex], CL_FRMSKP) == 0){
         tmp=atoi(argv[vIndex+1]);
	   if((tmp>=0)&&(tmp<=9)) tVBOpt.FRMSKIP = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_BRTNES) == 0){
         tmp=atoi(argv[vIndex+1]);
	   if((tmp>=0)&&(tmp<=127)) tVBOpt.BFACTOR = tmp;
         vIndex+=2;

      }else if (strcmp(argv[vIndex], CL_FLIP) == 0){
         tVBOpt.DSPSWAP = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_FIXPAL) == 0){
         tVBOpt.FIXPAL = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_DISASM) == 0){
         tVBOpt.DISASM = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_DEBUG) == 0){
         tVBOpt.DEBUG = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_STDOUT) == 0){
         tVBOpt.STDOUT = 1;
         vIndex++;
      } else {
         vIndex++;
      }
      if(vIndex >= argc) done = 1;
   }
#endif
}

void setDefaults(void) {
   //Set up the Defaults
   tVBOpt.FRMSKIP  = 0;
   tVBOpt.DSPMODE  = dm_NORMAL;
   tVBOpt.DSPSWAP  = 0;
   tVBOpt.PALMODE  = pal_NORMAL;
   tVBOpt.DEBUG    = 0;
   tVBOpt.STDOUT   = 0;
   tVBOpt.BFACTOR  = 64;
   tVBOpt.SCR_X    = 640;
   tVBOpt.SCR_Y    = 480;
   tVBOpt.SCR_MODE = 0 ; //VBgfx_driver[0];
   tVBOpt.FIXPAL   = 0;
   tVBOpt.DISASM   = 0;
   tVBOpt.SOUND    = 0;
   tVBOpt.DSP2X    = 0;

   //Default keys (based on what Reality Boy uses)
#if 0
   vbkey[0] = KEY_E;
   vbkey[1] = KEY_C;
   vbkey[2] = KEY_S;
   vbkey[3] = KEY_F;

   vbkey[4] = KEY_I;
   vbkey[5] = KEY_COMMA;
   vbkey[6] = KEY_J;
   vbkey[7] = KEY_L;

   vbkey[8] = KEY_M;
   vbkey[9] = KEY_N;

   vbkey[10] = KEY_B;
   vbkey[11] = KEY_V;

   vbkey[12] = KEY_G;
   vbkey[13] = KEY_H;

   vbkey[14] = KEY_W;
#endif
}

int setFileOptions (void) {
   int i=0;
   int j=0;
   int k=0;
   int is_string=0;
   int optionValue;
   char optionSValue[81];
   char lineString[81];
   char optionString[81];
   char tempString[81];

   optionsFile = fopen(optionfilename, "r");

   if(optionsFile==0) {	return 0; }

   while(1) {
	i=0;
	j=0;
	for(i=0;i<81;i++) {
		lineString[i] = '\0';
		tempString[i] = '\0';
		optionString[i] = '\0';
		optionSValue[i] = '\0';
	}
	i=0;
      fgets(lineString, 70, optionsFile);

      if(feof(optionsFile)) { break; }

      if(lineString[0]=='S') { is_string=1; }
      else { is_string=0; }

      while(1) {
        if(lineString[i] == '=') {
            if(!is_string) {
              optionValue = ((int)lineString[i+1]-48) * 1000 + ((int)lineString[i+2]-48) * 100 + ((int)lineString[i+3]-48) * 10 + ((int)lineString[i+4]-48);
              break;
            }

            else
            {
              k=0;
              i++;

              while(lineString[k+i]!='\n') {
                 optionSValue[k] = lineString[k+i];
                 k++;
              }
              break;
            }
        }

        else
        {
           optionString[j] = lineString[i];
           j++;
        }

        i++;
      }

      //if(strcmp("platform", optionString) == 0) {
         //if(optionValue!=platform) {
            //printf("Option file is for the wrong platform of Red Dragon!\n");
            //return 1;
         //}
      //}
      if(strcmp("frmskip", optionString) == 0) { tVBOpt.FRMSKIP = optionValue; }
      if(strcmp("dspmode", optionString) == 0) { tVBOpt.DSPMODE = optionValue; }
      if(strcmp("dspswap", optionString) == 0) { tVBOpt.DSPSWAP = optionValue; }
      if(strcmp("dsp2x", optionString) == 0) { tVBOpt.DSP2X = optionValue; }
      if(strcmp("palmode", optionString) == 0) { tVBOpt.PALMODE = optionValue; }
      if(strcmp("scrx", optionString) == 0) { tVBOpt.SCR_X = optionValue; }
      if(strcmp("scry", optionString) == 0) { tVBOpt.SCR_Y = optionValue; }
	  if(strcmp("scrmode", optionString) == 0) { tVBOpt.SCR_MODE = 0 ; } //VBgfx_driver[optionValue]; }
      if(strcmp("sound", optionString) == 0) { tVBOpt.SOUND = optionValue; }
      if(strcmp("lu", optionString) == 0) { vbkey[0] = optionValue; }
      if(strcmp("ld", optionString) == 0) { vbkey[1] = optionValue; }
      if(strcmp("ll", optionString) == 0) { vbkey[2] = optionValue; }
      if(strcmp("lr", optionString) == 0) { vbkey[3] = optionValue; }
      if(strcmp("ru", optionString) == 0) { vbkey[4] = optionValue; }
      if(strcmp("rd", optionString) == 0) { vbkey[5] = optionValue; }
      if(strcmp("rl", optionString) == 0) { vbkey[6] = optionValue; }
      if(strcmp("rr", optionString) == 0) { vbkey[7] = optionValue; }
      if(strcmp("ba", optionString) == 0) { vbkey[8] = optionValue; }
      if(strcmp("bb", optionString) == 0) { vbkey[9] = optionValue; }
      if(strcmp("st", optionString) == 0) { vbkey[10] = optionValue; }
      if(strcmp("sl", optionString) == 0) { vbkey[11] = optionValue; }
      if(strcmp("tl", optionString) == 0) { vbkey[12] = optionValue; }
      if(strcmp("tr", optionString) == 0) { vbkey[13] = optionValue; }
      if(strcmp("bl", optionString) == 0) { vbkey[14] = optionValue; }

      if(strcmp("Srompath", optionString) == 0) { strcpy(rompath, optionSValue); }
   }
   fclose(optionsFile);
   return 1;
}

