#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include "vb_vbt.h"
#include "v810_cpu.h"
#include "vb_types.h"
#include "vb_debug.h"

FILE *flog,*ftrc=NULL;
int dbg_watchpt_en=0;
WORD dbg_wp_start=0;
WORD dbg_wp_end=0;

char *intstr[16] = {
	/*0x00*/ "Controller (INTKEY)",
	/*0x01*/ "Timer (INTTIM)",
	/*0x02*/ "Expansion (INTCRO)",
	/*0x03*/ "Link (INTCOM)",
	/*0x04*/ "Video Retrace (INTVPU)",
	/*0x05*/ "Unknown",
	/*0x06*/ "Unknown",
	/*0x07*/ "Unknown",
	/*0x08*/ "Unknown",
	/*0x09*/ "Unknown",
	/*0x0A*/ "Unknown",
	/*0x0B*/ "Unknown",
	/*0x0C*/ "Unknown",
	/*0x0D*/ "Unknown",
	/*0x0E*/ "Unknown",
	/*0x0F*/ "Reset (RSTVCT)",
};

void dbg_open_log(void)
{
#if 0
   flog = fopen("debug.txt", "a");
   fseek(flog, 0, SEEK_END);
#endif
}

void dbg_close_log(void)
{
#if 0
   fclose(flog);
#endif
}

void dbg_close_trace(void) {
#if 0
	if (ftrc) fclose(ftrc);
	ftrc=NULL;
#endif
}

void dbg_write(char msg[])
{
#if 0
   time_t t;
   struct tm *tblock;

   t = time(NULL);
   tblock = localtime(&t);

   dbg_open_log();
   fprintf(flog, "%02d:%02d:%02d - %s\n", tblock->tm_hour, tblock->tm_min, tblock->tm_sec, msg);
   dbg_close_log();
#endif
}

void dbg_writef(const char *template, ...)
{
#if 0
    va_list ap;


    dbg_open_log();

    va_start(ap, template);
    vfprintf(flog, template, ap);
    va_end(ap);

    dbg_close_log();
#endif
}

void dbg_watchpt(WORD addr, int size, int type, WORD data)
{
#if 0
    if (/*(PC <= 0x07FFFFFF) &&*/ (addr>=dbg_wp_start) && (addr<=dbg_wp_end)) {
		if (type) {
			//dbg_writef("Writing %X of size %d to %08X at PC=%08X\n", data, size, addr, PC);
			if (size == 8) dbg_writef("Instruction at address %08X wrote 0x%02X to %08X\n",PC,data,addr);
			else if (size == 16) dbg_writef("Instruction at address %08X wrote 0x%04X to %08X\n",PC,data,addr);
			else dbg_writef("Instruction at address %08X wrote 0x%08X to %08X\n",PC,data,addr);
		}
		else {
			//dbg_writef("Reading of size %d to %08X at PC=%08X\n", size, addr, PC);
			dbg_writef("Instruction at address %08X read %d-bits from %08X\n",PC,size,addr);
		}
	}
#endif
}

void dbg_tracelog() {
#if 0
	int i;

	if (!ftrc) {
		ftrc = fopen("trace.log", "wt");
		if (!ftrc) return;
	}
	v810_dis(PC, 1, ftrc);
	fprintf(ftrc,"\tPSW:%08X, EIPC:%08X", S_REG[PSW], S_REG[EIPC]);
	for (i = 0; i < 32; i++) fprintf(ftrc,", r%02d:%08X",i,P_REG[i]);
#endif
}

void dbg_intlog(int inum) {
#if 0
	int i;

	if (!ftrc) {
		ftrc = fopen("trace.log", "wt");
		if (!ftrc) return;
	}
	fprintf(ftrc,"\nINTERRUPT: %d - %s",inum,intstr[inum]);
#endif
}

void dbg_addtrc(const char *template, ...) {
#if 0
    va_list ap;

	if (!ftrc) {
		ftrc = fopen("trace.log", "wt");
		if (!ftrc) return;
	}
    va_start(ap, template);
    vfprintf(ftrc, template, ap);
    va_end(ap);
#endif
}
