#include "vb_types.h"
//#include "vb_vbt.h"
#include "vb_snd.h"
#include "allegro.h"
#include "vb_debug.h"
#include "vb_set.h"

#define VBtoHz(hi, lo) 131072/(2048-(((hi & 0x07)<<8)|lo))
#define ADR_SDATA(inst, pos) (inst*0x80+0x01000000+pos*4)
//#define BUFFER_SIZE     1024
#define BUFFER_SIZE       512

SND_REG s[4];
int smreg;
AUDIOSTREAM *stream;
unsigned char *buffer;
unsigned char sound_ready=0;

unsigned char sbuf[4][BUFFER_SIZE];
unsigned char sqr_wave[32];
void vb_play_tone(int hz);
void vb_play_silence(void);

int vb_snd_init(void) {
	int i;

   	if((!sound_ready)&&(tVBOpt.SOUND==1))  //only need to install sound if not ready and enabled
	{
		if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
		{
			//there was a problem
			tVBOpt.SOUND=0;
			return 1;
		}

		stream = play_audio_stream(BUFFER_SIZE, 8, 0, 22050, 255, 128);

		if(!stream)
		{
			//there was a problem
			tVBOpt.SOUND=0;
			return 1;
		}

		sound_ready = 1;
	}

	return 0;
}

void vb_snd_remove(void)
{
	if(sound_ready) //only need to remove if it has been installed
	{
		remove_sound();
		sound_ready = 0;
	}
}


void refresh_snd_regs(void) {
   int i;

   for(i=0;i<4;i++) {
      s[i].ctl = mem_rbyte(ADR_SCTRL+(0x40*i)) & 0xFF;
      s[i].vol = mem_rbyte(ADR_SLEN +(0x40*i)) & 0xFF;
      s[i].fql = mem_rbyte(ADR_SFL  +(0x40*i)) & 0xFF;
      s[i].fqh = mem_rbyte(ADR_SFH  +(0x40*i)) & 0xFF;
      s[i].len = mem_rbyte(ADR_SUNK1+(0x40*i)) & 0xFF;
      s[i].unk2 = mem_rbyte(ADR_SUNK2+(0x40*i)) & 0xFF;
      s[i].ram = mem_rbyte(ADR_SINST+(0x40*i)) & 0xFF;
   }

   smreg = mem_rbyte(ADR_SMREG) & 0xFF;
}

void vb_snd_debuginfo(void) {
    int i;

    for(i=0;i<4;i++) {
       textprintf(screen, font, 1, 250+(i*8), 255, "CTRL:%2x VOL:%2x FL:%2x FH:%2x LEN:%2x U2:%2x IN:%2x Hz:%d",
          s[i].ctl, s[i].vol, s[i].fql, s[i].fqh, s[i].len, s[i].unk2,
          s[i].ram, VBtoHz(s[i].fqh, s[i].fql));
    }
    textprintf(screen, font, 1, 282, 255, "SMREG: %2x", smreg);
    textprintf(screen, font, 1, 300, 255, "S1Data: %02X %02X %02X",
               mem_rbyte(ADR_SDATA(1,0))&0xFF, mem_rbyte(ADR_SDATA(1,1))&0xFF,
               mem_rbyte(ADR_SDATA(1,2))&0xFF);

}

void vb_do_sound(void)
{
   int i;
   int j;

   //int ofs=0;
   int pos=0;
   int sdata=0;
   int state=0;
   static int ofs[4];
   buffer = get_audio_stream_buffer(stream);

   set_volume(255,0);

   if(buffer) {   							//Need to refill the buffer?
	   for(j=0;j<4;j++) {						//I hope this gets unrolled
		   if(s[j].ctl==0x80) { 				//Is the channel on?
			   for(i=0;i<BUFFER_SIZE;i++) {
				   //find offset
				   ofs[j] = (ofs[j]+VBtoHz(s[j].fqh, s[j].fql))&0xFFFF;

				   //divide by 2048
				   pos = ofs[j]>>11;

				   //get the sample
				   sdata = mem_rbyte(ADR_SDATA(s[j].ram, pos))&0x3F;

				   //only look at left channel when calculating volume (mono)
				   sbuf[j][i] = sdata*(s[j].vol>>4)>>2;
			   }
		   }

		   else {
			   //fill with silence
			   for(i=0;i<BUFFER_SIZE;i++)
				   sbuf[j][i] = 0;
		   }
	   }

	   //inefficient!
	   for(i=0;i<BUFFER_SIZE;i++)
		   buffer[i] = (sbuf[0][i]+sbuf[1][i]+sbuf[2][i]+sbuf[3][i])>>2;

	   free_audio_stream_buffer(stream);
   }
}

void vb_play_silence(void) {
	//why the %@#% doesnt this work!?!
	int i;

	set_volume(0,0);

	//wait until done playing current sample
	//while(voice_get_position(stream->voice)!=-1) { }

	//dbg_writef("current voice position: %d\n", voice_get_position(stream->voice));
	buffer = get_audio_stream_buffer(stream);

	while(!buffer) {  buffer = get_audio_stream_buffer(stream); }
	//dbg_writef("Buffer address: %p\n", buffer);
	for(i=0;i<BUFFER_SIZE;i++)
		buffer[i] = 0;

	free_audio_stream_buffer(stream);

	buffer = get_audio_stream_buffer(stream);
	while(!buffer) {  buffer = get_audio_stream_buffer(stream); }
	//if(buffer) {

		/*dbg_writef("Filling in with silence...\n");
		for(i=0;i<BUFFER_SIZE;i++)
		{
			buffer[i] = 0;
		}*/

		//free_audio_stream_buffer(stream);
	//}
/*	buffer = get_audio_stream_buffer(stream);

	//wait until we need silence to be played
	while(!buffer)
		buffer = get_audio_stream_buffer(stream);


	for(i=0;i<BUFFER_SIZE;i++)
	{
		buffer[i] = 0;
	}

	free_audio_stream_buffer(stream);*/
}

void vb_play_tone(int hz) {
   //simple square wave playing function (delete me)
   int state = 22050/hz/2;
   int i;
   int j=0;
   int xor=0;

   buffer = get_audio_stream_buffer(stream);

   if(buffer) {
      for(i=0;i<BUFFER_SIZE;i++) {
         j++;
         if(j>state) {
            xor = xor^1;
            j=0;
         }
         if(xor) { buffer[i] = 0xFF; }
         else { buffer[i] = 0; }
       }

   free_audio_stream_buffer(stream);

   }
}

int vb_snd_main(void) {
    int i;

    refresh_snd_regs();
//    vb_snd_debuginfo();
    vb_do_sound();
}
