////////////////////////////////////////////////////////////////
// Defines for the V810 CPU debug

#ifndef V810_CPU_D_H_
#define V810_CPU_D_H_

#include "vb_types.h"


//Structure to store an element in our linked list
// used to dynamicaly dissasemble a rom
typedef struct dasms {
	int            offset;
	WORD 		   PC;
	WORD           jump;
      struct dasms * nextElement;
} dasmS;

//Add an element into our linked list
void v810_addDasm(WORD tPC);

//write out our linked list to a file
void v810_writeDasm();

//clear our linked list of data
void v810_clearDasm();

// Dissasemble num lines of code  starting at tPC (If tPC == -1 start at PC)
long v810_dis(long tPC, int num, FILE* fout);

// Print the P_REG out
void v810_preg();

// Dump num lines
void v810_dump(long tPC, int num);

#endif
