/* File: port.c

   Purpose: Defines all the available drivers for the given platform.
            This file is theoretically all that is needed to
            port the emulator to another platform with Allegro */

#include "allegro.h"
#include <stdio.h>

//Should not really be here
FILE *optionsFile;

#ifdef ALLEGRO_WINDOWS
        const int VBgfx_driver[] = {
                GFX_AUTODETECT, GFX_AUTODETECT, GFX_AUTODETECT,
                GFX_SAFE, GFX_DIRECTX, GFX_DIRECTX_ACCEL, GFX_DIRECTX_SOFT,
                GFX_DIRECTX_SAFE, GFX_DIRECTX_WIN, GFX_DIRECTX_OVL, GFX_GDI
        };
        const int drivercount = 11;
        const int platform = 0;
#endif
#ifdef ALLEGRO_DOS
        const int VBgfx_driver[] = {
                GFX_AUTODETECT, GFX_AUTODETECT, GFX_AUTODETECT,
                GFX_VGA, GFX_MODEX, GFX_VESA1, GFX_VESA2B,
                GFX_VESA2L, GFX_VESA3, GFX_VBEAF, GFX_XTENDED
        };
        const int drivercount = 11;
        const int platform = 1;
#endif
#ifdef ALLEGRO_LINUX
	const int VBgfx_driver[] = {
		GFX_AUTODETECT, GFX_AUTODETECT, GFX_AUTODETECT,
		GFX_SAFE, GFX_FBCON, GFX_VBEAF,
		GFX_VGA, GFX_MODEX, GFX_AUTODETECT, GFX_AUTODETECT,
		GFX_AUTODETECT_WINDOWED, GFX_SAFE, GFX_XWINDOWS,
		GFX_XWINDOWS_FULLSCREEN, GFX_XDGA, GFX_XDGA_FULLSCREEN,
		GFX_XDGA2, GFX_XDGA2_SOFT
	};
	const int drivercount = 18;
	const int platform = 2;
#endif

