// PokeMini PC Version - homebrew-emulator for Pokmon-Mini
// Copyright (C) 2004 JustBurn HQ
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Pokmon-mini CPU core emulator, v0.6.4 (Retail)
//
// Coded by JustBurn, 2004

#ifndef POKECPU_H
#define POKECPU_H

#define LSB_FIRST            // For Little-Endian Systems
//#define MSB_FIRST            // For Big-Endian Systems
#define POKECPU_VREGPRESET 2 // Time that keeps U untouched

#define S_FLAG 0x08
#define O_FLAG 0x04
#define C_FLAG 0x02
#define Z_FLAG 0x01

#ifdef __GNUC__
#define INLINE inline
#else
#define INLINE static
#endif

#ifdef POKECPU_EXTERN
#define POKEEXTERN extern
#else
#define POKEEXTERN
#endif

typedef union {
#ifdef LSB_FIRST
  struct {
    unsigned char l;
    unsigned char h;
    unsigned char x;
    unsigned char reserved;
  } B;
  struct {
    unsigned short l;
    unsigned short reserved;
  } W;
#else
  struct {
    unsigned char reserved;
    unsigned char x;
    unsigned char h;
    unsigned char l;
  } B;
  struct {
    unsigned short reserved;
    unsigned short l;
  } W;
#endif
  unsigned long D;
} POKECPU_PAIR;

POKEEXTERN struct {
  POKECPU_PAIR BA;    // 16 Bits, A & B Registers
  POKECPU_PAIR HL;    // 24 Bits, H, L and Y(Upper HL) Registers
  POKECPU_PAIR X1;    // 24 Bits, X1 Register
  POKECPU_PAIR X2;    // 24 Bits, X2 Register
  POKECPU_PAIR NN;    // 16 Bits, NN Register and low 8bits always 0x00
  unsigned char F;    // 8 Bits, Flags
  POKECPU_PAIR SP;    // 16 Bits, Stack Pointer
  POKECPU_PAIR PC;    // 24 Bits, Program Counter
  unsigned char U;    // 8 Bits, U
  unsigned char V;    // 8 Bits, V
  unsigned long UT;   // U Timming that will return V
  bool INTR;          // Interrupt Running??
  unsigned long tmp;  //
  unsigned long tmp2; //
  unsigned long tmp3; // Temporary Variables for Opcode processing
  signed long LPeriod;
  signed long LCount; // Special for looping
  bool Halt;          // Emulation halted?
} PokeCPU;

// Reset Pokemon-mini CPU Register
void ResetPokeCPU();

// Execute until LCount turns less that 0
void RunPokeCPU();

// Execute 1 single opcode
void ExecPokeCPU();

// Read Memory entire range (MUST BE WRITTEN BY THE USER, ADDR MUST BE FILTERED)
static unsigned char ReadPokeCPUEx(unsigned long address);

// Read Memory from PC (MUST BE WRITTEN BY THE USER)
static unsigned char ReadPokeCPU(unsigned short address);

// Write Memory entire range (MUST BE WRITTEN BY THE USER, ADDR MUST BE FILTERED)
static void WritePokeCPUEx(unsigned long address, unsigned char data);

// Write Memory from PC (MUST BE WRITTEN BY THE USER)
static void WritePokeCPU(unsigned short address, unsigned char data);

// Illegal Opcode (MUST BE WRITTEN BY THE USER)
static void IllegalPokeCPU(unsigned long address);

// Executed in each Opcode/Block of Opcodes ran (MUST BE WRITTEN BY THE USER)
static void ExecutePokeCPU(int CyclesRan);

// Called when LCount is refilled (MUST BE WRITTEN BY THE USER)
static void LCountPokeCPU();

#endif

