// PokeMini PC Version - homebrew-emulator for Pokmon-Mini
// Copyright (C) 2004 JustBurn HQ
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// Pokmon-mini CPU core emulator, v0.6.4 (Debug / Retail)
//
// Coded by JustBurn, 2004

// CE 00 nn    - ADD A, [X1 + #nn]
case 0x00:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// CE 01 nn    - ADD A, [X2 + #nn]
case 0x01:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// CE 02       - ADD A, [X1 + L]
case 0x02:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 03       - ADD A, [X2 + L]
case 0x03:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 04       - ADD [HL], A
case 0x04:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + PokeCPU.BA.B.l;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  break;

// CE 05 nn    - ADD [HL], #nn
case 0x05:
  PokeCPU.tmp3 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + PokeCPU.tmp3;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE 06       - ADD [HL], [X1]
case 0x06:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + PokeCPU.tmp3;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 07       - ADD [HL], [X2]
case 0x07:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + PokeCPU.tmp3;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 08 nn    - ADC A, [X1 + #nn]
case 0x08:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// CE 09 nn    - ADC A, [X2 + #nn]
case 0x09:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// CE 0A       - ADC A, [X1 + L]
case 0x0A:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 0B       - ADC A, [X2 + L]
case 0x0B:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l + PokeCPU.tmp2 + (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 0C       - ADC [HL], A
case 0x0C:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + PokeCPU.BA.B.l + (PokeCPU.F & C_FLAG ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  break;

// CE 0D nn    - ADC [HL], #nn
case 0x0D:
  PokeCPU.tmp3 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + PokeCPU.tmp3 + (PokeCPU.F & C_FLAG ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE 0E       - ADC [HL], [X1]
case 0x0E:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + PokeCPU.tmp3 + (PokeCPU.F & C_FLAG ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 0F       - ADC [HL], [X2]
case 0x0F:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 + PokeCPU.tmp3 + (PokeCPU.F & C_FLAG ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_ADD(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 10 nn    - SUB A, [X1 + #nn]
case 0x10:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// CE 11 nn    - SUB A, [X2 + #nn]
case 0x11:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// CE 12       - SUB A, [X1 + L]
case 0x12:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 13       - SUB A, [X2 + L]
case 0x13:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 14       - SUB [HL], A
case 0x14:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.BA.B.l;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  break;

// CE 15 nn    - SUB [HL], #nn
case 0x15:
  PokeCPU.tmp3 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE 16       - SUB [HL], [X1]
case 0x16:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 17       - SUB [HL], [X2]
case 0x17:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 18 nn    - SBC A, [X1 + #nn]
case 0x18:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// CE 19 nn    - SBC A, [X2 + #nn]
case 0x19:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  PokeCPU.PC.W.l++;
  break;

// CE 1A       - SBC A, [X1 + L]
case 0x1A:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 1B       - SBC A, [X2 + L]
case 0x1B:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2 - (PokeCPU.F & C_FLAG ? 1 : 0);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 1C       - SBC [HL], A
case 0x1C:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.BA.B.l - (PokeCPU.F & C_FLAG ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  break;

// CE 1D nn    - SBC [HL], #nn
case 0x1D:
  PokeCPU.tmp3 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3 - (PokeCPU.F & C_FLAG ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE 1E       - SBC [HL], [X1]
case 0x1E:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3 - (PokeCPU.F & C_FLAG ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 1F       - SBC [HL], [X2]
case 0x1F:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3 - (PokeCPU.F & C_FLAG ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 20 nn    - AND A, [X1 + #nn]
case 0x20:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(ReadX1Add());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 21 nn    - AND A, [X2 + #nn]
case 0x21:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(ReadX2Add());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 22       - AND A, [X1 + L]
case 0x22:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(ReadX1AddL());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 23       - AND A, [X2 + L]
case 0x23:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l & ReadPokeCPUEx(ReadX2AddL());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 24       - AND [HL], A
case 0x24:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) & PokeCPU.BA.B.l;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 25 nn    - AND [HL], #nn
case 0x25:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) & ReadPokeCPU(PokeCPU.PC.W.l);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 26       - AND [HL], [X1]
case 0x26:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) & ReadPokeCPUEx(PokeCPU.X1.D);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 27       - AND [HL], [X2]
case 0x27:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) & ReadPokeCPUEx(PokeCPU.X2.D);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 28 nn    - OR A, [X1 + #nn]
case 0x28:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(ReadX1Add());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 29 nn    - OR A, [X2 + #nn]
case 0x29:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(ReadX2Add());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 2A       - OR A, [X1 + L]
case 0x2A:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(ReadX1AddL());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 2B       - OR A, [X2 + L]
case 0x2B:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l | ReadPokeCPUEx(ReadX2AddL());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 2C       - OR [HL], A
case 0x2C:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) | PokeCPU.BA.B.l;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 2D nn    - OR [HL], #nn
case 0x2D:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) | ReadPokeCPU(PokeCPU.PC.W.l);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 2E       - OR [HL], [X1]
case 0x2E:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) | ReadPokeCPUEx(PokeCPU.X1.D);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 2F       - OR [HL], [X2]
case 0x2F:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) | ReadPokeCPUEx(PokeCPU.X2.D);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 30 nn    - CMP A, [X1 + #nn]
case 0x30:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE 31 nn    - CMP A, [X2 + #nn]
case 0x31:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE 32       - CMP A, [X1 + L]
case 0x32:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX1AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  break;

// CE 33       - CMP A, [X2 + L]
case 0x33:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadX2AddL());
  PokeCPU.tmp = PokeCPU.BA.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  break;

// CE 34       - CMP [HL], A
case 0x34:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.BA.B.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  break;

// CE 35 nn    - CMP [HL], #nn
case 0x35:
  PokeCPU.tmp3 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE 36       - CMP [HL], [X1]
case 0x36:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X1.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 37       - CMP [HL], [X2]
case 0x37:
  PokeCPU.tmp3 = ReadPokeCPUEx(PokeCPU.X2.D);
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 - PokeCPU.tmp3;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.tmp2, PokeCPU.tmp3, PokeCPU.tmp & 0xFF);
  break;

// CE 38 nn    - XOR A, [X1 + #nn]
case 0x38:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(ReadX1Add());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 39 nn    - XOR A, [X2 + #nn]
case 0x39:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(ReadX2Add());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 3A       - XOR A, [X1 + L]
case 0x3A:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(ReadX1AddL());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 3B       - XOR A, [X2 + L]
case 0x3B:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ ReadPokeCPUEx(ReadX2AddL());
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 3C       - XOR [HL], A
case 0x3C:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) ^ PokeCPU.BA.B.l;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 3D nn    - XOR [HL], #nn
case 0x3D:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) ^ ReadPokeCPU(PokeCPU.PC.W.l);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 3E       - XOR [HL], [X1]
case 0x3E:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) ^ ReadPokeCPUEx(PokeCPU.X1.D);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 3F       - XOR [HL], [X2]
case 0x3F:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) ^ ReadPokeCPUEx(PokeCPU.X2.D);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 40 nn    - MOV A, [X1 + #nn]
case 0x40:
  PokeCPU.BA.B.l = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.PC.W.l++;
  break;

// CE 41 nn    - MOV A, [X2 + #nn]
case 0x41:
  PokeCPU.BA.B.l = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.PC.W.l++;
  break;

// CE 42       - MOV A, [X1 + L]
case 0x42:
  PokeCPU.BA.B.l = ReadPokeCPUEx(ReadX1AddL());
  break;

// CE 43       - MOV A, [X2 + L]
case 0x43:
  PokeCPU.BA.B.l = ReadPokeCPUEx(ReadX2AddL());
  break;

// CE 44 nn    - MOV [X1 + #nn], A
case 0x44:
  WritePokeCPUEx(ReadX1Add(), PokeCPU.BA.B.l);
  PokeCPU.PC.W.l++;
  break;

// CE 45 nn    - MOV [X2 + #nn], A
case 0x45:
  WritePokeCPUEx(ReadX2Add(), PokeCPU.BA.B.l);
  PokeCPU.PC.W.l++;
  break;

// CE 46       - MOV [X1 + L], A
case 0x46:
  WritePokeCPUEx(ReadX1AddL(), PokeCPU.BA.B.l);
  break;

// CE 47       - MOV [X2 + L], A
case 0x47:
  WritePokeCPUEx(ReadX2AddL(), PokeCPU.BA.B.l);
  break;

// CE 48 nn    - MOV B, [X1 + #nn]
case 0x48:
  PokeCPU.BA.B.h = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.PC.W.l++;
  break;

// CE 49 nn    - MOV B, [X2 + #nn]
case 0x49:
  PokeCPU.BA.B.h = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.PC.W.l++;
  break;

// CE 4A       - MOV B, [X1 + L]
case 0x4A:
  PokeCPU.BA.B.h = ReadPokeCPUEx(ReadX1AddL());
  break;

// CE 4B       - MOV B, [X2 + L]
case 0x4B:
  PokeCPU.BA.B.h = ReadPokeCPUEx(ReadX2AddL());
  break;

// CE 4C nn    - MOV [X1 + #nn], B
case 0x4C:
  WritePokeCPUEx(ReadX1Add(), PokeCPU.BA.B.h);
  PokeCPU.PC.W.l++;
  break;

// CE 4D nn    - MOV [X2 + #nn], B
case 0x4D:
  WritePokeCPUEx(ReadX2Add(), PokeCPU.BA.B.h);
  PokeCPU.PC.W.l++;
  break;

// CE 4E       - MOV [X1 + L], B
case 0x4E:
  WritePokeCPUEx(ReadX1AddL(), PokeCPU.BA.B.h);
  break;

// CE 4F       - MOV [X2 + L], B
case 0x4F:
  WritePokeCPUEx(ReadX2AddL(), PokeCPU.BA.B.h);
  break;

// CE 50 nn    - MOV L, [X1 + #nn]
case 0x50:
  PokeCPU.HL.B.l = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.PC.W.l++;
  break;

// CE 51 nn    - MOV L, [X2 + #nn]
case 0x51:
  PokeCPU.HL.B.l = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.PC.W.l++;
  break;

// CE 52       - MOV L, [X1 + L]
case 0x52:
  PokeCPU.HL.B.l = ReadPokeCPUEx(ReadX1AddL());
  break;

// CE 53       - MOV L, [X2 + L]
case 0x53:
  PokeCPU.HL.B.l = ReadPokeCPUEx(ReadX2AddL());
  break;

// CE 54 nn    - MOV [X1 + #nn], L
case 0x54:
  WritePokeCPUEx(ReadX1Add(), PokeCPU.HL.B.l);
  PokeCPU.PC.W.l++;
  break;

// CE 55 nn    - MOV [X2 + #nn], L
case 0x55:
  WritePokeCPUEx(ReadX2Add(), PokeCPU.HL.B.l);
  PokeCPU.PC.W.l++;
  break;

// CE 56       - MOV [X1 + L], L
case 0x56:
  WritePokeCPUEx(ReadX1AddL(), PokeCPU.HL.B.l);
  break;

// CE 57       - MOV [X2 + L], L
case 0x57:
  WritePokeCPUEx(ReadX2AddL(), PokeCPU.HL.B.l);
  break;

// CE 58 nn    - MOV H, [X1 + #nn]
case 0x58:
  PokeCPU.HL.B.h = ReadPokeCPUEx(ReadX1Add());
  PokeCPU.PC.W.l++;
  break;

// CE 59 nn    - MOV H, [X2 + #nn]
case 0x59:
  PokeCPU.HL.B.h = ReadPokeCPUEx(ReadX2Add());
  PokeCPU.PC.W.l++;
  break;

// CE 5A       - MOV H, [X1 + L]
case 0x5A:
  PokeCPU.HL.B.h = ReadPokeCPUEx(ReadX1AddL());
  break;

// CE 5B       - MOV H, [X2 + L]
case 0x5B:
  PokeCPU.HL.B.h = ReadPokeCPUEx(ReadX2AddL());
  break;

// CE 5C nn    - MOV [X1 + #nn], H
case 0x5C:
  WritePokeCPUEx(ReadX1Add(), PokeCPU.HL.B.h);
  PokeCPU.PC.W.l++;
  break;

// CE 5D nn    - MOV [X2 + #nn], H
case 0x5D:
  WritePokeCPUEx(ReadX2Add(), PokeCPU.HL.B.h);
  PokeCPU.PC.W.l++;
  break;

// CE 5E       - MOV [X1 + L], H
case 0x5E:
  WritePokeCPUEx(ReadX1AddL(), PokeCPU.HL.B.h);
  break;

// CE 5F       - MOV [X2 + L], H
case 0x5F:
  WritePokeCPUEx(ReadX2AddL(), PokeCPU.HL.B.h);
  break;

// CE 60 nn    - MOV [HL], [X1 + #nn]
case 0x60:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPUEx(ReadX1Add()));
  PokeCPU.PC.W.l++;
  break;

// CE 61 nn    - MOV [HL], [X2 + #nn]
case 0x61:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPUEx(ReadX2Add()));
  PokeCPU.PC.W.l++;
  break;

// CE 62       - MOV [HL], [X1 + L]
case 0x62:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPUEx(ReadX1AddL()));
  break;

// CE 63       - MOV [HL], [X2 + L]
case 0x63:
  WritePokeCPUEx(PokeCPU.HL.D, ReadPokeCPUEx(ReadX2AddL()));
  break;

// CE 64       - [INVALID]
case 0x64:
  IllegalPokeCPU(0xCE64);
  break;

// CE 65       - [INVALID]
case 0x65:
  IllegalPokeCPU(0xCE65);
  break;

// CE 66       - [INVALID]
case 0x66:
  IllegalPokeCPU(0xCE66);
  break;

// CE 67       - [INVALID]
case 0x67:
  IllegalPokeCPU(0xCE67);
  break;

// CE 68 nn    - MOV [X1], [X1 + #nn]
case 0x68:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPUEx(ReadX1Add()));
  PokeCPU.PC.W.l++;
  break;

// CE 69 nn    - MOV [X1], [X2 + #nn]
case 0x69:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPUEx(ReadX2Add()));
  PokeCPU.PC.W.l++;
  break;

// CE 6A       - MOV [X1], [X1 + L]
case 0x6A:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPUEx(ReadX1AddL()));
  break;

// CE 6B       - MOV [X1], [X2 + L]
case 0x6B:
  WritePokeCPUEx(PokeCPU.X1.D, ReadPokeCPUEx(ReadX2AddL()));
  break;

// CE 6C       - [INVALID]
case 0x6C:
  IllegalPokeCPU(0xCE6C);
  break;

// CE 6D       - [INVALID]
case 0x6D:
  IllegalPokeCPU(0xCE6D);
  break;

// CE 6E       - [INVALID]
case 0x6E:
  IllegalPokeCPU(0xCE6E);
  break;

// CE 6F       - [INVALID]
case 0x6F:
  IllegalPokeCPU(0xCE6F);
  break;

// CE 70       - [INVALID]
case 0x70:
  IllegalPokeCPU(0xCE70);
  break;

// CE 71       - [INVALID]
case 0x71:
  IllegalPokeCPU(0xCE71);
  break;

// CE 72       - [INVALID]
case 0x72:
  IllegalPokeCPU(0xCE72);
  break;

// CE 73       - [INVALID]
case 0x73:
  IllegalPokeCPU(0xCE73);
  break;

// CE 74       - [INVALID]
case 0x74:
  IllegalPokeCPU(0xCE74);
  break;

// CE 75       - [INVALID]
case 0x75:
  IllegalPokeCPU(0xCE75);
  break;

// CE 76       - [INVALID]
case 0x76:
  IllegalPokeCPU(0xCE76);
  break;

// CE 77       - [INVALID]
case 0x77:
  IllegalPokeCPU(0xCE77);
  break;

// CE 78 nn    - MOV [X2], [X1 + #nn]
case 0x78:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPUEx(ReadX1Add()));
  PokeCPU.PC.W.l++;
  break;

// CE 79 nn    - MOV [X2], [X2 + #nn]
case 0x79:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPUEx(ReadX2Add()));
  PokeCPU.PC.W.l++;
  break;

// CE 7A       - MOV [X2], [X1 + L]
case 0x7A:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPUEx(ReadX1AddL()));
  break;

// CE 7B       - MOV [X2], [X2 + L]
case 0x7B:
  WritePokeCPUEx(PokeCPU.X2.D, ReadPokeCPUEx(ReadX2AddL()));
  break;

// CE 7C       - [INVALID]
case 0x7C:
  IllegalPokeCPU(0xCE7C);
  break;

// CE 7D       - [INVALID]
case 0x7D:
  IllegalPokeCPU(0xCE7D);
  break;

// CE 7E       - [INVALID]
case 0x7E:
  IllegalPokeCPU(0xCE7E);
  break;

// CE 7F       - [INVALID]
case 0x7F:
  IllegalPokeCPU(0xCE7F);
  break;

// CE 80       - SLA A
case 0x80:
  PokeCPU.tmp = PokeCPU.BA.B.l << 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 81       - SLA B
case 0x81:
  PokeCPU.tmp = PokeCPU.BA.B.h << 1;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE 82 nn    - SLA [NN + #nn]
case 0x82:
  PokeCPU.tmp = ReadPokeCPUEx(ReadNNOfs8()) << 1;
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 83       - SLA [HL]
case 0x83:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) << 1;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 84       - SHL A
case 0x84:
  PokeCPU.tmp = PokeCPU.BA.B.l << 1;
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 85       - SHL B
case 0x85:
  PokeCPU.tmp = PokeCPU.BA.B.h << 1;
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE 86 nn    - SHL [NN + #nn]
case 0x86:
  PokeCPU.tmp = ReadPokeCPUEx(ReadNNOfs8()) << 1;
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 87       - SHL [HL]
case 0x87:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) << 1;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 88       - SRA A
case 0x88:
  PokeCPU.tmp = (PokeCPU.BA.B.l >> 1) | (PokeCPU.BA.B.l & 0x80);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 89       - SRA B
case 0x89:
  PokeCPU.tmp = (PokeCPU.BA.B.h >> 1) | (PokeCPU.BA.B.h & 0x80);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.h & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE 8A nn    - SRA [NN + #nn]
case 0x8A:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = (PokeCPU.tmp2 >> 1) | (PokeCPU.tmp2 & 0x80);
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp2 & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 8B       - SRA [HL]
case 0x8B:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = (PokeCPU.tmp2 >> 1) | (PokeCPU.tmp2 & 0x80);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp2 & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 8C       - SHR A
case 0x8C:
  PokeCPU.tmp = PokeCPU.BA.B.l >> 1;
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 8D       - SHR B
case 0x8D:
  PokeCPU.tmp = PokeCPU.BA.B.h >> 1;
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.h & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE 8E nn    - SHR [NN + #nn]
case 0x8E:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = PokeCPU.tmp2 >> 1;
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp2 & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 8F       - SHR [HL]
case 0x8F:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = PokeCPU.tmp2 >> 1;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp2 & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 90       - RL A
case 0x90:
  PokeCPU.tmp = (PokeCPU.BA.B.l << 1) | ((PokeCPU.F & C_FLAG) ? 1 : 0);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 91       - RL B
case 0x91:
  PokeCPU.tmp = (PokeCPU.BA.B.h << 1) | ((PokeCPU.F & C_FLAG) ? 1 : 0);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE 92 nn    - RL [NN + #nn]
case 0x92:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = (PokeCPU.tmp2 << 1) | ((PokeCPU.F & C_FLAG) ? 1 : 0);
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 93       - RL [HL]
case 0x93:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = (PokeCPU.tmp2 << 1) | ((PokeCPU.F & C_FLAG) ? 1 : 0);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 94       - RLC A
case 0x94:
  PokeCPU.tmp = (PokeCPU.BA.B.l << 1) | ((PokeCPU.BA.B.l & 0x80) >> 7);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 95       - RLC B
case 0x95:
  PokeCPU.tmp = (PokeCPU.BA.B.h << 1) | ((PokeCPU.BA.B.h & 0x80) >> 7);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE 96 nn    - RLC [NN + #nn]
case 0x96:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = (PokeCPU.tmp2 << 1) | ((PokeCPU.tmp2 & 0x80) >> 7);
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 97       - RLC [HL]
case 0x97:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = (PokeCPU.tmp2 << 1) | ((PokeCPU.tmp2 & 0x80) >> 7);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 98       - RR A
case 0x98:
  PokeCPU.tmp = (PokeCPU.BA.B.l >> 1) | ((PokeCPU.F & C_FLAG) ? 0x80 : 0x00);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 99       - RR B
case 0x99:
  PokeCPU.tmp = (PokeCPU.BA.B.h >> 1) | ((PokeCPU.F & C_FLAG) ? 0x80 : 0x00);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.h & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE 9A nn    - RR [NN + #nn]
case 0x9A:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = (PokeCPU.tmp2 >> 1) | ((PokeCPU.F & C_FLAG) ? 0x80 : 0x00);
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp2 & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 9B       - RR [HL]
case 0x9B:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = (PokeCPU.tmp2 >> 1) | ((PokeCPU.F & C_FLAG) ? 0x80 : 0x00);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp2 & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE 9C       - RRC A
case 0x9C:
  PokeCPU.tmp = (PokeCPU.BA.B.l >> 1) | (PokeCPU.BA.B.l << 7);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE 9D       - RRC B
case 0x9D:
  PokeCPU.tmp = (PokeCPU.BA.B.h >> 1) | (PokeCPU.BA.B.h << 7);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.h & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE 9E nn    - RRC [NN + #nn]
case 0x9E:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = (PokeCPU.tmp2 >> 1) | (PokeCPU.tmp2 << 7);
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp2 & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE 9F       - RRC [HL]
case 0x9F:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = (PokeCPU.tmp2 >> 1) | (PokeCPU.tmp2 << 7);
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp2 & 0x01) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  break;

// CE A0       - NOT A
case 0xA0:
  PokeCPU.BA.B.l = PokeCPU.BA.B.l ^ 0xFF;
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.l == 0x00) PokeCPU.F |= C_FLAG;
  break;

// CE A1       - NOT B
case 0xA1:
  PokeCPU.BA.B.h = PokeCPU.BA.B.h ^ 0xFF;
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.h & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.h == 0x00) PokeCPU.F |= C_FLAG;
  break;

// CE A2 nn    - NOT [NN + #nn]
case 0xA2:
  PokeCPU.tmp = ReadPokeCPUEx(ReadNNOfs8()) ^ 0xFF;
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= C_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE A3       - NOT [HL]
case 0xA3:
  PokeCPU.tmp = ReadPokeCPUEx(PokeCPU.HL.D) ^ 0xFF;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp == 0x00) PokeCPU.F |= C_FLAG;
  break;

// CE A4       - NEG A
case 0xA4:
  PokeCPU.tmp = 0 - PokeCPU.BA.B.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(0, PokeCPU.BA.B.l, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.l = (unsigned char)PokeCPU.tmp;
  break;

// CE A5       - NEG B
case 0xA5:
  PokeCPU.tmp = 0 - PokeCPU.BA.B.h;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(0, PokeCPU.BA.B.h, PokeCPU.tmp & 0xFF);
  PokeCPU.BA.B.h = (unsigned char)PokeCPU.tmp;
  break;

// CE A6 nn    - NEG [NN + #nn]
case 0xA6:
  PokeCPU.tmp2 = ReadPokeCPUEx(ReadNNOfs8());
  PokeCPU.tmp = 0 - PokeCPU.tmp2;
  WritePokeCPUEx(ReadNNOfs8(), (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(0, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  break;

// CE A7       - NEG [HL]
case 0xA7:
  PokeCPU.tmp2 = ReadPokeCPUEx(PokeCPU.HL.D);
  PokeCPU.tmp = 0 - PokeCPU.tmp2;
  WritePokeCPUEx(PokeCPU.HL.D, (unsigned char)PokeCPU.tmp);
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(0, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  break;

// CE A8       - EXTS BA, A
case 0xA8:
  PokeCPU.BA.B.h = PokeCPU.BA.B.l & 0x80 ? 0xFF : 0x00;
  break;

// CE A9       - [INVALID]
case 0xA9:
  IllegalPokeCPU(0xCEA9);
  break;

// CE AA       - [INVALID]
case 0xAA:
  IllegalPokeCPU(0xCEAA);
  break;

// CE AB       - [INVALID]
case 0xAB:
  IllegalPokeCPU(0xCEAB);
  break;

// CE AC       - [INVALID]
case 0xAC:
  IllegalPokeCPU(0xCEAC);
  break;

// CE AD       - [INVALID]
case 0xAD:
  IllegalPokeCPU(0xCEAD);
  break;

// CE AE       - HALT
case 0xAE:
  //PokeCPU.Halt = true;
  break;

// CE AF       - DEBUG
case 0xAF:
  // ADD ME!
  IllegalPokeCPU(0xCEAF);
  break;

// CE B0 nn    - AND B, #nn
case 0xB0:
  PokeCPU.BA.B.h = PokeCPU.BA.B.h & ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.h & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.h == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE B1 nn    - AND L, #nn
case 0xB1:
  PokeCPU.HL.B.l = PokeCPU.HL.B.l & ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.HL.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.HL.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE B2 nn    - AND H, #nn
case 0xB2:
  PokeCPU.HL.B.h = PokeCPU.HL.B.h & ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.HL.B.h & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.HL.B.h == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE B3       - [INVALID]
case 0xB3:
  IllegalPokeCPU(0xCEB3);
  break;

// CE B4 nn    - OR B, #nn
case 0xB4:
  PokeCPU.BA.B.h = PokeCPU.BA.B.h | ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.h & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.h == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE B5 nn    - OR L, #nn
case 0xB5:
  PokeCPU.HL.B.l = PokeCPU.HL.B.l | ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.HL.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.HL.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE B6 nn    - OR H, #nn
case 0xB6:
  PokeCPU.HL.B.h = PokeCPU.HL.B.h | ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.HL.B.h & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.HL.B.h == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE B7       - [INVALID]
case 0xB7:
  IllegalPokeCPU(0xCEB7);
  break;

// CE B8 nn    - XOR B, #nn
case 0xB8:
  PokeCPU.BA.B.h = PokeCPU.BA.B.h ^ ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.h & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.BA.B.h == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE B9 nn    - XOR L, #nn
case 0xB9:
  PokeCPU.HL.B.l = PokeCPU.BA.B.l ^ ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.HL.B.l & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.HL.B.l == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE BA nn    - XOR H, #nn
case 0xBA:
  PokeCPU.HL.B.h = PokeCPU.HL.B.h ^ ReadPokeCPU(PokeCPU.PC.W.l);
  ClearFlags(S_FLAG | Z_FLAG);
  if (PokeCPU.HL.B.h & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.HL.B.h == 0x00) PokeCPU.F |= Z_FLAG;
  PokeCPU.PC.W.l++;
  break;

// CE BB       - [INVALID]
case 0xBB:
  IllegalPokeCPU(0xCEBB);
  break;

// CE BC nn    - CMP B, #nn
case 0xBC:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.BA.B.h - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.BA.B.h, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE BD nn    - CMP L, #nn
case 0xBD:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.HL.B.l - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.HL.B.l, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE BE nn    - CMP H, #nn
case 0xBE:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.HL.B.h - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.HL.B.h, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE BF nn    - CMP N, #nn
case 0xBF:
  PokeCPU.tmp2 = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.tmp = PokeCPU.NN.B.h - PokeCPU.tmp2;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x80) PokeCPU.F |= S_FLAG;
  if (PokeCPU.tmp & 0xFFFFFF00) PokeCPU.F |= C_FLAG;
  if ((PokeCPU.tmp & 0xFF) == 0x00) PokeCPU.F |= Z_FLAG;
  O_Flag_SUB(PokeCPU.NN.B.h, PokeCPU.tmp2, PokeCPU.tmp & 0xFF);
  PokeCPU.PC.W.l++;
  break;

// CE C0       - MOV A, N
case 0xC0:
  PokeCPU.BA.B.l = PokeCPU.NN.B.h;
  break;

// CE C1       - MOV A, F
case 0xC1:
  PokeCPU.BA.B.l = PokeCPU.F;
  break;

// CE C2       - MOV N, A
case 0xC2:
  PokeCPU.NN.B.h = PokeCPU.BA.B.l;
  break;

// CE C3       - MOV F, A
case 0xC3:
  PokeCPU.F = PokeCPU.BA.B.l;
  break;

// CE C4 nn    - MOV U, #nn
case 0xC4:
  PokeCPU.U = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// CE C5 nn    - MOVX HL, #nn
case 0xC5:
  PokeCPU.HL.B.x = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// CE C6 nn    - MOVX X1, #nn
case 0xC6:
  PokeCPU.X1.B.x = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// CE C7 nn    - MOVX X2, #nn
case 0xC7:
  PokeCPU.X2.B.x = ReadPokeCPU(PokeCPU.PC.W.l);
  PokeCPU.PC.W.l++;
  break;

// CE C8       - MOV A, V
case 0xC8:
  PokeCPU.BA.B.l = PokeCPU.V;
  break;

// CE C9       - MOVX A, HL
case 0xC9:
  PokeCPU.BA.B.l = PokeCPU.HL.B.x;
  break;

// CE CA       - MOVX A, X1
case 0xCA:
  PokeCPU.BA.B.l = PokeCPU.X1.B.x;
  break;

// CE CB       - MOVX A, X2
case 0xCB:
  PokeCPU.BA.B.l = PokeCPU.X2.B.x;
  break;

// CE CC       - MOV U, A
case 0xCC:
  PokeCPU.U = PokeCPU.BA.B.l;
  break;

// CE CD       - MOVX HL, A
case 0xCD:
  PokeCPU.HL.B.x = PokeCPU.BA.B.l;
  break;

// CE CE       - MOVX X1, A
case 0xCE:
  PokeCPU.X1.B.x = PokeCPU.BA.B.l;
  break;

// CE CF       - MOVX X2, A
case 0xCF:
  PokeCPU.X2.B.x = PokeCPU.BA.B.l;
  break;

// CE D0 nn nn - MOV A, [#nnnn]
case 0xD0:
  PokeCPU.BA.B.l = ReadPokeCPU(ReadPC16());
  PokeCPU.PC.W.l += 2;
  break;

// CE D1 nn nn - MOV B, [#nnnn]
case 0xD1:
  PokeCPU.BA.B.h = ReadPokeCPU(ReadPC16());
  PokeCPU.PC.W.l += 2;
  break;

// CE D2 nn nn - MOV L, [#nnnn]
case 0xD2:
  PokeCPU.HL.B.l = ReadPokeCPU(ReadPC16());
  PokeCPU.PC.W.l += 2;
  break;

// CE D3 nn nn - MOV H, [#nnnn]
case 0xD3:
  PokeCPU.HL.B.h = ReadPokeCPU(ReadPC16());
  PokeCPU.PC.W.l += 2;
  break;

// CE D4 nn nn - MOV [#nnnn], A
case 0xD4:
  WritePokeCPU(ReadPC16(), PokeCPU.BA.B.l);
  PokeCPU.PC.W.l += 2;
  break;

// CE D5 nn nn - MOV [#nnnn], B
case 0xD5:
  WritePokeCPU(ReadPC16(), PokeCPU.BA.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// CE D6 nn nn - MOV [#nnnn], L
case 0xD6:
  WritePokeCPU(ReadPC16(), PokeCPU.HL.B.l);
  PokeCPU.PC.W.l += 2;
  break;

// CE D7 nn nn - MOV [#nnnn], H
case 0xD7:
  WritePokeCPU(ReadPC16(), PokeCPU.HL.B.h);
  PokeCPU.PC.W.l += 2;
  break;

// CE D8       - MUL L, A
case 0xD8:
  PokeCPU.tmp = PokeCPU.HL.B.l * PokeCPU.BA.B.l;
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.tmp & 0x8000) PokeCPU.F |= S_FLAG;
  if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
  PokeCPU.HL.W.l = (unsigned short)PokeCPU.tmp;
  break;

// CE D9       - DIV HL, A
case 0xD9:
  ClearFlags(S_FLAG | O_FLAG | C_FLAG | Z_FLAG);
  if (PokeCPU.BA.B.l) {
    PokeCPU.tmp = PokeCPU.HL.W.l / PokeCPU.BA.B.l;
    PokeCPU.tmp2 = PokeCPU.HL.W.l % PokeCPU.BA.B.l;
    if (PokeCPU.tmp & 0xFFFFFF00) {PokeCPU.F |= S_FLAG; PokeCPU.F |= O_FLAG;}
    if ((PokeCPU.tmp & 0xFFFF) == 0x0000) PokeCPU.F |= Z_FLAG;
    PokeCPU.HL.B.l = (unsigned char)PokeCPU.tmp;
    PokeCPU.HL.B.h = (unsigned char)PokeCPU.tmp2;
  } else {
    PokeCPU.HL.W.l = 0;
    SetFlags(Z_FLAG);
  }
  break;

// CE DA       - [INVALID]
case 0xDA:
  IllegalPokeCPU(0xCEDA);
  break;

// CE DB       - [INVALID]
case 0xDB:
  IllegalPokeCPU(0xCEDB);
  break;

// CE DC       - [INVALID]
case 0xDC:
  IllegalPokeCPU(0xCEDC);
  break;

// CE DD       - [INVALID]
case 0xDD:
  IllegalPokeCPU(0xCEDD);
  break;

// CE DE       - [INVALID]
case 0xDE:
  IllegalPokeCPU(0xCEDE);
  break;

// CE DF       - [INVALID]
case 0xDF:
  IllegalPokeCPU(0xCEDF);
  break;

// CE E0 nn    - JLB #nn
case 0xE0:
  if ((PokeCPU.F & S_FLAG) != (PokeCPU.F & O_FLAG)) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE E1 nn    - JLEB #nn
case 0xE1:
  if ((PokeCPU.F & Z_FLAG) || ((PokeCPU.F & S_FLAG) != (PokeCPU.F & O_FLAG))) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE E2 nn    - JGB #nn
case 0xE2:
  if ((!(PokeCPU.F & Z_FLAG)) && ((PokeCPU.F & S_FLAG) == (PokeCPU.F & O_FLAG))) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE E3 nn    - JGEB #nn
case 0xE3:
  if ((PokeCPU.F & S_FLAG) == (PokeCPU.F & O_FLAG)) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE E4 nn    - JOB #nn
case 0xE4:
  if (PokeCPU.F & O_FLAG) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE E5 nn    - JNOB #nn
case 0xE5:
  if (!(PokeCPU.F & O_FLAG)) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE E6 nn    - JNSB #nn
case 0xE6:
  if (!(PokeCPU.F & S_FLAG)) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE E7 nn    - JS #nn
case 0xE7:
  if (PokeCPU.F & S_FLAG) {
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE E8       - ???
case 0xE8:
  IllegalPokeCPU(0xCEE8);
  break;

// CE E9       - ???
case 0xE9:
  IllegalPokeCPU(0xCEE9);
  break;

// CE EA       - ???
case 0xEA:
  IllegalPokeCPU(0xCEEA);
  break;

// CE EB       - ???
case 0xEB:
  IllegalPokeCPU(0xCEEB);
  break;

// CE EC       - ???
case 0xEC:
  IllegalPokeCPU(0xCEEC);
  break;

// CE ED       - ???
case 0xED:
  IllegalPokeCPU(0xCEED);
  break;

// CE EE       - ???
case 0xEE:
  IllegalPokeCPU(0xCEEE);
  break;

// CE EF       - ???
case 0xEF:
  IllegalPokeCPU(0xCEEF);
  break;

// CE F0 nn    - CALLLB #nn
case 0xF0:
  if ((PokeCPU.F & S_FLAG) != (PokeCPU.F & O_FLAG)) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE F1 nn    - CALLLEB #nn
case 0xF1:
  if ((PokeCPU.F & Z_FLAG) || ((PokeCPU.F & S_FLAG) != (PokeCPU.F & O_FLAG))) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE F2 nn    - CALLGB #nn
case 0xF2:
  if ((!(PokeCPU.F & Z_FLAG)) && ((PokeCPU.F & S_FLAG) == (PokeCPU.F & O_FLAG))) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE F3 nn    - CALLGEB #nn
case 0xF3:
  if ((PokeCPU.F & S_FLAG) == (PokeCPU.F & O_FLAG)) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE F4 nn    - CALLO #nn
case 0xF4:
  if (PokeCPU.F & O_FLAG) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE F5 nn    - CALLNO #nn
case 0xF5:
  if (!(PokeCPU.F & O_FLAG)) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE F6 nn    - CALLNS #nn
case 0xF6:
  if (!(PokeCPU.F & S_FLAG)) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE F7 nn    - CALLS #nn
case 0xF7:
  if (PokeCPU.F & S_FLAG) {
    PokeCPU.SP.W.l = PokeCPU.SP.W.l - 3;
    PokeCPU.PC.W.l++;
    WritePokeCPU(PokeCPU.SP.W.l, PokeCPU.PC.B.l);
    WritePokeCPU(PokeCPU.SP.W.l + 1, PokeCPU.PC.B.h);
    WritePokeCPU(PokeCPU.SP.W.l + 2, PokeCPU.V);
    PokeCPU.PC.W.l--;
    PokeCPU.V = PokeCPU.U;
    PokeCPU.UT = POKECPU_VREGPRESET;
    PokeCPU.PC.W.l = PokeCPU.PC.W.l + S8_Jump(ReadPokeCPU(PokeCPU.PC.W.l));
  } else PokeCPU.PC.W.l++;
  break;

// CE F8       - ???
case 0xF8:
  IllegalPokeCPU(0xCEF8);
  break;

// CE F9       - ???
case 0xF9:
  IllegalPokeCPU(0xCEF9);
  break;

// CE FA       - ???
case 0xFA:
  IllegalPokeCPU(0xCEFA);
  break;

// CE FB       - ???
case 0xFB:
  IllegalPokeCPU(0xCEFB);
  break;

// CE FC       - ???
case 0xFC:
  IllegalPokeCPU(0xCEFC);
  break;

// CE FD       - ???
case 0xFD:
  IllegalPokeCPU(0xCEFD);
  break;

// CE FE       - ???
case 0xFE:
  IllegalPokeCPU(0xCEFE);
  break;

// CE FF       - ???
case 0xFF:
  IllegalPokeCPU(0xCEFF);
  break;

default:
  IllegalPokeCPU(0xFFFFCEFF);
  break;

