/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __EXECUTOR_H
#define __EXECUTOR_H

struct CodePoint
{
	char *m_Name;
	long m_Address;	
	bool m_AutoRemove;
	int  m_Size;

	unsigned char m_Data[16];

	CodePoint *m_Parent, *m_Left, *m_Right;
};

struct CPExplore
{
	CodePoint *m_CP;
	
	bool m_ExploredChildren;
};

class Executor
{
public:
	Executor::Executor( Mini *mini );
	Executor::~Executor();

	bool Executor::Running();
	void Executor::Stop();
	void Executor::Run();
	void Executor::DebugRun();
	void Executor::StepOperation();
	void Executor::StepCycles( int cycles );
	void Executor::StepFrame();

	void Executor::DeleteSymbols();
	void Executor::DeleteBreaks();
	void Executor::DeleteWatchs();

	bool Executor::HonoringBreaks();
	void Executor::HonorBreaks( bool enable );

	int Executor::BreakCount();
	int Executor::WatchCount();
	int Executor::SymbolCount();

	char* Executor::GetSymbol( long address );
	void Executor::NewSymbol( const char *name, long address );
	void Executor::LoadSymbols( char *file );
	void Executor::SaveSymbols( char *file );

	void Executor::NewWatchpoint( long address, int datasize );
	void Executor::NewBreakpoint( long address, bool temporary = false );

	bool Executor::GetBreakpoint( long address, bool execution = false );

	void Executor::DeleteWatch( long address );
	void Executor::DeleteBreak( long address );
	void Executor::DeleteSymbol( long address );

	CodePoint *Executor::ListBreakpoint( bool reset = false );
	CodePoint *Executor::ListWatchpoint( bool reset = false );
	CodePoint *Executor::ListSymbol( bool reset = false );

	bool Executor::RuntimeLoop();
private:
	CodePoint *Executor::Explore( CodePoint **ex );
	bool Executor::StuffCodePoint( CodePoint **tree, CodePoint *node );
	void Executor::DeletePoint( CodePoint **tree, CodePoint *node );

	void Executor::DeletePoint( CodePoint *point );

	bool m_Running;
	bool m_HonorBreakpoints;
	int  m_StepCycles;

	CodePoint *m_BreakExplore;
	CodePoint *m_WatchExplore;
	CodePoint *m_SymbolExplore;

	Mini      *m_Emulator;
	CodePoint *m_Breaks;
	CodePoint *m_Watchs;
	CodePoint *m_Symbols;

	int m_SymbolCount;
	int m_BreakCount;
	int m_WatchCount;
};

#endif