/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "minimon.h"

void MinxCore::ExecCodeCE()
{
	unsigned char code;

	Fetch( code );

	switch( code )
	{
	case 0x00: // addb A, [X1+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Add( m_CpuReg.byte.A, byte, false );
		}
		break ;
    case 0x01: // addb A, [X2+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Add( m_CpuReg.byte.A, byte, false );
		}
		break ;
    case 0x02: // addb A, [X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Add( m_CpuReg.byte.A, byte, false );
		}
		break ;
    case 0x03: // addb A, [X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Add( m_CpuReg.byte.A, byte, false );
		}
		break ;
    case 0x04: // addb [HL], A
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			Add( byte, m_CpuReg.byte.A, false );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x05: // addb [HL], %(i8)s
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Fetch( right );
			Add( left, right, false );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x06: // addb [HL], [X1]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.X, right );
			Add( left, right, false );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x07: // addb [HL], [X2]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.Y, right );
			Add( left, right, false );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x08: // addcb A, [X1+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Add( m_CpuReg.byte.A, byte, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		}
		break ;
    case 0x09: // addcb A, [X2+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Add( m_CpuReg.byte.A, byte, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		}
		break ;
    case 0x0A: // addcb A, [X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Add( m_CpuReg.byte.A, byte, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		}
		break ;
    case 0x0B: // addcb A, [X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Add( m_CpuReg.byte.A, byte, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		}
		break ;
    case 0x0C: // addcb [HL], A
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			Add( byte, m_CpuReg.byte.A, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x0D: // addcb [HL], %(i8)s
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Fetch( right );
			Add( left, right, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x0E: // addcb [HL], [X1]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.X, right );
			Add( left, right, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x0F: // addcb [HL], [X2]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.Y, right );
			Add( left, right, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x10: // subb A, [X1+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Sub( m_CpuReg.byte.A, byte, false );
		}
		break ;
    case 0x11: // subb A, [X2+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Sub( m_CpuReg.byte.A, byte, false );
		}
		break ;
    case 0x12: // subb A, [X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Sub( m_CpuReg.byte.A, byte, false );
		}
		break ;
    case 0x13: // subb A, [X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Sub( m_CpuReg.byte.A, byte, false );
		}
		break ;
    case 0x14: // subb [HL], A
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			Sub( byte, m_CpuReg.byte.A, false );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x15: // subb [HL], %(i8)s
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Fetch( right );
			Sub( left, right, false );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x16: // subb [HL], [X1]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.X, right );
			Sub( left, right, false );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x17: // subb [HL], [X2]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.Y, right );
			Sub( left, right, false );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x18: // subcb A, [X1+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Sub( m_CpuReg.byte.A, byte, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		}
		break ;
    case 0x19: // subcb A, [X2+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Sub( m_CpuReg.byte.A, byte, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		}
		break ;
    case 0x1A: // subcb A, [X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Sub( m_CpuReg.byte.A, byte, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		}
		break ;
    case 0x1B: // subcb A, [X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Sub( m_CpuReg.byte.A, byte, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
		}
		break ;
    case 0x1C: // subcb [HL], A
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			Sub( byte, m_CpuReg.byte.A, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x1D: // subcb [HL], %(i8)s
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Fetch( right );
			Sub( left, right, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x1E: // subcb [HL], [X1]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.addr.XA, right );
			Sub( left, right, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x1F: // subcb [HL], [X2]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.addr.YA, right );
			Sub( left, right, (m_CpuReg.byte.F & FLAG_CARRY) != 0 );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x20: // andb A, [X1+%(i8)s]		
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			m_CpuReg.byte.A &= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x21: // andb A, [X2+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			m_CpuReg.byte.A &= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x22: // andb A, [X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			m_CpuReg.byte.A &= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x23: // andb A, [X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			m_CpuReg.byte.A &= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x24: // andb [HL],A
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			byte &= m_CpuReg.byte.A;
			Flags8( FLAG_ZERO | FLAG_SIGN, byte );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x25: // andb [HL],%(i8)s
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Fetch( right );
			left &= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x26: // andb [HL],[X1]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.X, right );
			left &= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x27: // andb [HL],[X2]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.Y, right );
			left &= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x28: // orb A, [X1+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			m_CpuReg.byte.A |= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x29: // orb A, [X2+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			m_CpuReg.byte.A |= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x2A: // orb A, [X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			m_CpuReg.byte.A |= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x2B: // orb A, [X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			m_CpuReg.byte.A |= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x2C: // orb [HL],A
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			byte |= m_CpuReg.byte.A;
			Flags8( FLAG_ZERO | FLAG_SIGN, byte );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x2D: // orb [HL],%(i8)s
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Fetch( right );
			left |= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x2E: // orb [HL],[X1]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.X, right );
			left |= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x2F: // orb [HL],[X2]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.Y, right );
			left |= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x30: // cmpb A, [X1+%(i8)s]
		{
			unsigned char left, right;

			left = m_CpuReg.byte.A;
			Fetch( right );
			Peek( ( m_CpuReg.word.X + (signed char)right ) & 0xFFFF | (m_CpuReg.byte.XI << 16), right );
			Sub( left, right, false );
		}
		break ;
    case 0x31: // cmpb A, [X2+%(i8)s]
		{
			unsigned char left, right;

			left = m_CpuReg.byte.A;
			Fetch( right );
			Peek( ( m_CpuReg.word.Y + (signed char)right ) & 0xFFFF | (m_CpuReg.byte.YI << 16), right );
			Sub( left, right, false );
		}
		break ;
    case 0x32: // cmpb A, [X1+L]
		{
			unsigned char left, right;

			left = m_CpuReg.byte.A;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), right );
			Sub( left, right, false );
		}
		break ;
    case 0x33: // cmpb A, [X2+L]
		{
			unsigned char left, right;

			left = m_CpuReg.byte.A;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), right );
			Sub( left, right, false );
		}
		break ;
    case 0x34: // cmpb [HL], A
		{
			unsigned char left;
			Peek( m_CpuReg.addr.HLA, left );
			Sub( left, m_CpuReg.byte.A, false );
		}
		break ;
    case 0x35: // cmpb [HL], %(i8)s
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Fetch( right );
			Sub( left, right, false );
		}
		break ;
    case 0x36: // cmpb [HL], [X1]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.X, right );
			Sub( left, right, false );
		}
		break ;
    case 0x37: // cmpb [HL], [X2]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.Y, right );
			Sub( left, right, false );
		}
		break ;
    case 0x38: // xorb A, [X1+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			m_CpuReg.byte.A ^= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x39: // xorb A, [X2+%(i8)s]
		{
			unsigned char byte;

			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			m_CpuReg.byte.A ^= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x3A: // xorb A, [X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			m_CpuReg.byte.A ^= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x3B: // xorb A, [X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			m_CpuReg.byte.A ^= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		}
		break ;
    case 0x3C: // xorb [HL],A
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			byte ^= m_CpuReg.byte.A;
			Flags8( FLAG_ZERO | FLAG_SIGN, byte );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x3D: // xorb [HL],%(i8)s
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Fetch( right );
			left ^= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left);
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x3E: // xorb [HL],[X1]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.X, right );
			left ^= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x3F: // xorb [HL],[X2]
		{
			unsigned char left, right;
			Peek( m_CpuReg.addr.HLA, left );
			Peek( m_CpuReg.word.Y, right );
			left ^= right;
			Flags8( FLAG_ZERO | FLAG_SIGN, left );
			Poke( m_CpuReg.addr.HLA, left );
		}
		break ;
    case 0x40: // movb A,[X1+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.A );
		}
		break ;
    case 0x41: // movb A,[X2+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.A );
		}
		break ;
    case 0x42: // movb A,[X1+L]
		Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.A );
		break ;
    case 0x43: // movb A,[X2+L]
		Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.A );
		break ;
    case 0x44: // movb [X1+%(i8)s],A
		{
			unsigned char byte;
			Fetch( byte );
			Poke( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.A );
		}
		break ;
    case 0x45: // movb [X2+%(i8)s],A
		{
			unsigned char byte;
			Fetch( byte );
			Poke( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.A );
		}
		break ;
    case 0x46: // movb [X1+L],A
		Poke( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.A );
		break ;
    case 0x47: // movb [X2+L],A
		Poke( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.A );
		break ;
    case 0x48: // movb B,[X1+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.B );
		}
		break ;
    case 0x49: // movb B,[X2+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.B );
		}
		break ;
    case 0x4A: // movb B,[X1+L]
		Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.B );
		break ;
    case 0x4B: // movb B,[X2+L]
		Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.B );
		break ;
    case 0x4C: // movb [X1+%(i8)s],B
		{
			unsigned char byte;
			Fetch( byte );
			Poke( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.B );
		}
		break ;
    case 0x4D: // movb [X2+%(i8)s],B
		{
			unsigned char byte;
			Fetch( byte );
			Poke( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.B );
		}
		break ;
    case 0x4E: // movb [X1+L],B
		Poke( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.B );
		break ;
    case 0x4F: // movb [X2+L],B
		Poke( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.B );
		break ;
    case 0x50: // movb L,[X1+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.L );
		}
		break ;
    case 0x51: // movb L,[X2+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.L );
		}
		break ;
    case 0x52: // movb L,[X1+L]
		Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.L );
		break ;
    case 0x53: // movb L,[X2+L]
		Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.L );
		break ;
    case 0x54: // movb [X1+%(i8)s],L
		{
			unsigned char byte;
			Fetch( byte );
			Poke( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.L );
		}
		break ;
    case 0x55: // movb [X2+%(i8)s],L
		{
			unsigned char byte;
			Fetch( byte );
			Poke( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.L );
		}
		break ;
    case 0x56: // movb [X1+L],L
		Poke( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.L );
		break ;
    case 0x57: // movb [X2+L],L
		Poke( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.L );
		break ;
    case 0x58: // movb H,[X1+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.H );
		}
		break ;
    case 0x59: // movb H,[X2+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.H );
		}
		break ;
    case 0x5A: // movb H,[X1+L]
		Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.H );
		break ;
    case 0x5B: // movb H,[X2+L]
		Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.H );
		break ;
    case 0x5C: // movb [X1+%(i8)s],H
		{
			unsigned char byte;
			Fetch( byte );
			Poke( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.H );
		}
		break ;
    case 0x5D: // movb [X2+%(i8)s],H
		{
			unsigned char byte;
			Fetch( byte );
			Poke( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.H );
		}
		break ;
    case 0x5E: // movb [X1+L],H
		Poke( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), m_CpuReg.byte.H );
		break ;
    case 0x5F: // movb [X2+L],H
		Poke( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), m_CpuReg.byte.H );
		break ;
    case 0x60: // movb [HL],[X1+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x61: // movb [HL],[X2+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x62: // movb [HL],[X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x63: // movb [HL],[X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x68: // movb [X1],[X1+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Poke( m_CpuReg.addr.XA, byte );
		}
		break ;
    case 0x69: // movb [X1],[X2+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Poke( m_CpuReg.addr.XA, byte );
		}
		break ;
    case 0x6A: // movb [X1],[X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Poke( m_CpuReg.addr.XA, byte );
		}
		break ;
    case 0x6B: // movb [X1],[X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Poke( m_CpuReg.addr.XA, byte );
		}
		break ;
    case 0x78: // movb [X2],[X1+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.X + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Poke( m_CpuReg.addr.YA, byte );
		}
		break ;
    case 0x79: // movb [X2],[X2+%(i8)s]
		{
			unsigned char byte;
			Fetch( byte );
			Peek( ( m_CpuReg.word.Y + (signed char)byte ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Poke( m_CpuReg.addr.YA, byte );
		}
		break ;
    case 0x7A: // movb [X2],[X1+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.X + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.XI << 16), byte );
			Poke( m_CpuReg.addr.YA, byte );
		}
		break ;
    case 0x7B: // movb [X2],[X2+L]
		{
			unsigned char byte;
			Peek( ( m_CpuReg.word.Y + (signed char)m_CpuReg.byte.L ) & 0xFFFF | (m_CpuReg.byte.YI << 16), byte );
			Poke( m_CpuReg.addr.YA, byte );
		}
		break ;
    case 0x80: // salb A
		Flag(    FLAG_CARRY, (m_CpuReg.byte.A & 0x80) != 0 );
		Flag( FLAG_OVERFLOW, !(m_CpuReg.byte.A & 0x40) != !(m_CpuReg.byte.A & 0x80) );
		Flag(     FLAG_SIGN, (m_CpuReg.byte.A & 0x80) != 0 );

		m_CpuReg.byte.A = m_CpuReg.byte.A << 1;
		Flag(     FLAG_ZERO, m_CpuReg.byte.A == 0 );
		break;
    case 0x81: // salb B
		Flag(    FLAG_CARRY, (m_CpuReg.byte.B & 0x80) != 0 );
		Flag( FLAG_OVERFLOW, !(m_CpuReg.byte.B & 0x40) != !(m_CpuReg.byte.B & 0x80) );
		Flag(     FLAG_SIGN, (m_CpuReg.byte.B & 0x80) != 0 );

		m_CpuReg.byte.B = m_CpuReg.byte.B << 1;
		Flag(     FLAG_ZERO, m_CpuReg.byte.B == 0 );
		break;
    case 0x82: // salb [NN+%(i8)s]
		{
			unsigned char byte;

			Fetch( m_CpuReg.byte.IndexN );
			Peek( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );

			Flag(    FLAG_CARRY, (byte & 0x80) != 0 );
			Flag( FLAG_OVERFLOW, !(byte & 0x40) != !(byte & 0x80) );
			Flag(     FLAG_SIGN, (byte & 0x80) != 0 );

			byte = byte << 1;
			Flag(     FLAG_ZERO, byte == 0 );

			Poke( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );
		}
		break;
    case 0x83: // salb [HL]
		{
			unsigned char byte;

			Peek( m_CpuReg.addr.HLA, byte );

			Flag(    FLAG_CARRY, (byte & 0x80) != 0 );
			Flag( FLAG_OVERFLOW, !(byte & 0x40) != !(byte & 0x80) );
			Flag(     FLAG_SIGN, (byte & 0x80) != 0 );

			byte = byte << 1;
			Flag(     FLAG_ZERO, byte == 0 );

			Poke( m_CpuReg.addr.HLA, byte );
		}
		break;
    case 0x84: // shlb A
		Flag( FLAG_CARRY, (m_CpuReg.byte.A & 0x80) != 0 );
		m_CpuReg.byte.A <<= 1;
		Flag( FLAG_SIGN, (m_CpuReg.byte.A & 0x80) != 0 );
		Flag( FLAG_ZERO, m_CpuReg.byte.A == 0 );
		break ;
    case 0x85: // shlb B
		Flag( FLAG_CARRY, (m_CpuReg.byte.B & 0x80) != 0 );
		m_CpuReg.byte.B <<= 1;
		Flag( FLAG_SIGN, (m_CpuReg.byte.B & 0x80) != 0 );
		Flag( FLAG_ZERO, m_CpuReg.byte.B == 0 );
		break ;
    case 0x86: // shlb [NN+%(i8)s]
		{
			unsigned char byte;
			Fetch( m_CpuReg.byte.IndexN );
			Peek( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );

			Flag( FLAG_CARRY, (byte & 0x80) != 0 );
			byte <<= 1;
			Flag( FLAG_SIGN, (byte & 0x80) != 0 );
			Flag( FLAG_ZERO, byte == 0 );

			Poke( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );
		}
		break ;
    case 0x87: // shlb [HL]
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );

			Flag( FLAG_CARRY, (byte & 0x80) != 0 );
			byte <<= 1;
			Flag( FLAG_SIGN, (byte & 0x80) != 0 );
			Flag( FLAG_ZERO, byte == 0 );

			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x88: // sarb A
		Flag( FLAG_CARRY, (m_CpuReg.byte.A & 0x01) != 0 );
		m_CpuReg.byte.A = (m_CpuReg.byte.A & 0x80) | (m_CpuReg.byte.A >> 1);
		Flag( FLAG_OVERFLOW, false );
		Flag( FLAG_SIGN, (m_CpuReg.byte.A & 0x80) != 0 );
		Flag( FLAG_ZERO, m_CpuReg.byte.A == 0 );
		break ;
    case 0x89: // sarb B
		Flag( FLAG_CARRY, (m_CpuReg.byte.B & 0x01) != 0 );
		m_CpuReg.byte.B = (m_CpuReg.byte.B & 0x80) | (m_CpuReg.byte.B >> 1);
		Flag( FLAG_OVERFLOW, false );
		Flag( FLAG_SIGN, (m_CpuReg.byte.B & 0x80) != 0 );
		Flag( FLAG_ZERO, m_CpuReg.byte.B == 0 );
		break ;
    case 0x8A: // sarb [NN+%(i8)s]
		{
			unsigned char byte;
			Fetch( m_CpuReg.byte.IndexN );
			Peek( m_CpuReg.byte.I << 16 | m_CpuReg.word.N, byte );

			Flag( FLAG_CARRY, (byte & 0x01) != 0 );
			byte = (byte & 0x80) | (byte >> 1);
			Flag( FLAG_OVERFLOW, false );
			Flag( FLAG_SIGN, (byte & 0x80) != 0 );
			Flag( FLAG_ZERO, byte == 0 );

			Poke( m_CpuReg.byte.I << 16 | m_CpuReg.word.N, byte );
		}
		break ;
    case 0x8B: // sarb [HL]
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );

			Flag( FLAG_CARRY, (byte & 0x01) != 0 );
			byte = (byte & 0x80) | (byte >> 1);
			Flag( FLAG_OVERFLOW, false );
			Flag( FLAG_SIGN, (byte & 0x80) != 0 );
			Flag( FLAG_ZERO, byte == 0 );

			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x8C: // shrb A
		Flag( FLAG_CARRY, (m_CpuReg.byte.A & 0x01) != 0 );
		m_CpuReg.byte.A >>= 1;
		Flag( FLAG_SIGN, (m_CpuReg.byte.A & 0x80) != 0 );
		Flag( FLAG_ZERO, m_CpuReg.byte.A == 0 );
		break ;
    case 0x8D: // shrb B
		Flag( FLAG_CARRY, (m_CpuReg.byte.B & 0x01) != 0 );
		m_CpuReg.byte.B >>= 1;
		Flag( FLAG_SIGN, (m_CpuReg.byte.B & 0x80) != 0 );
		Flag( FLAG_ZERO, m_CpuReg.byte.B == 0 );
		break ;
    case 0x8E: // shrb [NN+%(i8)s]
		{
			unsigned char byte;
			Fetch( m_CpuReg.byte.IndexN );
			Peek( m_CpuReg.byte.I << 16 | m_CpuReg.word.N, byte );

			Flag( FLAG_CARRY, (byte & 0x01) != 0 );
			byte >>= 1;
			Flag( FLAG_SIGN, (byte & 0x80) != 0 );
			Flag( FLAG_ZERO, byte == 0 );

			Poke( m_CpuReg.byte.I << 16 | m_CpuReg.word.N, byte );
		}
		break ;
    case 0x8F: // shrb [HL]
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );

			Flag( FLAG_CARRY, (byte & 0x01) != 0 );
			byte >>= 1;
			Flag( FLAG_SIGN, (byte & 0x80) != 0 );
			Flag( FLAG_ZERO, byte == 0 );

			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0x90: // rolcb A
		{
			unsigned short result;

			result = (m_CpuReg.byte.A << 1) | ((m_CpuReg.byte.F & FLAG_CARRY) ? 1 : 0);
			Flag( FLAG_CARRY, (result & 0x100) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );
			m_CpuReg.byte.A = (unsigned char) result;
		}
		break ;
    case 0x91: // rolcb B
		{
			unsigned short result;

			result = (m_CpuReg.byte.B << 1) | ((m_CpuReg.byte.F & FLAG_CARRY) ? 1 : 0);
			Flag( FLAG_CARRY, (result & 0x100) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );
			m_CpuReg.byte.B = (unsigned char) result;
		}
		break ;
    case 0x92: // rolcb [NN+%(i8)s]
		{
			unsigned short result;
			unsigned char byte;

			Fetch( m_CpuReg.byte.IndexN );
			Peek( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );

			result = (byte << 1) | ((m_CpuReg.byte.F & FLAG_CARRY) ? 1 : 0);
			Flag( FLAG_CARRY, (result & 0x100) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );

			Poke( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, (unsigned char) result );
		}
		break ;
    case 0x93: // rolcb [HL]
		{
			unsigned short result;
			unsigned char byte;

			Peek( m_CpuReg.addr.HLA, byte );

			result = (byte << 1) | ((m_CpuReg.byte.F & FLAG_CARRY) ? 1 : 0);
			Flag( FLAG_CARRY, (result & 0x100) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );

			Poke( m_CpuReg.addr.HLA, (unsigned char) result );
		}
		break ;
    case 0x94: // rolb A
		{
			unsigned short result;

			result = (m_CpuReg.byte.A << 1) | ((m_CpuReg.byte.A & 0x80) ? 1 : 0);
			Flag( FLAG_CARRY, (result & 0x100) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			m_CpuReg.byte.A = (unsigned char) result;
			Flag( FLAG_ZERO, m_CpuReg.byte.A == 0 );
		}
		break ;
    case 0x95: // rolb B
		{
			unsigned short result;

			result = (m_CpuReg.byte.B << 1) | ((m_CpuReg.byte.B & 0x80) ? 1 : 0);
			Flag( FLAG_CARRY, (result & 0x100) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );
			m_CpuReg.byte.B = (unsigned char) result;
		}
		break ;
    case 0x96: // rolb [NN+%(i8)s]
		{
			unsigned short result;
			unsigned char byte;

			Fetch( m_CpuReg.byte.IndexN );
			Peek( m_CpuReg.byte.I << 16 | m_CpuReg.word.N, byte );

			result = (byte << 1) | ((byte & 0x80) ? 1 : 0);
			Flag( FLAG_CARRY, (result & 0x100) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );

			Poke( m_CpuReg.byte.I << 16 | m_CpuReg.word.N, (unsigned char) result );
		}
		break ;
    case 0x97: // rolb [HL]
		{
			unsigned short result;
			unsigned char byte;

			Peek( m_CpuReg.addr.HLA, byte );

			result = (byte << 1) | ((byte & 0x80) ? 1 : 0);
			Flag( FLAG_CARRY, (result & 0x100) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );

			Poke( m_CpuReg.addr.HLA, (unsigned char) result );
		}
		break ;
    case 0x98: // rorcb A
		{
			unsigned short result;

			result = (m_CpuReg.byte.A >> 1) | ((m_CpuReg.byte.F & FLAG_CARRY) ? 0x80 : 0x00);
			Flag( FLAG_CARRY, (m_CpuReg.byte.A & 0x01) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );
			m_CpuReg.byte.A = (unsigned char) result;
		}
		break ;
    case 0x99: // rorcb B
		{
			unsigned short result;

			result = (m_CpuReg.byte.B >> 1) | ((m_CpuReg.byte.F & FLAG_CARRY) ? 0x80 : 0x00);
			Flag( FLAG_CARRY, (m_CpuReg.byte.B & 0x01) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );
			m_CpuReg.byte.B = (unsigned char) result;
		}
		break ;
    case 0x9A: // rorcb [NN+%(i8)s]
		{
			unsigned short result;
			unsigned char byte;

			Fetch( m_CpuReg.byte.IndexN );
			Peek( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );

			result = (byte >> 1) | ((m_CpuReg.byte.F & FLAG_CARRY) ? 0x80 : 0x00);
			Flag( FLAG_CARRY, (byte & 0x01) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );

			Poke( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, (unsigned char) result );
		}
		break ;
    case 0x9B: // rorcb [HL]
		{
			unsigned short result;
			unsigned char byte;

			Peek( m_CpuReg.addr.HLA, byte );

			result = (byte >> 1) | ((m_CpuReg.byte.F & FLAG_CARRY) ? 0x80 : 0x00);
			Flag( FLAG_CARRY, (byte & 0x01) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );

			Poke( m_CpuReg.addr.HLA, (unsigned char) result );
		}
		break ;
    case 0x9C: // rorb A
		{
			unsigned short result;

			result = (m_CpuReg.byte.A >> 1) | ((m_CpuReg.byte.A & 0x01) ? 0x80 : 0x00);
			Flag( FLAG_CARRY, (m_CpuReg.byte.A & 0x01) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );
			m_CpuReg.byte.A = (unsigned char) result;
		}
		break ;
    case 0x9D: // rorb B
		{
			unsigned short result;

			result = (m_CpuReg.byte.B >> 1) | ((m_CpuReg.byte.B & 0x01) ? 0x80 : 0x00);
			Flag( FLAG_CARRY, (m_CpuReg.byte.B & 0x01) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );
			m_CpuReg.byte.B = (unsigned char) result;
		}
		break ;
    case 0x9E: // rorb [NN+%(i8)s]
		{
			unsigned short result;
			unsigned char byte;

			Fetch( m_CpuReg.byte.IndexN );
			Peek( m_CpuReg.byte.I << 16 | m_CpuReg.word.N, byte );

			result = (byte >> 1) | ((byte >> 1 & 0x01) ? 0x80 : 0x00);
			Flag( FLAG_CARRY, (byte & 0x01) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );

			Poke( m_CpuReg.byte.I << 16 | m_CpuReg.word.N, (unsigned char) result );
		}
		break ;
    case 0x9F: // rorb [HL]
		{
			unsigned short result;
			unsigned char byte;

			Peek( m_CpuReg.addr.HLA, byte );

			result = (byte >> 1) | ((byte >> 1 & 0x01) ? 0x80 : 0x00);
			Flag( FLAG_CARRY, (byte & 0x01) != 0 );
			Flag( FLAG_SIGN, (result & 0x80) != 0 );
			Flag( FLAG_ZERO, (result & 0xFF) == 0 );

			Poke( m_CpuReg.addr.HLA, (unsigned char) result );
		}
		break ;
    case 0xA0: // notb A
		m_CpuReg.byte.A ^= 0xFF;
		Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		break ;
    case 0xA1: // notb B
		m_CpuReg.byte.B ^= 0xFF;
		Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
		break ;
    case 0xA2: // notb [NN+%(i8)s]
		{
			unsigned char byte;
			Fetch( m_CpuReg.byte.IndexN );
			Peek( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );
			byte ^= 0xFF;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
			Poke( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );
		}
		break ;
    case 0xA3: // notb [HL]
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			byte ^= 0xFF;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0xA4: // negb A
    	m_CpuReg.byte.A = -m_CpuReg.byte.A;
		Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.A );
		break ;
	case 0xA5: // negb B
    	m_CpuReg.byte.B = -m_CpuReg.byte.B;
		Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
		break ;
    case 0xA6: // negb [NN+%(i8)s]
		{
			unsigned char byte;
			Fetch( m_CpuReg.byte.IndexN );
			Peek( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );
			byte = -byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
			Poke( (m_CpuReg.byte.I << 16) | m_CpuReg.word.N, byte );
		}
		break ;
    case 0xA7: // negb [HL]
		{
			unsigned char byte;
			Peek( m_CpuReg.addr.HLA, byte );
			byte = -byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
			Poke( m_CpuReg.addr.HLA, byte );
		}
		break ;
    case 0xA8: // exts BA,A
		if ( m_CpuReg.byte.A & 0x80 ) {
			m_CpuReg.byte.B = 0xFF;
		}
		else
		{
			m_CpuReg.byte.B = 0x00;
		}
		break ;
    case 0xB0: // andb B,%(i8)s
		{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.B &= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
		}
		break ;
    case 0xB1: // andb L,%(i8)s
		{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.L &= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.L );
		}
		break ;
    case 0xB2: // andb H,%(i8)s
    	{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.H &= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.H );
		}
		break ;
	case 0xB4: // orb B,%(i8)s
		{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.B |= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
		}
		break ;
    case 0xB5: // orb L,%(i8)s
		{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.L |= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.L );
		}
		break ;
    case 0xB6: // orb H,%(i8)s
		{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.H |= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.H );
		}
		break ;
    case 0xB8: // xorb B,%(i8)s
		{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.B ^= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.B );
		}
		break ;
    case 0xB9: // xorb L,%(i8)s
		{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.L ^= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.L );
		}
		break ;
    case 0xBA: // xorb H,%(i8)s
		{
			unsigned char byte;
			Fetch( byte );
			m_CpuReg.byte.H ^= byte;
			Flags8( FLAG_ZERO | FLAG_SIGN, m_CpuReg.byte.H );
		}
		break ;
    case 0xBC: // cmpb B,%(i8)s
		{
			unsigned char left, right;
			left = m_CpuReg.byte.B;
			Fetch( right );
			Sub( left, right, false );
		}
		break ;
    case 0xBD: // cmpb L,%(i8)s
		{
			unsigned char left, right;
			left = m_CpuReg.byte.L;
			Fetch( right );
			Sub( left, right, false );
		}
		break ;
    case 0xBE: // cmpb H,%(i8)s
		{
			unsigned char left, right;
			left = m_CpuReg.byte.H;
			Fetch( right );
			Sub( left, right, false );
		}
		break ;
    case 0xBF: // cmpb N,%(i8)s
		{
			unsigned char left, right;
			left = m_CpuReg.byte.N;
			Fetch( right );
			Sub( left, right, false );
		}
		break ;
    case 0xC0: // movb A, N
		m_CpuReg.byte.A = m_CpuReg.byte.N;
		break;
    case 0xC1: // movb A, FLAGS
		m_CpuReg.byte.A = m_CpuReg.byte.F;
		break;
    case 0xC2: // movb N, A
		m_CpuReg.byte.N = m_CpuReg.byte.A;
		break;
    case 0xC3: // movb FLAGS, A
		m_CpuReg.byte.F = m_CpuReg.byte.A;
		break;
    case 0xC4: // movb U, %(i8)s
		Fetch( m_CpuReg.byte.U );
		break ;
    case 0xC5: // movx HL,%(i8)s
		Fetch( m_CpuReg.byte.I );
		break ;
    case 0xC6: // movx X1,%(i8)s
		Fetch( m_CpuReg.byte.XI );
		break ;
    case 0xC7: // movx X2,%(i8)s
		Fetch( m_CpuReg.byte.YI );
		break ;
    case 0xC8: // movb A, V
		m_CpuReg.byte.A = m_CpuReg.byte.V;
		break ;
    case 0xC9: // movx A, HL
		m_CpuReg.byte.A = m_CpuReg.byte.I;
		break ;
    case 0xCA: // movx A, X1 
		m_CpuReg.byte.A = m_CpuReg.byte.XI;
		break ;
    case 0xCB: // movx A, X2 
		m_CpuReg.byte.A = m_CpuReg.byte.YI;
		break ;
    case 0xCC: // movb U, A
		m_CpuReg.byte.U = m_CpuReg.byte.A;
		break ;
    case 0xCD: // movx HL, A
		m_CpuReg.byte.I = m_CpuReg.byte.A;
		break ;
    case 0xCE: // movx X1, A
		m_CpuReg.byte.XI = m_CpuReg.byte.A;
		break ;
    case 0xCF: // movx X2, A
		m_CpuReg.byte.YI = m_CpuReg.byte.A;
		break ;
    case 0xD0: // movb A,[%(i16)s]
		{
			unsigned short addr;

			Fetch( addr );
			Peek( addr, m_CpuReg.byte.A );
		}
		break ;
    case 0xD1: // movb B,[%(i16)s]
		{
			unsigned short addr;

			Fetch( addr );
			Peek( addr, m_CpuReg.byte.B );
		}
		break ;
    case 0xD2: // movb L,[%(i16)s]
		{
			unsigned short addr;

			Fetch( addr );
			Peek( addr, m_CpuReg.byte.L );
		}
		break ;
    case 0xD3: // movb H,[%(i16)s]
		{
			unsigned short addr;

			Fetch( addr );
			Peek( addr, m_CpuReg.byte.H );
		}
		break ;
    case 0xD4: // movb [%(i16)s],A
		{
			unsigned short addr;

			Fetch( addr );
			Poke( addr, m_CpuReg.byte.A );
		}
		break ;
    case 0xD5: // movb [%(i16)s],B
		{
			unsigned short addr;

			Fetch( addr );
			Poke( addr, m_CpuReg.byte.B );
		}
		break ;
    case 0xD6: // movb [%(i16)s],L
		{
			unsigned short addr;

			Fetch( addr );
			Poke( addr, m_CpuReg.byte.L );
		}
		break ;
    case 0xD7: // movb [%(i16)s],H
		{
			unsigned short addr;

			Fetch( addr );
			Poke( addr, m_CpuReg.byte.H );
		}
		break ;
    case 0xD8: // mul L, A
		m_CpuReg.word.HL = m_CpuReg.byte.L * m_CpuReg.byte.A;

		Flag( FLAG_CARRY,    false );
		Flag( FLAG_OVERFLOW, false );
		Flag( FLAG_ZERO, m_CpuReg.word.HL == 0 );
		Flag( FLAG_SIGN, (m_CpuReg.word.HL & 0x8000) != 0 );

		break ;
    case 0xD9: // div HL, A
		if( m_CpuReg.byte.A != 0 )
		{
			int result = m_CpuReg.word.HL / m_CpuReg.byte.A;

			Flag( FLAG_CARRY, false );

			if( result >= 0x100 )
			{
				Flag( FLAG_OVERFLOW | FLAG_SIGN, true );
				Flag( FLAG_ZERO, m_CpuReg.byte.L == 0 );
			}
			else
			{
				m_CpuReg.byte.H = m_CpuReg.word.HL % m_CpuReg.byte.A;
				m_CpuReg.byte.L = result;
				
				Flag( FLAG_ZERO, m_CpuReg.byte.L == 0 );
				Flag( FLAG_SIGN, (m_CpuReg.byte.L & 0x80) != 0 );
			}
		}
		else
		{
			Error( "Division by zero\nThe exception mode handling is not supported", 0, NULL );
			ForceIRQ( 0 );
		}
		break ;
    case 0xE0: // jlb %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( (((m_CpuReg.byte.F & FLAG_OVERFLOW) != 0) != ((m_CpuReg.byte.F & FLAG_SIGN) != 0)) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xE1: // jleb %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( (((m_CpuReg.byte.F & FLAG_OVERFLOW) == 0) != ((m_CpuReg.byte.F & FLAG_SIGN) == 0)) ||
				((m_CpuReg.byte.F & FLAG_ZERO) != 0 ) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xE2: // jgb %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( (((m_CpuReg.byte.F & FLAG_OVERFLOW) != 0) == ((m_CpuReg.byte.F & FLAG_SIGN) != 0)) &&
				((m_CpuReg.byte.F & FLAG_ZERO) == 0 ) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xE3: // jgeb %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( ((m_CpuReg.byte.F & FLAG_OVERFLOW) == 0) == ((m_CpuReg.byte.F & FLAG_SIGN) == 0) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xE4: // job %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.F & FLAG_OVERFLOW ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xE5: // jnob %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.F & FLAG_OVERFLOW ) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xE6: // jnsb %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !(m_CpuReg.byte.F & FLAG_SIGN) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xE7: // jsb %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.F & FLAG_SIGN ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xE8: // jnex 0, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.E & 1 ) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xE9: // jnex 1, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.E & 2 ) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xEA: // jnex 2, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.E & 4 ) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xEB: // jnex 3, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.E & 8 ) ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xEC: // jex 0, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.E & 1 ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xED: // jex 1, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.E & 2 ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xEE: // jex 2, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.E & 4 ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xEF: // jex 3, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.E & 8 ){
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xF0: // calll %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( (((m_CpuReg.byte.F & FLAG_OVERFLOW) != 0) != ((m_CpuReg.byte.F & FLAG_SIGN) != 0)) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xF1: // callle %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( (((m_CpuReg.byte.F & FLAG_OVERFLOW) != 0) != ((m_CpuReg.byte.F & FLAG_SIGN) != 0)) ||
				((m_CpuReg.byte.F & FLAG_ZERO) != 0 ) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xF2: // callg %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( (((m_CpuReg.byte.F & FLAG_OVERFLOW) != 0) == ((m_CpuReg.byte.F & FLAG_SIGN) != 0)) &&
				((m_CpuReg.byte.F & FLAG_ZERO) == 0 ) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xF3: // callge %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( ((m_CpuReg.byte.F & FLAG_OVERFLOW) != 0) == ((m_CpuReg.byte.F & FLAG_SIGN) != 0) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xF4: // callo %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.F & FLAG_OVERFLOW ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xF5: // callno %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.F & FLAG_OVERFLOW ) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xF6: // callp %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !(m_CpuReg.byte.F & FLAG_SIGN) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
    case 0xF7: // calln %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.F & FLAG_SIGN ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xF8: // callnex 0, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.E & 1 ) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xF9: // callnex 1, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.E & 2 ) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xFA: // callnex 2, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.E & 4 ) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xFB: // callnex 3, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( !( m_CpuReg.byte.E & 8 ) ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xFC: // callex 0, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.E & 1 ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xFD: // callex 1, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.E & 2 ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xFE: // callex 2, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.E & 4 ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xFF: // callex 3, %(addr)s
		{
			unsigned char byte;
			Fetch( byte );

			if ( m_CpuReg.byte.E & 8 ){
				Push( m_CpuReg.byte.V );
				Push( m_CpuReg.word.PC );
				m_CpuReg.byte.V = m_CpuReg.byte.U;
				m_CpuReg.byte.PC = m_CpuReg.byte.PC + (signed char) byte - 1;
				LogBranch( m_CpuReg.byte.PC );
			}
		}
		break ;
	case 0xAE:
		m_Halted = true;
		break ;
	case 0xAF:
		break ;
	default:
		{
			int errorCode[] = { 0xCE00 | code };
			this->Error( "Unknown opcode", 1, errorCode );
		}
		break ;
	}

	m_Clock += CycleTable[ code | 0x100 ];
	Clock( CycleTable[ code | 0x100 ] );
}