/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __AUDIO_H
#define __AUDIO_H

#define AUDIO_BUFFER_SIZE   0x1000									// 4k audio buffer
#define AUDIO_NOTIFIES		8										// Number of divisions
#define AUDIO_CLIP_SIZE     (AUDIO_BUFFER_SIZE/AUDIO_NOTIFIES)		// 1k audio clip
#define AUDIO_BUFFER_INDEX  (AUDIO_BUFFER_SIZE-AUDIO_CLIP_SIZE)		// Index for the audio clip
#define AUDIO_NOTIFY_OFFSET (AUDIO_CLIP_SIZE/8)						// Offset by 128 samples

class AudioDriver
{
public:
	AudioDriver::AudioDriver( HWND hWnd, Mini *mini );
	AudioDriver::~AudioDriver();

	void AudioDriver::Enable( bool enable );
	void AudioDriver::Stream();

	HANDLE m_EventHandle;
private:
	LPDIRECTSOUND lpDS;
	LPDIRECTSOUNDBUFFER m_Primary;
	LPDIRECTSOUNDNOTIFY lpDSN;
	DSBPOSITIONNOTIFY	dsPos[AUDIO_NOTIFIES];
	HWND m_hWnd;

	HANDLE m_NotifyThreadHandle;
	DWORD m_NotifyThreadID;

	Mini *m_Mini;

	int m_SampleRate;

	int m_BufferSize;

	bool m_Enabled;
};

#endif