/*
 *
 * Copyright (C) 2004-2005 Robert Bryon Vandiver (asterick@buxx.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "Minimon.h"
#include <dsound.h>

#define DOSND

DWORD WINAPI StreamThread( LPVOID lpParameter )
{
#ifdef DOSND
	AudioDriver *ad = (AudioDriver*) lpParameter;

	DWORD dwResult;

	while( true )
	{
		dwResult = MsgWaitForMultipleObjects( 1, &ad->m_EventHandle, FALSE, INFINITE, QS_POSTMESSAGE );

		if( dwResult == WAIT_OBJECT_0 )
		{
			ad->Stream();
		}
	}
#endif
	return 0;
}

AudioDriver::AudioDriver( HWND hWnd, Mini *mini )
{
#ifdef DOSND
	m_hWnd = hWnd;

	m_Enabled = false;
	m_SampleRate = SAMPLE_RATE;
	m_BufferSize = AUDIO_BUFFER_SIZE;

	if( mini == NULL )
	{
		return ;
	}

	m_Mini = mini;

	if( DirectSoundCreate(NULL,&lpDS,NULL) != DS_OK )
	{
		lpDS = NULL;
		return ;
	}

	if ( lpDS->SetCooperativeLevel(m_hWnd, DSSCL_EXCLUSIVE) != DS_OK )
	{
		lpDS->Release();
		lpDS = NULL;
		return ;
	}

    WAVEFORMATEX wfx;
    ZeroMemory( &wfx, sizeof(WAVEFORMATEX) ); 
    wfx.wFormatTag      = (WORD) WAVE_FORMAT_PCM; 
    wfx.nChannels       = (WORD) 1;
    wfx.nSamplesPerSec  = (DWORD) m_SampleRate;
    wfx.wBitsPerSample  = (WORD) 8; 
    wfx.nBlockAlign     = (WORD) (wfx.wBitsPerSample / 8 * wfx.nChannels);
    wfx.nAvgBytesPerSec = (DWORD) (wfx.nSamplesPerSec * wfx.nBlockAlign);

	DSBUFFERDESC dsbd;
	ZeroMemory( &dsbd, sizeof( DSBUFFERDESC ) );
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_CTRLPOSITIONNOTIFY ;
	dsbd.dwBufferBytes = m_BufferSize;
	dsbd.lpwfxFormat = &wfx;

	if( lpDS->CreateSoundBuffer( &dsbd, &m_Primary, NULL ) != DS_OK )
	{
		MessageBox( hWnd, "Failed to initalize audio", g_AppTitle, MB_OK );
		lpDS->Release();
		lpDS = NULL;
		return ;
	}

	if( m_Primary->QueryInterface( IID_IDirectSoundNotify, (VOID**)&lpDSN ) != DS_OK )
	{
		MessageBox( hWnd, "Failed to create notification interface", g_AppTitle, MB_OK );
		m_Primary->Release();
		lpDS->Release();
		lpDS = NULL;
		return;
	}

	m_EventHandle = CreateEvent( NULL, FALSE, FALSE, NULL );

	for( int i = 0; i < AUDIO_NOTIFIES; i++ )
	{
		dsPos[i].dwOffset = AUDIO_CLIP_SIZE * i + AUDIO_NOTIFY_OFFSET;
		dsPos[i].hEventNotify = m_EventHandle;
	}

	if( lpDSN->SetNotificationPositions( AUDIO_NOTIFIES, dsPos ) != DS_OK )
	{
		MessageBox( hWnd, "Failed to create notification interface", g_AppTitle, MB_OK );

		CloseHandle( m_EventHandle );
		lpDSN->Release();
		m_Primary->Release();
		lpDS->Release();

		lpDSN = NULL;
		m_Primary = NULL;
		lpDS = NULL;
		return;
	}	

	m_NotifyThreadHandle = CreateThread( NULL, 0, StreamThread, this, 0, &m_NotifyThreadID );
#endif
}

AudioDriver::~AudioDriver()
{
#ifdef DOSND

	TerminateThread( m_NotifyThreadHandle, 0 );

	if( lpDS != NULL )
	{		
		CloseHandle( m_EventHandle );
		lpDSN->Release();
		m_Primary->Release();
		lpDS->Release();
	}
#endif
}

void AudioDriver::Enable( bool enable )
{
#ifdef DOSND
	if( m_Primary == NULL )
	{
		return ;
	}

	if( enable )
	{
		m_Primary->Play( 0, 0, DSBPLAY_LOOPING );
	}
	else
	{
		m_Primary->Stop();
	}
#endif
}

void AudioDriver::Stream()
{	
#ifdef DOSND
	char *bt1;
	long bc1;

	int play;

	if( m_Primary == NULL )
	{
		return ;
	}

	m_Primary->GetCurrentPosition( (DWORD*)&play, NULL );

	play = (play + AUDIO_BUFFER_INDEX) & AUDIO_BUFFER_INDEX;

	if ( m_Primary->Lock( play, AUDIO_CLIP_SIZE,
		(LPVOID*)&bt1, (LPDWORD)&bc1,
		NULL, NULL,
		0 ) == DS_OK )
	{
		m_Mini->Stream( bt1, bc1 );

		m_Primary->Unlock((LPVOID)bt1, bc1, NULL, 0);
	}
#endif
}
