#define	REGNAME	"Software\\Atari800Win"
#define	READ_REG_FAIL	999999

/* Whenever any value is changed/deleted/added in this file, change CURRENT_REV */
#define CURRENT_REV	26

#define	REG_REFRESH_RATE	"REFRESH"
#define	REG_DEFAULT_SYSTEM	"DEFSYSTEM"
#define	REG_DEFAULT_TV_MODE	"DEFTVMODE"
#define	REG_HOLD_OPTION		"HOLD_OPTION"
#define	REG_ENABLE_C000_RAM	"ENABLE_C000_RAM"
#define REG_ENABLE_SIO_PATCH	"ENABLE_SIO_PATCH"
#define REG_ENABLE_ROM_PATCH	"ENABLE_ROM_PATCH"
#define REG_ARTIF_MODE		"ARTIFACT_MODE"

#define REG_OSA_ROM		"OSAROM"
#define REG_OSB_ROM		"OSBROM"
#define REG_XLXE_ROM	"XLXEROM"
#define REG_5200_ROM	"5200ROM"
#define REG_BASIC_ROM	"BASICROM"
#define REG_OTHER_ROM	"OTHERROM"
#define REG_CURRENT_ROM	"CURRENTROM"
#define REG_CART_TYPE	"CARTTYPE"
#define REG_KEY_TEMPLATE	"KEYTEMPLATE"

#define	REG_DRIVE1	"D1"
#define REG_DRIVE2	"D2"
#define	REG_DRIVE3	"D3"
#define REG_DRIVE4	"D4"
#define	REG_DRIVE5	"D5"
#define	REG_DRIVE6	"D6"
#define	REG_DRIVE7	"D7"
#define	REG_DRIVE8	"D8"

#define REG_HD1		"H1"
#define REG_HD2		"H2"
#define REG_HD3		"H3"
#define	REG_HD4		"H4"

#define REG_EXEPATH	"EXEPATH"

#define REG_JOYSTICKS		"STICKS"
#define REG_STICK_REPEAT	"STICKREPEAT"
#define REG_STICK_SKIP		"STICKSKIP"

#define	REG_START_XPOS	"STARTXPOS"
#define	REG_START_YPOS	"STARTYPOS"

#define REG_DDRAW_MODE	"SCREENMODE"

#define REG_SOUND_STATE	"SOUNDSTATE"
#define REG_SOUND_RATE	"SOUNDRATE"
#define REG_SOUND_VOLUME "SOUNDVOLUME"

#define REG_DONT_SHOW	"DONTSHOWFLAGS"

#define REG_MISC_STATES	"MISCSTATES"

#define REG_CURRENT_REV	"VERSION"

extern char atari_exe_dir[ ];
extern char *szDriveRegID[ ];

//---------------------------------------------------------------------------
//| These are functions to handle initialization and reading/writing to the 
//| registry of persistent data elements
//---------------------------------------------------------------------------

void WriteRegDWORD( HKEY hkInput, char *item, DWORD value);
void WriteRegBinary( HKEY hkInput, char *item, unsigned char *data, int size );
void WriteRegString( HKEY hkInput, char *item, char *data );
int ReadRegDWORD( HKEY hkInput, char *item, DWORD *date, BOOL bShowError );
DWORD ReadRegBinary( HKEY hkInput, char *item, char *buffer, unsigned long maxsize, BOOL bShowError );
void ReadRegDrives( HKEY hkInput );
BOOL HandleRegistry( void );
void WriteInitialReg( HKEY hkInput, BOOL bErasePaths );
void WriteAtari800Drives( HKEY hkInput );
void WriteAtari800Registry( HKEY hkInitKey );

