/* (C) 2000  Krzysztof Nikiel */
/* $Id: atari_win32.c,v 1.6 2001/12/04 13:07:22 joy Exp $ */
#define DEBUG_KEYBOARD

#include <xtl.h>
#include <xkbd.h>
#include <stdio.h>
#include <stdlib.h>
//#include <dinput.h>

#include "config.h"
#include "platform.h"
#include "input.h"
#include "screen.h"
#include "keyboard.h"
#include "main.h"
#include "sound.h"
#include "monitor.h"
#include "diskled.h"

static int usesnd = 1;

extern int refresh_rate;

extern int alt_function;
static int kbjoy = 1;

extern int key_ctrl ;

#if 0
static UBYTE joydefs[] =
{
  DIK_NUMPAD0,			/* fire */
  DIK_NUMPAD7,			/* up/left */
  DIK_NUMPAD8,			/* up */
  DIK_NUMPAD9,			/* up/right */
  DIK_NUMPAD4,			/* left */
  DIK_NUMPAD6,			/* right */
  DIK_NUMPAD1,			/* down/left */
  DIK_NUMPAD2,			/* down */
  DIK_NUMPAD3,			/* down/right */
#ifdef USE_CURSORBLOCK
  DIK_UP,
  DIK_LEFT,
  DIK_RIGHT,
  DIK_DOWN,
#endif
};
#endif

static UBYTE joymask[] =
{
  0,				/* not used */
  ~1 & ~4,			/* up/left */
  ~1,				/* up */
  ~1 & ~8,			/* up/right */
  ~4,				/* left */
  ~8,				/* right */
  ~2 & ~4,			/* down/left */
  ~2,				/* down */
  ~2 & ~8,			/* down/right */
#ifdef USE_CURSORBLOCK
  ~1,				/* up */
  ~4,				/* left */
  ~8,				/* right */
  ~2,				/* down */
#endif
};

static int trig0;
static int stick0;

extern double deltatime;
#define EMU_START        0x40
#define EMU_SELECT       0x80
#define EMU_OPTIONS      0x100

int Atari_Keyboard(void)
{
  int keycode;
  int i;
  unsigned int controller ;

  xbox_check_events() ;

  prockb();

  key_consol = CONSOL_NONE ;

  for ( i = 0 ; i < 4 ; i++ )
  {
	  controller = xbox_read_port( i ) ;

	  if ( controller & EMU_START )
		  key_consol &= ~CONSOL_START ;
	  if ( controller & EMU_OPTIONS)
		  key_consol &= ~CONSOL_OPTION ;
	  if ( controller & EMU_SELECT )
		  key_consol &= ~CONSOL_SELECT ;
  }

  /*
  key_consol = (key_consol & ~CONSOL_NONE)
    | (kbhits[DIK_F2] ? 0 : CONSOL_OPTION)
    | (kbhits[DIK_F3] ? 0 : CONSOL_SELECT)
    | (kbhits[DIK_F4] ? 0 : CONSOL_START);

  if (pause_hit)
    {
      pause_hit = 0;
      return AKEY_BREAK;
    }
*/

  //key_shift = (kbhits[VK_LSHIFT] | kbhits[VK_RSHIFT]) ? 1 : 0;

  alt_function = -1;		/* no alt function */
  key_break = 0 ;
 
#if 0
  if (kbhits[DIK_LMENU])
    {				/* left Alt key is pressed */
      if (kbcode == DIK_R)
	alt_function = MENU_RUN;	/* ALT+R .. Run file */
      else if (kbcode == DIK_Y)
	alt_function = MENU_SYSTEM;	/* ALT+Y .. Select system */
      else if (kbcode == DIK_O)
	alt_function = MENU_SOUND;	/* ALT+O .. mono/stereo sound */
      else if (kbcode == DIK_A)
	alt_function = MENU_ABOUT;	/* ALT+A .. About */
      else if (kbcode == DIK_S)
	alt_function = MENU_SAVESTATE;	/* ALT+S .. Save state */
      else if (kbcode == DIK_D)
	alt_function = MENU_DISK;	/* ALT+D .. Disk management */
      else if (kbcode == DIK_L)
	alt_function = MENU_LOADSTATE;	/* ALT+L .. Load state */
      else if (kbcode == DIK_C)
	alt_function = MENU_CARTRIDGE;	/* ALT+C .. Cartridge management */
    }
  if (alt_function != -1)
    return AKEY_UI;
#endif 

  /* need to set shift mask here to avoid conflict with PC layout */
  keycode = (key_shift ? 0x40 : 0)
    | ( key_ctrl ? 0x80 : 0);

	kbcode = xbox_get_keystroke() ;

  switch (kbcode)
    {
#if 0
    case DIK_F9:
      return AKEY_EXIT;
      break;
    case DIK_F8:
      keycode = Atari_Exit(1) ? AKEY_NONE : AKEY_EXIT;
      kbcode = 0;
      break;
    case DIK_SCROLL:		/* pause */
      while (kbhits[DIK_SCROLL])
	prockb();
      while (!kbhits[DIK_SCROLL])
	prockb();
      kbcode = 0;
      break;
    case DIK_SYSRQ:
    case DIK_F10:
      keycode = key_shift ? AKEY_SCREENSHOT_INTERLACE : AKEY_SCREENSHOT;
      kbcode = 0;
      break;

    case DIK_F1:
      return AKEY_UI;
      break;
    case DIK_F5:
      return key_shift ? AKEY_COLDSTART : AKEY_WARMSTART;
      break;
    case DIK_F11:
      for (i = 0; i < 4; i++)
	{
	  if (++joy_autofire[i] > 2)
	    joy_autofire[i] = 0;
	}
      kbcode = 0;
      break;
#endif

#define VK_1 '1'
#define VK_0 '0'
#define VK_2 '2'
#define VK_3 '3'
#define VK_4 '4'
#define VK_5 '5'
#define VK_6 '6'
#define VK_7 '7'
#define VK_8 '8'
#define VK_9 '9'

#define VK_A 'A'
#define VK_B 'B'
#define VK_C 'C'
#define VK_D 'D'
#define VK_E 'E'
#define VK_F 'F'
#define VK_G 'G'
#define VK_H 'H'
#define VK_I 'I'
#define VK_J 'J'
#define VK_K 'K'
#define VK_L 'L'
#define VK_M 'M'
#define VK_N 'N'
#define VK_O 'O'
#define VK_P 'P'
#define VK_Q 'Q'
#define VK_R 'R'
#define VK_S 'S'
#define VK_T 'T'
#define VK_U 'U'
#define VK_V 'V'
#define VK_W 'W'
#define VK_X 'X'
#define VK_Y 'Y'
#define VK_Z 'Z'

#define KBSCAN(name) \
	  case VK_##name: \
	    keycode |= (AKEY_##name & ~(AKEY_CTRL | AKEY_SHFT)); \
	    break;
#define KBSCAN2(name,name2) \
	  case VK_##name: \
	    keycode |= (AKEY_##name2 & ~(AKEY_CTRL | AKEY_SHFT)); \
	    break;
      KBSCAN(ESCAPE)
	KBSCAN(1)
    case VK_2:
      if (key_shift)
	keycode = AKEY_AT;
      else
	keycode |= AKEY_2;
      break;
      KBSCAN(3)
	KBSCAN(4)
	KBSCAN(5)
    case VK_6:
      if (key_shift)
	keycode = AKEY_CARET;
      else
	keycode |= AKEY_6;
      break;
    case VK_7:
      if (key_shift)
	keycode = AKEY_AMPERSAND;
      else
	keycode |= AKEY_7;
      break;
    case VK_8:
      if (key_shift)
	keycode = AKEY_ASTERISK;
      else
	keycode |= AKEY_8;
      break;
      KBSCAN(9)
	KBSCAN(0)
	KBSCAN2(OEM_MINUS,MINUS)
    case VK_OEM_PLUS:
      if (key_shift)
	keycode = AKEY_PLUS;
      else
	keycode |= AKEY_EQUAL;
      break;
      KBSCAN2(BACK,BACKSPACE)
	KBSCAN(TAB)
	KBSCAN(Q)
	KBSCAN(W)
	KBSCAN(E)
	KBSCAN(R)
	KBSCAN(T)
	KBSCAN(Y)
	KBSCAN(U)
	KBSCAN(I)
	KBSCAN(O)
	KBSCAN(P)
    case VK_OEM_4:
      keycode |= AKEY_BRACKETLEFT;
      break;
    case VK_OEM_6:
      keycode |= AKEY_BRACKETRIGHT;
      break;
    case VK_RETURN:
      keycode |= AKEY_RETURN;
      break;
      KBSCAN(A)
	KBSCAN(S)
	KBSCAN(D)
	KBSCAN(F)
	KBSCAN(G)
	KBSCAN(H)
	KBSCAN(J)
	KBSCAN(K)
	KBSCAN(L)
	KBSCAN2(OEM_1,SEMICOLON)
    case VK_OEM_7:
      if (key_shift)
	keycode = AKEY_DBLQUOTE;
      else
	keycode |= AKEY_QUOTE;
      break;
    case VK_OEM_3:
      keycode |= AKEY_ATARI;
      break;
    case VK_OEM_5:
      if (key_shift)
	keycode = AKEY_EQUAL | AKEY_SHFT;
      else
	keycode |= AKEY_BACKSLASH;
      break;
      KBSCAN(Z)
	KBSCAN(X)
	KBSCAN(C)
	KBSCAN(V)
	KBSCAN(B)
	KBSCAN(N)
	KBSCAN(M)
    case VK_OEM_COMMA:
      if (key_shift)
	keycode = AKEY_LESS;
      else
	keycode |= AKEY_COMMA;
      break;
    case VK_OEM_PERIOD:
      if (key_shift)
	keycode = AKEY_GREATER;
      else
	keycode |= AKEY_FULLSTOP;
      break;
      KBSCAN2(OEM_2,SLASH)
	KBSCAN(SPACE)
	//KBSCAN(CAPSLOCK)
	case VK_PAUSE : keycode = AKEY_BREAK ; key_break = 1 ; break ;
    case VK_UP:
      keycode = AKEY_UP;
      break;
    case VK_DOWN:
      keycode = AKEY_DOWN;
      break;
    case VK_LEFT:
      keycode = AKEY_LEFT;
      break;
    case VK_RIGHT:
      keycode = AKEY_RIGHT;
      break;
    case VK_DELETE:
      if (key_shift)
	keycode = AKEY_DELETE_LINE;
      else
	keycode |= AKEY_DELETE_CHAR;
      break;
    case VK_INSERT:
      if (key_shift)
	keycode = AKEY_INSERT_LINE;
      else
	keycode |= AKEY_INSERT_CHAR;
      break;
    case VK_HOME:
      keycode = AKEY_CLEAR;
      break;
    case VK_END:
      keycode = AKEY_HELP;
      break;
    default:
      keycode = AKEY_NONE;
    }

  return keycode;
}

void Atari_Initialise(int *argc, char *argv[])
{
  //ShowWindow(hWndMain, SW_RESTORE);

#ifdef SOUND
  if (usesnd)
    Sound_Initialise(argc, argv);
#endif
  if (initinput())
  {
    //MessageBox(hWndMain, "DirectInput Init FAILED",
		//myname,
		//MB_ICONEXCLAMATION
		//| MB_OK);
	return ;
    //exit(1);
  }
  if (gron(argc, argv))
	  return;
    //exit(1);

  clearkb();

  trig0 = 1;
  stick0 = 15;
  key_consol = CONSOL_NONE;
}
void xbox_set_quit() ;

int Atari_Exit(int run_monitor)
{
  int i;
  xbox_set_quit() ;

/*
  if (run_monitor)
    {
#ifdef SOUND
      Sound_Pause();
#endif
      ShowWindow(hWndMain, SW_MINIMIZE);
      i = monitor();
      ShowWindow(hWndMain, SW_RESTORE);
#ifdef SOUND
      Sound_Continue();
#endif
      if (i)
	return 1;	      /* return to emulation 
    }
*/
#ifdef BUFFERED_LOG
  Aflushlog();
#endif

  return 0;
}

void Atari_DisplayScreen(UBYTE * ascreen)
{
  refreshv(ascreen + 32);
  //refreshv(ascreen + 24);
  //refreshv(ascreen );
}

int Atari_PORT(int num)
{
	if ( num )
	{
		return ~( xbox_read_port(2) & 0x0F | xbox_read_port(3) << 4 & 0xF0 ) ;
	}
	else
	{
		return ~(xbox_read_port(0) & 0x0F | xbox_read_port(1) << 4 & 0xF0) ;
	}

/*
  if (num == 0)
    {
      return 0xf0 | stick0;
    }
  else
    return 0xff;
	*/
}


int Atari_TRIG(int num)
{
	if ( xbox_read_port(num) & 0x10 )
		return 0 ;
	else
		return 1 ;

	/*
  if (num == 0)
    {
      return trig0;
    }
  else
    return 1;
	*/
}

int Atari_POT(int num)
{
  return 228;
}

/*
$Log: atari_win32.c,v $
Revision 1.6  2001/12/04 13:07:22  joy
LED_lastline apparently disappeared from the Atari800 core so remove it here, too (suggested by Nathan)

Revision 1.5  2001/10/03 16:16:42  knik
keyboard update

Revision 1.4  2001/09/25 17:40:16  knik
keyboard and display update

Revision 1.3  2001/04/08 05:51:44  knik
sound calls update

Revision 1.2  2001/03/24 10:15:13  knik
included missing header

Revision 1.1  2001/03/18 07:56:48  knik
win32 port

*/
