#include "stdafx.h"
#include "iomem.h"
#include "input.h"
#include "regs.h"
#include "gpu.h"
#include "dsp.h"
#include "blitter.h"
#include <stdio.h>
#include "sound.h"

extern BYTE* MEM;
extern DWORD* screen;

extern WORD* EEPROM;

extern WORD* wave[2];
extern int wave_start_1;
extern int wave_start_2;
extern DWORD sample_rate;

extern GPUSTATE gpustate;
extern DSPSTATE dspstate;
extern M68K_INTERRUPTS m68k_ints;
extern JERRY_INTERRUPTS jerry_ints;
extern TIMERS timers;
extern int blitter_version;
extern BOOL disable_dsp;
extern BOOL enable_sound;

extern FILE* eeprom;

extern int SOUNDBUFFER_SIZE;

int eeprom_cell;
int eeprom_mode = EEPROM_COMMAND;
int eeprom_bit;
int eeprom_command;

TURBO68K_UINT8 gpu_read8(TURBO68K_UINT32 addr) 
{
	if(addr >= 0xF0B000)
		addr -= 0x8000;
	return *(BYTE*)(&MEM[addr^1]);
}
TURBO68K_UINT32 gpu_read32(TURBO68K_UINT32 addr)
{
	if(addr < 0xF03000) {
		return (DWORD)gpu_read16(addr)<<16 | (DWORD)gpu_read16(addr+2);
	} else {
		if(addr >= 0xF0B000 && addr < 0xF0C000) {
			return _rotl(*(DWORD*)(&MEM[addr-0x8000]),16);
		} else {
			return _rotl(*(DWORD*)(&MEM[addr]),16);
		}
	}
}
TURBO68K_UINT8 dsp_read8(TURBO68K_UINT32 addr) 
{
	return *(BYTE*)(&MEM[addr^1]);
}
TURBO68K_UINT32 dsp_read32(TURBO68K_UINT32 addr)
{
	return (DWORD)dsp_read16(addr)<<16 | (DWORD)dsp_read16(addr+2);
}
void gpu_write8(TURBO68K_UINT32 addr, TURBO68K_UINT8 value)
{
	if(addr >= 0xF00400 && addr < 0xF00600) {
		*(BYTE*)(MEM+(addr^1)) = value;
		*(BYTE*)(MEM+(addr^1)+0x200) = value;
		return;
	}
	if(addr >= 0xF00600 && addr < 0xF00800) {
		*(BYTE*)(MEM+(addr^1)) = value;
		*(BYTE*)(MEM+(addr^1)-0x200) = value;
		return;
	}
	if(addr >= 0xF0B000)
		addr -= 0x8000;
	*(BYTE*)(&MEM[addr^1]) = value;
	return;
}
void gpu_write32(TURBO68K_UINT32 addr, TURBO68K_UINT32 value)
{
	//*(DWORD*)(GPURAM+addr-0xF00000) = value;
	if(addr < 0xF03000) {
		gpu_write16(addr,value>>16);
		gpu_write16(addr+2,value&0xFFFF);
	} else {
		if(addr >= 0xF0B000 && addr < 0xF0C000) {
			*(DWORD*)(&MEM[addr-0x8000]) = _rotl(value,16);
		} else {
			*(DWORD*)(&MEM[addr]) = _rotl(value,16);
		}
	}
	return;
}
void dsp_write8(TURBO68K_UINT32 addr, TURBO68K_UINT8 value)
{
	*(BYTE*)(&MEM[addr^1]) = value;
	return;
}
void dsp_write32(TURBO68K_UINT32 addr, TURBO68K_UINT32 value)
{
	//*(DWORD*)(DSPRAM+addr-0xF10000) = value;
	dsp_write16(addr,value>>16);
	dsp_write16(addr+2,value&0xFFFF);
	return;
}

TURBO68K_UINT16 gpu_read16(TURBO68K_UINT32 addr)
{
	WORD value = 0;
	if(addr == 0xF000E0) {
		value |= m68k_ints.video_active;
		value |= m68k_ints.gpu_active << 1;
		value |= m68k_ints.op_active << 2;
		value |= m68k_ints.timer_active << 3;
		value |= m68k_ints.jerry_active << 4;
		return value;
	}
	if(addr == 0xF0223A)
		return 1;
	if(addr == 0xF02102) {
		value |= (gpustate.z & 0x1);
		value |= ((gpustate.c & 0x1) << 1);
		value |= ((gpustate.n & 0x1) << 2);
		value |= ((gpustate.imask & 0x1) << 3);
		value |= ((gpustate.irq_enable[0] & 0x1) << 4);
		value |= ((gpustate.irq_enable[1] & 0x1) << 5);
		value |= ((gpustate.irq_enable[2] & 0x1) << 6);
		value |= ((gpustate.irq_enable[3] & 0x1) << 7);
		value |= ((gpustate.irq_enable[4] & 0x1) << 8);
		value |= (gpu_get_regbank() & 0x1) << 14;
		return value;
	}
	if(addr == 0xF02116) {
		value |= gpustate.active & 0x1;
		value |= 0x8;
		value |= (gpustate.irq_active[0] & 0x1) << 6;
		value |= (gpustate.irq_active[1] & 0x1) << 7;
		value |= (gpustate.irq_active[2] & 0x1) << 8;
		value |= (gpustate.irq_active[3] & 0x1) << 9;
		value |= (gpustate.irq_active[4] & 0x1) << 10;
		//return (WORD)gpustate.active;// ? 1 : 0;
		return value;
	}
	if(addr == 0xF02118) {
		return (WORD)(gpustate.hidata >> 16);
	}
	if(addr == 0xF0211A) {
		return (WORD)(gpustate.hidata & 0xFFFF);
	}
	if(addr == 0xF0211C) {
		return (WORD)(gpustate.remain >> 16);
	}
	if(addr == 0xF0211E) {
		return (WORD)(gpustate.remain & 0xFFFF);
	}
	if(addr == 0xF02110) {
		return (WORD)(gpustate.pc >> 16);
	}
	if(addr == 0xF02112) {
		return (WORD)(gpustate.pc & 0xFFFF);
	}
	if(addr >= 0xF00600 && addr < 0xF00800) {
		addr -= 0x200;
	}
	if(addr >= 0xF0B000)
		addr -= 0x8000;
	return *(WORD*)(MEM+addr);
}

TURBO68K_UINT16 dsp_read16(TURBO68K_UINT32 addr)
{
	/*if(addr == 0xF1B9D8) return 0;
	if(addr == 0xF1B9DA) return 0;
	if(addr == 0xF1B2C0) return 0;
	if(addr == 0xF1B2C2) return 0;*/

	WORD value = 0x1;
	if(addr == 0xF14000) {
		/*if(eeprom_mode == EEPROM_READ) {
			value = (EEPROM[eeprom_cell] & (1 << (15-eeprom_bit))) ? 1 : 0;
			eeprom_bit++;
			if(eeprom_bit >= 16) {
				//fprintf(eeprom,"Eeprom Read: Cell %d, Data %04X\n",eeprom_cell,EEPROM[eeprom_cell]);
				//fprintf(eeprom,"68K PC: %08X\n",Turbo68KReadPC());
				eeprom_mode = EEPROM_COMMAND;
				eeprom_bit = 0;
			}
		}*/
		return ReadKeys(*(WORD*)(MEM+0xF14000)) & 0xFFFE | value;
	}
	if(addr == 0xF14002)
		return ReadButtons(*(WORD*)(MEM+0xF14000));
	if(addr == 0xF14800) {
		return 0x1;
	}
	if(addr == 0xF15000) {
		//fprintf(eeprom,"Eeprom: CS\n");
		eeprom_mode = EEPROM_COMMAND;
		eeprom_command = 0;
		eeprom_bit = 0;
		return 0x1;
	}
	if(addr == 0xF1A102) {
		value = 0;
		value |= (dspstate.z & 0x1);
		value |= ((dspstate.c & 0x1) << 1);
		value |= ((dspstate.n & 0x1) << 2);
		value |= ((dspstate.imask & 0x1) << 3);
		value |= ((dspstate.irq_enable[0] & 0x1) << 4);
		value |= ((dspstate.irq_enable[1] & 0x1) << 5);
		value |= ((dspstate.irq_enable[2] & 0x1) << 6);
		value |= ((dspstate.irq_enable[3] & 0x1) << 7);
		value |= ((dspstate.irq_enable[4] & 0x1) << 8);
		value |= (dsp_get_regbank() & 0x1) << 14;
		return value;
	}
	if(addr == 0xF1A110) {
		return (WORD)(dspstate.pc >> 16);
	}
	if(addr == 0xF1A112) {
		return (WORD)(dspstate.pc & 0xFFFF);
	}
	if(addr == 0xF1A116) {
		value = 0;
		if(disable_dsp)
			return 0;
		value |= 0x8;
		value |= dspstate.active & 0x1;
		value |= (dspstate.irq_active[0] & 0x1) << 6;
		value |= (dspstate.irq_active[1] & 0x1) << 7;
		value |= (dspstate.irq_active[2] & 0x1) << 8;
		value |= (dspstate.irq_active[3] & 0x1) << 9;
		value |= (dspstate.irq_active[4] & 0x1) << 10;
		return value;
	}
	if(addr == 0xF1A11C) {
		return (WORD)(dspstate.remain >> 16);
	}
	if(addr == 0xF1A11E) {
		return (WORD)(dspstate.remain & 0xFFFF);
	}
	if(addr == 0xF1A120) {
		return 0;
	}
	if(addr == 0xF1A122) {
		return (WORD)((dspstate.acc>>32) & 0xFF);
	}
	return *(WORD*)(MEM+addr);
}

void gpu_write16(TURBO68K_UINT32 addr, TURBO68K_UINT16 value)
{
	if(addr == 0xF00050) {
		timers.pit_value &= 0xFFFF0000;
		timers.pit_value |= value;
		if(value == 0)
			timers.pit_active = 0;
	}
	if(addr == 0xF00052) {
		timers.pit_value &= 0xFFFF;
		timers.pit_value |= value << 16;
		timers.pit_current_value = timers.pit_value;
		timers.pit_active = 1;
	}
	if(addr == 0xF000E0) {
		m68k_ints.video = (value & 0x1) ? 1 : 0;
		m68k_ints.gpu = (value & 0x2) ? 1 : 0;
		m68k_ints.op = (value & 0x4) ? 1 : 0;
		m68k_ints.timer = (value & 0x8) ? 1 : 0;
		m68k_ints.jerry = (value & 0x10) ? 1 : 0;
		if(value & 0x100)
			m68k_ints.video_active = 0;
		if(value & 0x200)
			m68k_ints.gpu_active = 0;
		if(value & 0x400)
			m68k_ints.op_active = 0;
		if(value & 0x800)
			m68k_ints.timer_active = 0;
		if(value & 0x1000)
			m68k_ints.jerry_active = 0;
	}
	if(addr == 0xF02102) {
		gpustate.z = (value & 0x1) ? 1 : 0;
		gpustate.c = (value & 0x2) ? 1 : 0;
		gpustate.n = (value & 0x4) ? 1 : 0;
		if((value & 0x8) == 0) {
			gpustate.imask = 0;
			//gpu_set_regbank(gpustate.old_bank);
		}
		if(gpustate.imask == 0) {
			if(value & 0x4000)
				gpu_set_regbank(1);
			else
				gpu_set_regbank(0);
		}
		gpustate.irq_enable[0] = (value & 0x10) ? 1 : 0;
		gpustate.irq_enable[1] = (value & 0x20) ? 1 : 0;
		gpustate.irq_enable[2] = (value & 0x40) ? 1 : 0;
		gpustate.irq_enable[3] = (value & 0x80) ? 1 : 0;
		gpustate.irq_enable[4] = (value & 0x100) ? 1 : 0;
		if(value & 0x200)
			gpustate.irq_active[0] = 0;
		if(value & 0x400)
			gpustate.irq_active[1] = 0;
		if(value & 0x800)
			gpustate.irq_active[2] = 0;
		if(value & 0x1000)
			gpustate.irq_active[3] = 0;
		if(value & 0x2000)
			gpustate.irq_active[4] = 0;
	}
	if(addr == 0xF02116) {
		if(value & 0x1) {
			gpustate.active = 1;
		} else {
			gpustate.active = 0;
		}
		if(value & 0x2) {
			if(m68k_ints.gpu) {
				m68k_ints.gpu_active = 1;
				Turbo68KInterrupt(2,TURBO68K_AUTOVECTOR);
			}
		}
		if(value & 0x4) {
			if(gpustate.irq_enable[0]) {
				gpu_interrupt(0);
			}
		}
		gpustate.single_step = value & 0x8 ? 1 : 0;
		if(value & 0x10 && gpustate.single_step) {
			gpu_exec(1);
			gpustate.active = 0;
		}
		//gpustate.active = (value & 0x1) ? 1 : 0;
	}
	if(addr == 0xF02238) {
		gpustate.bcmd &= 0xFFFF;
		gpustate.bcmd |= value << 16;
	}
	if(addr == 0xF0223A) {
		gpustate.bcmd &= 0xFFFF0000;
		gpustate.bcmd |= value;
		switch(blitter_version) {
			case 0:default:
				BlitterExec_HLE(gpustate.bcmd);break;
			case 1:
				BlitterExec_New(gpustate.bcmd);break;
		}
		//gpu_interrupt(4);
	}
	if(addr == 0xF02118) {
		gpustate.hidata &= 0xFFFF;
		gpustate.hidata |= value << 16;
	}
	if(addr == 0xF0211A) {
		gpustate.hidata &= 0xFFFF0000;
		gpustate.hidata |= value;
	}
	if(addr == 0xF0211E) {
		gpustate.divide = value & 0x1 ? 1 : 0;
	}
	if(addr == 0xF02110) {
		gpustate.pc &= 0xFFFF;
		gpustate.pc |= value << 16;
	}
	if(addr == 0xF02112) {
		gpustate.pc &= 0xFFFF0000;
		gpustate.pc |= value;
	}
	if(addr == 0xF02104) {
		gpustate.matrix_size &= 0xFFFF;
		gpustate.matrix_size |= value << 16;
	}
	if(addr == 0xF02106) {
		gpustate.matrix_size &= 0xFFFF0000;
		gpustate.matrix_size |= value;
	}
	if(addr == 0xF02108) {
		gpustate.matrix_address &= 0xFFFF;
		gpustate.matrix_address |= value << 16;
	}
	if(addr == 0xF0210A) {
		gpustate.matrix_address &= 0xFFFF0000;
		gpustate.matrix_address |= value;
	}
	if(addr >= 0xF00400 && addr < 0xF00600) {
		*(WORD*)(MEM+addr) = value;
		//*(WORD*)(GPURAM+addr-0xF00000+0x200) = value;
		return;
	}
	if(addr >= 0xF00600 && addr < 0xF00800) {
		//*(WORD*)(GPURAM+addr-0xF00000) = value;
		*(WORD*)(MEM+addr-0x200) = value;
		return;
	}
	if(addr >= 0xF0B000)
		addr -= 0x8000;
	*(WORD*)(MEM+addr) = value;
	return;
}

void dsp_write16(TURBO68K_UINT32 addr, TURBO68K_UINT16 value)
{
	if(addr == 0xF10020) {
		jerry_ints.external = value & 0x1 ? 1 : 0;
		jerry_ints.dsp = value & 0x2 ? 1 : 0;
		jerry_ints.pit1 = value & 0x4 ? 1 : 0;
		jerry_ints.pit2 = value & 0x8 ? 1 : 0;
		jerry_ints.asi = value & 0x10 ? 1 : 0;
		jerry_ints.ssi = value & 0x20 ? 1 : 0;
		if(value & 0x100)
			jerry_ints.external_active = 0;
		if(value & 0x200)
			jerry_ints.dsp_active = 0;
		if(value & 0x400)
			jerry_ints.pit1_active = 0;
		if(value & 0x800)
			jerry_ints.pit2_active = 0;
		if(value & 0x1000)
			jerry_ints.asi_active = 0;
		if(value & 0x2000)
			jerry_ints.ssi_active = 0;
	}
	if(addr == 0xF10000) {
		timers.pit1_prescale = value;
		timers.pit1_prescale_value = value;
	}
	if(addr == 0xF10002) {
		timers.pit1_divider = value;
		timers.pit1_divider_value = value;
		timers.pit1_active = 1;
	}
	if(addr == 0xF10004) {
		timers.pit2_prescale = value;
		timers.pit2_prescale_value = value;
	}
	if(addr == 0xF10006) {
		timers.pit2_divider = value;
		timers.pit2_divider_value = value;
		timers.pit2_active = 1;
	}

	if(addr == 0xF1A102) {
		dspstate.z = (value & 0x1) ? 1 : 0;
		dspstate.c = (value & 0x2) ? 1 : 0;
		dspstate.n = (value & 0x4) ? 1 : 0;
		if((value & 0x8) == 0) {
			dspstate.imask = 0;
			//dsp_set_regbank(dspstate.old_bank);
		}
		//if(dspstate.imask == 0) {
			if(value & 0x4000)
				dsp_set_regbank(1);
			else
				dsp_set_regbank(0);
		//}
		dspstate.irq_enable[0] = (value & 0x10) ? 1 : 0;
		dspstate.irq_enable[1] = (value & 0x20) ? 1 : 0;
		dspstate.irq_enable[2] = (value & 0x40) ? 1 : 0;
		dspstate.irq_enable[3] = (value & 0x80) ? 1 : 0;
		dspstate.irq_enable[4] = (value & 0x100) ? 1 : 0;
		if(value & 0x200)
			dspstate.irq_active[0] = 0;
		if(value & 0x400)
			dspstate.irq_active[1] = 0;
		if(value & 0x800)
			dspstate.irq_active[2] = 0;
		if(value & 0x1000)
			dspstate.irq_active[3] = 0;
		if(value & 0x2000)
			dspstate.irq_active[4] = 0;
	}
	if(addr == 0xF14800) {
		if(eeprom_mode == EEPROM_COMMAND) {
			eeprom_command |= ((value & 0x1) << (8-eeprom_bit));
			eeprom_bit++;
			if(eeprom_bit >= 9) {
				int command = (eeprom_command >> 6) & 0x7;
				switch(command) {
					case 6:
						eeprom_mode = EEPROM_READ;
						eeprom_cell = eeprom_command & 0x3F;
						eeprom_bit = 0;
						break;
					case 5:
						eeprom_mode = EEPROM_WRITE;
						eeprom_cell = eeprom_command & 0x3F;
						EEPROM[eeprom_cell] = 0;
						eeprom_bit = 0;
						break;
					default:
						eeprom_mode = EEPROM_COMMAND;
						eeprom_bit = 0;
				}
			}
		}
		if(eeprom_mode == EEPROM_WRITE) {
			EEPROM[eeprom_cell] |= ((value & 0x1) << (15-eeprom_bit));
			eeprom_bit++;
			if(eeprom_bit >= 16) {
				//fprintf(eeprom,"Eeprom Write: Cell %d, Data %04X\n",eeprom_cell,EEPROM[eeprom_cell]);
				eeprom_mode = EEPROM_COMMAND;
				eeprom_bit = 0;
			}
		}
	}
	if(addr == 0xF1A116) {
		if(value & 0x1) {
			dspstate.active = 1;
		} else {
			dspstate.active = 0;
		}
		if(value & 0x2) {
			if(m68k_ints.jerry) {
				m68k_ints.jerry_active = 1;
				Turbo68KInterrupt(2,TURBO68K_AUTOVECTOR);
			}
		}
		if(value & 0x4) {
			dsp_interrupt(0);
		}
		//gpustate.active = (value & 0x1) ? 1 : 0;
	}
	if(addr == 0xF1A11E) {
		dspstate.divide = value & 0x1 ? 1 : 0;
	}
	if(addr == 0xF1A104) {
		gpustate.matrix_size &= 0xFFFF;
		gpustate.matrix_size |= value << 16;
	}
	if(addr == 0xF1A106) {
		gpustate.matrix_size &= 0xFFFF0000;
		gpustate.matrix_size |= value;
	}
	if(addr == 0xF1A108) {
		gpustate.matrix_address &= 0xFFFF;
		gpustate.matrix_address |= value << 16;
	}
	if(addr == 0xF1A10A) {
		gpustate.matrix_address &= 0xFFFF0000;
		gpustate.matrix_address |= value;
	}
	if(addr == 0xF1A110) {
		dspstate.pc &= 0xFFFF;
		dspstate.pc |= value << 16;
	}
	if(addr == 0xF1A112) {
		dspstate.pc &= 0xFFFF0000;
		dspstate.pc |= value;
	}
	if(addr == 0xF1A118) {
		dspstate.mod &= 0xFFFF;
		dspstate.mod |= value << 16;
	}
	if(addr == 0xF1A11A) {
		dspstate.mod &= 0xFFFF0000;
		dspstate.mod |= value;
	}

	//doxxx sound put back
	if(addr == 0xF1A14A) {
		value <<= 1;
		wave[0][wave_start_1] = value;
		wave_start_1++;
		if(wave_start_1 > SOUNDBUFFER_SIZE) {
			wave_start_1 = 0;
			if(enable_sound) {
				UpdateLeftChannel(SOUNDBUFFER_SIZE);
			}
		}
	}
	if(addr == 0xF1A14E) {
		value <<= 1;
		wave[1][wave_start_2] = value;
		wave_start_2++;
		if(wave_start_2 > SOUNDBUFFER_SIZE) {
			wave_start_2 = 0;
			if(enable_sound) {
				UpdateRightChannel(SOUNDBUFFER_SIZE);
			}
		}
	}


	if(addr == 0xF1A152) {
		sample_rate = (26591000 / 64) / (value + 1);
	}
	*(WORD*)(MEM+addr) = value;
	return;
}