/* menu_data.c: menu structure for Fuse
   Copyright (c) 2004 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from menu_data.c by ../menu_data.pl.
   Any changes made here will not be preserved. */

#include <config.h>

#include "menu.h"

#include "input.h"
#include "options.h"
#include "widget_internals.h"

static widget_menu_entry menu_file_recording[] = {
  { "Recording" },
  { "(R)ecord...", INPUT_KEY_r, NULL, menu_file_recording_record, 0 },
  { "Record (f)rom snapshot...", INPUT_KEY_f, NULL, menu_file_recording_recordfromsnapshot, 0 },
  { "(P)lay...", INPUT_KEY_p, NULL, menu_file_recording_play, 0 },
  { "(S)top", INPUT_KEY_s, NULL, menu_file_recording_stop, 0 },
  { NULL }
};

static widget_menu_entry menu_file_aylogging[] = {
  { "AY Logging" },
  { "(R)ecord...", INPUT_KEY_r, NULL, menu_file_aylogging_record, 0 },
  { "(S)top", INPUT_KEY_s, NULL, menu_file_aylogging_stop, 0 },
  { NULL }
};

static widget_menu_entry menu_file[] = {
  { "File" },
  { "(O)pen...", INPUT_KEY_o, NULL, menu_file_open, 0 },
  { "(S)ave Snapshot...", INPUT_KEY_s, NULL, menu_file_savesnapshot, 0 },
  { "(R)ecording", INPUT_KEY_r, menu_file_recording, NULL, 0 },
  { "A(Y) Logging", INPUT_KEY_y, menu_file_aylogging, NULL, 0 },
  { "O(p)en SCR Screenshot...", INPUT_KEY_p, NULL, menu_file_openscrscreenshot, 0 },
  { "S(a)ve Screen as SCR...", INPUT_KEY_a, NULL, menu_file_savescreenasscr, 0 },
  //{ "Save S(c)reen as PNG...", INPUT_KEY_c, NULL, menu_file_savescreenaspng, 0 },
  //{ "Loa(d) binary data...", INPUT_KEY_d, NULL, menu_file_loadbinarydata, 0 },
  //{ "Save (b)inary data...", INPUT_KEY_b, NULL, menu_file_savebinarydata, 0 },
  { "E(x)it...", INPUT_KEY_x, NULL, menu_file_exit, 0 },
  { NULL }
};

static widget_menu_entry menu_options_joysticks[] = {
  { "Joysticks" },
  { "Joystick (1)...", INPUT_KEY_1, NULL, menu_options_joysticks_select, 1 },
  { "Joystick (2)...", INPUT_KEY_2, NULL, menu_options_joysticks_select, 2 },
  { "(K)eyboard...", INPUT_KEY_k, NULL, menu_options_joysticks_select, 3 },
  { NULL }
};

static widget_menu_entry menu_options_selectroms[] = {
  { "Select ROMs" },
  { "Spectrum 1(6)K...", INPUT_KEY_6, NULL, menu_options_selectroms_select, 1 },
  { "Spectrum (4)8K...", INPUT_KEY_4, NULL, menu_options_selectroms_select, 2 },
  { "Spectrum (1)28K...", INPUT_KEY_1, NULL, menu_options_selectroms_select, 3 },
  { "Spectrum +(2)...", INPUT_KEY_2, NULL, menu_options_selectroms_select, 4 },
  { "Spectrum +2(A)...", INPUT_KEY_a, NULL, menu_options_selectroms_select, 5 },
  { "Spectrum +(3)...", INPUT_KEY_3, NULL, menu_options_selectroms_select, 6 },
  { "Spectrum +3(e)...", INPUT_KEY_e, NULL, menu_options_selectroms_select, 11 },
  { "Timex (T)C2048...", INPUT_KEY_t, NULL, menu_options_selectroms_select, 7 },
  { "Timex TC206(8)...", INPUT_KEY_8, NULL, menu_options_selectroms_select, 8 },
  { "(P)entagon 128K...", INPUT_KEY_p, NULL, menu_options_selectroms_select, 9 },
  { "S(c)orpion ZS 256...", INPUT_KEY_c, NULL, menu_options_selectroms_select, 10 },
  { "Spectrum (S)E...", INPUT_KEY_s, NULL, menu_options_selectroms_select, 12 },
  { NULL }
};

static widget_menu_entry menu_options[] = {
  { "Options" },
  { "(G)eneral...", INPUT_KEY_g, NULL, menu_options_general, 0 },
  { "(S)ound...", INPUT_KEY_s, NULL, menu_options_sound, 0 },
  { "(P)eripherals...", INPUT_KEY_p, NULL, menu_options_peripherals, 0 },
  { "(R)ZX...", INPUT_KEY_r, NULL, menu_options_rzx, 0 },
  { "(J)oysticks", INPUT_KEY_j, menu_options_joysticks, NULL, 0 },
  { "S(e)lect ROMs", INPUT_KEY_e, menu_options_selectroms, NULL, 0 },
  { "(F)ilter...", INPUT_KEY_f, NULL, menu_options_filter, 0 },
  //{ "S(a)ve", INPUT_KEY_a, NULL, menu_options_save, 0 },
  { NULL }
};

static widget_menu_entry menu_machine[] = {
  { "Machine" },
//  { "(P)ause...", INPUT_KEY_p, NULL, menu_machine_pause, 0 },
//  { "(R)eset...", INPUT_KEY_r, NULL, menu_machine_reset, 0 },
//  { "(S)elect...", INPUT_KEY_s, NULL, menu_machine_select, 0 },
//  { "(D)ebugger...", INPUT_KEY_d, NULL, menu_machine_debugger, 0 },
//  { "P(o)ke Finder...", INPUT_KEY_o, NULL, menu_machine_pokefinder, 0 },
//  { "(M)emory Browser...", INPUT_KEY_m, NULL, menu_machine_memorybrowser, 0 },
//  { "(N)MI", INPUT_KEY_n, NULL, menu_machine_nmi, 0 },
  { NULL }
};

static widget_menu_entry menu_media_tape[] = {
  { "Tape" },
  { "(O)pen...", INPUT_KEY_o, NULL, menu_media_tape_open, 0 },
  { "(P)lay", INPUT_KEY_p, NULL, menu_media_tape_play, 0 },
  { "(B)rowse...", INPUT_KEY_b, NULL, menu_media_tape_browse, 0 },
  { "(R)ewind", INPUT_KEY_r, NULL, menu_media_tape_rewind, 0 },
  { "(C)lear", INPUT_KEY_c, NULL, menu_media_tape_clear, 0 },
  { "(W)rite...", INPUT_KEY_w, NULL, menu_media_tape_write, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_drivea[] = {
  { "Drive A:" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_disk_insert, 1 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_disk_eject, 1 },
  { "Eject and (w)rite...", INPUT_KEY_w, NULL, menu_media_disk_eject, 3 },
  { NULL }
};

static widget_menu_entry menu_media_disk_driveb[] = {
  { "Drive B:" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_disk_insert, 2 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_disk_eject, 2 },
  { "Eject and (w)rite...", INPUT_KEY_w, NULL, menu_media_disk_eject, 4 },
  { NULL }
};

static widget_menu_entry menu_media_disk[] = {
  { "Disk" },
  { "Drive (A):", INPUT_KEY_a, menu_media_disk_drivea, NULL, 0 },
  { "Drive (B):", INPUT_KEY_b, menu_media_disk_driveb, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge_timexdock[] = {
  { "Timex Dock" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_cartridge_timexdock_insert, 0 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_cartridge_timexdock_eject, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge_interfaceii[] = {
  { "Interface II" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_cartridge_interfaceii_insert, 0 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_cartridge_interfaceii_eject, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge[] = {
  { "Cartridge" },
  { "(T)imex Dock", INPUT_KEY_t, menu_media_cartridge_timexdock, NULL, 0 },
  { "(I)nterface II", INPUT_KEY_i, menu_media_cartridge_interfaceii, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit_master[] = {
  { "Master" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 1 },
  { "(C)ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 1 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 1 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit_slave[] = {
  { "Slave" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 2 },
  { "(C)ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 2 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 2 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit[] = {
  { "Simple 8-bit" },
  { "(M)aster", INPUT_KEY_m, menu_media_ide_simple8bit_master, NULL, 0 },
  { "(S)lave", INPUT_KEY_s, menu_media_ide_simple8bit_slave, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp_master[] = {
  { "Master" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 3 },
  { "(C)ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 3 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 3 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp_slave[] = {
  { "Slave" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 4 },
  { "(C)ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 4 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 4 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp[] = {
  { "ZXATASP" },
  { "(M)aster", INPUT_KEY_m, menu_media_ide_zxatasp_master, NULL, 0 },
  { "(S)lave", INPUT_KEY_s, menu_media_ide_zxatasp_slave, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxcfcompactflash[] = {
  { "ZXCF CompactFlash" },
  { "(I)nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 5 },
  { "(C)ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 5 },
  { "(E)ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 5 },
  { NULL }
};

static widget_menu_entry menu_media_ide[] = {
  { "IDE" },
  { "Simple (8)-bit", INPUT_KEY_8, menu_media_ide_simple8bit, NULL, 0 },
  { "ZX(A)TASP", INPUT_KEY_a, menu_media_ide_zxatasp, NULL, 0 },
  { "ZX(C)F CompactFlash", INPUT_KEY_c, menu_media_ide_zxcfcompactflash, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media[] = {
  { "Media" },
  { "(T)ape", INPUT_KEY_t, menu_media_tape, NULL, 0 },
  { "(D)isk", INPUT_KEY_d, menu_media_disk, NULL, 0 },
  { "(C)artridge", INPUT_KEY_c, menu_media_cartridge, NULL, 0 },
  { "(I)DE", INPUT_KEY_i, menu_media_ide, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_help[] = {
  { "Help" },
  { "(K)eyboard...", INPUT_KEY_k, NULL, menu_help_keyboard, 0 },
  { NULL }
};

widget_menu_entry widget_menu[] = {
  { "Main menu" },
  { "(F)ile", INPUT_KEY_f, menu_file, NULL, 0 },
  { "(O)ptions", INPUT_KEY_o, menu_options, NULL, 0 },
  { "(M)achine", INPUT_KEY_m, menu_machine, NULL, 0 },
  { "M(e)dia", INPUT_KEY_e, menu_media, NULL, 0 },
  { "(H)elp", INPUT_KEY_h, menu_help, NULL, 0 },
  { NULL }
};

