/*****************************************************************************
** File:        Win32Toolbar.c
**
** Author:      Daniel Vik
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#include "Win32ToolBar.h"
#include "Language.h"
#include "Resource.h"
#include <windows.h>
#include <CommCtrl.h>
#include <tchar.h>
#include <stdio.h>
#include <math.h>

static HWND hwndParent;
static HWND hwndToolBar = NULL; 
static int oldLarge = 0;
static int oldPause = 0;

#ifndef BTNS_BUTTON
#define BTNS_BUTTON     TBSTYLE_BUTTON
#endif
#ifndef BTNS_DROPDOWN
#define BTNS_DROPDOWN   TBSTYLE_DROPDOWN
#endif
#ifndef BTNS_SEP
#define BTNS_SEP        TBSTYLE_SEP
#endif


HWND toolBarInit(HWND parent) {
    TBBUTTON tbb[10]; 
    INITCOMMONCONTROLSEX icex;
    HBITMAP   hBtn;
    HIMAGELIST  hImglBtn;

    hwndParent = parent;
 
    icex.dwSize = sizeof(INITCOMMONCONTROLSEX);
    icex.dwICC  = ICC_BAR_CLASSES;
    InitCommonControlsEx(&icex);

    hwndToolBar = CreateWindowEx(0, TOOLBARCLASSNAME, (LPSTR) NULL, 
        WS_CHILD | TBSTYLE_TOOLTIPS | WS_BORDER | TBSTYLE_FLAT | CCS_ADJUSTABLE, 
        0, 0, 0, 0, hwndParent, (HMENU) ID_TOOLBAR, GetModuleHandle(NULL), NULL); 

    SendMessage(hwndToolBar, TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON), 0); 
    SendMessage(hwndToolBar, TB_SETSTYLE, 0, SendMessage(hwndToolBar, TB_GETSTYLE, 0,0 ) & ~TBSTYLE_TRANSPARENT);

    SendMessage(hwndToolBar, TB_SETBITMAPSIZE, 0, MAKELONG(18,18));
    SendMessage(hwndToolBar, TB_SETBUTTONSIZE, 0, MAKELONG(18,18));
    SendMessage(hwndToolBar, TB_AUTOSIZE, 0, 0L);

    hImglBtn = ImageList_Create(18, 18, ILC_COLOR24 | ILC_MASK , 3, 1);
    hBtn = LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_TOOLBAR), IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR);
    ImageList_AddMasked(hImglBtn, hBtn, RGB(222, 222, 209));
    DeleteObject(hBtn);
    
    SendMessage(hwndToolBar, TB_SETIMAGELIST, (WPARAM)0, (LPARAM)hImglBtn);
    SendMessage(hwndToolBar, TB_SETEXTENDEDSTYLE, (WPARAM)0, TBSTYLE_EX_DRAWDDARROWS );

    memset(tbb, 0, sizeof(tbb));

    tbb[0].iBitmap = 0; 
    tbb[0].idCommand = 0; 
    tbb[0].fsState = TBSTATE_ENABLED; 
    tbb[0].fsStyle = BTNS_SEP; 

    tbb[1].iBitmap = 0; 
    tbb[1].idCommand = ID_TB_RESET; 
    tbb[1].fsState = TBSTATE_ENABLED; 
    tbb[1].fsStyle = BTNS_DROPDOWN; 

    tbb[2].iBitmap = 1; 
    tbb[2].idCommand = ID_TB_CARTA; 
    tbb[2].fsState = TBSTATE_ENABLED; 
    tbb[2].fsStyle = BTNS_DROPDOWN; 

    tbb[3].iBitmap = 2; 
    tbb[3].idCommand = ID_TB_CARTB; 
    tbb[3].fsState = TBSTATE_ENABLED; 
    tbb[3].fsStyle = BTNS_DROPDOWN; 

    tbb[4].iBitmap = 3; 
    tbb[4].idCommand = ID_TB_DISKA; 
    tbb[4].fsState = TBSTATE_ENABLED; 
    tbb[4].fsStyle = BTNS_DROPDOWN; 

    tbb[5].iBitmap = 4; 
    tbb[5].idCommand = ID_TB_DISKB; 
    tbb[5].fsState = TBSTATE_ENABLED; 
    tbb[5].fsStyle = BTNS_DROPDOWN; 
    
    tbb[6].iBitmap = 5; 
    tbb[6].idCommand = ID_TB_CAS; 
    tbb[6].fsState = TBSTATE_ENABLED; 
    tbb[6].fsStyle = BTNS_DROPDOWN; 

    tbb[7].iBitmap = 0; 
    tbb[7].idCommand = 0; 
    tbb[7].fsState = TBSTATE_ENABLED; 
    tbb[7].fsStyle = BTNS_SEP; 

    tbb[8].iBitmap = 6; 
    tbb[8].idCommand = ID_TB_ZOOM; 
    tbb[8].fsState = TBSTATE_ENABLED; 
    tbb[8].fsStyle = BTNS_DROPDOWN; 

    tbb[9].iBitmap = 7; 
    tbb[9].idCommand = ID_TB_PROPERTIES; 
    tbb[9].fsState = TBSTATE_ENABLED; 
    tbb[9].fsStyle = BTNS_DROPDOWN; 

    SendMessage(hwndToolBar, TB_ADDBUTTONS, sizeof(tbb) / sizeof(TBBUTTON), 
        (LPARAM) (LPTBBUTTON) &tbb);

    ShowWindow(hwndToolBar, SW_SHOWNORMAL);

    return hwndToolBar;
}

void toolbarUpdate(int large, int pause) {
    TBBUTTON tbb; 

    if (oldLarge == large && oldPause == pause) {
        return;
    }

    memset(&tbb, 0, sizeof(tbb));

    if (large) {
        if (!oldLarge) {
            tbb.iBitmap = pause ? 9 : 8; 
            tbb.idCommand = ID_TB_PLAYPAUSE; 
            tbb.fsState = TBSTATE_ENABLED; 
            tbb.fsStyle = 0; 
            SendMessage(hwndToolBar, TB_INSERTBUTTON, 2, (LPARAM)(LPTBBUTTON)&tbb);

            tbb.iBitmap = 0; 
            tbb.idCommand = 0; 
            tbb.fsState = TBSTATE_ENABLED; 
            tbb.fsStyle = BTNS_SEP;  
            SendMessage(hwndToolBar, TB_INSERTBUTTON, 3, (LPARAM)(LPTBBUTTON)&tbb);

            tbb.iBitmap = 0; 
            tbb.idCommand = 0; 
            tbb.fsState = TBSTATE_ENABLED; 
            tbb.fsStyle = BTNS_SEP; 
            SendMessage(hwndToolBar, TB_INSERTBUTTON, 12, (LPARAM)(LPTBBUTTON)&tbb);

            tbb.iBitmap = 10; 
            tbb.idCommand = ID_TB_HELP; 
            tbb.fsState = TBSTATE_ENABLED; 
            tbb.fsStyle = 0; 
            SendMessage(hwndToolBar, TB_INSERTBUTTON, 13, (LPARAM)(LPTBBUTTON)&tbb);
        }
        else {
            SendMessage(hwndToolBar, TB_DELETEBUTTON, 2, 0);

            tbb.iBitmap = pause ? 9 : 8; 
            tbb.idCommand = ID_TB_PLAYPAUSE; 
            tbb.fsState = TBSTATE_ENABLED; 
            tbb.fsStyle = 0; 
            SendMessage(hwndToolBar, TB_INSERTBUTTON, 2, (LPARAM)(LPTBBUTTON)&tbb);
        }
    }
    else {
        if (oldLarge) {
            SendMessage(hwndToolBar, TB_DELETEBUTTON, 2, 0);
            SendMessage(hwndToolBar, TB_DELETEBUTTON, 2, 0);
            SendMessage(hwndToolBar, TB_DELETEBUTTON, 10, 0);
            SendMessage(hwndToolBar, TB_DELETEBUTTON, 10, 0);
        }
    }

    oldLarge = large;
    oldPause = pause;
}

void toolBarShow(int show) {
    ShowWindow(hwndToolBar, show);
}
