/*****************************************************************************
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef LANGUAGE_PORTUGUESE_H
#define LANGUAGE_PORTUGUESE_H

#include "LanguageStrings.h"

void langInitPortuguese(LanguageStrings* ls) 
{
    ls->statusBarStopped        = "  Parado ";
    ls->statusBarPaused         = "  Pausa ";
    ls->statusBarRunning        = "  Executando";
    
    ls->menuHardReset           = "Reset Completo";
    ls->menuSoftReset           = "Reset Leve";
    
    ls->menuCartInsert          = "Inserir";
    ls->menuCartRemove          = "Remover";
    ls->menuCartAutoReset       = "Reset apos inserir/remover";
    ls->menuCartNoRecentFiles   = "- Sem Arquivos Recentes -";
    ls->menuCartFMPac           = "Cartucho FM-PAC";
    ls->menuCartPac           = "Cartucho PAC";
    ls->menuCartSpecial         = "Especial";

    ls->menuDiskInsert          = "Inserir";
    ls->menuDiskEject           = "Ejetar";
    ls->menuDiskAutoStart       = "Reset apos inserir";
    ls->menuDiskNoRecentFiles   = "- Sem Arquivos Recentes -";
    
    ls->menuCasInsert           = "Inserir";
    ls->menuCasEject            = "Ejetar";
    ls->menuCasSetPosition      = "Ajustar Posio";
    ls->menuCasRewind           = "Rebobinar";
    ls->menuCasNoRecentFiles    = "- Sem Arquivos Recentes -";

    ls->menuZoomNormal          = "Tamanho Normal";
    ls->menuZoomDouble          = "Tamanho Duplo";
    ls->menuZoomFullscreen      = "Tela Cheia";
    
    ls->menuPropsEmulation      = "Emulao";
    ls->menuPropsVideo          = "Video";
    ls->menuPropsSound          = "Som";
    ls->menuPropsControls       = "Controles";
    ls->menuPropsPerformance    = "Performance";
    ls->menuPropsLanguage       = "Linguagem";
    
    ls->menuHelpHelp            = "Topicos Ajuda";
    ls->menuHelpAbout           = "Sobre blueMSX";

    ls->menuFileCart1           = "Cartucho slot 1";
    ls->menuFileCart2           = "Cartucho slot 2";
    ls->menuFileDiskA           = "Disco drive A";
    ls->menuFileDiskB           = "Disco drive B";
    ls->menuFileCas             = "Cassette";
    ls->menuFileLoadState       = "Carregar Status da CPU";
    ls->menuFileSaveState       = "Salvar Status da CPU";
    ls->menuFileQLoadState      = "Carregar rapido Status";
    ls->menuFileQSaveState      = "Salvar rapido Status";
    ls->menuFileCaptureAudio    = "Capturar audio";
    ls->menuFileScreenShot      = "Salvar Tela";
    ls->menuFileExit            = "Sair";

    ls->menuRunRun              = "Executar";
    ls->menuRunPause            = "Pausa";
    ls->menuRunStop             = "Parar";
    ls->menuRunSoftReset        = "Reset Completo";
    ls->menuRunHardReset        = "Reset Leve";
    ls->menuRunCleanReset       = "Reset Geral";

    ls->menuFile                = "Arquivo";
    ls->menuRun                 = "Execuo";
    ls->menuWindow              = "Janela";
    ls->menuOptions             = "Opes";
    ls->menuHelp                = "Ajuda";
    
    ls->errorTitle              = "blueMSX - Erro";
    ls->errorEnterFullscreen    = "Falha ao entrar em Tela Cheia.             \n";
    ls->errorDirectXFailed      = "Falha ao Criar Objetos DirectX.             \nUsando GDI ao inves.\nCheque as propriedades Video.";
    ls->errorNoRomInZip         = "Nao foi localizado arquivo .ROM dentro do arquivo zip.";
    ls->errorNoDskInZip         = "Nao foi localizado arquivo .DSK dentro do arquivo zip.";
    ls->errorNoCasInZip         = "Nao foi localizado arquivo .CAS dentro do arquivo zip.";
    ls->errorNoHelp             = "Nao foi localizado arquivo ajuda do blueMSX";
    ls->errorStartEmu           = "Falha ao Iniciar o emulador MSX.";

    ls->tooltipReset            = "Reset MSX";
    ls->tooltipCart1            = "Insira Cartucho no Slot 1";
    ls->tooltipCart2            = "Insira Cartucho no Slot 2";
    ls->tooltipDiskA            = "Insira Disco no Drive A";
    ls->tooltipDiskB            = "Insira Disco no Drive B";
    ls->tooltipCas              = "Insira Tape no Cassette player";
    ls->tooltipStart            = "Iniciar emulao";
    ls->tooltipResume           = "Continuar emulao";
    ls->tooltipPause            = "Pausar emulao";
    ls->tooltipWindowSize       = "Ajustar tamanho Janela";
    ls->tooltipProperties       = "Abrir Propriedades";
    ls->tooltipHelp             = "Abrir Ajuda";

    ls->dlgMainWindow           = "  blueMSX";
    ls->dlgLoadRom              = "blueMSX - Selecione uma ROM para carregar";
    ls->dlgLoadDsk              = "blueMSX - Selecione uma DSK para carregar";
    ls->dlgLoadCas              = "blueMSX - Selecione uma CAS para carregar";
    ls->dlgLoadRomDskCas        = "blueMSX - Selecione uma ROM, DSK, ou CAS para carregar";
    ls->dlgLoadRomDesc          = "Escolha uma ROM para carregar:";
    ls->dlgLoadDskDesc          = "Escolha um disco para carregar:";
    ls->dlgLoadCasDesc          = "Escolha um tape para carregar:";
    ls->dlgLoadRomDskCasDesc    = "Escolha uma ROM, disco, ou tape para carregar:";
    ls->dlgLoadState            = "Carregar Status da CPU";
    ls->dlgSaveState            = "Salvar Status da CPU";
    ls->dlgInsertRom1           = "Insira cartucho ROM no slot 1";
    ls->dlgInsertRom2           = "Insira cartucho ROM no slot 2";
    ls->dlgInsertDiskA          = "Insira disco no drive A";
    ls->dlgInsertDiskB          = "Insira disco no drive B";
    ls->dlgInsertCas            = "Insira cassette tape";

    ls->dlgOK                   = "OK";
    ls->dlgOpen                 = "Abrir";
    ls->dlgCancel               = "Cancelar";

    ls->dlgTapeTitle            = "blueMSX - Posio do Tape";
    ls->dlgTapeFrameText        = "Posio do Tape";
    ls->dlgTapeCurrentPos       = "Posio Atual";
    ls->dlgTapeTotalTime        = "Tempo Total";

    ls->dlgZipReset             = "Reset apos inserir";

    ls->dlgAboutTitle           = "blueMSX - Sobre";

    ls->dlgJoyTitle1            = "blueMSX - Ajuste Joystick A";
    ls->dlgJoyTitle2            = "blueMSX - Ajuste Joystick B";
    ls->dlgJoyUpText            = "Acima";
    ls->dlgJoyDownText          = "Abaixo";
    ls->dlgJoyLeftText          = "Esquerda";
    ls->dlgJoyRightText         = "Direita";
    ls->dlgJoyButton1Text       = "Botao 1";
    ls->dlgJoyButton2Text       = "Botao 2";
    ls->dlgJoyGB                = "Ajuste das Teclas ";

    ls->dlgLangLangText         = "Escolha uma linguagem que blueMSX ir usar";
    ls->dlgLangLangTitle        = "blueMSX - Linguagem";

    ls->propTitle               = "blueMSX - Propriedades";
    ls->propEmulation           = "Emulao";
    ls->propVideo               = "Video";
    ls->propSound               = "Som";
    ls->propControls            = "Controles";
    ls->propPerformance         = "Performance";
    
    ls->propEmuGeneralGB        = "Geral ";
    ls->propEmuFamilyText       = "MSX :";
    ls->propEmuMemoryGB         = "Memoria ";
    ls->propEmuRamSizeText      = "Tamanho RAM :";
    ls->propEmuVramSizeText     = "Tamanho VRAM :";
    ls->propEmuSpeedGB          = "Velocidade da Emulao ";
    ls->propEmuSpeedText        = "Velocidade da Emulao:";

    ls->propMonMonGB            = "Monitor:";
    ls->propMonTypeText         = "Tipo de Monitor:";
    ls->propMonEmuText          = "Emulaco de Monitor:";
    ls->propVideoYypeText       = "Tipo de Video:";
    ls->propWindowSizeText      = "Tamanho Janela:";

    ls->propPerfVideoDrvGB      = "Driver de Video";
    ls->propPerfVideoDispDrvText= "Driver do Display:";
    ls->propPerfFrameSkipText   = "Frame skipping:";
    ls->propPerfAudioDrvGB      = "Driver de Audio:";
    ls->propPerfAudioDrvText    = "Driver de Som:";
    ls->propPerfAudioBufSzText  = "Tamanho buffer Som:";
    ls->propPerfEmuGB           = "Emulao ";
    ls->propPerfSyncModeText    = "Modo Sincronismo:";

    ls->propSndChipEmuGB        = "Emulao do Chip de Som";
    ls->propSndMixerGB          = "Mixer de Audio";
    ls->propSndMonoText         = "Mono";
    ls->propSndStereoText       = "Estereo";
    ls->propSndMsxMusicText     = " MSX-MUSIC (YM-2413 chip de som)";
    ls->propSndMsxAudioText     = " MSX-AUDIO (Y8950 chip de som)";
    ls->propSndMsxMasterText    = "MASTER";

    ls->propJoyPort1GB          = "Porta #1";
    ls->propJoyPort2GB          = "Porta #2";
    ls->propJoyAutofireText     = "Auto-Tiro";
    ls->propJoyKeysetGB         = "Ajuste de Joystick";
    ls->propJoyKeyest1          = "Ajuste Joystick A";
    ls->propJoyKeyest2          = "Ajuste Joystick B";

    ls->enumVideoMonColor       = "Cor";
    ls->enumVideoMonGrey        = "Branco e Preto";
    ls->enumVideoMonGreen       = "Verde";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC e PAL-M";

    ls->enumVideoEmuNone        = "Nenhum";
    ls->enumVideoEmuYc          = "Y/C cable (sharp)";
    ls->enumVideoEmuYcBlur      = "Noisy Y/C cable (sharp)";
    ls->enumVideoEmuComp        = "Composite (blurry)";
    ls->enumVideoEmuCompBlur    = "Noisy Composite (blurry)";
    ls->enumVideoEmuScale2x     = "Escala 2x";

    ls->enumVideoSize1x         = "Normal - 320x200";
    ls->enumVideoSize2x         = "Duplo  - 640x400";
    ls->enumVideoSizeFullscreen = "Tela Cheia";

    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";

    ls->enumVideoFrameskip0     = "Nenhum";
    ls->enumVideoFrameskip1     = "1 frame";
    ls->enumVideoFrameskip2     = "2 frames";
    ls->enumVideoFrameskip3     = "3 frames";
    ls->enumVideoFrameskip4     = "4 frames";
    ls->enumVideoFrameskip5     = "5 frames";

    ls->enumSoundDrvNone        = "Sem Som";
    ls->enumSoundDrvWMM         = "Driver WMM";
    ls->enumSoundDrvDirectX     = "Driver DirectX";

    ls->enumEmuSync1ms          = "1ms (Melhor)";
    ls->enumEmuSyncAuto         = "Auto (Rapido)";

    ls->enumControlsJoyNone     = "Nenhum";
    ls->enumControlsJoyNumpad   = "Teclado Numerico";
    ls->enumControlsJoyKeysetA  = "Teclas A";
    ls->enumControlsJoyKeysetB  = "Teclas B";
    ls->enumControlsJoyPCjoy1   = "PC joystick #1";
    ls->enumControlsJoyPCjoy2   = "PC joystick #2";
    ls->enumControlsJoyMouse    = "Mouse";

    ls->enumControlsAfOff       = "Desligado";
    ls->enumControlsAfSlow      = "Lento";
    ls->enumControlsAfMedium    = "Medio";
    ls->enumControlsAfFast      = "Rapido";

    ls->dlgAboutAbout           = "Sobre\r\n====";
    ls->dlgAboutVersion         = "Verso:";
    ls->dlgAboutBuildNumber     = "Compilao:";
    ls->dlgAboutBuildDate       = "Data:";
    ls->dlgAboutDevel           = "Desenvolvido por Daniel Vik";
    ls->dlgAboutThanks          = "MOITO OBRIGADO PARA\r\n============";
    ls->dlgAboutLisence         = "LICENA\r\n"
                                  "======\r\n\r\n"
                                  "Este software  provido 'como-est', sem Garantia expressa ou implicada."
                                  "Em Nenhuma circunstancia os autores sero responsaveis por qualquer "
                                  "Problema ou DANO proveniente do uso deste software.\r\n\r\n"
                                  "Qualquer pessoal poder utilizar este software para uso no-comercial "
                                  "SOMENTE.\r\n\r\n\r\n"
                                  "Visite www.bluemsx.com para mais detalhes.";


    
    ls->dlgAboutCreat           = "Criado Por Daniel Vik";
    ls->dlgAboutDevel           = "DESENVOLVEDORES\r\n========";

    // New entries
    ls->menuTools                = "Ferramentas";
    ls->menuToolsMachine         = "Configurao da Maquina";
    ls->menuPropsSettings        = "Ajustes";
    ls->menuCasRewindAfterInsert = "Rebobinar Apos Inserir";
    ls->menuCasUseReadOnly       = "Usar Cassette Como Somente Leitura";
    ls->lmenuCasSaveAs           = "Salvar Imagem do Cassette Como...";

    ls->dlgSaveCassette          = "blueMSX - Salvar Imagem Tape";
    ls->dlgTapeCustom            = "Mostrar Arquivos Personalizados";
    ls->dlgTapeSetPosText        = "Posio do Tape:";
    ls->dlgTabPosition           = "Posio";
    ls->dlgTabType               = "Tipo";
    ls->dlgTabFilename           = "Nome do Arquivo";

    ls->propSettings             = "Ajustes";
    
    ls->propSetFileHistoryGB     = "Histrico ";
    ls->propSetFileHistorySize   = "Numero de items no Histrico:";
    ls->propSetFileHistoryClear  = "Limpar Historico";
    ls->propSetScreenSaverGB     = "Proteo de Tela";
    ls->propSetScreenSaver       = "Desabilitar Proteo de Tela Quando blueMSX estiver ativo";

    ls->confTitle                = "blueMSX - Editor de Configurao da Maquina";
    ls->confSave                 = "Salvar";
    ls->confSaveAs               = "Salvar Como";
    ls->confRun                  = "Executar";
    ls->confClose                = "Fechar";
    ls->confConfigText           = "Configurao";
    ls->confSlotLayout           = "Slot Layout";
    ls->confMemory               = "Memoria";
    ls->confChipEmulation        = "Emulao do Chip";

    ls->confSlotLayoutGB         = "Layout do Slot ";
    ls->confSlotExtSlotGB        = "Slots Externos";
    ls->confSlotSlot0            = "Slot 0";
    ls->confSlotSlot1            = "Slot 1";
    ls->confSlotSlot2            = "Slot 2";
    ls->confSlotSlot3            = "Slot 3";
    ls->confSlotCart1            = "Cartucho 1:";
    ls->confSlotCart2            = "Cartucho 2:";
    ls->confSlotPrimary          = "Primario";
    ls->confSlotExpanded         = "Expandido (Quatro sub-slots)";

    ls->confMemAdd               = "Adicionar...";
    ls->confMemEdit              = "Editar...";
    ls->confMemRemove            = "Remover";
    ls->confMemSlot              = "Slot";
    ls->confMemAddresss          = "Endereo";
    ls->confMemType              = "Tipo";
    ls->confMemRomImage          = "Imagem Rom ";
    
    ls->confChipVideoGB          = "Video ";
    ls->confChipVideoChip        = "Video Chip:";
    ls->confChipVideoRam         = "Video RAM:";
    ls->confChipSoundGB          = "Som ";

    ls->confSaveTitle            = "blueMSX - Salvar Configurao";
    ls->confSaveText             = "Voc quer  substituir esta configurao da mquina? :";

    ls->slotEditMemTitle         = "blueMSX - Editar Mapper";
    ls->slotEditMemGB            = "Detalhes do Mapper ";
    ls->slotEditMemType          = "Tipo:";
    ls->slotEditMemFile          = "Arquivo:";
    ls->slotEditMemAddress       = "Endereo";
    ls->slotEditMemSize          = "Tamanho";
    ls->slotEditMemSlot          = "Slot";

    ls->confDiscardTitle         = "blueMSX - Configurao";
    ls->confExitSaveTitle        = "blueMSX - Sair do Editor de Configurao";
    ls->confExitSaveText         = "Voce quer desfazer as alteraes da Configurao atual ?";

    ls->confSaveAsTitle          = "blueMSX - Salvar Configurao da Maquina Como...";
    ls->confSaveAsMachineName    = "Nome da Maquina:";

    ls->confEditMemInternalRoms  = "blueMSX - Roms interno"; 


    ls->propSndMoonsound         = " Moonsound";

    ls->propFileTypesGB          = "Tipos de arquivo ";
    ls->propFileTypes            = " Associar certos tipos de arquivo com blueMSX";
    ls->propDisableWinKeys       = " Funo MSX automtica para as teclas Windows"; 
    ls->propWindowsEnvGB         = "Ambiente Windows";

    ls->enumVideoDrvDirectDrawHW = "DirectDraw HW acel.";
    ls->enumVideoDrvDirectDrawHWSys = "DirectDraw mix."; 
    ls->propMonHorizStretch      = " Estiramento Horizontal"; 
    ls->propClearHistory         = "Dsirez realmente limpar historico ?";
    ls->propEmuFrontSwitchGB     = "Botaoes Panasonic "; 
    ls->propEmuFrontSwitch       = " Botao Frontal (MSX2+)"; 
    ls->propEmuAudioSwitch       = " Botao cartucho MSX-AUDIO"; 
    ls->propMonVertStretch       = " Estiramento Vertical"; 

    ls->dlgCmosGB                = "CMOS "; 
    ls->dlgCmosEnable            = " Activar CMOS"; 
    ls->dlgCmosBattery           = " Utilizar uma Bateria Carregada";

    ls->menuCartSnatcher        = "Cartucho The Snatcher";
    ls->menuCartSdSnatcher      = "Cartucho SD-Snatcher";
    ls->menuCartSCCMirrored     = "Cartucho SCC Mirrored";
    ls->menuCartSCCExpanded     = "Cartucho SCC Expanded";
    
    ls->warningTitle             = "blueMSX - Advertncia";
    ls->tooltipStop              = "Parar emulao";
};

#endif

