/*****************************************************************************
**
** Copyright (C) 2003-2004 Daniel Vik
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
******************************************************************************
*/
#ifndef LANGUAGE_SWEDISH_H
#define LANGUAGE_SWEDISH_H

#include "LanguageStrings.h"

void langInitSwedish(LanguageStrings* ls) 
{
    ls->statusBarStopped        = "  Stannad";
    ls->statusBarPaused         = "  Pausad";
    ls->statusBarRunning        = "  Startad";
    
    ls->menuHardReset           = "Hrd Reset";
    ls->menuSoftReset           = "Mjuk Reset";
    
    ls->menuCartInsert          = "Stt in";
    ls->menuCartRemove          = "Ta ur";
    ls->menuCartAutoReset       = "Starta om efter insttning/urdagning";
    ls->menuCartNoRecentFiles   = "- ingen filhistoria -";
    ls->menuCartSCCPlus         = "SCC+ Cartridge";
    ls->menuCartFMPac           = "FM-PAC Cartridge";
    ls->menuCartPac             = "PAC Cartridge";
    ls->menuCartSpecial         = "Special";

    ls->menuDiskInsert          = "Stt in";
    ls->menuDiskEject           = "Ta ur";
    ls->menuDiskAutoStart       = "Starta om efter insttning/urdagning";
    ls->menuDiskNoRecentFiles   = "- ingen filhistoria -";
    
    ls->menuCasInsert           = "Stt in";
    ls->menuCasEject            = "Ta ur";
    ls->menuCasSetPosition      = "Stt position";
    ls->menuCasRewind           = "Spola tillbaka";
    ls->menuDiskNoRecentFiles   = "- ingen filhistoria -";

    ls->menuZoomNormal          = "Normal storlek";
    ls->menuZoomDouble          = "Dubbel storlek";
    ls->menuZoomFullscreen      = "Helskrm";
    
    ls->menuPropsEmulation      = "Emulering";
    ls->menuPropsVideo          = "Video";
    ls->menuPropsSound          = "Ljud";
    ls->menuPropsControls       = "Kontroller";
    ls->menuPropsPerformance    = "Prestanda";
    ls->menuPropsLanguage       = "Sprk";
    
    ls->menuHelpHelp            = "Hjlp";
    ls->menuHelpAbout           = "Om blueMSX";

    ls->menuFileCart1           = "Cartridge slot 1";
    ls->menuFileCart2           = "Cartridge slot 2";
    ls->menuFileDiskA           = "Diskettstaion A";
    ls->menuFileDiskB           = "Diskettstaion B";
    ls->menuFileCas             = "Kasett";
    ls->menuFileLoadState       = "Ls in CPU-tillstand";
    ls->menuFileSaveState       = "Spara CPU-tillstand";
    ls->menuFileQLoadState      = "Snabbladda CPU-tillstand";
    ls->menuFileQSaveState      = "Snabbspara CPU-tillstand";
    ls->menuFileCaptureAudio    = "Spara ljud";
    ls->menuFileScreenShot      = "Spara skrmdump";
    ls->menuFileExit            = "Avsluta";

    ls->menuRunRun              = "Kr";
    ls->menuRunPause            = "Paus";
    ls->menuRunStop             = "Stop";
    ls->menuRunSoftReset        = "Mjuk Omstart";
    ls->menuRunHardReset        = "Hrd Omstart";
    ls->menuRunCleanReset       = "Full Omstart";

    ls->menuFile                = "Arkiv";
    ls->menuRun                 = "Kr";
    ls->menuWindow              = "Fnster";
    ls->menuOptions             = "Egenskaper";
    ls->menuHelp                = "Hjlp";
    
    ls->errorTitle              = "blueMSX - Fel";
    ls->errorEnterFullscreen    = "Misslyckades att byta till fullskrm.           \n";
    ls->errorDirectXFailed      = "Misslyckades att skapa DirectX objekt.          \nAnvnder GDI istllet.\nKontrollera video instllningarna.";
    ls->errorNoRomInZip         = "Kunde inte hitta en .rom fil i zip arkivet.";
    ls->errorNoDskInZip         = "Kunde inte hitta en .dsk fil i zip arkivet.";
    ls->errorNoCasInZip         = "Kunde inte hitta en .cas fil i zip arkivet.";
    ls->errorNoHelp             = "Kunde inte hitta hjlpfilen.";
    ls->errorStartEmu           = "Misslyckades att starta emulatorn.";

    ls->tooltipReset            = "Starta om emulatorn";
    ls->tooltipCart1            = "Stt in Cartridge i Slot 1";
    ls->tooltipCart2            = "Stt in Cartridge i Slot 2";
    ls->tooltipDiskA            = "Stt in diskett i diskettstation A";
    ls->tooltipDiskB            = "Stt in diskett i diskettstation B";
    ls->tooltipCas              = "Stt in kassettband";
    ls->tooltipStart            = "Starta emuleringen";
    ls->tooltipResume           = "Fortstt emuleringen";
    ls->tooltipPause            = "Pausa emuleringen";
    ls->tooltipWindowSize       = "Stt fnsterstorlek";
    ls->tooltipProperties       = "ppna Egenskaper";
    ls->tooltipHelp             = "ppna Hjalp fonstret";

    ls->dlgMainWindow           = "  blueMSX";
    ls->dlgLoadRom              = "blueMSX - Ladda en rom fil";
    ls->dlgLoadDsk              = "blueMSX - Ladda en dsk fil";
    ls->dlgLoadCas              = "blueMSX - Ladda en cas fil";
    ls->dlgLoadRomDskCas        = "blueMSX - Ladda en rom, dsk eller cas fil";
    ls->dlgLoadRomDesc          = "Vlj en cartridge fil:";
    ls->dlgLoadDskDesc          = "Vlj en diskett fil:";
    ls->dlgLoadCasDesc          = "Vlj en kassett fil:";
    ls->dlgLoadRomDskCasDesc    = "Vlj en fil:";
    ls->dlgLoadState            = "Ladda CPU-tillstand";
    ls->dlgSaveState            = "Spara CPU-tillstand";
    ls->dlgInsertRom1           = "Stt in ROM cartridge i slot 1";
    ls->dlgInsertRom2           = "Stt in ROM cartridge i slot 2";
    ls->dlgInsertDiskA          = "Stt in diskett i diskettstation A";
    ls->dlgInsertDiskB          = "Stt in diskett i diskettstation B";
    ls->dlgInsertCas            = "Stt in kassettband";

    ls->dlgOK                   = "OK";
    ls->dlgOpen                 = "ppna";
    ls->dlgCancel               = "Avbryt";

    ls->dlgTapeTitle            = "blueMSX - Kassettposition";
    ls->dlgTapeFrameText        = "Kassettposition";
    ls->dlgTapeCurrentPos       = "Aktuell position";
    ls->dlgTapeTotalTime        = "Total lngd";
    
    ls->dlgZipReset             = "Starta om efter insttning";

    ls->dlgAboutTitle           = "blueMSX - Information";

    ls->dlgJoyTitle1            = "blueMSX - Styrspak tangentgrupp A";
    ls->dlgJoyTitle2            = "blueMSX - Styrspak tangentgrupp B";
    ls->dlgJoyUpText            = "Upp";
    ls->dlgJoyDownText          = "Ner";
    ls->dlgJoyLeftText          = "Vnster";
    ls->dlgJoyRightText         = "Hger";
    ls->dlgJoyButton1Text       = "Knapp 1";
    ls->dlgJoyButton2Text       = "Knapp 2";
    ls->dlgJoyGB                = "Konfigurering av tangentgrupp ";

    ls->dlgLangLangText         = "Vlj sprk som blueMSX ska anvnda";
    ls->dlgLangLangTitle        = "blueMSX - Sprk";

    ls->propTitle               = "blueMSX - Egenskaper";
    ls->propEmulation           = "Emulering";
    ls->propVideo               = "Video";
    ls->propSound               = "Ljud";
    ls->propControls            = "Kontroller";
    ls->propPerformance         = "Prestanda";
    
    ls->propEmuGeneralGB        = "Allmnt ";
    ls->propEmuFamilyText       = "MSX familj:";
    ls->propEmuMemoryGB         = "Minne ";
    ls->propEmuRamSizeText      = "RAM storlek:";
    ls->propEmuVramSizeText     = "VRAM storlek:";
    ls->propEmuSpeedGB          = "Emuleringshastighet ";
    ls->propEmuSpeedText        = "Emuleringshastighet:";

    ls->propMonMonGB            = "Monitor ";
    ls->propMonTypeText         = "Monitor typ:";
    ls->propMonEmuText          = "Monitor emulering ";
    ls->propVideoYypeText       = "Video typ:";
    ls->propWindowSizeText      = "Fnsterstorlek:";

    ls->propPerfVideoDrvGB      = "Video Driver ";
    ls->propPerfVideoDispDrvText= "Display driver:";
    ls->propPerfFrameSkipText   = "Frame skipping:";
    ls->propPerfAudioDrvGB      = "Audiodriver ";
    ls->propPerfAudioDrvText    = "Ljuddriver:";
    ls->propPerfAudioBufSzText  = "Storlek p ljudbuffer:";
    ls->propPerfEmuGB           = "Emulering ";
    ls->propPerfSyncModeText    = "Synkronisering:";

    ls->propSndChipEmuGB        = "Emulering av ljudchip ";
    ls->propSndMixerGB          = "Ljudmixer ";
    ls->propSndMonoText         = "mono";
    ls->propSndStereoText       = "stereo";
    ls->propSndMsxMusicText     = " MSX-MUSIC (YM-2413 ljudchip)";
    ls->propSndMsxAudioText     = " MSX-AUDIO (Y8950 ljudchip)";
    ls->propSndMsxMasterText    = "MASTER";

    ls->propJoyPort1GB          = "Port #1 ";
    ls->propJoyPort2GB          = "Port #2 ";
    ls->propJoyAutofireText     = "Auto eld:";
    ls->propJoyKeysetGB         = "Tangentgrupper for styrspak ";
    ls->propJoyKeyest1          = "Konfigurera grupp A";
    ls->propJoyKeyest2          = "Konfigurera grupp B";

    ls->enumVideoMonColor       = "Frg";
    ls->enumVideoMonGrey        = "Svartvit";
    ls->enumVideoMonGreen       = "Grn";

    ls->enumVideoTypePAL        = "PAL";
    ls->enumVideoTypeNTSC       = "NTSC";

    ls->enumVideoEmuNone        = "Ingen";
    ls->enumVideoEmuYc          = "Y/C kabel (skarp)";
    ls->enumVideoEmuYcBlur      = "Brusig Y/C kabel (skarp)";
    ls->enumVideoEmuComp        = "Kompositkabel (suddig)";
    ls->enumVideoEmuCompBlur    = "Brusig komposit (suddig)";
    ls->enumVideoEmuScale2x     = "Scale 2x";

    ls->enumVideoSize1x         = "Normal - 320x200";
    ls->enumVideoSize2x         = "Dubbel - 640x400";
    ls->enumVideoSizeFullscreen = "Helskrm";

    ls->enumVideoDrvDirectDraw  = "DirectDraw";
    ls->enumVideoDrvGDI         = "GDI";

    ls->enumVideoFrameskip0     = "Ingen";
    ls->enumVideoFrameskip1     = "1 bild";
    ls->enumVideoFrameskip2     = "2 bilder";
    ls->enumVideoFrameskip3     = "3 bilder";
    ls->enumVideoFrameskip4     = "4 bilder";
    ls->enumVideoFrameskip5     = "5 bilder";

    ls->enumSoundDrvNone        = "Inget ljud";
    ls->enumSoundDrvWMM         = "WMM driver";
    ls->enumSoundDrvDirectX     = "DirectX driver";

    ls->enumEmuSync1ms          = "1ms (bast)";
    ls->enumEmuSyncAuto         = "Automatisk (snabbast)";

    ls->enumControlsJoyNone     = "Ingen";
    ls->enumControlsJoyNumpad   = "Numeriska tangenter";
    ls->enumControlsJoyKeysetA  = "Tangentgrupp A";
    ls->enumControlsJoyKeysetB  = "Tangentgrupp B";
    ls->enumControlsJoyPCjoy1   = "PC styrspak #1";
    ls->enumControlsJoyPCjoy2   = "PC styrspak #2";
    ls->enumControlsJoyMouse    = "Mus";

    ls->enumControlsAfOff       = "Av";
    ls->enumControlsAfSlow      = "Lngsam";
    ls->enumControlsAfMedium    = "Medel";
    ls->enumControlsAfFast      = "Snabb";

    ls->dlgAboutAbout           = "INFORMATION\r\n========";
    ls->dlgAboutVersion         = "Version:";
    ls->dlgAboutBuildNumber     = "Bygge:";
    ls->dlgAboutBuildDate       = "Datum:";
    ls->dlgAboutCreat           = "Skapat av Daniel Vik";
    ls->dlgAboutDevel           = "UTVECKLARE\r\n========";
    ls->dlgAboutThanks          = "TACK TILL\r\n=======";
    ls->dlgAboutLisence         = "LICENS\r\n"
                                  "=====\r\n\r\n"
                                  "Denna programvara r erbjuden 'som den r', utan ngon explicit eller "
                                  "implicit garanti. Inte av ngon hndelse kommer frfattaren/na att hllas "
                                  "ansvariga fr ngra skador orsakade av detta program.\r\n\r\n"
                                  "Tillstnd ges till vem som helst att anvnda detta program endast fr icke-"
                                  "kommersiell anvndning\r\n\r\n\r\n"
                                  "Besk www.vik.cc/blueMSX for mer detaljer.";

    ls->menuTools                = "Verktyg";
    ls->menuToolsMachine         = "Konfigureringsverktyg";
    ls->menuPropsSettings        = "Instllningar";
    ls->menuCasRewindAfterInsert = "Spola tillbaka vid insttning";
    ls->menuCasUseReadOnly       = "Tillt endast lsning av kasett";
    ls->lmenuCasSaveAs           = "Spara kasett som...";
    
    ls->dlgSaveCassette          = "blueMSX - Spara Kasett";
    ls->dlgTapeCustom            = "Visa Specialfiler";
    ls->dlgTapeSetPosText        = "Kasettposition:";
    ls->dlgTabPosition           = "Position";
    ls->dlgTabType               = "Typ";
    ls->dlgTabFilename           = "Filnamn";

    ls->propSettings             = "Instllningar";
    
    ls->propSetFileHistoryGB     = "Filhistoria ";
    ls->propSetFileHistorySize   = "Antal element i filhistorian:";
    ls->propSetFileHistoryClear  = "Rensa historia";
    ls->propSetScreenSaverGB     = "Skrmslckare ";
    ls->propSetScreenSaver       = " Deaktivera skrmslckare nr blueMSX kr";

    ls->confTitle                = "blueMSX - Konfigureringsverktyg";
    ls->confSave                 = "Spara";
    ls->confSaveAs               = "Spara Som...";
    ls->confRun                  = "Kr";
    ls->confClose                = "Stng";
    ls->confConfigText           = "Konfigurering:";
    ls->confSlotLayout           = "Slot mappning";
    ls->confMemory               = "Minne";
    ls->confChipEmulation        = "Chipemulering";

    ls->confSlotLayoutGB         = "Slot Layout ";
    ls->confSlotExtSlotGB        = "Externa slots ";
    ls->confSlotSlot0            = "Slot 0";
    ls->confSlotSlot1            = "Slot 1";
    ls->confSlotSlot2            = "Slot 2";
    ls->confSlotSlot3            = "Slot 3";
    ls->confSlotCart1            = "Cartridge 1:";
    ls->confSlotCart2            = "Cartridge 2:";
    ls->confSlotPrimary          = "Primr";
    ls->confSlotExpanded         = "Expanderad (4 subslottar)";

    ls->confMemAdd               = "Ny...";
    ls->confMemEdit              = "ndra...";
    ls->confMemRemove            = "Ta Bort";
    ls->confMemSlot              = "Slot";
    ls->confMemAddresss          = "Adress";
    ls->confMemType              = "Typ";
    ls->confMemRomImage          = "Rom Fil";
    
    ls->confChipVideoGB          = "Video ";
    ls->confChipVideoChip        = "Video Chip:";
    ls->confChipVideoRam         = "Video RAM:";
    ls->confChipSoundGB          = "Audio ";

    ls->confSaveTitle            = "blueMSX - Spara Konfigurering";
    ls->confSaveText             = "Vill du skriva ver maskinkonfigureringen? :";

    ls->slotEditMemTitle         = "blueMSX - ndra Minnesmap";
    ls->slotEditMemGB            = "Detailjer ";
    ls->slotEditMemType          = "Typ:";
    ls->slotEditMemFile          = "Fil:";
    ls->slotEditMemAddress       = "Adress";
    ls->slotEditMemSize          = "Storlek";
    ls->slotEditMemSlot          = "Slot";

    ls->confDiscardTitle         = "blueMSX - Konfigurering";
    ls->confExitSaveTitle        = "blueMSX - Avsluta Konfigureringsverktyg";
    ls->confExitSaveText         = "Vill du stanga konfigureringsverktyget utan att spara dina ndringar?";

    ls->confSaveAsTitle          = "blueMSX - Spara Maskinkonfigurering Som...";
    ls->confSaveAsMachineName    = "Maskinnamn:";

    ls->confEditMemInternalRoms  = "blueMSX - Interna Rom Filer";


    ls->propSndMoonsound         = " Moonsound";

    ls->propFileTypesGB          = "Filtyper ";
    ls->propFileTypes            = " Registrera filtyper med blueMSX (.rom, .dsk, .cas, .sta)";
    ls->propDisableWinKeys       = " Avaktivera WIndows menyer nr emulatorn kr";
    ls->propWindowsEnvGB         = "Windows Milj ";
    ls->enumVideoDrvDirectDrawHW = "DirectDraw HW accel.";
    ls->enumVideoDrvDirectDrawHWSys = "DirectDraw mix."; 
    ls->propClearHistory         = "Vill du verkligen radera filhistorien ?";

    ls->propMonHorizStretch      = " Korrekt horizontell vidd";
    ls->propMonVertStretch       = " Vertikal stretch";
    ls->propEmuFrontSwitchGB     = "Panasonic Switches ";
    ls->propEmuFrontSwitch       = " Front Switch (MSX2+)";
    ls->propEmuAudioSwitch       = " MSX-AUDIO cartridge switch";


};

#endif

