/*****************************************************************************
** File:
**      Win32Sound.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Sound base methods
**
******************************************************************************
*/
#ifndef WIN32_SOUND_H
#define WIN32_SOUND_H

#include <windows.h>
#include "audioMixer.h"

typedef enum {
    SOUND_DRV_NONE,
    SOUND_DRV_WMM,
    SOUND_DRV_DIRECTX
} SoundDriver;

void soundCreate(HWND hwnd, SoundDriver driver, Mixer* mixer, UInt32 sampleRate, UInt32 bufferSize, Int16 channels);
void soundDestroy(void);
void soundResume(void); 
void soundSuspend(void);

#endif
