/*****************************************************************************
** File:
**      romMapper.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Determines the type of a rom image.
**
******************************************************************************
*/
#ifndef ROM_MAPPER_H
#define ROM_MAPPER_H

typedef enum {
    ROM_UNKNOWN     = 0,
    ROM_STANDARD    = 1,
    ROM_MSXDOS2     = 2,
    ROM_KONAMI5     = 3,
    ROM_KONAMI4     = 4,
    ROM_ASCII8      = 5,
    ROM_ASCII16     = 6,
    ROM_GAMEMASTER2 = 7,
    ROM_ASCII8SRAM  = 8,
    ROM_ASCII16SRAM = 9,
    ROM_RTYPE       = 10,
    ROM_CROSSBLAIM  = 11,
    ROM_HARRYFOX    = 12,
    ROM_KOREAN80    = 13,
    ROM_KOREAN126   = 14,
    ROM_SCCPLUS     = 15,
    ROM_FMPAC       = 16,
    ROM_KONAMI4NF   = 17,
    ROM_ASCII16NF   = 18,

    // Not used yet
    ROM_LODERUNNER  = 19,
    ROM_KONAMISYNTH = 20,
    ROM_DISKROM     = 21,
    ROM_KONAMIMJ2   = 22,
    ROM_ANY_MEGAROM = 23
} RomType;

extern RomType getRomType(const void* buffer, int size);

#endif /*ROM_MAPPER_H*/

