/*****************************************************************************
** File:
**      audioMixer.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Mixer implementation that allows sound chip emulation instances to 
**      share one output channel.
**
******************************************************************************
*/
#ifndef AUDIO_MIXER_H
#define AUDIO_MIXER_H

#include "msxTypes.h"

/* Type definitions */
typedef struct Mixer Mixer;

typedef enum { 
    MIXER_CHANNEL_PSG = 0,
    MIXER_CHANNEL_SCC,
    MIXER_CHANNEL_MSX_MUSIC,
    MIXER_CHANNEL_MSX_AUDIO,
    MIXER_CHANNEL_KEYBOARD,
    MIXER_CHANNEL_CASSETTE,
    MIXER_CHANNEL_COUNT
} MixerChannelType;

typedef Int16* (*MixerUpdateCallback)(void*, UInt32);
typedef Int32 (*MixerWriteCallback)(void*, Int16*, UInt32);

/* Constructor and destructor */
Mixer* mixerCreate();
void mixerDestroy(Mixer* mixer);

void mixerSetMasterVolume(Mixer* mixer, Int32 volume);
void mixerSetStereo(Mixer* mixer, Int32 stereo);

void mixerSetChannelVolume(Mixer* mixer, Int32 channelNumber, Int32 volume);
void mixerSetChannelPan(Mixer* mixer, Int32 channelNumber, Int32 pan);
void mixerEnableChannel(Mixer* mixer, Int32 channelNumber, Int32 enable);

/* Write callback registration for audio drivers */
void mixerSetWriteCallback(Mixer* mixer, MixerWriteCallback callback, void*);

/* File logging methods */
int  mixerStartLog(Mixer* mixer, char* fileName);
void mixerStopLog(Mixer* mixer);

/* Internal interface methods */
void mixerReset(Mixer* mixer, UInt32 cpuClock);
void mixerSync(Mixer* mixer, UInt32 cpuClock);
void mixerRegisterChannel(Mixer* mixer, Int32 channelNumber, MixerUpdateCallback callback, void*param);
void mixerUnregisterChannel(Mixer* mixer, Int32 channelNumber);
Int32 mixerGetSize();

#endif

