/*****************************************************************************
** File:        Win32Help.c
**
** Author:      Daniel Vik
**
** Description: Methods to show help dialogs.
**
** License:     Freeware. Anyone may distribute, use and modify the file 
**              without notifying the author. Even though it is not a 
**              requirement, the autor will be happy if you mention his 
**              name when using the file as is or in modified form.
**
******************************************************************************
*/
#include "Win32Help.h"
#include "Language.h"
#include "build_number.h"
#include "Resource.h"
#include <stdio.h>
 
#define BLUE_MSX_VERSION "1.2.0"

static BOOL CALLBACK aboutDlgProc(HWND hDlg, UINT iMsg, WPARAM wParam, LPARAM lParam) 
{
    switch (iMsg) {
    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK) {
            EndDialog(hDlg, TRUE);
            return TRUE;
        }
        break;

    case WM_CLOSE:
        EndDialog(hDlg, TRUE);
        return TRUE;

    case WM_INITDIALOG:
        {
            _TCHAR aboutText[1024];
                _stprintf(aboutText, "%s\r\n\r\n"
                                     "%s%\t%s\r\n"
                                     "%s%\t%d\r\n"
                                     "%s%\t%s\r\n\r\n"
                                     "%s\r\n\r\n\r\n"
                                     "%s",
                          langDlgAboutAbout(),
                          langDlgAboutVersion(),
                          BLUE_MSX_VERSION,
                          langDlgAboutBuildNumber(),
                          BUILD_NUMBER,
                          langDlgAboutBuildDate(),
                          BUILD_DATE,
                          langDlgAboutDevel(),
                          langDlgAboutInfo());

            SetWindowText(hDlg, langDlgAboutTitle());
            SetWindowText(GetDlgItem(hDlg, IDOK), langDlgOK());

            SendMessage(GetDlgItem(hDlg, IDC_ABOUTTEXT), WM_SETTEXT, 0, (LPARAM)aboutText);
        }
        return FALSE;
    }

    return FALSE;
}

void helpShowAbout(HWND hwnd) {
    DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_ABOUT), hwnd, aboutDlgProc);
}

