
#include "GRAM.h"

const UINT16 GRAM::locations[16] = {
    0x3800, 0x3A00, 0x3C00, 0x3E00, //writeable and readable
    0x7800, 0x7A00, 0x7C00, 0x7E00, //write-only
    0xB800, 0xBA00, 0xBC00, 0xBE00, //write-only
    0xF800, 0xFA00, 0xFC00, 0xFE00, //write-only
};

GRAM::GRAM() {}

void GRAM::reset() {
	UINT16 i;
    visible = TRUE;
    dirtyRAM = TRUE;
    for (i = 0; i < GRAM_SIZE; i++)
        image[i] = 0;

    for (i = 0; i < 0x40; i++)
        dirtyCards[i] = TRUE;
}

UINT16 GRAM::getSize() {
    return GRAM_SIZE;
}

UINT16 GRAM::getNumLocations() {
    return 16;
}

UINT16 GRAM::getLocation(UINT16 i) {
    return locations[i];
}

BOOL GRAM::isLocationReadable(UINT16 i) {
    //only the first four locations respond to reads
    return (i < 4);
}

BOOL GRAM::isLocationWriteable(UINT16 i) {
    //all locations respond to writes
    return TRUE;
}

UINT16 GRAM::peek(UINT16 location) {
    return (visible ? image[location & 0x01FF] : location);
}

void GRAM::poke(UINT16 location, UINT16 value) {
    if (!visible)
        return;

    location &= 0x01FF;
    value &= 0xFF;

    if (image[location] == value)
        return;

    image[location] = value;
    dirtyCards[location>>3] = TRUE;
    dirtyRAM = TRUE;
}

void GRAM::markClean() {
    if (!dirtyRAM)
        return;

    for (UINT16 i = 0; i < 0x40; i++)
        dirtyCards[i] = FALSE;
    dirtyRAM = FALSE;
}

BOOL GRAM::isDirty() {
    return dirtyRAM;
}

BOOL GRAM::isCardDirty(UINT16 cardLocation) {
    return dirtyCards[cardLocation>>3];
}

