
#ifndef BANKSWITCHEDROM_H
#define BANKSWITCHEDROM_H

#include "../../core/osd/types.h"
#include "../../core/Memory.h"

class BankSwitchedROM : public Memory16Bit
{

    public:
        BankSwitchedROM();
        BankSwitchedROM(UINT16 size, UINT16 page, UINT16 location);
        ~BankSwitchedROM();
        void init(UINT16 size, UINT16 page, UINT16 location);
        void reset();
        void loadImage(UINT16* image);
        UINT16 getSize();
        UINT16 getNumLocations();
        UINT16 getLocation(UINT16 i);
        BOOL isLocationReadable(UINT16 i);
        BOOL isLocationWriteable(UINT16 i);
        void poke(UINT16 location, UINT16 value);
        UINT16 peek(UINT16 location);

    private:
        UINT16  currentPage;
        UINT16* image;
        UINT16  size;
        UINT16  imagePage;
        UINT16  location;
        UINT16  pageChangeValue;

};

#endif

