
#ifndef CP1610_H
#define CP1610_H

#include "../core/MemoryBus.h"
#include "../core/Processor.h"
#include "../core/SignalLine.h"

class CP1610 : public Processor
{

    public:
        CP1610();
        void init(MemoryBus16Bit* m, SignalLine* intrmLine,
                SignalLine* busRqLine, SignalLine* busAkLine,
                UINT16 resetAddress, UINT16 interruptAddress);
        INT32 getClockSpeed();
        void reset();
        INT32 tick();

        //16-bit register debugging info
        INT32 getNum16BitRegisters();
        const CHAR* get16BitRegisterName(INT32 regNum);
        UINT16 get16BitRegisterValue(INT32 regNum);

        //status bit debugging info
        INT32 getNumStatusBits();
        CHAR getStatusBitLetter(INT32 regNum);
        BOOL isStatusBitOn(INT32 regNum);

        //text output
        void describeNextOperation(CHAR* descriptor);
        void describeNextOpcode(CHAR* descriptor);


    private:
        void setIndirect(UINT16 register, UINT16 value);
        UINT16 getIndirect(UINT16 register);
        void HLT();
        void SDBD();
        void EIS();
        void DIS();
        void TCI();
        void CLRC();
        void SETC();
        void J(UINT16 target);
        void JSR(UINT16 register, UINT16 target);
        void JE(UINT16 target);
        void JSRE(UINT16 register, UINT16 target);
        void JD(UINT16 target);
        void JSRD(UINT16 register, UINT16 target);
        void INCR(UINT16 register);
        void DECR(UINT16 register);
        void COMR(UINT16 register);
        void NEGR(UINT16 register);
        void ADCR(UINT16 register);
        void RSWD(UINT16 register);
        void GSWD(UINT16 register);
        void NOP(UINT16 twoOption);
        void SIN(UINT16 twoOption);
        void SWAP_1(UINT16 register);
        void SWAP_2(UINT16 register);
        void SLL_1(UINT16 register);
        void SLL_2(UINT16 register);
        void RLC_1(UINT16 register);
        void RLC_2(UINT16 register);
        void SLLC_1(UINT16 register);
        void SLLC_2(UINT16 register);
        void SLR_1(UINT16 register);
        void SLR_2(UINT16 register);
        void SAR_1(UINT16 register);
        void SAR_2(UINT16 register);
        void RRC_1(UINT16 register);
        void RRC_2(UINT16 register);
        void SARC_1(UINT16 register);
        void SARC_2(UINT16 register);
        void MOVR(UINT16 sourceReg, UINT16 destReg);
        void ADDR(UINT16 sourceReg, UINT16 destReg);
        void SUBR(UINT16 sourceReg, UINT16 destReg);
        void CMPR(UINT16 sourceReg, UINT16 destReg);
        void ANDR(UINT16 sourceReg, UINT16 destReg);
        void XORR(UINT16 sourceReg, UINT16 destReg);
        void BEXT(UINT16 condition, INT16 displacement);
        void B(INT16 displacement);
        void NOPP(INT16 displacement);
        void BC(INT16 displacement);
        void BNC(INT16 displacement);
        void BOV(INT16 displacement);
        void BNOV(INT16 displacement);
        void BPL(INT16 displacement);
        void BMI(INT16 displacement);
        void BEQ(INT16 displacement);
        void BNEQ(INT16 displacement);
        void BLT(INT16 displacement);
        void BGE(INT16 displacement);
        void BLE(INT16 displacement);
        void BGT(INT16 displacement);
        void BUSC(INT16 displacement);
        void BESC(INT16 displacement);
        void MVO(UINT16 register, UINT16 address);
        void MVO_ind(UINT16 registerWithAddress, UINT16 registerToMove);
        void MVI(UINT16 address, UINT16 register);
        void MVI_ind(UINT16 registerWithAddress, UINT16 registerToReceive);
        void ADD(UINT16 address, UINT16 register);
        void ADD_ind(UINT16 registerWithAddress, UINT16 registerToReceive);
        void SUB(UINT16 address, UINT16 register);
        void SUB_ind(UINT16 registerWithAddress, UINT16 registerToReceive);
        void CMP(UINT16 address, UINT16 register);
        void CMP_ind(UINT16 registerWithAddress, UINT16 registerToReceive);
        void AND(UINT16 address, UINT16 register);
        void AND_ind(UINT16 registerWithAddress, UINT16 registerToReceive);
        void XOR(UINT16 address, UINT16 register);
        void XOR_ind(UINT16 registerWithAddress, UINT16 registerToReceive);
        void decode(UINT16 op);

        //the mory bus
        MemoryBus16Bit* memoryBus;

        //signal lines
        SignalLine* intrmLine;
        SignalLine* busRqLine;
        SignalLine* busAkLine;
    
        //interrupt address
        UINT16 interruptAddress;

        //reset address
        UINT16 resetAddress;

        //the eight registers available in the CP1610
        UINT16 r[8];

        //the six flags available in the CP1610
        BOOL S, Z, O, C, I, D;

        //indicates whether the last executed instruction is interruptible
        BOOL interruptible;

        //cycles used during each op
        INT32 usedCycles;

        //the four external lines
        INT8 ext;

};

#endif
