/*
	WinSTon

	PSG Tab Control
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\debugger.h"
#include "..\includes\debuggertab.h"
#include "..\includes\decode.h"
#include "..\includes\dialog.h"
#include "..\includes\psg.h"
#include "..\includes\stmemory.h"

#ifdef USE_DEBUGGER

//-----------------------------------------------------------------------
/*
	Init PSG Tab Control
*/
void Debugger_TabPSG_Init(HWND hWnd)
{

}

//-----------------------------------------------------------------------
/*
	Show PSG Tab Control
*/
void Debugger_TabPSG_ShowPage(HWND hWnd,BOOL bShow)
{
	// NOTE : Control IDs must be consecutive in resource editor! Ie hand-edited
	Dialog_ShowItemRange(hWnd,IDC_TABPSG_TEXT_AFINE,IDC_TABPSG_EDIT_REGSELECT,bShow ? SW_SHOW:SW_HIDE);
}

//-----------------------------------------------------------------------
/*
	Update PSG Tab Control
*/
void Debugger_TabPSG_UpdateDisplay(HWND hWnd)
{
	char szString[256];

	// Show 16 PSG registers
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_A_FINE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_A_FINE,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_A_COARSE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_A_COARSE,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_B_FINE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_B_FINE,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_B_COARSE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_B_COARSE,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_C_FINE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_C_FINE,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_C_COARSE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_C_COARSE,szString);

	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_NOISE_GENERATOR]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_NOISE,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_MIXER_CONTROL]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_MIXER,szString);

	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_A_AMP]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_A_AMP,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_B_AMP]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_B_AMP,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_CHANNEL_C_AMP]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_C_AMP,szString);

	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_ENV_FINE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_ENV_FINE,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_ENV_COARSE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_ENV_COARSE,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_ENV_SHAPE]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_ENV_SHAPE,szString);

	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_IO_PORTA]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_IO_PORTA,szString);
	sprintf(szString,"$%2.2X",PSGRegisters[PSG_REG_IO_PORTB]);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_IO_PORTB,szString);
	
	// And select register
	sprintf(szString,"$%2.2X",PSGRegisterSelect);
	Dialog_SetText(hWnd,IDC_TABPSG_EDIT_REGSELECT,szString);
}

#endif	//USE_DEBUGGER
