/*
	WinSTon

	History Tab Control
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\debugger.h"
#include "..\includes\debuggertab.h"
#include "..\includes\decode.h"
#include "..\includes\dialog.h"
#include "..\includes\mfp.h"
#include "..\includes\stmemory.h"

#ifdef USE_DEBUGGER

//-----------------------------------------------------------------------
/*
	Init History Tab Control
*/
void Debugger_TabHistory_Init(HWND hWnd)
{
	HWND hItem;

	// Set to select full-row
	hItem = GetDlgItem(DebughWnd,IDC_TABHISTORY_LISTVIEW);
	ListView_SetExtendedListViewStyle(hItem,LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);

	// Add Columns
	Dialog_AddListViewColumn(DebughWnd,IDC_TABHISTORY_LISTVIEW,0,"Address",100);
	Dialog_AddListViewColumn(DebughWnd,IDC_TABHISTORY_LISTVIEW,1,"Instruction",280);
	Dialog_AddListViewColumn(DebughWnd,IDC_TABHISTORY_LISTVIEW,2,"Registers",150);
}

//-----------------------------------------------------------------------
/*
	Show History Tab Control
*/
void Debugger_TabHistory_ShowPage(HWND hWnd,BOOL bShow)
{
	// NOTE : Control IDs must be consecutive in resource editor! Ie hand-edited
	Dialog_ShowItemRange(hWnd,IDC_TABHISTORY_LISTVIEW,IDC_TABHISTORY_LISTVIEW,bShow ? SW_SHOW:SW_HIDE);	
}

//-----------------------------------------------------------------------
/*
	Update History Tab Control
*/
void Debugger_TabHistory_UpdateDisplay(HWND hWnd)
{
}

#endif	//USE_DEBUGGER
