/*
	WinSTon

	Configure Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\dialog.h"
#include "..\includes\daudio.h"
#include "..\includes\dsurface.h"
#include "..\includes\sound.h"

HWND ConfigurehDlg=NULL;

//-----------------------------------------------------------------------
/*
	Set defaults for Configure
*/
void Dialog_Configure_SetDefaults(void)
{
	// Set defaults for Configure
	ConfigureParams.Configure.nMinMaxSpeed = ConfigureParams.Configure.nPrevMinMaxSpeed = MINMAXSPEED_MIN;
}

//-----------------------------------------------------------------------
/*
	Store/Clear hDlg handle so can change options on this page while viewing another
*/
void Dialog_Configure_ClearHandle(void)
{
	ConfigurehDlg = NULL;
}

//-----------------------------------------------------------------------
/*
	Get hDlg handle
*/
HWND Dialog_Configure_GetHandle(void)
{
	return(ConfigurehDlg);
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_Configure_EnableItems(HWND hDlg)
{	
	// Direct X working?
	if (!bDirectDrawWorking)
		Dialog_EnableItem(hDlg,IDC_RADIO_CONFIG_FULLSCREEN,FALSE);

	// Is sound working?
	if (!bDirectSoundWorking)
		Dialog_EnableItem(hDlg,IDC_RADIO_CONFIG_ENABLESOUND,FALSE);
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_Configure_WritePopulate(HWND hDlg)
{
	// Set global dialog handle
	ConfigurehDlg = hDlg;

	// Set items
	Dialog_SetTrackBar(hDlg,IDC_SLIDER1, MINMAXSPEED_MIN, MINMAXSPEED_MAX, DialogParams.Configure.nMinMaxSpeed);
	Dialog_SetButton(hDlg,IDC_RADIO_CONFIG_ENABLESOUND,DialogParams.Sound.bEnableSound);
	Dialog_SetButton(hDlg,IDC_RADIO_CONFIG_FULLSCREEN,ConfigureParams.Screen.bFullScreen);

	Dialog_Configure_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_Configure_ReadPopulate(HWND hDlg)
{
	// Read items
	DialogParams.Configure.nMinMaxSpeed = Dialog_GetTrackBar(hDlg,IDC_SLIDER1);
	DialogParams.Configure.nPrevMinMaxSpeed = DialogParams.Configure.nMinMaxSpeed;
	DialogParams.Sound.bEnableSound = Dialog_ReadButton(hDlg,IDC_RADIO_CONFIG_ENABLESOUND);
	DialogParams.Screen.bFullScreen = Dialog_ReadButton(hDlg,IDC_RADIO_CONFIG_FULLSCREEN);
}

//-----------------------------------------------------------------------
/*
	Quick Start guide
*/
void Dialog_Configure_QuickStart(HWND hDlg)
{
	WinSTon_GoWeb("help\\gettingstarted\\guide.html",FALSE);
}

//-----------------------------------------------------------------------
/*
	Trouble Shooting guide
*/
void Dialog_Configure_TroubleShooting(HWND hDlg)
{
	WinSTon_GoWeb("help\\troubleshooting\\trouble.html",FALSE);
}

//-----------------------------------------------------------------------
/*
	WinSTon credits
*/
void Dialog_Configure_Credits(HWND hDlg)
{
	WinSTon_GoWeb("help\\credits\\credits.html",FALSE);
}

//-----------------------------------------------------------------------
/*
	Configure Property page handler
*/
BOOL FAR PASCAL Dialog_Configure_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	switch(Message) {
		case WM_INITDIALOG:
			Dialog_Configure_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_CONFIGURE;
			return(TRUE);

		case WM_NOTIFY:
			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_Configure_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\configure.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\configure.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_RADIO_CONFIG_ENABLESOUND:
					// Update as used on Sound+Configure dialog
					DialogParams.Sound.bEnableSound = Dialog_ReadButton(hDlg,IDC_RADIO_CONFIG_ENABLESOUND);
					Dialog_SetButton(Dialog_Sound_GetHandle(),IDC_RADIO_ENABLESOUND,DialogParams.Sound.bEnableSound);
					Dialog_Sound_EnableItems(Dialog_Sound_GetHandle());
					return(TRUE);
				case IDC_RADIO_CONFIG_FULLSCREEN:
					DialogParams.Screen.bFullScreen = Dialog_ReadButton(hDlg,IDC_RADIO_CONFIG_FULLSCREEN);
					Dialog_SetButton(Dialog_Screen_GetHandle(),IDC_RADIO_FULLSCREEN,DialogParams.Screen.bFullScreen);
					return(TRUE);
				case IDC_BUTTON_QUICKSTART:
					Dialog_Configure_QuickStart(hDlg);
					return(TRUE);
				case IDC_BUTTON_TROUBLESHOOTING:
					Dialog_Configure_TroubleShooting(hDlg);
					return(TRUE);
				case IDC_BUTTON_CREDITS:
					Dialog_Configure_Credits(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
