/*
** z26 -- an Atari 2600 emulator
*/

/*
** z26 is Copyright 1997-2003 by John Saeger and is a derived work with many
** contributors.  z26 is released subject to the terms and conditions of the 
** GNU General Public License Version 2 (GPL).	z26 comes with no warranty.
** Please see COPYING.TXT for details.
*/


#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "unzip.h"

#include "globals.c"
#include "ct.c"
#include "carts.c"
#include "cli.c"
#include "trace.c"
#include "pcx.c"
#include "kidvid.c"
#include "palette.c"

#include "sdlsrv.c"
#include "text.c"
#include "states.c"

char *default_arg[] = { "z26", "-r100000", "-f5000", "demonatk.bin" };

extern void emulator();

int z26main( char *filename, int p1diff, int p2diff, int colorbw )
{

		writexbox("1\r\n") ;
        //def_LoadDefaults();

	VideoMode = 0xff;
	InWindow = 0;
	CFirst = 0xffff;
	quiet = 0;
	IOPortA = 0xff;
	IOPortB = 0x0b;
	DoChecksum = 0;
	NoRetrace = -1;
	OriginalNoRetrace = NoRetrace;
	FrameExit = 0;
	//dsp = 0;
	//Joystick = 0xff;
	//PaletteNumber = 0xff;
	UserPaletteNumber = 0;
	PaddleGame = 0;
	KeyBase = 0xff;
	TraceCount = 0;
	TraceEnabled = 0;
	OldTraceCount = 0;
	KeyPad = 0;
	Driving = 0;
	BSType = 0;
	MouseBase = 0xff;
	//SimColourLoss = 0;
	Lightgun = 0;
	LGadjust = 5;
	ShowLineCount = 0;
	Mindlink = 0;
	AllowAll4 = 0;
	Effect = 0;
	//Phosphor = 0;
	KidVid = 0;
	KidVidTape = 0;
    MaxLines = 0xffff ;  /* unreasonable default screen height - gets fixed by auto positioning */
    //DisableCompareCopy = 0;
    DoInterlace = 0;
	MouseRude = 1;

	if ( !p1diff )
		IOPortB &= 0xBF ;
	else
		IOPortB |= 0x40 ;

	if ( !p2diff )
		IOPortB &= 0x7f ;
	else
		IOPortB |= 0x80 ;

	if ( colorbw )
		IOPortB |= 0x08 ;
	else
		IOPortB &= 0xF7 ;
	

		writexbox("1\r\n") ;
        ClearScreenBuffers();

		writexbox("1\r\n") ;
        ScreenBuffer = RealScreenBuffer1;
        ScreenBufferPrev = RealScreenBuffer2;
		writexbox("1\r\n") ;

		/*
	if (argc == 1)
	{
//		cli_CommandLine(4, default_arg);
		srv_print("version 2.07");
		exit(1);
	}
	else
	{
	   	cli_CommandLine(argc, argv);
	}
*/

	srv_done = 0;
	if ( ! cli_CommandLine( filename) )
	{
		
		writexbox("1\r\n") ;
		writexbox("about to to emu\r\n") ;

		//VideoMode = 1 ;
		//CFirst = 1 ;

		emulator();		   /* call emulator -- (main.asm) */

		switch(MessageCode) {
			case 1:
				sprintf(msg, "Unable to find load %02x\n", SC_ControlByte);
				srv_print(msg);
				break;
			case 2:
				sprintf(msg, "Starpath call @ %04x\n", cpu_pc);
				srv_print(msg);
				break;
			case 3:
				sprintf(msg, "JAM instruction %02x @ %04x\n", cpu_a, cpu_pc);
				srv_print(msg);
				break;
       			}
	}

	return 0 ;
}                                                         

void peekbank() ;
void pokebank() ;

unsigned char donereg[] = {
0x00,
0x01,
0x02,
0x05,
0x08,
0x0A,
0x0B,
0x0D,
0x0E,
0x11,
0x12,
0x15,
0x16,
0x17,
0x19,
0x1C,
0x1E,
0x20,
0x23,
0x26,
0x28,
0x2B,
0x2E,
0x2F,
0x32,
0x34,
0x35,
0x37,
0x39,
0x3C,
0x3E,
0x40,
0x42,
0x45,
0x47,
0x4A,
0x4D,
0x50,
0x51,
0x54,
0x55,
0x56,
0x58,
0x5A,
0x5D,
0x5E,
0x5F,
0x62,
0x65,
0x66,
0x69,
0x6B,
0x6C,
0x6E,
0x70,
0x71,
0x73,
0x75,
0x76,
0x79,
0x7B,
0x7C,
0x7E,
0x80,
0x83,
0x86,
0x88,
0x89,
0x8A,
0x8D,
0x8E,
0x8F,
0x91,
0x94,
0x95,
0x97,
0x98,
0x9A,
0x9B,
0x9E,
0x9F,
0xA1,
0xA3,
0xA4,
0xA7,
0xA8,
0xAA,
0xAD,
0xB0,
0xB1,
0xB2,
0xB5,
0xB7,
0xB8,
0xB9,
0xBB,
0xBC,
0xBD,
0xBE,
0xBF,
0xC0,
0xC1,
0xC3,
0xC4,
0xC5,
0xC6,
0xC9,
0xCB,
0xCD,
0xCF,
0xD0,
0xD2,
0xD5,
0xD7,
0xD9,
0xDC,
0xDD,
0xE0,
0xE1,
0xE4,
0xE7,
0xE8,
0xEB,
0xEC,
0xEE,
0xF0,
0xF1,
0xF3,
0xF6,
0xF9,
0xFB,
0xFD
} ;

void fry()
{
	int ZPmem = 0 ;
	int val = 0 ;
	int d = 0 ;
	int found = 0 ;
	FILE *outfile ;

	outfile = fopen( "d:\\regs.txt", "wb" ) ;

  //for (ZPmem=0; ZPmem<0x100; ZPmem += rand() % 4)
  for (ZPmem=0x18; ZPmem<0x100; ZPmem++)
  {
	  found = 0 ;

	  for ( d = 0 ; d < sizeof(donereg) ; d++ )
	  {
		  if ( ZPmem == donereg[d] )
		  {
			  found = 1 ;
			  break ;
		  }
	  }

	  //if ( found)
		  //continue ;

	  if ( ZPmem > 0xFF )
	  {
		  ZPmem = 0xFF ;
	  }

	  POKEADDR = ZPmem ;
	  //peekbank() ;

      POKEBYTE &= (unsigned char)rand() % 256 ;

	  for ( val = 0 ; val < 256 ; val++ )
	  {
		  //fprintf( outfile, "%02.2X %02.2X\r\n", ZPmem, val ) ;
		  //fflush( outfile ) ;
		  POKEBYTE = val ;
		  pokebank() ;
	  }

	  pokebank() ;

    //poke(ZPmem, mySystem->peek(ZPmem) & (uInt8)rand() % 256);
  }
}
