#include "config.h"
#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "memory.h"
#include "inputdevice.h"
#include "xwin.h"
#include "custom.h"
#include "uae.h"
#include "newcpu.h"
#include "keyboard_api.h"
#include "..\..\propinclude.h"
#include "picasso96_win.h"
#include "filesys.h"

extern Properties* pProperties ;
extern int xbox_genlock ;

struct PicassoResolution  gmodes[3] ;

struct PicassoResolution *DisplayModes;

extern char g_cdfilename[MAX_PATH] ;

uae_u16 picasso96_pixel_format = RGBFF_CHUNKY;
uae_u32 default_freq = 50;
int screen_is_picasso = 0;

int p96_double_buffer_first, p96_double_buffer_last, p96_double_buffer_needs_flushing = 0;

int log_scsi; 
int have_done_picasso=0;
int os_winnt=1, os_winnt_admin=1;
uae_u16 serper, serdat, serdatr;
char *start_path = "D:\\" ;
int pause_emulation=0;
static int data_in_serdat; /* new data written to SERDAT */
static int data_in_serdatr; /* new data received */
static int data_in_sershift; /* data transferred from SERDAT to shift register */
static uae_u16 serdatshift; /* serial shift register */
static int ninebit;
static int ovrun;
static int serial_period_hsyncs, serial_period_hsync_counter;
static int capslockstate=0;
static char scrlinebuf[4096];	/* this is too large, but let's rather play on the safe side here */

extern int joybutton[MAX_INPUT_DEVICES];
extern int mouse_delta[MAX_INPUT_DEVICES][MAX_INPUT_DEVICE_EVENTS];
extern int mouse_deltanoreset[MAX_INPUT_DEVICES][MAX_INPUT_DEVICE_EVENTS];
extern unsigned int joydir[MAX_INPUT_DEVICE_EVENTS];
extern int joydirpot[MAX_INPUT_DEVICE_EVENTS][2];
extern int   m_mouseX, m_mouseY, m_mouseButtons ;
extern int   m_mouseX2, m_mouseY2, m_mouseButtons2 ;
extern int vkey_to_amiga[256] ;

int useqpc = 1 ;

static int allowed_baudrates[] =
    { 0, 110, 300, 600, 1200, 2400, 4800, 9600, 14400,
	19200, 31400, 38400, 57600, 115200, 128000, 256000, -1 };

void gui_hd_led (int led)
{
}

void gui_cd_led (int led)
{
}

static int init_kb (void)
{
	return 1 ;
}
static int init_mouse (void)
{
	//mousehack_set( mousehack_follow ) ;
	return 1 ;
}

void gui_message (const char *format,...)
{
}
static void close_kb (void)
{
}
static void close_mouse (void)
{
}

void sleep_millis_busy (int ms)
{
	int i ;

	i =0 ;
}
void ahi_close_sound (void)
{
}

void target_save_options (FILE *f, struct uae_prefs *p)
{
//    cfgfile_write (f, "win32.middle_mouse=%s\n", p->win32_middle_mouse ? "true" : "false");
}
void target_default_options (struct uae_prefs *p)
{
    //p->win32_middle_mouse = 0;
}
int target_parse_option (struct uae_prefs *p, char *option, char *value)
{
#if 0
    int i, v;
    int result = (cfgfile_yesno (option, value, "middle_mouse", &p->win32_middle_mouse)
	    || cfgfile_yesno (option, value, "logfile", &p->win32_logfile)
	    || cfgfile_yesno  (option, value, "networking", &p->socket_emu)
	    || cfgfile_yesno (option, value, "no_overlay", &p->win32_no_overlay)
	    || cfgfile_yesno (option, value, "aspi", &p->win32_aspi)
	    || cfgfile_yesno  (option, value, "map_drives", &p->win32_automount_drives)
	    || cfgfile_yesno (option, value, "inactive_pause", &p->win32_inactive_pause)
	    || cfgfile_yesno (option, value, "inactive_nosound", &p->win32_inactive_nosound)
	    || cfgfile_yesno (option, value, "iconified_pause", &p->win32_iconified_pause)
	    || cfgfile_yesno (option, value, "iconified_nosound", &p->win32_iconified_nosound)
	    || cfgfile_yesno  (option, value, "ctrl_f11_is_quit", &p->win32_ctrl_F11_is_quit)
	    || cfgfile_intval (option, value, "midi_device", &p->win32_midioutdev, 1)
	    || cfgfile_intval (option, value, "midiout_device", &p->win32_midioutdev, 1)
	    || cfgfile_intval (option, value, "midiin_device", &p->win32_midiindev, 1)
	    || cfgfile_intval (option, value, "soundcard", &p->win32_soundcard, 1)
	    || cfgfile_string (option, value, "serial_port", &p->sername[0], 256)
	    || cfgfile_string (option, value, "parallel_port", &p->prtname[0], 256)
	    || cfgfile_intval  (option, value, "cpu_idle", &p->cpu_idle, 1));

    if (cfgfile_intval (option, value, "active_priority", &v, 1)) {
	p->win32_active_priority = fetchpri (v, 0);
	return 1;
    }
    if (cfgfile_intval (option, value, "activepriority", &v, 1)) {
	p->win32_active_priority = fetchpri (v, 0);
	return 1;
    }
    if (cfgfile_intval (option, value, "inactive_priority", &v, 1)) {
	p->win32_inactive_priority = fetchpri (v, 1);
	return 1;
    }
    if (cfgfile_intval (option, value, "iconified_priority", &v, 1)) {
	p->win32_iconified_priority = fetchpri (v, 2);
	return 1;
    }

    if (p->sername[0] == 'n')
	p->use_serial = 0;
    else
	p->use_serial = 1;

    i = 0;
    while (obsolete[i]) {
	if (!strcasecmp (obsolete[i], option)) {
	    write_log ("obsolete config entry '%s'\n", option);
	    return 1;
	}
	i++;
    }

    return result;
#endif
	return 0 ;
}
void gui_led (int led, int on)
{
}

void D3D_refresh (void)
{
}

void serial_check_irq (void)
{
    if (data_in_serdatr)
        INTREQ_0 (0x8000 | 0x0800);
}
static void checkreceive (int mode)
{
#ifdef SERIAL_PORT
    static uae_u32 lastchartime;
    static int ninebitdata;
    struct timeval tv;
    int recdata;

    if (!readseravail())
	return;

    if (data_in_serdatr) {
        /* probably not needed but there may be programs that expect OVRUNs.. */
	gettimeofday (&tv, NULL);
	if (tv.tv_sec > lastchartime) {
	    ovrun = 1;
	    INTREQ (0x8000 | 0x0800);
	    while (readser (&recdata));
	    write_log ("SERIAL: overrun\n");
	}
	return;
    }

    if (ninebit) {
	for (;;) {
	    if (!readser (&recdata))
		return;
	    if (ninebitdata) {
		serdatr = (ninebitdata & 1) << 8;
		serdatr |= recdata;
		serdatr |= 0x200;
		ninebitdata = 0;
		break;
	    } else {
		ninebitdata = recdata;
		if ((ninebitdata & ~1) != 0xa8) {
		    write_log ("SERIAL: 9-bit serial emulation sync lost, %02.2X != %02.2X\n", ninebitdata & ~1, 0xa8);
		    ninebitdata = 0;
		    return;
		}
		continue;
	    }
	}
    } else {
        if (!readser (&recdata))
	    return;
	serdatr = recdata;
        serdatr |= 0x100;
    }
    gettimeofday (&tv, NULL);
    lastchartime = tv.tv_sec + 5;
    data_in_serdatr = 1;
    serial_check_irq ();
#if SERIALDEBUG > 2
    write_log ("SERIAL: received %02.2X (%c)\n", serdatr & 0xff, dochar (serdatr));
#endif
#endif
}

static void checksend (int mode)
{
    int bufstate = 0;

#ifdef SERIAL_PORT
    bufstate = checkserwrite ();
#endif
    if (!data_in_serdat && !data_in_sershift)
	return;

    if (data_in_sershift && mode == 0 && bufstate)
	data_in_sershift = 0;

    if (data_in_serdat && !data_in_sershift) {
	data_in_sershift = 1;
	serdatshift = serdat;
#ifdef SERIAL_PORT
	if (ninebit)
	    writeser (((serdatshift >> 8) & 1) | 0xa8);
	writeser (serdatshift);
#endif
	data_in_serdat = 0;
        INTREQ (0x8000 | 0x0001);
#if SERIALDEBUG > 2
	write_log ("SERIAL: send %04.4X (%c)\n", serdatshift, dochar (serdatshift));
#endif
    }
}    
int getcapslockstate (void)
{
    return capslockstate;
}
void setcapslockstate (int state)
{
    capslockstate = state;
}

void serial_hsynchandler (void)
{
#ifdef AHI
    extern void hsyncstuff(void);
    hsyncstuff();
#endif
    if (serial_period_hsyncs == 0)
	return;
    serial_period_hsync_counter++;
    if (serial_period_hsyncs == 1 || (serial_period_hsync_counter % (serial_period_hsyncs - 1)) == 0)
	checkreceive (0);
    if ((serial_period_hsync_counter % serial_period_hsyncs) == 0)
	checksend (0);
}

unsigned int xbox_get_controller_value( int port ) ;

void handle_events (void)
{
	int i ;
	int port ;
	unsigned int xjoy1, xjoy2 ;

	if ( xbox_check_events() )
	{
		quit_program = 1 ;
	}

	joydir[0] = joydir[1] = 0 ;
	joybutton[0] = joybutton[1] = 0 ;

	if ( currprefs.jport0 == 2 ) 
	{
		mouse_delta[0][0] += (m_mouseX * currprefs.input_mouse_speed)/100 ;
		mouse_delta[0][1] += (m_mouseY * currprefs.input_mouse_speed)/100 ;
		mouse_deltanoreset[0][0] = 0;
		mouse_deltanoreset[0][1] = 0;
		joybutton[0] |= m_mouseButtons ;
	}
	if ( currprefs.jport1 == 2 ) 
	{
		mouse_delta[1][0] += (m_mouseX2 * currprefs.input_mouse_speed)/100 ;
		mouse_delta[1][1] += (m_mouseY2 * currprefs.input_mouse_speed)/100 ;
		mouse_deltanoreset[1][0] = 0;
		mouse_deltanoreset[1][1] = 0;
		joybutton[1] |= m_mouseButtons2 ;
	}

	for ( i = 0 ; i < 4 ; i++ )
	{
		xjoy1 = xbox_get_controller_value( i ) ;

		if ( ( currprefs.jport0 == 0 ) || ( currprefs.jport0 == 1 ) )
		{
			joydir[0] |= (xjoy1 & 0x0F );
			joybutton[0] |= ( (xjoy1 & 0x3FFF) >> 4 ) ;
		}

		if ( ( currprefs.jport1 == 0 ) || ( currprefs.jport1 == 1 ) )
		{
			joydir[1] |= ((xjoy1 >> 16) & 0x0F );
			joybutton[1] |= ( ((xjoy1 >> 16)&0x3FFFF) >> 4 ) ;
		}


	}

//    handle_input_event (e, state, 1, 0);


//	        scancode = keyhack (scancode, pressed, i);
//    inputdevice_translatekeycode (keyboard, scancode, newstate);

	//joydir[joy] |= DIR_LEFT
//			    joybutton[joy] |= 1 << ie->data;  JOYBUTTON_1. JOYBUTTON_2, JOYBUTTON_3 = mouse left/right/middle
//	        mouse_delta[joy][ie->data] += delta;
//		if (state && (ie->data & DIR_LEFT)) {
//		    mouse_delta[joy][0] = -speed;
		    //mouse_deltanoreset[joy][0] = 1;
		//} else if (state && (ie->data & DIR_RIGHT)) {
		    //mouse_delta[joy][0] = speed;
		    //mouse_deltanoreset[joy][0] = 1;
		//} else
		    //mouse_deltanoreset[joy][0] = 0;
//		joydirpot[joy][ie->data] = state;  0-127 = negative ; 128-255 = positive



}
void gui_fps (int fps, int idle)
{
}
void serial_uartbreak (int v)
{
#ifdef SERIAL_PORT
    serialuartbreak (v);
#endif
}
int needmousehack (void)
{
    return 1;
}

uae_u16 SERDATR (void)
{
    serdatr &= 0x03ff;
    if (!data_in_serdat)
	serdatr |= 0x2000;
    if (!data_in_sershift)
	serdatr |= 0x1000;
    if (data_in_serdatr)
	serdatr |= 0x4000;
    if (ovrun)
	serdatr |= 0x8000;
#if SERIALDEBUG > 2
    write_log( "SERIAL: read 0x%04.4x (%c) %x\n", serdatr, dochar (serdatr), m68k_getpc());
#endif
    ovrun = 0;
    data_in_serdatr = 0;
    return serdatr;
}
void SERPER (uae_u16 w)
{
    int baud = 0, i, per;
    static int warned;

    if (serper == w)  /* don't set baudrate if it's already ok */
	return;
    ninebit = 0;
    serper = w;

    if (w & 0x8000) {
        if (!warned) {
            write_log( "SERIAL: program uses 9bit mode PC=%x\n", m68k_getpc() );
	    warned++;
        }
        ninebit = 1;
    }
    w &= 0x7fff;

    if (w < 13)
	w = 13;

    per = w;
    if (per == 0) per = 1;
    per = 3546895 / (per + 1);
    if (per <= 0) per = 1;
    i = 0;
    while (allowed_baudrates[i] >= 0 && per > allowed_baudrates[i] * 100 / 97)
	i++;
    baud = allowed_baudrates[i];

    serial_period_hsyncs = (((serper & 0x7fff) + 1) * 10) / maxhpos;
    if (serial_period_hsyncs <= 0)
	serial_period_hsyncs = 1;
    serial_period_hsync_counter = 0;

    write_log ("SERIAL: period=%d, baud=%d, hsyncs=%d PC=%x\n", w, baud, serial_period_hsyncs, m68k_getpc());

    if (ninebit)
	baud *= 2;
    if (currprefs.serial_direct) {
	if (baud != 31400 && baud < 115200)
	    baud = 115200;
	serial_period_hsyncs = 1;
    }
#ifdef SERIAL_PORT
    setbaud (baud);
#endif
}
void SERDAT (uae_u16 w)
{
    serdat = w;

    if (!(w & 0x3ff)) {
#if SERIALDEBUG > 1
	write_log ("SERIAL: zero serial word written?! PC=%x\n", m68k_getpc());
#endif
	return;
    }

#if SERIALDEBUG > 1
    if (data_in_serdat) {
	write_log ("SERIAL: program wrote to SERDAT but old byte wasn't fetched yet\n");
    }
#endif
    
    data_in_serdat = 1;
    if (!data_in_sershift)
	checksend (1);

#if SERIALDEBUG > 2
    write_log ("SERIAL: wrote 0x%04x (%c) PC=%x\n", w, dochar (w), m68k_getpc());
#endif

    return;
}
void gui_filename (int num, const char *name)
{
}
void gui_lock (void)
{
}

void gui_unlock (void)
{
}

void xbox_lock( unsigned char **ptr );

int lockscr (void)
{
	xbox_lock( &(gfxvidinfo.bufmem) );

	gfxvidinfo.realbufmem = gfxvidinfo.bufmem ;
	//gfxvidinfo.rowbytes = xbox_get_pitch() ;

	return 1 ;
}

void flush_line( int lineno )
{

}

void flush_block (int a, int b)
{

}
void flush_screen (int a, int b)
{
	if ( gfxvidinfo.realbufmem  )
		xbox_frame( gfxvidinfo.realbufmem ) ;
}
void unlockscr (void)
{
}
int check_prefs_changed_gfx (void)
{
	return 0 ;
}

void flush_clear_screen (void)
{
	int y ;

	if ( gfxvidinfo.bufmem )
	{
		for (y = 0; y < gfxvidinfo.height; y++) {
			memset (gfxvidinfo.bufmem + y * gfxvidinfo.rowbytes, 0, gfxvidinfo.width * gfxvidinfo.pixbytes);
		}
		flush_screen (0, 0);
	}
}

int driveclick_loadresource (struct drvsample *s, int drivetype)
{
	return 1 ;
}
void sleep_millis (int ms)
{
	int i ;

	i = 0 ;
}
void fullscreentoggle (void)
{

}
void input_get_default_mouse (struct uae_input_device *uid)
{
    int i, port;

    for (i = 0; i < 1; i++) {
		//port = i & 1;
		//if (di_mouse[i].wininput)
			port = 0;
        uid[i].eventid[ID_AXIS_OFFSET + 0][0] = port ? INPUTEVENT_MOUSE2_HORIZ : INPUTEVENT_MOUSE1_HORIZ;
		uid[i].eventid[ID_AXIS_OFFSET + 1][0] = port ? INPUTEVENT_MOUSE2_VERT : INPUTEVENT_MOUSE1_VERT;
        uid[i].eventid[ID_AXIS_OFFSET + 2][0] = port ? 0 : INPUTEVENT_MOUSE1_WHEEL;
		uid[i].eventid[ID_BUTTON_OFFSET + 0][0] = port ? INPUTEVENT_JOY2_FIRE_BUTTON : INPUTEVENT_JOY1_FIRE_BUTTON;
		uid[i].eventid[ID_BUTTON_OFFSET + 1][0] = port ? INPUTEVENT_JOY2_2ND_BUTTON : INPUTEVENT_JOY1_2ND_BUTTON;
		uid[i].eventid[ID_BUTTON_OFFSET + 2][0] = port ? INPUTEVENT_JOY2_3RD_BUTTON : INPUTEVENT_JOY1_3RD_BUTTON;
    }

    uid[0].enabled = 1;
}

void input_get_default_joystick (struct uae_input_device *uid)
{
    int i, port;

    for (i = 0; i < 1; i++) {
		port = i & 1;
        uid[i].eventid[ID_AXIS_OFFSET + 0][0] = port ? INPUTEVENT_JOY2_HORIZ : INPUTEVENT_JOY1_HORIZ;
		uid[i].eventid[ID_AXIS_OFFSET + 1][0] = port ? INPUTEVENT_JOY2_VERT : INPUTEVENT_JOY1_VERT;
		uid[i].eventid[ID_BUTTON_OFFSET + 0][0] = port ? INPUTEVENT_JOY2_FIRE_BUTTON : INPUTEVENT_JOY1_FIRE_BUTTON;
		uid[i].eventid[ID_BUTTON_OFFSET + 1][0] = port ? INPUTEVENT_JOY2_2ND_BUTTON : INPUTEVENT_JOY1_2ND_BUTTON;
		uid[i].eventid[ID_BUTTON_OFFSET + 2][0] = port ? INPUTEVENT_JOY2_3RD_BUTTON : INPUTEVENT_JOY1_3RD_BUTTON;
    }
    uid[0].enabled = 1;
}

static int acquire_joystick (int num, int flags)
{
	return 1 ;
}
static void close_joystick (void)
{
}
static int init_joystick (void)
{
	return 1 ;
}
static int acquire_mouse (int num, int flags)
{
	return 1 ;
}
static void unacquire_mouse (int num)
{
}
static void unacquire_joystick (int num)
{
}

static int acquire_kb (int num, int flags)
{
	return 1 ;
}
static void unacquire_kb (int num)
{
}
static int get_mouse_num (void)
{
    return 1;
}
static char *get_mouse_name (int mouse)
{
    return "Mouse" ;
}

static int get_mouse_widget_num (int mouse)
{
    return 4 ;
}

static int get_mouse_widget_first (int mouse, int type)
{
    switch (type)
    {
	case IDEV_WIDGET_BUTTON:
	return 2;
	case IDEV_WIDGET_AXIS:
	return 0;
    }
    return -1;
}

static char *get_joystick_name (int joy)
{
    return "Joystick" ;
}
static int get_joystick_num (void)
{
	return 4 ;
}
static int get_joystick_widget_num (int joy)
{
    return 12 ;
}

static int get_joystick_widget_type (int joy, int num, char *name, uae_u32 *code)
{
	switch ( num )
	{
		case 0 :
		{
			strcpy( name, "Axis X" ) ;
			return IDEV_WIDGET_AXIS ;
			break ;
		}
		case 1 :
		{
			strcpy( name, "Axis Y" ) ;
			return IDEV_WIDGET_AXIS ;
			break ;
		}
		default :
		{
			strcpy( name, "Button" ) ;
			return IDEV_WIDGET_BUTTON ;
			break ;
		}
	}

    return IDEV_WIDGET_NONE;
}

static int get_joystick_widget_first (int joy, int type)
{
    switch (type)
    {
		case IDEV_WIDGET_BUTTON:
			return 2 ;
		case IDEV_WIDGET_AXIS:
			return 0;
    }
    return -1;
}

static int get_mouse_widget_type (int mouse, int num, char *name, uae_u32 *code)
{
	switch ( num )
	{
		case 0 : 
		{
			strcpy( name, "Axis X" ) ;
			return IDEV_WIDGET_AXIS ;
			break ;
		}
		case 1 : 
		{
			strcpy( name, "Axis Y" ) ;
			return IDEV_WIDGET_AXIS ;
			break ;
		}
		case 2 : 
		{
			strcpy( name, "Left Button" ) ;
			return IDEV_WIDGET_BUTTON ;
			break ;
		}
		case 3 : 
		{
			strcpy( name, "Right Button" ) ;
			return IDEV_WIDGET_BUTTON ;
			break ;
		}
	}
    return IDEV_WIDGET_NONE;

}

static int get_kb_num (void)
{
    return 1;
}

static char *get_kb_name (int kb)
{
    return "Keyboard" ;
}

static int get_kb_widget_num (int kb)
{
    return 256 ;
}

static int get_kb_widget_first (int kb, int type)
{
    return 0;
}

static int get_kb_widget_type (int kb, int num, char *name, uae_u32 *code)
{
    return IDEV_WIDGET_KEY;
}
static void read_joystick (void)
{
	//		        setjoybuttonstate (i, k, state);
			    //setjoystickstate (i, k, (data2 >= 20250 && data2 <= 33750) ? -1 : (data2 >= 2250 && data2 <= 15750) ? 1 : 0, 1);
			    //setjoystickstate (i, k + 1, ((data2 >= 29250 && data2 <= 33750) || (data2 >= 0 && data2 <= 6750)) ? -1 : (data2 >= 11250 && data2 <= 24750) ? 1 : 0, 1);
			    //setjoystickstate (i, k, data, 32768);

}
static void read_kb (void)
{
}
static void read_mouse (void)
{
		//int state = (data & 0x80) ? 1 : 0;
	//				setmousestate (i, k, data, 0);
				    //setmousebuttonstate (i, k, state);
//				setmouseactive(0);

}

struct inputdevice_functions inputdevicefunc_keyboard = {
    init_kb, close_kb, acquire_kb, unacquire_kb, read_kb,
    get_kb_num, get_kb_name,
    get_kb_widget_num, get_kb_widget_type,
    get_kb_widget_first
};
struct inputdevice_functions inputdevicefunc_joystick = {
    init_joystick, close_joystick, acquire_joystick, unacquire_joystick,
    read_joystick, get_joystick_num, get_joystick_name,
    get_joystick_widget_num, get_joystick_widget_type,
    get_joystick_widget_first
};
struct inputdevice_functions inputdevicefunc_mouse = {
    init_mouse, close_mouse, acquire_mouse, unacquire_mouse, read_mouse,
    get_mouse_num, get_mouse_name,
    get_mouse_widget_num, get_mouse_widget_type,
    get_mouse_widget_first
};

void gui_exit (void)
{
    //FreeConfigStore ();
#ifdef PARALLEL_PORT
    closeprinter(); // Bernd Roesch
#endif
}
void close_windows (void)
{
	//if ( gfxvidinfo.realbufmem ) 
		//free (gfxvidinfo.realbufmem);

    //gfxvidinfo.realbufmem = 0;
    //gfxvidinfo.bufmem = 0;
}

void graphics_leave (void)
{

    //free (gfxvidinfo.realbufmem);
    //gfxvidinfo.realbufmem = 0;
    //gfxvidinfo.bufmem = 0;

    //close_windows ();
}
int debuggable (void)
{
    return 0;
}
void setup_brkhandler (void)
{
}
void remove_brkhandler (void)
{
}
int xbox_get_pitch() ;

int changegfxfilter()
{
	lockscr() ;
	init_row_map() ;
	xbox_frame( NULL ) ;
	return 0 ;
}

int graphics_init (void)
{
	gfxvidinfo.width = 908;
	//gfxvidinfo.width = 640;
	gfxvidinfo.height = 312; 
	//gfxvidinfo.height = 576; 
	gfxvidinfo.pixbytes = 2; 
	gfxvidinfo.rowbytes = xbox_get_pitch() ;
	//gfxvidinfo.rowbytes = 640*2;

	if ( gfxvidinfo.bufmem == 0 )
	{
		xbox_lock( &(gfxvidinfo.bufmem) ) ;
		//gfxvidinfo.bufmem = (char *)malloc(640*576*2);
	}

	gfxvidinfo.realbufmem = gfxvidinfo.bufmem  ;
	gfxvidinfo.linemem = 0;
	gfxvidinfo.emergmem = scrlinebuf ;
	gfxvidinfo.maxblocklines = 0 ; //10000;
	gfxvidinfo.can_double = 0;
	alloc_colors64k(5,6,5,11,5,0,0,0,0);
	return 1;
}
int gui_update (void)
{
    return 1;
}
void logging_init( void )
{
}
void machdep_init (void)
{
    picasso_requested_on = 0;
    picasso_on = 0;
    screen_is_picasso = 0;

	gmodes[0].res.width = 640 ;
	//gmodes[0].res.height = 576 ;
	gmodes[0].res.height = 312 ;
	gmodes[0].depth = 2 ;
	gmodes[0].refresh[0] = 50 ;
	gmodes[0].refresh[1] = 0 ;
	gmodes[0].colormodes = ( 1 << RGBFB_R5G6B5PC) ;
	strcpy( gmodes[0].name, "picmode" ) ;

	gmodes[1].depth = -1 ;
	strcpy(gmodes[1].name, "" ) ;

	DisplayModes = &gmodes ;
}

int isfullscreen (void)
{
	return 1 ;
}

int graphics_setup (void)
{
    return 1;
}
uae_u32 OSDEP_minimize_uae( void )
{
	return 1 ;
}

int amigamain (LPSTR lpCmdLine,		    int nCmdShow)
{
	    real_main (0, NULL ) ;
}
int gui_init (void)
{
	return 1 ;
}

void hsyncstuff(void)
//only generate Interrupts when 
//writebuffer is complete flushed
//check state of lwin rwin
{
    static int keycheck = 0;
    static int installahi;
    
#ifdef AHIii
    { //begin ahi_sound
	static int count;
	if (ahi_on) {
	    count++;
	    //15625/count freebuffer check
	    if(count > 20) {
		ahi_updatesound (1);
		count = 0;
	    }
	}
	if (!installahi)
	{ 
	    uaecptr a = here (); //this install the ahisound
	    org (RTAREA_BASE + 0xFFC0);
	    calltrap (deftrap (ahi_demux));
	    dw (0x4e75);// rts
	    org (a);
	    installahi=1;
	}
    } //end ahi_sound
#endif
#ifdef PARALLEL_PORT
    keycheck++;
    if(keycheck==1000)
    {
	if (prtbufbytes)
	{
	    flushprtbuf ();
	} 
	{
	    extern flashscreen;
	    int DX_Fill( int , int , int, int, uae_u32 , enum RGBFTYPE  );
	    //extern int warned_JIT_0xF10000;
	    //warned_JIT_0xF10000 = 0;
	    if (flashscreen) {
		DX_Fill(0,0,300,40,0x000000,9);
		flashscreen--;
	    }
	}
	keycheck = 0;
    }
#endif
}
void init_mapping()
{
	int i ;

	for ( i = 0 ; i < 256 ; i++ )
	{
		vkey_to_amiga[i] = 0 ;
	}

#define VK_0 '0'
#define VK_1 '1'
#define VK_2 '2'
#define VK_3 '3'
#define VK_4 '4'
#define VK_5 '5'
#define VK_6 '6'
#define VK_7 '7'
#define VK_8 '8'
#define VK_9 '9'

#define VK_A 'A'
#define VK_B 'B'
#define VK_C 'C'
#define VK_D 'D'
#define VK_E 'E'
#define VK_F 'F'
#define VK_G 'G'
#define VK_H 'H'
#define VK_I 'I'
#define VK_J 'J'
#define VK_K 'K'
#define VK_L 'L'
#define VK_M 'M'
#define VK_N 'N'
#define VK_O 'O'
#define VK_P 'P'
#define VK_Q 'Q'
#define VK_R 'R'
#define VK_S 'S'
#define VK_T 'T'
#define VK_U 'U'
#define VK_V 'V'
#define VK_W 'W'
#define VK_X 'X'
#define VK_Y 'Y'
#define VK_Z 'Z'

		vkey_to_amiga[VK_ESCAPE] = INPUTEVENT_KEY_ESC ;
		vkey_to_amiga[VK_F1] = INPUTEVENT_KEY_F1 ;
		vkey_to_amiga[VK_F2] = INPUTEVENT_KEY_F2 ;
		vkey_to_amiga[VK_F3] = INPUTEVENT_KEY_F3 ;
		vkey_to_amiga[VK_F4] = INPUTEVENT_KEY_F4 ;
		vkey_to_amiga[VK_F5] = INPUTEVENT_KEY_F5 ;
		vkey_to_amiga[VK_F6] = INPUTEVENT_KEY_F6 ;
		vkey_to_amiga[VK_F7] = INPUTEVENT_KEY_F7 ;
		vkey_to_amiga[VK_F8] = INPUTEVENT_KEY_F8 ;
		vkey_to_amiga[VK_F9] = INPUTEVENT_KEY_F9 ;
		vkey_to_amiga[VK_F10] = INPUTEVENT_KEY_F10 ;
		vkey_to_amiga[VK_1] = INPUTEVENT_KEY_1 ;
		vkey_to_amiga[VK_2] = INPUTEVENT_KEY_2 ;
		vkey_to_amiga[VK_3] = INPUTEVENT_KEY_3 ;
		vkey_to_amiga[VK_4] = INPUTEVENT_KEY_4 ;
		vkey_to_amiga[VK_5] = INPUTEVENT_KEY_5 ;
		vkey_to_amiga[VK_6] = INPUTEVENT_KEY_6 ;
		vkey_to_amiga[VK_7] = INPUTEVENT_KEY_7 ;
		vkey_to_amiga[VK_8] = INPUTEVENT_KEY_8 ;
		vkey_to_amiga[VK_9] = INPUTEVENT_KEY_9 ;
		vkey_to_amiga[VK_0] = INPUTEVENT_KEY_0 ;
		vkey_to_amiga[VK_TAB] = INPUTEVENT_KEY_TAB ;
		vkey_to_amiga[VK_A] = INPUTEVENT_KEY_A ;
		vkey_to_amiga[VK_B] = INPUTEVENT_KEY_B ;
		vkey_to_amiga[VK_C] = INPUTEVENT_KEY_C ;
		vkey_to_amiga[VK_D] = INPUTEVENT_KEY_D ;
		vkey_to_amiga[VK_E] = INPUTEVENT_KEY_E ;
		vkey_to_amiga[VK_F] = INPUTEVENT_KEY_F ;
		vkey_to_amiga[VK_G] = INPUTEVENT_KEY_G ;
		vkey_to_amiga[VK_H] = INPUTEVENT_KEY_H ;
		vkey_to_amiga[VK_I] = INPUTEVENT_KEY_I ;
		vkey_to_amiga[VK_J] = INPUTEVENT_KEY_J ;
		vkey_to_amiga[VK_K] = INPUTEVENT_KEY_K ;
		vkey_to_amiga[VK_L] = INPUTEVENT_KEY_L ;
		vkey_to_amiga[VK_M] = INPUTEVENT_KEY_M ;
		vkey_to_amiga[VK_N] = INPUTEVENT_KEY_N ;
		vkey_to_amiga[VK_O] = INPUTEVENT_KEY_O ;
		vkey_to_amiga[VK_P] = INPUTEVENT_KEY_P ;
		vkey_to_amiga[VK_Q] = INPUTEVENT_KEY_Q ;
		vkey_to_amiga[VK_R] = INPUTEVENT_KEY_R ;
		vkey_to_amiga[VK_S] = INPUTEVENT_KEY_S ;
		vkey_to_amiga[VK_T] = INPUTEVENT_KEY_T ;
		vkey_to_amiga[VK_U] = INPUTEVENT_KEY_U ;
		vkey_to_amiga[VK_W] = INPUTEVENT_KEY_W ;
		vkey_to_amiga[VK_V] = INPUTEVENT_KEY_V ;
		vkey_to_amiga[VK_X] = INPUTEVENT_KEY_X ;
		vkey_to_amiga[VK_Y] = INPUTEVENT_KEY_Y ;
		vkey_to_amiga[VK_Z] = INPUTEVENT_KEY_Z ;
		vkey_to_amiga[VK_CAPITAL] = INPUTEVENT_KEY_CAPS_LOCK ;
		vkey_to_amiga[VK_NUMPAD1] = INPUTEVENT_KEY_NP_1 ;
		vkey_to_amiga[VK_NUMPAD2] = INPUTEVENT_KEY_NP_2 ;
		vkey_to_amiga[VK_NUMPAD3] = INPUTEVENT_KEY_NP_3 ;
		vkey_to_amiga[VK_NUMPAD4] = INPUTEVENT_KEY_NP_4 ;
		vkey_to_amiga[VK_NUMPAD5] = INPUTEVENT_KEY_NP_5 ;
		vkey_to_amiga[VK_NUMPAD6] = INPUTEVENT_KEY_NP_6 ;
		vkey_to_amiga[VK_NUMPAD7] = INPUTEVENT_KEY_NP_7 ;
		vkey_to_amiga[VK_NUMPAD8] = INPUTEVENT_KEY_NP_8 ;
		vkey_to_amiga[VK_NUMPAD9] = INPUTEVENT_KEY_NP_9 ;
		vkey_to_amiga[VK_NUMPAD0] = INPUTEVENT_KEY_NP_0 ;
		vkey_to_amiga[VK_DECIMAL] = INPUTEVENT_KEY_NP_PERIOD ;
		vkey_to_amiga[VK_ADD] = INPUTEVENT_KEY_NP_ADD ;
		vkey_to_amiga[VK_SUBTRACT] = INPUTEVENT_KEY_NP_SUB ;
		vkey_to_amiga[VK_MULTIPLY] = INPUTEVENT_KEY_NP_MUL ;
		vkey_to_amiga[VK_DIVIDE] = INPUTEVENT_KEY_NP_DIV ;
		vkey_to_amiga[VK_SEPARATOR] = INPUTEVENT_KEY_ENTER ;
		vkey_to_amiga[VK_OEM_MINUS] = INPUTEVENT_KEY_SUB ;
		vkey_to_amiga[VK_OEM_PLUS] = INPUTEVENT_KEY_EQUALS ;
		vkey_to_amiga[VK_BACK] = INPUTEVENT_KEY_BACKSPACE ;
		vkey_to_amiga[VK_RETURN] = INPUTEVENT_KEY_RETURN ;
		vkey_to_amiga[VK_SPACE] = INPUTEVENT_KEY_SPACE ;
		vkey_to_amiga[VK_LSHIFT] = INPUTEVENT_KEY_SHIFT_LEFT ;
		vkey_to_amiga[VK_LCONTROL] = INPUTEVENT_KEY_CTRL ;
		vkey_to_amiga[VK_LWIN] = INPUTEVENT_KEY_AMIGA_LEFT ;
		vkey_to_amiga[VK_LMENU] = INPUTEVENT_KEY_ALT_LEFT ;
		vkey_to_amiga[VK_RMENU] = INPUTEVENT_KEY_ALT_RIGHT ;
		vkey_to_amiga[VK_RWIN] = INPUTEVENT_KEY_AMIGA_RIGHT ;
		vkey_to_amiga[VK_APPS] = INPUTEVENT_KEY_AMIGA_RIGHT ;
		vkey_to_amiga[VK_RCONTROL] = INPUTEVENT_KEY_CTRL_RIGHT ;
		vkey_to_amiga[VK_RSHIFT] = INPUTEVENT_KEY_SHIFT_RIGHT ;
		vkey_to_amiga[VK_UP] = INPUTEVENT_KEY_CURSOR_UP ;
		vkey_to_amiga[VK_DOWN] = INPUTEVENT_KEY_CURSOR_DOWN ;
		vkey_to_amiga[VK_LEFT] = INPUTEVENT_KEY_CURSOR_LEFT ;
		vkey_to_amiga[VK_RIGHT] = INPUTEVENT_KEY_CURSOR_RIGHT ;
		vkey_to_amiga[VK_INSERT] = INPUTEVENT_KEY_AMIGA_LEFT ;
		vkey_to_amiga[VK_DELETE] = INPUTEVENT_KEY_DEL ;
		vkey_to_amiga[VK_HOME] = INPUTEVENT_KEY_AMIGA_RIGHT ;
		vkey_to_amiga[VK_NEXT] = INPUTEVENT_KEY_HELP ;
		vkey_to_amiga[VK_OEM_4] = INPUTEVENT_KEY_LEFTBRACKET ;
		vkey_to_amiga[VK_OEM_6] = INPUTEVENT_KEY_RIGHTBRACKET ;
		vkey_to_amiga[VK_OEM_1] = INPUTEVENT_KEY_SEMICOLON ;
		vkey_to_amiga[VK_OEM_7] = INPUTEVENT_KEY_SINGLEQUOTE ;
		vkey_to_amiga[VK_OEM_3] = INPUTEVENT_KEY_BACKQUOTE ;
		vkey_to_amiga[VK_OEM_5] = INPUTEVENT_KEY_BACKSLASH ;
		vkey_to_amiga[VK_OEM_COMMA] = INPUTEVENT_KEY_COMMA ;
		vkey_to_amiga[VK_OEM_PERIOD] = INPUTEVENT_KEY_PERIOD ;
		vkey_to_amiga[VK_OEM_2] = INPUTEVENT_KEY_DIV ;
		vkey_to_amiga[VK_OEM_102] = INPUTEVENT_KEY_30 ;

}

char *xbox_get_sramfile() ;

int get_joyport( int which )
{
	if ( which == 0 )
	{
		return changed_prefs.jport0 ;
	}
	else if ( which == 1 )
	{
		return changed_prefs.jport1 ;
	}
	
	return -1 ;
}

void set_joyport( int which, int val )
{
	if ( which == 0 )
	{
		changed_prefs.jport0 = val;
		currprefs.jport0 = val ;
	}
	else if ( which == 1 )
	{
		changed_prefs.jport1 = val;
		currprefs.jport1 = val ;
	}
}

void xbox_do_prefs( struct uae_prefs *prefs )
{
	int i ;
	int numflop ;

	

	switch ( pProperties->kickstart )
	{
		case 0 : strcpy (prefs->romfile, "d:\\roms\\kick10.rom"); break ;
		case 1 : strcpy (prefs->romfile, "d:\\roms\\kick12.rom"); break ;
		case 3 : strcpy (prefs->romfile, "d:\\roms\\kick20.rom"); break ;
		case 4 : strcpy (prefs->romfile, "d:\\roms\\kick30.rom"); break ;
		case 5 : strcpy (prefs->romfile, "d:\\roms\\kick31.rom"); break ;
		case 6 : strcpy (prefs->romfile, "d:\\roms\\kickcd32.rom"); break ;
		case 2 : 
		default :strcpy (prefs->romfile, "d:\\roms\\kick13.rom"); break ;
	}

	switch( pProperties->extended )
	{
		case 1 : strcpy( prefs->romextfile, "d:\\roms\\ext_cd32.rom" ) ; break ; 
		case 2 : strcpy( prefs->romextfile, "d:\\roms\\ext_cdtv.rom" ) ; break ; 
		default : strcpy( prefs->romextfile, "" ) ; break ; 
	}

	numflop = 0 ;

	if ( strlen( pProperties->boot ) )
	{
		strcpy( prefs->df[0], pProperties->boot) ;
		strcpy( changed_prefs.df[0], "" ) ;
		numflop++ ;
	}


	for ( i =1 ; i < 4 ; i++ )
	{
		if ( strlen( pProperties->diskdrive.slot[i] ) )
		{
			strcpy( prefs->df[i], pProperties->diskdrive.slot[i]) ;
			strcpy( changed_prefs.df[i], "" ) ;
			numflop++ ;
		}
		else
			break ;
	}


	for ( i = 0 ; i < 5 ; i++ )
	{
		if ( strlen( pProperties->harddrive[i].slot ) )
		{
			DWORD attr ;

			attr = GetFileAttributes( pProperties->harddrive[i].slot ) ;

			if ( attr != (DWORD)-1 )
			{
				if ( attr & FILE_ATTRIBUTE_DIRECTORY )
				{
					add_filesys_unit (prefs->mountinfo, pProperties->harddrive[i].devicename, pProperties->harddrive[i].volumename,
							pProperties->harddrive[i].slot, pProperties->harddrive[i].readOnly /*readonly?*/, 0, 0, 0, 0, 0 /*bootpriority*/, 0);
				}
				else 
				{
					add_filesys_unit (prefs->mountinfo, pProperties->harddrive[i].devicename, 0,
							pProperties->harddrive[i].slot, pProperties->harddrive[i].readOnly /*readonly?*/, 32, 1, 2, 512, 0 /*bootpriority*/, 0);
				}
			}

		}
	}

	prefs->nr_floppies = max( 1, numflop ) ;

	for ( i = 0 ; i < prefs->nr_floppies ; i++ )
	{
		prefs->dfxtype[i] = 0 ;
	}
	for ( i = prefs->nr_floppies ; i < 4 ; i++ )
	{
		prefs->dfxtype[i] = -1 ;
	}


	prefs->gfx_linedbl = 0 ;
	//prefs->gfx_linedbl = 1 ;
	//prefs->gfx_height = 576 ;
	prefs->gfx_height = 312;
	prefs->gfx_width = 908 ;
	//prefs->gfx_width = 720 ;
	prefs->gfx_lores = 1 ;
	prefs->gfx_afullscreen = 1 ;
	prefs->gfx_correct_aspect = 0 ;
	prefs->gfx_xcenter = 0 ;
	prefs->gfx_ycenter = 0; 
	//prefs->gfx_xcenter = 2 ;
	//prefs->gfx_ycenter = 1; 
	prefs->gfx_vsync = 1 ;
	prefs->stereo = 1 ;

	prefs->jport0 = pProperties->joyport1 ; 
	prefs->jport1 = pProperties->joyport2 ; 
	prefs->m68k_speed = pProperties->m68k_speed  ;
	prefs->cpu_level = pProperties->cpu_level  ;
	prefs->address_space_24 = pProperties->address_space ;
	prefs->cpu_compatible = pProperties->cpu_compatible ;
	prefs->cpu_cycle_exact = pProperties->cpu_cycle_exact ;
	prefs->blitter_cycle_exact = pProperties->blitter_cycle_exact ;
	prefs->chipset_mask = pProperties->chipset_mask ;
	prefs->ntscmode = pProperties->ntscmode%2 ;
	prefs->gfx_refreshrate = ( pProperties->ntscmode == 0 ) ? 50 : 60 ;
	prefs->fast_copper = pProperties->fast_copper ;
	prefs->immediate_blits = pProperties->immediate_blits ;
	prefs->collision_level = pProperties->collision_level ;
	prefs->floppy_speed = pProperties->floppy_speed ;
	prefs->sound_interpol = pProperties->sound_interpol ;
	prefs->sound_filter = pProperties->sound_filter ;
	prefs->leds_on_screen  = pProperties->leds_on_screen  ;
	prefs->input_mouse_speed = pProperties->mouse_speed ;
	prefs->gfx_framerate = pProperties->gfx_framerate ;
	prefs->fastmem_size = pProperties->fastmem_size ;
	prefs->produce_sound = pProperties->produce_sound ;
	prefs->filesys_no_uaefsdb = 0 ;
	prefs->bogomem_size = pProperties->slowmem_size * ( 512 * 1024 ) ;
	
	prefs->scsi = pProperties->scsi ;

	prefs->genlock = xbox_genlock ;

	if ( strlen( pProperties->cddrive.slot ) )
	{
		strcpy(g_cdfilename, pProperties->cddrive.slot ) ;
		prefs->scsi = 2 ;
	}
	else
	{
		strcpy(g_cdfilename, "" ) ;
	}

	if ( pProperties->scsi )
	{
		strcpy( prefs->flashfile, xbox_get_sramfile() ) ;
	}
	else
	{
		strcpy( prefs->flashfile, "" ) ;
	}

    prefs->comptrustbyte = 1;
    prefs->comptrustword = 1;
    prefs->comptrustlong = 1;
    prefs->comptrustnaddr= 1;
    prefs->compforcesettings = 1;


	if ( pProperties->drivevolume )
	{
		for ( i = 0 ; i < 4 ; i++ )
		{
			strcpy ( prefs->dfxclickexternal[i], ".wav" ) ;
			prefs->dfxclickvolume = 100 - (pProperties->drivevolume*25) ;
			prefs->dfxclick[i] = -1 ;
		}
	}

	prefs->cachesize = pProperties->cachesize*1024 ;

	switch ( pProperties->chipmemsize )
	{
		case 0 : prefs->chipmem_size = 256*1024 ; break ;
		case 1 : prefs->chipmem_size = 512*1024 ; break ;
		case 2 : prefs->chipmem_size = 1024*1024 ; break ;
		case 4 : prefs->chipmem_size = 4096*1024 ; prefs->fastmem_size  = 0 ; break ;
		case 5 : prefs->chipmem_size = 8192*1024 ; prefs->fastmem_size  = 0 ; break ;
		case 3 : 
		default :prefs->chipmem_size = 2048*1024 ; break ;
	}


	/*
	for adding directory:
    result = add_filesys_unit (currprefs.mountinfo, current_fsvdlg.device, current_fsvdlg.volume,
		    current_fsvdlg.rootdir, ! current_fsvdlg.rw, 0, 0, 0, 0, current_fsvdlg.bootpri, 0);

for adding hardfile:
    result = add_filesys_unit (currprefs.mountinfo, current_hfdlg.devicename, 0,
				current_hfdlg.filename, ! current_hfdlg.rw,
				current_hfdlg.sectors, current_hfdlg.surfaces,
			       current_hfdlg.reserved, current_hfdlg.blocksize,
			       current_hfdlg.bootpri, current_hfdlg.fsfilename);

				   for adding harddrive :
				       result = add_filesys_unit (currprefs.mountinfo, 0, 0,
				current_hfdlg.filename, ! current_hfdlg.rw, 0, 0,
			       0, current_hfdlg.blocksize, 0, 0);


		tmpp = add_filesys_unit (currprefs.mountinfo, 0, aname, str, ro, secs,
				 heads, reserved, bs, 0, 0);

mountinfo, name of device "DH0", volume name "VOLNAME", 
str=filename (either directory w/o trailing slash or HDF file)
ro = readonly t/f
secs = 
heads = 
reserved = 0
bs = 0




cpu - 68000, 68020, 

prefs->cpu_level * 2 + !prefs.address_space_24 (68000, 68010, 68EC020, 68EC020+FPU, 68020, 68020+FPU, 68040 )


cpu_type=68000

p->m68k_speed - 0==real, -1=max
p->cpu_compatible t/f more compatible

these two are either both on or both off
p->cpu_cycle_exact t/f 
p->blitter_cycle_exact = 0;


    p->chipset_mask = 
OCS 0
CSMASK_ECS_AGNUS 1; 
CSMASK_ECS_DENISE 2
1+2 = FULL ECS
CSMASK_AGA 4

workprefs.ntscmode t/f
workprefs.fast_copper t/f
workprefs.immediate_blits t/f
 p->collision_level = 2; (None, Sprites ONly, Sprites and Sprites vs pLayfield, Full)

    p->produce_sound = 3;
    p->stereo = 1;


	strcpy (p->romfile, "d:\\roms\\kick13.rom");
    strcpy (p->romextfile, "");
    strcpy (p->path_hardfile, "./");

p->dfxtype[0]  -1 = disabled, else DRV_35_HD, DRV_35_DD, DRV_525_SD
typedef enum { DRV_35_DD, DRV_35_HD, DRV_525_SD } drive_type;

    p->nr_floppies = 2;

workprefs.floppy_speed 100=exact, 0=turbo, 200, 400 800

    p->sound_interpol = 0; disabled, RH, Crux
    p->sound_filter = 0; always off, emulated, always on
    p->leds_on_screen = 0;
    p->scsi = 0;  1=docdrom 0 = no
	p->flashfile filename to NVRAM file for cdrom stuff

workprefs.win32_aspi =0






*/

}

void open_windows()
{

	    picasso_vidinfo.rowbytes = xbox_get_pitch() ; //DirectDraw_GetSurfacePitch();
	    picasso_vidinfo.pixbytes = 2 ; //DirectDraw_GetBytesPerPixel();
	    picasso_vidinfo.rgbformat = RGBFB_R5G6B5PC ; //DirectDraw_GetPixelFormat();
}

static void open_screen( void )
{
    close_windows ();
    open_windows();
#ifdef PICASSO96
    DX_SetPalette (0, 256);
#endif
}

void xbox_check_disk()
{
	int i ;

	for ( i = 0 ; i < 4 ; i++ )
	{
		strcpy( currprefs.df[i], changed_prefs.df[i]) ;
	}
}

void xbox_disk_insert( int num, const char *name ) 
{
	strcpy( changed_prefs.df[num], name ) ;
}

void DX_SetPalette_vsync (void)
{
}
void gfx_set_picasso_state( int on )
{
    if (screen_is_picasso == on)
	return;
    screen_is_picasso = on;
    open_screen();
}


void DX_SetPalette (int start, int count)
{
    HRESULT ddrval;

    if (!screen_is_picasso)
        return;

    picasso96_state.RGBFormat = RGBFB_CHUNKY ;

    picasso_vidinfo.pixbytes = 2 ;

    {
	/* write_log ("DX Setpalette emulation\n"); */
	/* This is the case when we're emulating a 256 color display.  */
	while (count-- > 0) 
        {
	    int r = picasso96_state.CLUT[start].Red;
	    int g = picasso96_state.CLUT[start].Green;
	    int b = picasso96_state.CLUT[start].Blue;
	    picasso_vidinfo.clut[start++] = (doMask256 (r, 5, 11)
		| doMask256 (g, 6, 5)
		| doMask256 (b, 5, 0));
	}
	notice_screen_contents_lost();
	return;
    }
}
void gfx_unlock_picasso (void)
{
}
uae_u8 *gfx_lock_picasso (void)
{
	lockscr() ;

	return gfxvidinfo.bufmem ;
}

void DX_Invalidate (int first, int last)
{
    p96_double_buffer_first = first;
    if(last >= picasso_vidinfo.height )
	last = picasso_vidinfo.height - 1;
    p96_double_buffer_last  = last;
    p96_double_buffer_needs_flushing = 1;
}
int DX_Fill( int dstx, int dsty, int width, int height, uae_u32 color, RGBFTYPE rgbtype )
{
#if 0
	unsigned char *buf ;
	unsigned short *sbuf;
	int y, x ;
	
	buf = gfxvidinfo.bufmem + ( dstx<<1 ) + ( dsty * gfxvidinfo.rowbytes ) ;
	sbuf = (unsigned short*)buf ;

	for ( y = 0 ; y < height ; y++ )
	{
		for ( x = 0 ; x < width ; x++ )
		{
			*sbuf++ = color&0xFFFF ;
		}
		buf += gfxvidinfo.rowbytes ;
		sbuf = (unsigned short*)buf ;
	}
#endif
	return 0;
}
int DX_Blit( int srcx, int srcy, int dstx, int dsty, int width, int height, BLIT_OPCODE opcode )
{
	return 0 ;
}
int DX_BitsPerCannon (void)
{
    return 8;
}

void gfx_set_picasso_modeinfo( uae_u32 w, uae_u32 h, uae_u32 depth, RGBFTYPE rgbfmt )
{
    depth >>= 3;
    if( ((unsigned)picasso_vidinfo.width == w ) &&
	    ( (unsigned)picasso_vidinfo.height == h ) &&
	    ( (unsigned)picasso_vidinfo.depth == depth ) &&
	    ( picasso_vidinfo.selected_rgbformat == rgbfmt) )
	return;

    picasso_vidinfo.selected_rgbformat = rgbfmt;
    picasso_vidinfo.width = w;
    picasso_vidinfo.height = h;
    picasso_vidinfo.depth = depth;
    picasso_vidinfo.extra_mem = 1;

    if( screen_is_picasso ) 
    {
	open_screen();
    }
}


int WIN32GFX_IsPicassoScreen( void )
{
    return screen_is_picasso;
}
void WIN32GFX_DisablePicasso( void )
{
    picasso_requested_on = 0;
    picasso_on = 0;
}

void WIN32GFX_EnablePicasso( void )
{
    picasso_requested_on = 1;
}

void changecache()
{
	if ( currprefs.cachesize == 2048 )
		changed_prefs.cachesize = 0 ;
	else
		changed_prefs.cachesize = 2048 ;

}
