#include "video-driver.h"

void MDFN_ResetMessages(void);
void MDFN_InitFontData(void);
uint32 DrawTextTrans(uint32 *dest, int pitch, uint32 width, uint8 *textmsg, uint32 fgcolor, int centered);
uint32 DrawTextTransShadow(uint32 *dest, int pitch, uint32 width, uint8 *textmsg, uint32 fgcolor, uint32 shadcolor, int centered);

int MDFN_InitVirtualVideo(void);
void MDFN_KillVirtualVideo(void);
int SaveSnapshot(void);
void MDFN_DrawStateMovieRow(uint32 *XBuf, const MDFN_Rect *OSDRect, uint32 *preview, uint32 preview_width, uint32 preview_height, int *nstatus, int cur, uint8 *text);

static inline void DECOMP_COLOR(int c, int &r, int &g, int &b)
{
 r = (c >> FSettings.rshift) & 0xFF;
 g = (c >> FSettings.gshift) & 0xFF;
 b = (c >> FSettings.bshift) & 0xFF;
}

#define MK_COLOR16(r,g,b) ( (((r)>>3)<<FSettings.rshift) | (((g)>>2) << FSettings.gshift) | (((b)>>3) << FSettings.bshift))
#define MK_COLORA16(r,g,b,a) ( (((r)>>3)<<FSettings.rshift) | (((g)>>2) << FSettings.gshift) | (((b)>>3) << FSettings.bshift))
#define MK_COLOR(r,g,b) ( ((r)<<16) | ((g) << 8) | ((b) ))
#define MK_COLORA(r,g,b, a) ( ((r)<<16) | ((g) << 8) | ((b) ) | ((a) << 24))
//#define MK_COLOR(r,g,b) ( ((r)<<FSettings.rshift) | ((g) << FSettings.gshift) | ((b) << FSettings.bshift))
//#define MK_COLORA(r,g,b, a) ( ((r)<<FSettings.rshift) | ((g) << FSettings.gshift) | ((b) << FSettings.bshift) | ((a) << FSettings.ashift))

#define DO_COLOR_HALF(v) ( (((v&0xff)>>1)&0xFF) | ((v&0xFF00)>>1)&0xFF00 | ((v&0xFF0000)>>1)&0xFF0000 | ((v&0xFF000000)>>1)&0xFF000000 )
