/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint8 mapbyte1[2] ;
static uint8 lastV ;
static uint32 lastA ;

static DECLFW(Mapper57_write)
{
	lastA = A ;
	lastV = V ;

 A&=0x8800;
 if(A==0x8800)
 {
  mapbyte1[0]=V;
  if(V&0x80)
   setprg32(0x8000, 2|(V>>6));
  else
  {
   setprg16(0x8000,(V>>5)&3);
   setprg16(0xc000,(V>>5)&3);
  }
  setmirror((V&0x8)>>3 ? MI_H : MI_V );
 }
 else
  mapbyte1[1]=V;
 
 setchr8((mapbyte1[1]&3)|(mapbyte1[0]&7)|((mapbyte1[0]&0x10)>>1));
 //VROM_BANK8((mapbyte1[1]&3)|(mapbyte1[0]&7)|((mapbyte1[0]&0x10)>>1));
 //printf("$%04x:$%02x\n",A,V);
}

static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(lastA),
  SFVAR(lastV),
  SFARRAY(mapbyte1,2),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  Mapper57_write( lastA, lastV ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
 lastA = 0 ;
 lastV = 0 ;
 mapbyte1[0] = mapbyte1[1] = 0 ;
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
}

int Mapper57_Init(CartInfo *info)
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

	//setprg8r(1,0x6000,0);
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	//setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

	
	SetWriteHandler(0x8000,0xffff,Mapper57_write);

 return 1 ;
}
