/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Ben Parnell
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint32 lastA, IRQCount, lastA2 ;
static uint8 IRQa ;
#if 0

DECLFW(Mapper43_write)
{
  uint32 m;
  int z;

  lastA = A ;

  m=A&0xff;
  z=(A>>8)&3;

  //if ( z > 1 )
	  //return ;

  if ( z == 1 )
	  m |= 0x20 ;
  /*
  switch(CHRmask8[0])
  {
   default:
   case 0xFF:
             if(z&2)
              m|=0x20;
             break;
   case 0x1FF:
             m|=z<<5;
             break;
  }
*/
  if(A&0x800)
  { //16k bank mode
	//setmirror( MI_0);
	  setmirror( (A>>13)&1 ? MI_0: MI_1);
    setprg16(0x8000,(m<<1)|((A&0x1000)>>12));
    setprg16(0xC000,(m<<1)|((A&0x1000)>>12));
  }
  else
  {
	  //32k bank mode
   setmirror((A>>13)&1 ? MI_H : MI_V );
    setprg32(0x8000,m);
  }




}
#endif

#if 1

DECLFW(Mapper43_write)
{
  uint32 m;
  int z;
	unsigned int zz = V ;

  lastA = A ;

  if(A&0x800)
   setmirror((A>>13)&1 ? MI_H : MI_V );
	  //setmirror( (A>>13)&1 ? MI_1 : MI_0);
  else
   setmirror((A>>13)&1 ? MI_H : MI_V );
  m=A&0xff;

  z=(A>>8)&3;

  switch(CHRmask8[0])
  {
   default:
   case 0xFF:
             if(z&1)
              m|=0x20;
             break;
   case 0x1FF:
             m|=z<<5;
             break;
  }

   if(A&0x800)
   {
    setprg16(0x8000,(m<<1)|((A&0x1000)>>12));
    setprg16(0xC000,(m<<1)|((A&0x1000)>>12));
   }
   else
    setprg32(0x8000,m);
}
#endif

static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(lastA),
  SFVAR(IRQa),
  SFVAR(IRQCount),
  SFARRAY32( CHRmask8, 32 ),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
 {
	  Mapper43_write( lastA, 0 ) ;
//	  M43Low( lastA2, 0) ;
 }

 return(ret);
}

static void Power(CartInfo *info)
{
 lastA = 0 ;
	//setprg8r(1,0x6000,0);
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
 setprg32(0x8000, 0);
}

#if 1
int Mapper43_Init( CartInfo *info )
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

	//setprg8r(1,0x6000,0);
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

 setprg32(0x8000, 0);
 SetWriteHandler(0x8000,0xffff,Mapper43_write);

 return 1 ;
}
#endif 