/* FCE Ultra - NES/Famicom Emulator
 * 
 * Copyright notice for this file:
 *  Copyright (C) 2003 Xodnizel
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *      
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */  

#include "mapinc.h"

static uint32 lastA ;

static DECLFW(Mapper231_write)
{
	lastA = A ;

 if(A&0x20)
  setprg32(0x8000, (A>>1)&0xF);
 else
 {
  setprg16(0x8000,(A&0x1E));
  setprg16(0xc000,(A&0x1E));
 }
 setmirror((A>>7)&1 ? MI_H : MI_V);
}
static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(lastA),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  Mapper231_write( lastA, 0 ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);

   setprg16(0x8000,0);
   setprg16(0xc000,0);
}


int Mapper231_Init(CartInfo *info )
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

   setprg16(0x8000,0);
   setprg16(0xc000,0);
   SetWriteHandler(0x8000,0xffff,Mapper231_write);

   return 1 ;
}

