/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2003 CaH4e3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint8 mapbyte1[1] ;
static uint8 lastV ;

#define rom_sw mapbyte1[0]

void Mapper230_Reset(void)
{
	lastV = 0 ;
	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
        rom_sw ^= 1; //1 - rom_sw;

        if( rom_sw ) {
                setprg16(0x8000,0);
                setprg16(0xc000,7);
        } else {
                setprg16(0x8000,8);
                setprg16(0xc000,39);
        }
		setmirror(MI_V);
}

static DECLFW(Mapper230_write)
{
	lastV = V ;
        if( rom_sw ) {
                setprg16( 0x8000, V&0x07 );
        } else {
                if( V & 0x20 ) {
                        setprg16( 0x8000, (V&0x1F)+8 );
                        setprg16( 0xc000, (V&0x1F)+8 );
                } else {
                        setprg32( 0x8000, ((V&0x1E) >> 1) + 4 );
                }
				setmirror( ((V & 0x40) >> 6) ? MI_V : MI_H );
        }
}
static int StateAction(StateMem *sm, int load, int data_only)
{
 SFORMAT StateRegs[] =
 {
  SFVAR(lastV),
  SFARRAY( mapbyte1, 1),
  SFEND
 };

 int ret = MDFNSS_StateAction(sm, load, data_only, StateRegs, "MAPR");

 if(load)
  Mapper230_write( 0, lastV ) ;
 return(ret);
}

static void Power(CartInfo *info)
{
	Mapper230_Reset() ;
}

int Mapper230_Init(CartInfo *info)
{
	info->Power = Power ;
	info->StateAction = StateAction;
	info->Reset = Power ;

	setprg16(0x8000,0);
	setprg16(0xC000,~0);
	setchr8(0);
	SetReadHandler(0x8000,0xFFFF,CartBR);

        setprg16(0x8000,0);
        setprg16(0xc000,7);
        SetWriteHandler(0x8000, 0xffff, Mapper230_write);
        //MapperReset = Mapper230_Reset;
        rom_sw = 1;

		return 1 ;
}

