//------------------------------------------------------------------------------
// inlines-- moved from .h file for clarity
//------------------------------------------------------------------------------
// Logical rotate left operation.
inline uint32 jpeg_decoder::rol(uint32 i, uint8 j)
{
#ifdef SUPPORT_X86ASM
  // Breaks the rules a bit.. return value is in eax.
  _asm
  {
    Mov eax, i
    Mov cl, j
    rol eax, cl
  }
#else
  return ((i << j) | (i >> (32 - j)));
#endif
}
//------------------------------------------------------------------------------
// Retrieve one character from the input stream.
inline uint32 jpeg_decoder::get_char(void)
{
  // Any bytes remaining in buffer?
  if (!in_buf_left)
  {
    // Pad the end of the stream with zeroes
    return (0x00);
  }

  uint32 c = *Pin_buf_ofs++;
  in_buf_left--;

  if(c == 0xFF)
  {
   c = *Pin_buf_ofs++;
   in_buf_left--;
  }

  //printf("Char Read: %02x\n", c);
  return (c);
}

inline uint8 jpeg_decoder::get_octet(void)
{
  int c = get_char();
  return (c);
}

inline uint32 jpeg_decoder::get_bits_2(int num_bits)
{
  uint32 i;

  if(!bits_left)
  {
   bits_left = 16;
   bit_buf = (get_char() << 8) | (get_char() << 0);
  }

  i = (bit_buf >> (16 - num_bits)) & ((1 << num_bits) - 1);
  //printf("GetBits2: %d %02x\n", num_bits, i);
  //printf("Pre: %04x %04x %d\n", i, ((1 << num_bits) - 1), num_bits);

  if ((bits_left -= num_bits) <= 0)
  {
    bit_buf = rol(bit_buf, num_bits += bits_left);

    uint32 c1 = get_char();
    uint32 c2 = get_char();

    bit_buf = (bit_buf & 0xFFFF) | (((uint32)c1) << 24) | (((uint32)c2) << 16);

    bit_buf = rol(bit_buf, -bits_left);

    bits_left += 16;
  }
  else
    bit_buf = rol(bit_buf, num_bits);

  return i;
}

//------------------------------------------------------------------------------
// Decodes a Huffman encoded symbol.
inline int jpeg_decoder::huff_decode(Phuff_tables_t Ph)
{
  int symbol;

  // Check first 8-bits: do we have a complete symbol?
  if ((symbol = Ph->look_up[(bit_buf >> 8) & 0xFF]) < 0)
  {
    // Decode more bits, use a tree traversal to find symbol.
    get_bits_2(8);

    do
    {
      symbol = Ph->tree[~symbol + (1 - get_bits_2(1))];
    } while (symbol < 0);
  }
  else
    get_bits_2(Ph->code_size[symbol]);

  return symbol;
}
//------------------------------------------------------------------------------
// Tables and macro used to fully decode the DPCM differences.
// (Note: In x86 asm this can be done without using tables.)
const int extend_test[16] =   /* entry n is 2**(n-1) */
  { 0, 0x0001, 0x0002, 0x0004, 0x0008, 0x0010, 0x0020, 0x0040, 0x0080,
    0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000 };

const int extend_offset[16] = /* entry n is (-1 << n) + 1 */
  { 0, ((-1)<<1) + 1, ((-1)<<2) + 1, ((-1)<<3) + 1, ((-1)<<4) + 1,
    ((-1)<<5) + 1, ((-1)<<6) + 1, ((-1)<<7) + 1, ((-1)<<8) + 1,
    ((-1)<<9) + 1, ((-1)<<10) + 1, ((-1)<<11) + 1, ((-1)<<12) + 1,
    ((-1)<<13) + 1, ((-1)<<14) + 1, ((-1)<<15) + 1 };

// used by huff_extend()
const int extend_mask[] =
{
  0,
  (1<<0), (1<<1), (1<<2), (1<<3),
  (1<<4), (1<<5), (1<<6), (1<<7),
  (1<<8), (1<<9), (1<<10), (1<<11),
  (1<<12), (1<<13), (1<<14), (1<<15),
  (1<<16),
};

#define HUFF_EXTEND_TBL(x,s) ((x) < extend_test[s] ? (x) + extend_offset[s] : (x))

#define HUFF_EXTEND(x,s) HUFF_EXTEND_TBL(x,s)
#define HUFF_EXTEND_P(x,s) HUFF_EXTEND_TBL(x,s)

//------------------------------------------------------------------------------
// Clamps a value between 0-255.
inline uint8 jpeg_decoder::clamp(int i)
{
  if (i & 0xFFFFFF00)
    i = (((~i) >> 31) & 0xFF);

  return (i);
}

