#include "SndXBOX.hxx"
#include <stdio.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

void dac_update( unsigned char* dac_buffer, int length_bytes);
void sound_update( unsigned short* chip_buffer, int length_bytes);

int sounddanger ;


#ifdef __cplusplus
}
#endif

// the local buffer is what the stream buffer feeds from
// note that this needs to be large enough to buffer at frameskip 11
// for 30fps games like Tapper; we will scale the value down based
// on the actual framerate of the game
#define MAX_BUFFER_SIZE			(128 * 1024)

// this is the maximum number of extra samples we will ask for
// per frame (I know this looks like a lot, but most of the
// time it will generally be nowhere close to this)
#define MAX_SAMPLE_ADJUST		16

extern DWORD g_dwStartTime ;
extern DWORD g_dwTimePaused ;

/**
  Compute the buffer size to use based on the given sample rate

  @param The sample rate to compute the buffer size for
*/
static unsigned long computeBufferSize(int sampleRate)
{
  int t;

  for(t = 7; t <= 12; ++t)
  {
    if((1 << t) > (sampleRate / 60))
    {
      return (1 << (t - 1));
    }
  }

  return 256;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
SoundXBOX::SoundXBOX()
{
	dsound = NULL ;
	stream_buffer = NULL ;
	attenuation = 0 ;
	samples_to_read = 0 ;
	m_fps = 60 ;


}
 
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
SoundXBOX::~SoundXBOX()
{
}

int SoundXBOX::dsound_init(void)
{
	HRESULT result;


	current_adjustment = 0 ;
	m_totalBytesWritten = 0 ;

	// make a format description for what we want
	stream_format.wBitsPerSample	= 16;
	stream_format.wFormatTag		= WAVE_FORMAT_PCM;
	stream_format.nChannels			= 2;
	stream_format.nSamplesPerSec	= 44100;
	stream_format.nBlockAlign		= stream_format.wBitsPerSample * stream_format.nChannels / 8;
	stream_format.nAvgBytesPerSec	= stream_format.nSamplesPerSec * stream_format.nBlockAlign;

	// compute the buffer sizes
	stream_buffer_size = (UINT64)MAX_BUFFER_SIZE ;
//	stream_buffer_size = ((UINT64)MAX_BUFFER_SIZE * (UINT64)stream_format.nSamplesPerSec) / 44100;
	stream_buffer_size = (stream_buffer_size * stream_format.nBlockAlign) / 4;
	stream_buffer_size = (stream_buffer_size * 30) / 60 ;
	stream_buffer_size = (stream_buffer_size / 1024) * 1024;
	stream_buffer_size = 2940*6 ;

	stream_buffer_in = 0 ;

	DSMIXBINVOLUMEPAIR dsmbvp[8] = {
		{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},   // left channel
		{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},  // right channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // left channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // right channel
		{DSMIXBIN_BACK_LEFT, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_BACK_RIGHT, DSBVOLUME_MAX},   // right channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX}};   // right channel
		
	DSMIXBINS dsmb;
	dsmb.dwMixBinCount = 8;
	dsmb.lpMixBinVolumePairs = dsmbvp;
	
	// create a buffer desc for the stream buffer
	stream_desc.dwSize				= sizeof(stream_desc);
	stream_desc.dwFlags				= 0 ;
	stream_desc.dwBufferBytes 		= 0; //we'll specify our own data
//	stream_desc.dwBufferBytes 		= stream_buffer_size;
	stream_desc.lpwfxFormat			= &stream_format;
	stream_desc.lpMixBins			= &dsmb;
	
	// create the stream buffer
	if ((result = dsound->CreateSoundBuffer(&stream_desc, &stream_buffer, NULL)) != DS_OK)
	{
		stream_buffer = NULL ;
		return 1 ;
	}
	
	m_pSoundBufferData = (byte*)malloc( stream_buffer_size ) ;

	stream_buffer->SetBufferData( m_pSoundBufferData, stream_buffer_size ) ;
	stream_buffer->SetPlayRegion( 0, stream_buffer_size ) ;
	stream_buffer->SetLoopRegion( 0, stream_buffer_size ) ;

	memset( m_pSoundBufferData, 0, stream_buffer_size);
	
	stream_buffer->SetVolume( DSBVOLUME_MAX );
	stream_buffer->SetCurrentPosition( 0 ) ;

	m_dwWritePos = 0 ;











	stream_format.wBitsPerSample	= 8;
	stream_format.wFormatTag		= WAVE_FORMAT_PCM;
	stream_format.nChannels			= 1;
	stream_format.nSamplesPerSec	= 8000;
	stream_format.nBlockAlign		= stream_format.wBitsPerSample * stream_format.nChannels / 8;
	stream_format.nAvgBytesPerSec	= stream_format.nSamplesPerSec * stream_format.nBlockAlign;

	// compute the buffer sizes
	stream_buffer_size2 = 800 ;

	DSMIXBINVOLUMEPAIR dsmbvp2[8] = {
		{DSMIXBIN_FRONT_LEFT, DSBVOLUME_MAX},   // left channel
		{DSMIXBIN_FRONT_RIGHT, DSBVOLUME_MAX},  // right channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // left channel
		{DSMIXBIN_FRONT_CENTER, DSBVOLUME_MAX}, // right channel
		{DSMIXBIN_BACK_LEFT, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_BACK_RIGHT, DSBVOLUME_MAX},   // right channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX},    // left channel
		{DSMIXBIN_LOW_FREQUENCY, DSBVOLUME_MAX}};   // right channel
		
	DSMIXBINS dsmb2;
	dsmb2.dwMixBinCount = 8;
	dsmb2.lpMixBinVolumePairs = dsmbvp2;
	
	// create a buffer desc for the stream buffer
	stream_desc.dwSize				= sizeof(stream_desc);
	stream_desc.dwFlags				= 0 ;
	stream_desc.dwBufferBytes 		= 0; //we'll specify our own data
//	stream_desc.dwBufferBytes 		= stream_buffer_size;
	stream_desc.lpwfxFormat			= &stream_format;
	stream_desc.lpMixBins			= &dsmb2;
	
	// create the stream buffer
	if ((result = dsound->CreateSoundBuffer(&stream_desc, &stream_buffer2, NULL)) != DS_OK)
	{
		stream_buffer2 = NULL ;
		return 1 ;
	}
	
	m_pSoundBufferData2 = (byte*)malloc( stream_buffer_size2 ) ;

	stream_buffer2->SetBufferData( m_pSoundBufferData2, stream_buffer_size2 ) ;
	stream_buffer2->SetPlayRegion( 0, stream_buffer_size2 ) ;
	stream_buffer2->SetLoopRegion( 0, stream_buffer_size2 ) ;

	memset( m_pSoundBufferData2, 0, stream_buffer_size2);
	
	stream_buffer2->SetVolume( DSBVOLUME_MAX );
	stream_buffer2->SetCurrentPosition( 0 ) ;

	m_dwWritePos2 = 0 ;







	return 0 ;
}


void SoundXBOX::init( )
{
	m_totalBytesWritten = 0 ;
	m_dwWritePos = 0 ;
	m_dwWritePos2 = 0 ;
	m_bDanger = 0 ;
	memset( m_pSoundBufferData, 0, stream_buffer_size ) ;
	memset( m_pSoundBufferData2, 0, stream_buffer_size2 ) ;
	stream_buffer->SetVolume( DSBVOLUME_MAX );
	stream_buffer->Stop() ;
	stream_buffer->SetCurrentPosition( 0 ) ;
	stream_buffer2->SetVolume( DSBVOLUME_MAX );
	stream_buffer2->Stop() ;
	stream_buffer2->SetCurrentPosition( 0 ) ;
	m_nVolume = DSBVOLUME_MAX ;
	sounddanger = 0 ;
}

void SoundXBOX::adjust_volume( int volchange ) 
{
	m_nVolume += volchange ;

	if ( m_nVolume > DSBVOLUME_MAX )
		m_nVolume = DSBVOLUME_MAX ;
	if ( m_nVolume < DSBVOLUME_MIN )
		m_nVolume = DSBVOLUME_MIN ;

	stream_buffer->SetVolume( m_nVolume ) ;
	stream_buffer2->SetVolume( m_nVolume ) ;

}


void SoundXBOX::cleanup()
{
	stream_buffer->SetVolume( DSBVOLUME_MIN );
	stream_buffer->Stop() ;
	stream_buffer2->SetVolume( DSBVOLUME_MIN );
	stream_buffer2->Stop() ;
}

int SoundXBOX::process(  )
{
	unsigned char *sndbuf ;
	int            num_written ;
	float          numtowrite_f ;
	int            numtowrite ;
	float          waittime ;
	DWORD          waittime_ms ;
	float          elapsedTime ;
	DWORD          playPos  ;
	DWORD          bytesToEnd ;
	DWORD          distWritePlay ;
	DWORD          newWritePos ;
	byte           *bytebuf ;
	int            danger ;
	unsigned char block[4000] ;
	unsigned char block2[4000] ;



	danger = 0 ;

	sound_update((unsigned short*)block, 2940>>1);	//Get sound data
	//memset(block, 0, 2940 ) ;

	stream_buffer->GetCurrentPosition( &playPos, NULL ) ;

	if ( m_dwWritePos > playPos )
	{
		distWritePlay = m_dwWritePos - playPos ;
	}
	else
	{
		distWritePlay = ( stream_buffer_size - playPos ) + m_dwWritePos ;
	}

	int count = 2940 >> 2;
	unsigned short *src16 ;
	unsigned short *dest16 ;

	src16 = (unsigned short*)block ;
	dest16 = (unsigned short*)block2 ;

	while(count)
	{ 
		*dest16++ = *src16;
		*dest16++ = *src16++; count--; 
	}


	numtowrite = 2940 ;
	bytebuf = block2 ;

	if ( distWritePlay < 2940*3 )
	{

		bytesToEnd = stream_buffer_size - m_dwWritePos ;

		if ( numtowrite > bytesToEnd )
		{
			memcpy( m_pSoundBufferData + m_dwWritePos, bytebuf, bytesToEnd ) ;
			memcpy( m_pSoundBufferData, bytebuf + bytesToEnd, numtowrite - bytesToEnd ) ;
		}
		else
		{
			memcpy( m_pSoundBufferData + m_dwWritePos, bytebuf, numtowrite ) ;
		}

		m_dwWritePos = ( m_dwWritePos + numtowrite ) % stream_buffer_size ;

		m_totalBytesWritten += numtowrite ;

		if ( distWritePlay < 3200 ) 
		{
			danger |= 1 ;
		}

	}




	dac_update(block, 134);	//Get DAC data

	//memset(block, 0, 134 ) ;

	stream_buffer2->GetCurrentPosition( &playPos, NULL ) ;

	if ( m_dwWritePos2 > playPos )
	{
		distWritePlay = m_dwWritePos2 - playPos ;
	}
	else
	{
		distWritePlay = ( stream_buffer_size2 - playPos ) + m_dwWritePos2 ;
	}


	numtowrite = 134 ;
	bytebuf = (byte*)block ;

	if ( distWritePlay < 134*3 )
	{

		bytesToEnd = stream_buffer_size2 - m_dwWritePos2 ;

		if ( numtowrite > bytesToEnd )
		{
			memcpy( m_pSoundBufferData2 + m_dwWritePos2, bytebuf, bytesToEnd ) ;
			memcpy( m_pSoundBufferData2, bytebuf + bytesToEnd, numtowrite - bytesToEnd ) ;
		}
		else
		{
			memcpy( m_pSoundBufferData2 + m_dwWritePos2, bytebuf, numtowrite ) ;
		}

		m_dwWritePos2 = ( m_dwWritePos2 + numtowrite ) % stream_buffer_size2 ;

		m_totalBytesWritten += numtowrite ;

		if ( distWritePlay < 175 ) 
		{
			danger |= 1 ;
		}

	}






	sounddanger = danger ;

	return sounddanger ;

}


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
void SoundXBOX::pause(bool state)
{

	if (stream_buffer)
	{
		if (state)
			stream_buffer->Stop() ;
		else
			stream_buffer->Play( 0, 0, DSBPLAY_LOOPING ) ;
	}
	if (stream_buffer2)
	{
		if (state)
			stream_buffer2->Stop() ;
		else
			stream_buffer2->Play( 0, 0, DSBPLAY_LOOPING ) ;
	}
}

