#include "zlib.h"

#include "m68000.h"
#include "dmac.h"
#include "windrv.h"


int M288_savecontextA( unsigned char *buf );
int M288_savecontextB( unsigned char *buf );
int M288_loadcontextA( unsigned char *buf );
int M288_loadcontextB( unsigned char *buf );
int OPM_savecontext( unsigned char *buf );
int OPM_loadcontext( unsigned char *buf );


DWORD FASTCALL FDC_Int(BYTE irq) ;
DWORD FASTCALL FDD_Int(BYTE irq) ;
DWORD FASTCALL IRQH_DefaultVector(BYTE irq);
DWORD FASTCALL Mcry_IntCB(BYTE irq);
DWORD FASTCALL MFP_IntCallback(BYTE irq);
DWORD FASTCALL MIDI_Int(BYTE irq) ;
DWORD FASTCALL SASI_Int(BYTE irq) ;
DWORD FASTCALL SCC_Int(BYTE irq) ;

extern	m68k_regs regs;

#define ADPCM_BufSize      96000
#define Mcry_BufSize             48000*2
#define MIDIBUFFERS 1024
#define KeyBufSize 128
#define MIDIDELAYBUF 4096
#define MAX_PATH_TBL      64

typedef struct {
	BYTE	type;
	BYTE	trkflag[170];
	BYTE	headerinfo[15];
	BYTE	date[4];
	BYTE	time[4];
	BYTE	comment[61];
	BYTE	overtrack;
} DIM_HEADER;

typedef struct {
	DWORD time;
	BYTE msg;
} DELAYBUFITEM;

typedef struct {
	BYTE PortA;
	BYTE PortB;
	BYTE PortC;
	BYTE Ctrl;
} PIA;

typedef struct {
	int cmd;

	int cyl;
	int drv;
	int ready;
	int ctrl;
	int wexec;

	int rdptr;
	int wrptr;
	int rdnum;
	int wrnum;
	int bufnum;
	int st0;
	int st1;
	int st2;
	BYTE RspBuf[10];
	BYTE PrmBuf[10];
	BYTE DataBuf[0x8000];
	BYTE ScanBuf[0x8000];
} FDC;

typedef struct {
	int SetDelay[4];
	int Types[4];
	int ROnly[4];
	int EMask[4];
	int Blink[4];
	int Access;
} FDDINFO;

extern int ADPCM_VolumeShift ;
extern int dif_table[49*16];
extern signed short ADPCM_BufR[ADPCM_BufSize];
extern signed short ADPCM_BufL[ADPCM_BufSize];

extern long ADPCM_WrPtr ;
extern long ADPCM_RdPtr ;
extern DWORD ADPCM_SampleRate ;
extern DWORD ADPCM_ClockRate ;
extern DWORD ADPCM_Count ;
extern int ADPCM_Step ;
extern int ADPCM_Out ;
extern BYTE ADPCM_Playing ;
extern BYTE ADPCM_Clock ;
extern int ADPCM_PreCounter;
extern int ADPCM_DifBuf ;


extern int ADPCM_Pan ;
extern int OldR , OldL;
extern int Outs[8];
extern int OutsIp[4];
extern int OutsIpR[4];
extern int OutsIpL[4];


//-------------------------------

//bg.c

extern 	BYTE	BG[0x8000];
extern BYTE	Sprite_Regs[0x800];
extern BYTE	BG_Regs[0x12];
extern WORD	BG_CHREND ;
extern WORD	BG_BG0TOP ;
extern WORD	BG_BG0END ;
extern WORD	BG_BG1TOP ;
extern WORD	BG_BG1END ;
extern BYTE	BG_CHRSIZE ;
extern DWORD	BG_AdrMask ;
extern DWORD	BG0ScrollX , BG0ScrollY ;
extern DWORD	BG1ScrollX , BG1ScrollY ;

extern long	BG_HAdjust ;
extern long	BG_VLINE ;

extern BYTE	BG_Dirty0[64*64];
extern BYTE	BG_Dirty1[64*64];
extern BYTE	BGCHR8[8*8*256];
extern BYTE	BGCHR16[16*16*256];

extern WORD	BG_LineBuf[1600];
extern WORD	BG_PriBuf[1600];

extern DWORD	VLINEBG ;


//------------------------------

//crtc.c

extern 	BYTE	CRTC_Regs[24*2];
extern BYTE	CRTC_Mode ;
extern DWORD	TextDotX , TextDotY ;
extern WORD	CRTC_VSTART, CRTC_VEND;
extern WORD	CRTC_HSTART, CRTC_HEND;
extern DWORD	TextScrollX , TextScrollY ;
extern DWORD	GrphScrollX[4] ;		// zɂc
extern DWORD	GrphScrollY[4] ;

extern BYTE	CRTC_FastClr ;
extern BYTE	CRTC_SispScan ;
extern DWORD	CRTC_FastClrLine ;
extern WORD	CRTC_FastClrMask ;
extern WORD	CRTC_IntLine ;
extern BYTE	CRTC_VStep ;

extern BYTE	VCReg0[2] ;
extern BYTE	VCReg1[2] ;
extern BYTE	VCReg2[2] ;

extern BYTE	CRTC_RCFlag[2] ;
extern int HSYNC_CLK ;

//--------------------------

//disk_d88.c

typedef struct {
	BYTE	c;
	BYTE	h;
	BYTE	r;
	BYTE	n;
	WORD	sectors;		// Sector Count
	BYTE	mfm_flg;		// sides
	BYTE	del_flg;		// DELETED DATA
	BYTE	stat;			// STATUS (FDC ret)
	BYTE	reserved2[5];		// Reserved
	WORD	size;			// Sector Size
//	byte	data[0];		// Sector Data
} D88_SECTOR;

typedef struct D88_SECTINFO {
	struct D88_SECTINFO* next;
	D88_SECTOR sect;
} D88_SECTINFO;

extern D88_SECTINFO* D88Cur[4] ;
extern D88_SECTINFO* D88Top[4] ;
extern D88_SECTINFO* D88Trks[4][164];

//D88Cur and D88Top are pointers to ( static D88_SECTINFO* D88Trks[4][164]->next; ) objects


//traverse D88Trks[0][0-163]->next - for each one, write out the D88_SECTOR and sect.size data


//----------------------------

//disk_dim.c

extern int            DIMCur[4] ;
extern int            DIMTrk[4] ;
extern unsigned char* DIMImg[4] ;

//	DIMImg[drv] = (unsigned char*)malloc(1024*9*170+sizeof(DIM_HEADER));		// Maximum size


//----------------------------

//disk_xdf.c

extern int            XDFCur[4] ;
extern int            XDFTrk[4] ;
extern unsigned char* XDFImg[4] ;


	//XDFImg[drv] = (unsigned char*)malloc(1261568);


//--------------------------------

//dmac.c

extern dmac_ch	DMA[4];
extern int dmatrace ;

extern int DMA_IntCH ;
extern int DMA_LastInt ;

//-----------------------------------

//fdc.c

extern FDC fdc;

//-----------------------------------

//fdd.c

extern FDDINFO fdd;


//------------------------------------

//gvram.c

extern BYTE	GVRAM[0x80000];
extern WORD	Grp_LineBuf[1024];
extern WORD	Grp_LineBufSP[1024];		// vCIeB^pobt@
extern WORD	Grp_LineBufSP2[1024];		// x[Xv[pobt@i񔼓rbgi[j
extern WORD	Pal16Adr[256];			// 16bit color pbgAhXvZp

//--------------------------------
//ioc.c

extern 	BYTE	IOC_IntStat ;
extern BYTE	IOC_IntVect ;


//-----------------------------------------

//irq.c

extern BYTE	IRQH_IRQ[8];
extern void	*IRQH_CallBack[8];

//IRQH_Callback can be one of:

//NULL,
//&DMA_Int
//&FDC_Int
//&FDC_Int
//&Mcry_IntCB
//&MFP_IntCallback
//&MIDI_Int
//&SASI_Int
//&SCC_Int
//&IRQH_DefaultVector

//--------------------------------

//mem_wrap.c

extern	BYTE*	MEM;
extern	BYTE*	IPL;
extern	BYTE*	OP_ROM;
extern	BYTE*	FONT;
extern	BYTE	traceflag;


extern    DWORD   BusErrFlag;
extern    DWORD   MemByteAccess;
extern    int     m68000_ICount;
extern    int     m68000_ICountBk;
extern int     ICount;

 //MEM = (BYTE*)malloc(0xc00000);
 //IPL = (BYTE*)malloc(0x40000);
//FONT = (BYTE*)malloc(0xc0000);

//OP_ROM is one of:

//MEM
//GVRAM-0xc00000;  
//SRAM-0xed0000;
//TVRAM-0xe00000;
//_SCSIIPL - 0ea0000h
//IPL-0xfc0000;


//--------------------------------------------

//mercury.c

extern long	Mcry_WrPtr ;
extern long	Mcry_RdPtr ;
extern long	Mcry_SampleRate ;
extern long	Mcry_ClockRate ;
extern long	Mcry_Count ;
extern BYTE	Mcry_Status ;
extern BYTE	Mcry_LRTiming ;
extern short	Mcry_OutDataL ;
extern short	Mcry_OutDataR ;
extern short	Mcry_BufL[Mcry_BufSize];
extern short	Mcry_BufR[Mcry_BufSize];
extern long	Mcry_PreCounter ;

extern short	Mcry_OldR, Mcry_OldL;
extern int	Mcry_DMABytes ;

extern double Mcry_VolumeShift ;
extern int Mcry_SampleCnt ;
extern BYTE Mcry_Vector ;

//-------------------------------

//mfp.c

extern BYTE testflag;
extern BYTE LastKey ;

extern BYTE MFP[24];
extern BYTE Timer_TBO ;
extern BYTE Timer_Reload[4] ;
extern int Timer_Tick[4] ;

//-----------------------------

//midi.c

extern int		MIDI_CTRL;
extern int		MIDI_POS;
extern int		MIDI_SYSCOUNT;
extern BYTE		MIDI_LAST;
extern BYTE		MIDI_BUF[MIDIBUFFERS];
extern BYTE		MIDI_EXCVBUF[MIDIBUFFERS];
extern BYTE		MIDI_EXCVWAIT;

extern BYTE		MIDI_RegHigh ;				// X68Kp
extern BYTE		MIDI_Playing ;				// }X^XCb`
extern BYTE		MIDI_Vector ;
extern BYTE		MIDI_IntEnable ;
extern BYTE		MIDI_IntVect ;
extern BYTE		MIDI_IntFlag ;
extern DWORD		MIDI_Buffered ;
extern long		MIDI_BufTimer ;
extern BYTE		MIDI_R05 ;
extern DWORD		MIDI_GTimerMax ;
extern DWORD		MIDI_MTimerMax ;
extern long		MIDI_GTimerVal ;
extern long		MIDI_MTimerVal ;
extern BYTE		MIDI_TxFull ;
extern BYTE		MIDI_MODULE ;


extern DELAYBUFITEM DelayBuf[MIDIDELAYBUF];
extern int DBufPtrW ;
extern int DBufPtrR ;

extern BYTE		LOADED_TONEMAP ;
extern BYTE		ENABLE_TONEMAP ;
extern BYTE		TONE_CH[16];
extern BYTE		TONEBANK[3][128];
extern BYTE		TONEMAP[3][128];

//---------------------------

//palette.c

extern BYTE	Pal_Regs[1024];
extern WORD	TextPal[256];
extern WORD	GrphPal[256];
extern WORD	Pal16[65536];
extern WORD	Ibit;				// ƂŎg`

extern WORD	Pal_HalfMask, Pal_Ix2;
extern WORD	Pal_R, Pal_G, Pal_B;		// ʋPxύXp


//--------------------

//pia.c

extern PIA pia;

//-----------------

//rtc.c

extern BYTE	RTC_Regs[2][16];
extern BYTE	RTC_Bank ;
extern int RTC_Timer1 ;
extern int RTC_Timer16 ;

//--------------------

//sasi.c

extern BYTE SASI_Buf[256];
extern BYTE SASI_Phase ;
extern DWORD SASI_Sector ;
extern DWORD SASI_Blocks ;
extern BYTE SASI_Cmd[6];
extern BYTE SASI_CmdPtr ;
extern WORD SASI_Device ;
extern BYTE SASI_Unit ;
extern short SASI_BufPtr ;
extern BYTE SASI_RW ;
extern BYTE SASI_Stat ;
extern BYTE SASI_Mes ;
extern BYTE SASI_Error ;
extern BYTE SASI_SenseStatBuf[4];
extern BYTE SASI_SenseStatPtr ;
extern int hddtrace;

//------------------------

//scc.c

extern signed char MouseX ;
extern signed char MouseY ;
extern BYTE MouseSt ;

extern BYTE SCC_RegsA[16] ;
extern BYTE SCC_RegNumA ;
extern BYTE SCC_RegSetA ;
extern BYTE SCC_RegsB[16] ;
extern BYTE SCC_RegNumB ;
extern BYTE SCC_RegSetB ;
extern BYTE SCC_Vector ;
extern BYTE SCC_Dat[3] ;
extern BYTE SCC_DatNum ;

//----------------------

//scsi.c

extern 	BYTE	SCSIIPL[0x2000];

//-----------------

//sram.c

extern 	BYTE	SRAM[0x4000];
//-------------------

//sysport.c

extern BYTE	SysPort[7];

//------------------
//tvram.c

extern BYTE	TVRAM[0x80000];
extern BYTE	TextDrawWork[1024*1024];
extern BYTE	TextDirtyLine[1024];
extern BYTE	TextDrawPattern[2048*4];
extern BYTE	Text_TrFlag[1024];

//----------------------------

//windrv.c

extern path_buff_s	path_tbl[MAX_PATH_TBL];	//FCBpathׂ̃e[u
extern int	path_cur_prio;
extern char	win_letter;
extern int	num_win_drv;
extern char	win_drvs[32];

extern files_buff_s files_tbl[MAX_FILES_TBL];
extern int files_next;		//pointer
extern int files_num;
extern int fatr;

extern int	gr_files ;
extern char	gr_buf[16][256];


//--------------------------


//joystick.c

extern BYTE JoyKeyState0 ;
extern BYTE JoyKeyState1 ;
extern BYTE JoyState0[2] ;
extern BYTE JoyState1[2] ;
extern BYTE JoyPortData[2] ;

//---------------------

//juliet.c


//------------------

//keyboard.c

extern BYTE	KeyBufWP;
extern BYTE	KeyBufRP;
extern BYTE	KeyBuf[KeyBufSize];
extern BYTE	KeyEnable ;
extern BYTE	KeyIntFlag ;

//---------------------

//windraw.c

extern 	int	Draw_Opaque;
extern int	FullScreenFlag ;
extern	BYTE	Draw_DrawFlag ;
extern 	BYTE	Draw_ClrMenu ;
extern BYTE            Debug_Text, Debug_Grp, Debug_Sp;
extern 	BYTE	Draw_BitMask[800];
extern BYTE	Draw_TextBitMask[800];
extern int	winx, winy;
extern int	winh, winw;
extern WORD	FrameCount ;
extern int	SplashFlag ;
extern WORD	WinDraw_Pal16B, WinDraw_Pal16R, WinDraw_Pal16G;
extern int	WindowX ;
extern int	WindowY ;

//-----------------------

//mouse68k

extern int	MousePosX ;
extern int	MousePosY ;
extern BYTE	MouseStat ;
extern BYTE	MouseSW ;
extern POINT	CursorPos;
extern int	mousex, mousey;

//--------------

//winx68k.c

extern WORD      VLINE_TOTAL ;
extern DWORD     VLINE ;
extern DWORD     vline ;
extern BYTE DispFrame ;
extern DWORD SoundSampleRate;
extern int CurFrameRate ;
extern int NoWaitMode ;
extern int ClkUsed ;
extern int FrameSkipCount ;
extern int FrameSkipQueue ;



void save_state( char *filename )
{
	gzFile outfile ;
	int val, i   ;
	unsigned char *buf ;
	int numbytes ;

	outfile = gzopen( filename, "wb" ) ;

	if ( outfile == NULL )
		return ;


gzwrite( outfile, &ADPCM_VolumeShift, sizeof(int) ) ;
gzwrite( outfile, &ADPCM_WrPtr, sizeof(long) ) ;
gzwrite( outfile, &ADPCM_RdPtr, sizeof(long) ) ;
gzwrite( outfile, &ADPCM_SampleRate, sizeof(DWORD) ) ;
gzwrite( outfile, &ADPCM_ClockRate, sizeof(DWORD) ) ;
gzwrite( outfile, &ADPCM_Count, sizeof(DWORD) ) ;
gzwrite( outfile, &ADPCM_Step, sizeof(int) ) ;
gzwrite( outfile, &ADPCM_Out, sizeof(int) ) ;
gzwrite( outfile, &ADPCM_Playing, sizeof(BYTE) ) ;
gzwrite( outfile, &ADPCM_Clock, sizeof(BYTE) ) ;
gzwrite( outfile, &ADPCM_PreCounter, sizeof(int) ) ;
gzwrite( outfile, &ADPCM_DifBuf, sizeof(int) ) ;
gzwrite( outfile, &ADPCM_Pan, sizeof(int) ) ;
gzwrite( outfile, &OldR, sizeof(int) ) ;
gzwrite( outfile, &OldL, sizeof(int) ) ;
gzwrite( outfile, &BG_CHREND, sizeof(WORD) ) ;
gzwrite( outfile, &BG_BG0TOP, sizeof(WORD) ) ;
gzwrite( outfile, &BG_BG0END, sizeof(WORD) ) ;
gzwrite( outfile, &BG_BG1TOP, sizeof(WORD) ) ;
gzwrite( outfile, &BG_BG1END, sizeof(WORD) ) ;
gzwrite( outfile, &BG_CHRSIZE, sizeof(BYTE) ) ;
gzwrite( outfile, &BG_AdrMask, sizeof(DWORD) ) ;
gzwrite( outfile, &BG0ScrollX, sizeof(DWORD) ) ;
gzwrite( outfile, &BG0ScrollY, sizeof(DWORD) ) ;
gzwrite( outfile, &BG1ScrollX, sizeof(DWORD) ) ;
gzwrite( outfile, &BG1ScrollY, sizeof(DWORD) ) ;
gzwrite( outfile, &BG_HAdjust, sizeof(long) ) ;
gzwrite( outfile, &BG_VLINE, sizeof(long) ) ;
gzwrite( outfile, &VLINEBG, sizeof(DWORD) ) ;
gzwrite( outfile, &CRTC_Mode, sizeof(BYTE) ) ;
gzwrite( outfile, &TextDotX, sizeof(DWORD) ) ;
gzwrite( outfile, &TextDotY, sizeof(DWORD) ) ;
gzwrite( outfile, &CRTC_VSTART, sizeof(WORD) ) ;
gzwrite( outfile, &CRTC_VEND, sizeof(WORD) ) ;
gzwrite( outfile, &CRTC_HSTART, sizeof(WORD) ) ;
gzwrite( outfile, &CRTC_HEND, sizeof(WORD) ) ;
gzwrite( outfile, &TextScrollX, sizeof(DWORD) ) ;
gzwrite( outfile, &TextScrollY, sizeof(DWORD) ) ;
gzwrite( outfile, &CRTC_FastClr, sizeof(BYTE) ) ;
gzwrite( outfile, &CRTC_SispScan, sizeof(BYTE) ) ;
gzwrite( outfile, &CRTC_FastClrLine, sizeof(DWORD) ) ;
gzwrite( outfile, &CRTC_FastClrMask, sizeof(WORD) ) ;
gzwrite( outfile, &CRTC_IntLine, sizeof(WORD) ) ;
gzwrite( outfile, &CRTC_VStep, sizeof(BYTE) ) ;
gzwrite( outfile, &HSYNC_CLK, sizeof(int) ) ;
gzwrite( outfile, &dmatrace, sizeof(int) ) ;
gzwrite( outfile, &DMA_IntCH, sizeof(int) ) ;
gzwrite( outfile, &DMA_LastInt, sizeof(int) ) ;
gzwrite( outfile, &fdc, sizeof(FDC) ) ;
gzwrite( outfile, &fdd, sizeof(FDDINFO) ) ;
gzwrite( outfile, &IOC_IntStat, sizeof(BYTE) ) ;
gzwrite( outfile, &IOC_IntVect, sizeof(BYTE) ) ;
gzwrite( outfile, &traceflag, sizeof(BYTE) ) ;
gzwrite( outfile, &BusErrFlag, sizeof(DWORD) ) ;
gzwrite( outfile, &MemByteAccess, sizeof(DWORD) ) ;
gzwrite( outfile, &m68000_ICount, sizeof(int) ) ;
gzwrite( outfile, &m68000_ICountBk, sizeof(int) ) ;
gzwrite( outfile, &ICount, sizeof(int) ) ;
gzwrite( outfile, &Mcry_WrPtr, sizeof(long) ) ;
gzwrite( outfile, &Mcry_RdPtr, sizeof(long) ) ;
gzwrite( outfile, &Mcry_SampleRate, sizeof(long) ) ;
gzwrite( outfile, &Mcry_ClockRate, sizeof(long) ) ;
gzwrite( outfile, &Mcry_Count, sizeof(long) ) ;
gzwrite( outfile, &Mcry_Status, sizeof(BYTE) ) ;
gzwrite( outfile, &Mcry_LRTiming, sizeof(BYTE) ) ;
gzwrite( outfile, &Mcry_OutDataL, sizeof(short) ) ;
gzwrite( outfile, &Mcry_OutDataR, sizeof(short) ) ;
gzwrite( outfile, &Mcry_PreCounter, sizeof(long) ) ;
gzwrite( outfile, &Mcry_OldR, sizeof(short) ) ;
gzwrite( outfile, &Mcry_OldL, sizeof(short) ) ;
gzwrite( outfile, &Mcry_DMABytes, sizeof(int) ) ;
gzwrite( outfile, &Mcry_VolumeShift, sizeof(double) ) ;
gzwrite( outfile, &Mcry_SampleCnt, sizeof(int) ) ;
gzwrite( outfile, &Mcry_Vector, sizeof(BYTE) ) ;
gzwrite( outfile, &testflag, sizeof(BYTE) ) ;
gzwrite( outfile, &LastKey, sizeof(BYTE) ) ;
gzwrite( outfile, &Timer_TBO, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_CTRL, sizeof(int) ) ;
gzwrite( outfile, &MIDI_POS, sizeof(int) ) ;
gzwrite( outfile, &MIDI_SYSCOUNT, sizeof(int) ) ;
gzwrite( outfile, &MIDI_LAST, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_EXCVWAIT, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_RegHigh, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_Playing, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_Vector, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_IntEnable, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_IntVect, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_IntFlag, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_Buffered, sizeof(DWORD) ) ;
gzwrite( outfile, &MIDI_BufTimer, sizeof(long) ) ;
gzwrite( outfile, &MIDI_R05, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_GTimerMax, sizeof(DWORD) ) ;
gzwrite( outfile, &MIDI_MTimerMax, sizeof(DWORD) ) ;
gzwrite( outfile, &MIDI_GTimerVal, sizeof(long) ) ;
gzwrite( outfile, &MIDI_MTimerVal, sizeof(long) ) ;
gzwrite( outfile, &MIDI_TxFull, sizeof(BYTE) ) ;
gzwrite( outfile, &MIDI_MODULE, sizeof(BYTE) ) ;
gzwrite( outfile, &DBufPtrW, sizeof(int) ) ;
gzwrite( outfile, &DBufPtrR, sizeof(int) ) ;
gzwrite( outfile, &LOADED_TONEMAP, sizeof(BYTE) ) ;
gzwrite( outfile, &ENABLE_TONEMAP, sizeof(BYTE) ) ;
gzwrite( outfile, &Ibit, sizeof(WORD) ) ;
gzwrite( outfile, &Pal_HalfMask, sizeof(WORD) ) ;
gzwrite( outfile, &Pal_Ix2, sizeof(WORD) ) ;
gzwrite( outfile, &Pal_R, sizeof(WORD) ) ;
gzwrite( outfile, &Pal_G, sizeof(WORD) ) ;
gzwrite( outfile, &Pal_B, sizeof(WORD) ) ;
gzwrite( outfile, &pia, sizeof(PIA) ) ;
gzwrite( outfile, &RTC_Bank, sizeof(BYTE) ) ;
gzwrite( outfile, &RTC_Timer1, sizeof(int) ) ;
gzwrite( outfile, &RTC_Timer16, sizeof(int) ) ;
gzwrite( outfile, &SASI_Phase, sizeof(BYTE) ) ;
gzwrite( outfile, &SASI_Sector, sizeof(DWORD) ) ;
gzwrite( outfile, &SASI_Blocks, sizeof(DWORD) ) ;
gzwrite( outfile, &SASI_CmdPtr, sizeof(BYTE) ) ;
gzwrite( outfile, &SASI_Device, sizeof(WORD) ) ;
gzwrite( outfile, &SASI_Unit, sizeof(BYTE) ) ;
gzwrite( outfile, &SASI_BufPtr, sizeof(short) ) ;
gzwrite( outfile, &SASI_RW, sizeof(BYTE) ) ;
gzwrite( outfile, &SASI_Stat, sizeof(BYTE) ) ;
gzwrite( outfile, &SASI_Mes, sizeof(BYTE) ) ;
gzwrite( outfile, &SASI_Error, sizeof(BYTE) ) ;
gzwrite( outfile, &SASI_SenseStatPtr, sizeof(BYTE) ) ;
gzwrite( outfile, &hddtrace, sizeof(int) ) ;
gzwrite( outfile, &MouseX, sizeof(signed char) ) ;
gzwrite( outfile, &MouseY, sizeof(signed char) ) ;
gzwrite( outfile, &MouseSt, sizeof(BYTE) ) ;
gzwrite( outfile, &SCC_RegNumA, sizeof(BYTE) ) ;
gzwrite( outfile, &SCC_RegSetA, sizeof(BYTE) ) ;
gzwrite( outfile, &SCC_RegNumB, sizeof(BYTE) ) ;
gzwrite( outfile, &SCC_RegSetB, sizeof(BYTE) ) ;
gzwrite( outfile, &SCC_Vector, sizeof(BYTE) ) ;
gzwrite( outfile, &SCC_DatNum, sizeof(BYTE) ) ;
gzwrite( outfile, &path_cur_prio, sizeof(int) ) ;
gzwrite( outfile, &win_letter, sizeof(char) ) ;
gzwrite( outfile, &num_win_drv, sizeof(int) ) ;
gzwrite( outfile, &files_next, sizeof(int) ) ;
gzwrite( outfile, &files_num, sizeof(int) ) ;
gzwrite( outfile, &fatr, sizeof(int) ) ;
gzwrite( outfile, &gr_files, sizeof(int) ) ;
gzwrite( outfile, &JoyKeyState0, sizeof(BYTE) ) ;
gzwrite( outfile, &JoyKeyState1, sizeof(BYTE) ) ;
gzwrite( outfile, &KeyBufWP, sizeof(BYTE) ) ;
gzwrite( outfile, &KeyBufRP, sizeof(BYTE) ) ;
gzwrite( outfile, &KeyEnable, sizeof(BYTE) ) ;
gzwrite( outfile, &KeyIntFlag, sizeof(BYTE) ) ;
gzwrite( outfile, &Draw_Opaque, sizeof(int) ) ;
gzwrite( outfile, &FullScreenFlag, sizeof(int) ) ;
gzwrite( outfile, &Draw_DrawFlag, sizeof(BYTE) ) ;
gzwrite( outfile, &Draw_ClrMenu, sizeof(BYTE) ) ;
gzwrite( outfile, &Debug_Text, sizeof(BYTE) ) ;
gzwrite( outfile, &Debug_Grp, sizeof(BYTE) ) ;
gzwrite( outfile, &Debug_Sp, sizeof(BYTE) ) ;
gzwrite( outfile, &winx, sizeof(int) ) ;
gzwrite( outfile, &winy, sizeof(int) ) ;
gzwrite( outfile, &winh, sizeof(int) ) ;
gzwrite( outfile, &winw, sizeof(int) ) ;
gzwrite( outfile, &FrameCount, sizeof(WORD) ) ;
gzwrite( outfile, &SplashFlag, sizeof(int) ) ;
gzwrite( outfile, &WinDraw_Pal16B, sizeof(WORD) ) ;
gzwrite( outfile, &WinDraw_Pal16R, sizeof(WORD) ) ;
gzwrite( outfile, &WinDraw_Pal16G, sizeof(WORD) ) ;
gzwrite( outfile, &WindowX, sizeof(int) ) ;
gzwrite( outfile, &WindowY, sizeof(int) ) ;
gzwrite( outfile, &MousePosX, sizeof(int) ) ;
gzwrite( outfile, &MousePosY, sizeof(int) ) ;
gzwrite( outfile, &MouseStat, sizeof(BYTE) ) ;
gzwrite( outfile, &MouseSW, sizeof(BYTE) ) ;
gzwrite( outfile, &CursorPos, sizeof(POINT) ) ;
gzwrite( outfile, &mousex, sizeof(int) ) ;
gzwrite( outfile, &mousey, sizeof(int) ) ;
gzwrite( outfile, &VLINE_TOTAL, sizeof(WORD) ) ;
gzwrite( outfile, &VLINE, sizeof(DWORD) ) ;
gzwrite( outfile, &vline, sizeof(DWORD) ) ;
gzwrite( outfile, &DispFrame, sizeof(BYTE) ) ;
gzwrite( outfile, &SoundSampleRate, sizeof(DWORD) ) ;
gzwrite( outfile, &CurFrameRate, sizeof(int) ) ;
gzwrite( outfile, &NoWaitMode, sizeof(int) ) ;
gzwrite( outfile, &ClkUsed, sizeof(int) ) ;
gzwrite( outfile, &FrameSkipCount, sizeof(int) ) ;
gzwrite( outfile, &FrameSkipQueue, sizeof(int) ) ;

gzwrite( outfile, ADPCM_BufR, sizeof(signed short)*ADPCM_BufSize) ;
gzwrite( outfile, ADPCM_BufL, sizeof(signed short)*ADPCM_BufSize) ;


gzwrite( outfile, dif_table, sizeof(int) * ( 49*16 ) ) ;
gzwrite( outfile, Outs, sizeof(int) * ( 8 ) ) ;
gzwrite( outfile, OutsIp, sizeof(int) * ( 4 ) ) ;
gzwrite( outfile, OutsIpR, sizeof(int) * ( 4 ) ) ;
gzwrite( outfile, OutsIpL, sizeof(int) * ( 4 ) ) ;
gzwrite( outfile, BG, sizeof(BYTE) * ( 0x8000 ) ) ;
gzwrite( outfile, Sprite_Regs, sizeof(BYTE) * ( 0x800 ) ) ;
gzwrite( outfile, BG_Regs, sizeof(BYTE) * ( 0x12 ) ) ;
gzwrite( outfile, BG_Dirty0, sizeof(BYTE) * ( 64*64 ) ) ;
gzwrite( outfile, BG_Dirty1, sizeof(BYTE) * ( 64*64 ) ) ;
gzwrite( outfile, BGCHR8, sizeof(BYTE) * ( 8*8*256 ) ) ;
gzwrite( outfile, BGCHR16, sizeof(BYTE) * ( 16*16*256 ) ) ;
gzwrite( outfile, BG_LineBuf, sizeof(WORD) * ( 1600 ) ) ;
gzwrite( outfile, BG_PriBuf, sizeof(WORD) * ( 1600 ) ) ;
gzwrite( outfile, CRTC_Regs, sizeof(BYTE) * ( 24*2 ) ) ;
gzwrite( outfile, GrphScrollX, sizeof(DWORD) * ( 4 ) ) ;
gzwrite( outfile, GrphScrollY, sizeof(DWORD) * ( 4 ) ) ;
gzwrite( outfile, VCReg0, sizeof(BYTE) * ( 2 ) ) ;
gzwrite( outfile, VCReg1, sizeof(BYTE) * ( 2 ) ) ;
gzwrite( outfile, VCReg2, sizeof(BYTE) * ( 2 ) ) ;
gzwrite( outfile, CRTC_RCFlag, sizeof(BYTE) * ( 2 ) ) ;
gzwrite( outfile, DIMCur, sizeof(int) * ( 4 ) ) ;
gzwrite( outfile, DIMTrk, sizeof(int) * ( 4 ) ) ;
gzwrite( outfile, XDFCur, sizeof(int) * ( 4 ) ) ;
gzwrite( outfile, XDFTrk, sizeof(int) * ( 4 ) ) ;
gzwrite( outfile, DMA, sizeof(dmac_ch) * ( 4 ) ) ;
gzwrite( outfile, GVRAM, sizeof(BYTE) * ( 0x80000 ) ) ;
gzwrite( outfile, Grp_LineBuf, sizeof(WORD) * ( 1024 ) ) ;
gzwrite( outfile, Grp_LineBufSP, sizeof(WORD) * ( 1024 ) ) ;
gzwrite( outfile, Grp_LineBufSP2, sizeof(WORD) * ( 1024 ) ) ;
gzwrite( outfile, Pal16Adr, sizeof(WORD) * ( 256 ) ) ;
gzwrite( outfile, IRQH_IRQ, sizeof(BYTE) * ( 8 ) ) ;
gzwrite( outfile, Mcry_BufL, sizeof(short) * ( Mcry_BufSize ) ) ;
gzwrite( outfile, Mcry_BufR, sizeof(short) * ( Mcry_BufSize ) ) ;
gzwrite( outfile, MFP, sizeof(BYTE) * ( 24 ) ) ;
gzwrite( outfile, Timer_Reload, sizeof(BYTE) * ( 4 ) ) ;
gzwrite( outfile, Timer_Tick, sizeof(int) * ( 4 ) ) ;
gzwrite( outfile, MIDI_BUF, sizeof(BYTE) * ( MIDIBUFFERS ) ) ;
gzwrite( outfile, MIDI_EXCVBUF, sizeof(BYTE) * ( MIDIBUFFERS ) ) ;
gzwrite( outfile, DelayBuf, sizeof(DELAYBUFITEM) * ( MIDIDELAYBUF ) ) ;
gzwrite( outfile, TONE_CH, sizeof(BYTE) * ( 16 ) ) ;
gzwrite( outfile, Pal_Regs, sizeof(BYTE) * ( 1024 ) ) ;
gzwrite( outfile, TextPal, sizeof(WORD) * ( 256 ) ) ;
gzwrite( outfile, GrphPal, sizeof(WORD) * ( 256 ) ) ;
gzwrite( outfile, Pal16, sizeof(WORD) * ( 65536 ) ) ;
gzwrite( outfile, SASI_Buf, sizeof(BYTE) * ( 256 ) ) ;
gzwrite( outfile, SASI_Cmd, sizeof(BYTE) * ( 6 ) ) ;
gzwrite( outfile, SASI_SenseStatBuf, sizeof(BYTE) * ( 4 ) ) ;
gzwrite( outfile, SCC_RegsA, sizeof(BYTE) * ( 16 ) ) ;
gzwrite( outfile, SCC_RegsB, sizeof(BYTE) * ( 16 ) ) ;
gzwrite( outfile, SCC_Dat, sizeof(BYTE) * ( 3 ) ) ;
gzwrite( outfile, SCSIIPL, sizeof(BYTE) * ( 0x2000 ) ) ;
gzwrite( outfile, SRAM, sizeof(BYTE) * ( 0x4000 ) ) ;
gzwrite( outfile, SysPort, sizeof(BYTE) * ( 7 ) ) ;
gzwrite( outfile, TVRAM, sizeof(BYTE) * ( 0x80000 ) ) ;
gzwrite( outfile, TextDrawWork, sizeof(BYTE) * ( 1024*1024 ) ) ;
gzwrite( outfile, TextDirtyLine, sizeof(BYTE) * ( 1024 ) ) ;
gzwrite( outfile, TextDrawPattern, sizeof(BYTE) * ( 2048*4 ) ) ;
gzwrite( outfile, Text_TrFlag, sizeof(BYTE) * ( 1024 ) ) ;
gzwrite( outfile, path_tbl, sizeof(path_buff_s) * ( MAX_PATH_TBL ) ) ;
gzwrite( outfile, win_drvs, sizeof(char) * ( 32 ) ) ;
gzwrite( outfile, files_tbl, sizeof(files_buff_s) * ( MAX_FILES_TBL ) ) ;
gzwrite( outfile, JoyState0, sizeof(BYTE) * ( 2 ) ) ;
gzwrite( outfile, JoyState1, sizeof(BYTE) * ( 2 ) ) ;
gzwrite( outfile, JoyPortData, sizeof(BYTE) * ( 2 ) ) ;
gzwrite( outfile, KeyBuf, sizeof(BYTE) * ( KeyBufSize ) ) ;
gzwrite( outfile, Draw_BitMask, sizeof(BYTE) * ( 800 ) ) ;
gzwrite( outfile, Draw_TextBitMask, sizeof(BYTE) * ( 800 ) ) ;

gzwrite( outfile, TONEBANK, sizeof(BYTE) * ( 3*128 ) ) ;
gzwrite( outfile, TONEMAP, sizeof(BYTE) * ( 3*128 ) ) ;
gzwrite( outfile, RTC_Regs, sizeof(BYTE) * ( 2*16 ) ) ;
gzwrite( outfile, gr_buf, sizeof(char) * ( 16*256 ) ) ;

gzwrite( outfile, MEM, 0xc00000 ) ;
gzwrite( outfile, IPL, 0x40000 ) ;
gzwrite( outfile, FONT, 0xc0000 ) ;


if ( OP_ROM == MEM )
{
   val = 1 ;
}
else if ( OP_ROM == ( GVRAM-0xc00000 ) )
{
   val = 2 ;
}
else if ( OP_ROM == (SRAM-0xed0000) )
{
   val = 3 ;
}
else if ( OP_ROM == (TVRAM-0xe00000) )
{
   val = 4 ;
}
else if ( OP_ROM == (SCSIIPL - 0x0ea0000) )
{
   val = 5 ;
}
else if ( OP_ROM == (IPL-0xfc0000) )
{
   val = 6 ;
}
else
{
	val = 0 ; //should never get here
}


gzwrite( outfile, &val, sizeof(int) ) ;


for ( i = 0 ; i < 4 ; i++ )
{
	if ( DIMImg[i] )
	{
		val = 1 ;
		gzwrite( outfile, &val, sizeof(int) ) ;
		gzwrite( outfile, DIMImg[i], 1024*9*170+sizeof(DIM_HEADER) ) ;
	}
	else
	{
		val = 0 ;
		gzwrite( outfile, &val, sizeof(int) ) ;
	}

	if ( XDFImg[i] )
	{
		val = 1 ;
		gzwrite( outfile, &val, sizeof(int) ) ;
		gzwrite( outfile, XDFImg[i], 1261568 ) ;
	}
	else
	{
		val = 0 ;
		gzwrite( outfile, &val, sizeof(int) ) ;
	}
}

for( i = 0 ; i < 8 ; i++ )
{
	val = 0 ;

	if ( IRQH_CallBack[i] == &IRQH_DefaultVector )
	{
		val = 1 ;
	}
	else if ( IRQH_CallBack[i] == &DMA_Int )
	{
		val = 2;
	}
	else if ( IRQH_CallBack[i] == &FDC_Int )
	{
		val = 3;
	}
	else if ( IRQH_CallBack[i] == &FDD_Int )
	{
		val = 4;
	}
	else if ( IRQH_CallBack[i] == &Mcry_IntCB )
	{
		val = 5;
	}
	else if ( IRQH_CallBack[i] == &MFP_IntCallback )
	{
		val = 6;
	}
	else if ( IRQH_CallBack[i] == &MIDI_Int )
	{
		val = 7;
	}
	else if ( IRQH_CallBack[i] == &SASI_Int )
	{
		val = 8;
	}
	else if ( IRQH_CallBack[i] == &SCC_Int )
	{
		val = 9;
	}
	else
	{
		val = (int)(IRQH_CallBack[i]) ;
	}

	gzwrite( outfile, &val, sizeof(int)) ;


}


gzwrite( outfile, &regs, sizeof(m68k_regs) ) ;


	val = 0 ;

	if ( regs.irq_callback == &IRQH_DefaultVector )
	{
		val = 1 ;
	}
	else if ( regs.irq_callback == &DMA_Int )
	{
		val = 2;
	}
	else if ( regs.irq_callback == &FDC_Int )
	{
		val = 3;
	}
	else if ( regs.irq_callback == &FDD_Int )
	{
		val = 4;
	}
	else if ( regs.irq_callback == &Mcry_IntCB )
	{
		val = 5;
	}
	else if ( regs.irq_callback == &MFP_IntCallback )
	{
		val = 6;
	}
	else if ( regs.irq_callback == &MIDI_Int )
	{
		val = 7;
	}
	else if ( regs.irq_callback == &SASI_Int )
	{
		val = 8;
	}
	else if ( regs.irq_callback == &SCC_Int )
	{
		val = 9;
	}
	else
	{
		val = (int)(regs.irq_callback) ;
	}

	gzwrite( outfile, &val, sizeof(int)) ;




	buf = malloc( 2000000 ) ;

	numbytes = OPM_savecontext( buf ) ;

	gzwrite( outfile, &numbytes, sizeof(int)) ;
	gzwrite( outfile, buf, numbytes) ;


	numbytes = M288_savecontextA( buf ) ;

	gzwrite( outfile, &numbytes, sizeof(int)) ;
	gzwrite( outfile, buf, numbytes) ;

	numbytes = M288_savecontextB( buf ) ;

	gzwrite( outfile, &numbytes, sizeof(int)) ;
	gzwrite( outfile, buf, numbytes) ;

	free(buf) ;

	gzclose( outfile ) ;


#if 0



//extern D88_SECTINFO* D88Cur[4] ;
//extern D88_SECTINFO* D88Top[4] ;
//extern D88_SECTINFO* D88Trks[4][164];


#endif

}


void load_state( char *filename )
{
	gzFile outfile ;
	int val, i   ;
	int numbytes ;
	unsigned char *buf ;

	outfile = gzopen( filename, "rb" ) ;

	if ( outfile == NULL )
		return ;


gzread( outfile, &ADPCM_VolumeShift, sizeof(int) ) ;
gzread( outfile, &ADPCM_WrPtr, sizeof(long) ) ;
gzread( outfile, &ADPCM_RdPtr, sizeof(long) ) ;
gzread( outfile, &ADPCM_SampleRate, sizeof(DWORD) ) ;
gzread( outfile, &ADPCM_ClockRate, sizeof(DWORD) ) ;
gzread( outfile, &ADPCM_Count, sizeof(DWORD) ) ;
gzread( outfile, &ADPCM_Step, sizeof(int) ) ;
gzread( outfile, &ADPCM_Out, sizeof(int) ) ;
gzread( outfile, &ADPCM_Playing, sizeof(BYTE) ) ;
gzread( outfile, &ADPCM_Clock, sizeof(BYTE) ) ;
gzread( outfile, &ADPCM_PreCounter, sizeof(int) ) ;
gzread( outfile, &ADPCM_DifBuf, sizeof(int) ) ;
gzread( outfile, &ADPCM_Pan, sizeof(int) ) ;
gzread( outfile, &OldR, sizeof(int) ) ;
gzread( outfile, &OldL, sizeof(int) ) ;
gzread( outfile, &BG_CHREND, sizeof(WORD) ) ;
gzread( outfile, &BG_BG0TOP, sizeof(WORD) ) ;
gzread( outfile, &BG_BG0END, sizeof(WORD) ) ;
gzread( outfile, &BG_BG1TOP, sizeof(WORD) ) ;
gzread( outfile, &BG_BG1END, sizeof(WORD) ) ;
gzread( outfile, &BG_CHRSIZE, sizeof(BYTE) ) ;
gzread( outfile, &BG_AdrMask, sizeof(DWORD) ) ;
gzread( outfile, &BG0ScrollX, sizeof(DWORD) ) ;
gzread( outfile, &BG0ScrollY, sizeof(DWORD) ) ;
gzread( outfile, &BG1ScrollX, sizeof(DWORD) ) ;
gzread( outfile, &BG1ScrollY, sizeof(DWORD) ) ;
gzread( outfile, &BG_HAdjust, sizeof(long) ) ;
gzread( outfile, &BG_VLINE, sizeof(long) ) ;
gzread( outfile, &VLINEBG, sizeof(DWORD) ) ;
gzread( outfile, &CRTC_Mode, sizeof(BYTE) ) ;
gzread( outfile, &TextDotX, sizeof(DWORD) ) ;
gzread( outfile, &TextDotY, sizeof(DWORD) ) ;
gzread( outfile, &CRTC_VSTART, sizeof(WORD) ) ;
gzread( outfile, &CRTC_VEND, sizeof(WORD) ) ;
gzread( outfile, &CRTC_HSTART, sizeof(WORD) ) ;
gzread( outfile, &CRTC_HEND, sizeof(WORD) ) ;
gzread( outfile, &TextScrollX, sizeof(DWORD) ) ;
gzread( outfile, &TextScrollY, sizeof(DWORD) ) ;
gzread( outfile, &CRTC_FastClr, sizeof(BYTE) ) ;
gzread( outfile, &CRTC_SispScan, sizeof(BYTE) ) ;
gzread( outfile, &CRTC_FastClrLine, sizeof(DWORD) ) ;
gzread( outfile, &CRTC_FastClrMask, sizeof(WORD) ) ;
gzread( outfile, &CRTC_IntLine, sizeof(WORD) ) ;
gzread( outfile, &CRTC_VStep, sizeof(BYTE) ) ;
gzread( outfile, &HSYNC_CLK, sizeof(int) ) ;
gzread( outfile, &dmatrace, sizeof(int) ) ;
gzread( outfile, &DMA_IntCH, sizeof(int) ) ;
gzread( outfile, &DMA_LastInt, sizeof(int) ) ;
gzread( outfile, &fdc, sizeof(FDC) ) ;
gzread( outfile, &fdd, sizeof(FDDINFO) ) ;
gzread( outfile, &IOC_IntStat, sizeof(BYTE) ) ;
gzread( outfile, &IOC_IntVect, sizeof(BYTE) ) ;
gzread( outfile, &traceflag, sizeof(BYTE) ) ;
gzread( outfile, &BusErrFlag, sizeof(DWORD) ) ;
gzread( outfile, &MemByteAccess, sizeof(DWORD) ) ;
gzread( outfile, &m68000_ICount, sizeof(int) ) ;
gzread( outfile, &m68000_ICountBk, sizeof(int) ) ;
gzread( outfile, &ICount, sizeof(int) ) ;
gzread( outfile, &Mcry_WrPtr, sizeof(long) ) ;
gzread( outfile, &Mcry_RdPtr, sizeof(long) ) ;
gzread( outfile, &Mcry_SampleRate, sizeof(long) ) ;
gzread( outfile, &Mcry_ClockRate, sizeof(long) ) ;
gzread( outfile, &Mcry_Count, sizeof(long) ) ;
gzread( outfile, &Mcry_Status, sizeof(BYTE) ) ;
gzread( outfile, &Mcry_LRTiming, sizeof(BYTE) ) ;
gzread( outfile, &Mcry_OutDataL, sizeof(short) ) ;
gzread( outfile, &Mcry_OutDataR, sizeof(short) ) ;
gzread( outfile, &Mcry_PreCounter, sizeof(long) ) ;
gzread( outfile, &Mcry_OldR, sizeof(short) ) ;
gzread( outfile, &Mcry_OldL, sizeof(short) ) ;
gzread( outfile, &Mcry_DMABytes, sizeof(int) ) ;
gzread( outfile, &Mcry_VolumeShift, sizeof(double) ) ;
gzread( outfile, &Mcry_SampleCnt, sizeof(int) ) ;
gzread( outfile, &Mcry_Vector, sizeof(BYTE) ) ;
gzread( outfile, &testflag, sizeof(BYTE) ) ;
gzread( outfile, &LastKey, sizeof(BYTE) ) ;
gzread( outfile, &Timer_TBO, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_CTRL, sizeof(int) ) ;
gzread( outfile, &MIDI_POS, sizeof(int) ) ;
gzread( outfile, &MIDI_SYSCOUNT, sizeof(int) ) ;
gzread( outfile, &MIDI_LAST, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_EXCVWAIT, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_RegHigh, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_Playing, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_Vector, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_IntEnable, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_IntVect, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_IntFlag, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_Buffered, sizeof(DWORD) ) ;
gzread( outfile, &MIDI_BufTimer, sizeof(long) ) ;
gzread( outfile, &MIDI_R05, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_GTimerMax, sizeof(DWORD) ) ;
gzread( outfile, &MIDI_MTimerMax, sizeof(DWORD) ) ;
gzread( outfile, &MIDI_GTimerVal, sizeof(long) ) ;
gzread( outfile, &MIDI_MTimerVal, sizeof(long) ) ;
gzread( outfile, &MIDI_TxFull, sizeof(BYTE) ) ;
gzread( outfile, &MIDI_MODULE, sizeof(BYTE) ) ;
gzread( outfile, &DBufPtrW, sizeof(int) ) ;
gzread( outfile, &DBufPtrR, sizeof(int) ) ;
gzread( outfile, &LOADED_TONEMAP, sizeof(BYTE) ) ;
gzread( outfile, &ENABLE_TONEMAP, sizeof(BYTE) ) ;
gzread( outfile, &Ibit, sizeof(WORD) ) ;
gzread( outfile, &Pal_HalfMask, sizeof(WORD) ) ;
gzread( outfile, &Pal_Ix2, sizeof(WORD) ) ;
gzread( outfile, &Pal_R, sizeof(WORD) ) ;
gzread( outfile, &Pal_G, sizeof(WORD) ) ;
gzread( outfile, &Pal_B, sizeof(WORD) ) ;
gzread( outfile, &pia, sizeof(PIA) ) ;
gzread( outfile, &RTC_Bank, sizeof(BYTE) ) ;
gzread( outfile, &RTC_Timer1, sizeof(int) ) ;
gzread( outfile, &RTC_Timer16, sizeof(int) ) ;
gzread( outfile, &SASI_Phase, sizeof(BYTE) ) ;
gzread( outfile, &SASI_Sector, sizeof(DWORD) ) ;
gzread( outfile, &SASI_Blocks, sizeof(DWORD) ) ;
gzread( outfile, &SASI_CmdPtr, sizeof(BYTE) ) ;
gzread( outfile, &SASI_Device, sizeof(WORD) ) ;
gzread( outfile, &SASI_Unit, sizeof(BYTE) ) ;
gzread( outfile, &SASI_BufPtr, sizeof(short) ) ;
gzread( outfile, &SASI_RW, sizeof(BYTE) ) ;
gzread( outfile, &SASI_Stat, sizeof(BYTE) ) ;
gzread( outfile, &SASI_Mes, sizeof(BYTE) ) ;
gzread( outfile, &SASI_Error, sizeof(BYTE) ) ;
gzread( outfile, &SASI_SenseStatPtr, sizeof(BYTE) ) ;
gzread( outfile, &hddtrace, sizeof(int) ) ;
gzread( outfile, &MouseX, sizeof(signed char) ) ;
gzread( outfile, &MouseY, sizeof(signed char) ) ;
gzread( outfile, &MouseSt, sizeof(BYTE) ) ;
gzread( outfile, &SCC_RegNumA, sizeof(BYTE) ) ;
gzread( outfile, &SCC_RegSetA, sizeof(BYTE) ) ;
gzread( outfile, &SCC_RegNumB, sizeof(BYTE) ) ;
gzread( outfile, &SCC_RegSetB, sizeof(BYTE) ) ;
gzread( outfile, &SCC_Vector, sizeof(BYTE) ) ;
gzread( outfile, &SCC_DatNum, sizeof(BYTE) ) ;
gzread( outfile, &path_cur_prio, sizeof(int) ) ;
gzread( outfile, &win_letter, sizeof(char) ) ;
gzread( outfile, &num_win_drv, sizeof(int) ) ;
gzread( outfile, &files_next, sizeof(int) ) ;
gzread( outfile, &files_num, sizeof(int) ) ;
gzread( outfile, &fatr, sizeof(int) ) ;
gzread( outfile, &gr_files, sizeof(int) ) ;
gzread( outfile, &JoyKeyState0, sizeof(BYTE) ) ;
gzread( outfile, &JoyKeyState1, sizeof(BYTE) ) ;
gzread( outfile, &KeyBufWP, sizeof(BYTE) ) ;
gzread( outfile, &KeyBufRP, sizeof(BYTE) ) ;
gzread( outfile, &KeyEnable, sizeof(BYTE) ) ;
gzread( outfile, &KeyIntFlag, sizeof(BYTE) ) ;
gzread( outfile, &Draw_Opaque, sizeof(int) ) ;
gzread( outfile, &FullScreenFlag, sizeof(int) ) ;
gzread( outfile, &Draw_DrawFlag, sizeof(BYTE) ) ;
gzread( outfile, &Draw_ClrMenu, sizeof(BYTE) ) ;
gzread( outfile, &Debug_Text, sizeof(BYTE) ) ;
gzread( outfile, &Debug_Grp, sizeof(BYTE) ) ;
gzread( outfile, &Debug_Sp, sizeof(BYTE) ) ;
gzread( outfile, &winx, sizeof(int) ) ;
gzread( outfile, &winy, sizeof(int) ) ;
gzread( outfile, &winh, sizeof(int) ) ;
gzread( outfile, &winw, sizeof(int) ) ;
gzread( outfile, &FrameCount, sizeof(WORD) ) ;
gzread( outfile, &SplashFlag, sizeof(int) ) ;
gzread( outfile, &WinDraw_Pal16B, sizeof(WORD) ) ;
gzread( outfile, &WinDraw_Pal16R, sizeof(WORD) ) ;
gzread( outfile, &WinDraw_Pal16G, sizeof(WORD) ) ;
gzread( outfile, &WindowX, sizeof(int) ) ;
gzread( outfile, &WindowY, sizeof(int) ) ;
gzread( outfile, &MousePosX, sizeof(int) ) ;
gzread( outfile, &MousePosY, sizeof(int) ) ;
gzread( outfile, &MouseStat, sizeof(BYTE) ) ;
gzread( outfile, &MouseSW, sizeof(BYTE) ) ;
gzread( outfile, &CursorPos, sizeof(POINT) ) ;
gzread( outfile, &mousex, sizeof(int) ) ;
gzread( outfile, &mousey, sizeof(int) ) ;
gzread( outfile, &VLINE_TOTAL, sizeof(WORD) ) ;
gzread( outfile, &VLINE, sizeof(DWORD) ) ;
gzread( outfile, &vline, sizeof(DWORD) ) ;
gzread( outfile, &DispFrame, sizeof(BYTE) ) ;
gzread( outfile, &SoundSampleRate, sizeof(DWORD) ) ;
gzread( outfile, &CurFrameRate, sizeof(int) ) ;
gzread( outfile, &NoWaitMode, sizeof(int) ) ;
gzread( outfile, &ClkUsed, sizeof(int) ) ;
gzread( outfile, &FrameSkipCount, sizeof(int) ) ;
gzread( outfile, &FrameSkipQueue, sizeof(int) ) ;

gzread( outfile, ADPCM_BufR, sizeof(signed short)*ADPCM_BufSize) ;
gzread( outfile, ADPCM_BufL, sizeof(signed short)*ADPCM_BufSize) ;


gzread( outfile, dif_table, sizeof(int) * ( 49*16 ) ) ;
gzread( outfile, Outs, sizeof(int) * ( 8 ) ) ;
gzread( outfile, OutsIp, sizeof(int) * ( 4 ) ) ;
gzread( outfile, OutsIpR, sizeof(int) * ( 4 ) ) ;
gzread( outfile, OutsIpL, sizeof(int) * ( 4 ) ) ;
gzread( outfile, BG, sizeof(BYTE) * ( 0x8000 ) ) ;
gzread( outfile, Sprite_Regs, sizeof(BYTE) * ( 0x800 ) ) ;
gzread( outfile, BG_Regs, sizeof(BYTE) * ( 0x12 ) ) ;
gzread( outfile, BG_Dirty0, sizeof(BYTE) * ( 64*64 ) ) ;
gzread( outfile, BG_Dirty1, sizeof(BYTE) * ( 64*64 ) ) ;
gzread( outfile, BGCHR8, sizeof(BYTE) * ( 8*8*256 ) ) ;
gzread( outfile, BGCHR16, sizeof(BYTE) * ( 16*16*256 ) ) ;
gzread( outfile, BG_LineBuf, sizeof(WORD) * ( 1600 ) ) ;
gzread( outfile, BG_PriBuf, sizeof(WORD) * ( 1600 ) ) ;
gzread( outfile, CRTC_Regs, sizeof(BYTE) * ( 24*2 ) ) ;
gzread( outfile, GrphScrollX, sizeof(DWORD) * ( 4 ) ) ;
gzread( outfile, GrphScrollY, sizeof(DWORD) * ( 4 ) ) ;
gzread( outfile, VCReg0, sizeof(BYTE) * ( 2 ) ) ;
gzread( outfile, VCReg1, sizeof(BYTE) * ( 2 ) ) ;
gzread( outfile, VCReg2, sizeof(BYTE) * ( 2 ) ) ;
gzread( outfile, CRTC_RCFlag, sizeof(BYTE) * ( 2 ) ) ;
gzread( outfile, DIMCur, sizeof(int) * ( 4 ) ) ;
gzread( outfile, DIMTrk, sizeof(int) * ( 4 ) ) ;
gzread( outfile, XDFCur, sizeof(int) * ( 4 ) ) ;
gzread( outfile, XDFTrk, sizeof(int) * ( 4 ) ) ;
gzread( outfile, DMA, sizeof(dmac_ch) * ( 4 ) ) ;
gzread( outfile, GVRAM, sizeof(BYTE) * ( 0x80000 ) ) ;
gzread( outfile, Grp_LineBuf, sizeof(WORD) * ( 1024 ) ) ;
gzread( outfile, Grp_LineBufSP, sizeof(WORD) * ( 1024 ) ) ;
gzread( outfile, Grp_LineBufSP2, sizeof(WORD) * ( 1024 ) ) ;
gzread( outfile, Pal16Adr, sizeof(WORD) * ( 256 ) ) ;
gzread( outfile, IRQH_IRQ, sizeof(BYTE) * ( 8 ) ) ;
gzread( outfile, Mcry_BufL, sizeof(short) * ( Mcry_BufSize ) ) ;
gzread( outfile, Mcry_BufR, sizeof(short) * ( Mcry_BufSize ) ) ;
gzread( outfile, MFP, sizeof(BYTE) * ( 24 ) ) ;
gzread( outfile, Timer_Reload, sizeof(BYTE) * ( 4 ) ) ;
gzread( outfile, Timer_Tick, sizeof(int) * ( 4 ) ) ;
gzread( outfile, MIDI_BUF, sizeof(BYTE) * ( MIDIBUFFERS ) ) ;
gzread( outfile, MIDI_EXCVBUF, sizeof(BYTE) * ( MIDIBUFFERS ) ) ;
gzread( outfile, DelayBuf, sizeof(DELAYBUFITEM) * ( MIDIDELAYBUF ) ) ;
gzread( outfile, TONE_CH, sizeof(BYTE) * ( 16 ) ) ;
gzread( outfile, Pal_Regs, sizeof(BYTE) * ( 1024 ) ) ;
gzread( outfile, TextPal, sizeof(WORD) * ( 256 ) ) ;
gzread( outfile, GrphPal, sizeof(WORD) * ( 256 ) ) ;
gzread( outfile, Pal16, sizeof(WORD) * ( 65536 ) ) ;
gzread( outfile, SASI_Buf, sizeof(BYTE) * ( 256 ) ) ;
gzread( outfile, SASI_Cmd, sizeof(BYTE) * ( 6 ) ) ;
gzread( outfile, SASI_SenseStatBuf, sizeof(BYTE) * ( 4 ) ) ;
gzread( outfile, SCC_RegsA, sizeof(BYTE) * ( 16 ) ) ;
gzread( outfile, SCC_RegsB, sizeof(BYTE) * ( 16 ) ) ;
gzread( outfile, SCC_Dat, sizeof(BYTE) * ( 3 ) ) ;
gzread( outfile, SCSIIPL, sizeof(BYTE) * ( 0x2000 ) ) ;
gzread( outfile, SRAM, sizeof(BYTE) * ( 0x4000 ) ) ;
gzread( outfile, SysPort, sizeof(BYTE) * ( 7 ) ) ;
gzread( outfile, TVRAM, sizeof(BYTE) * ( 0x80000 ) ) ;
gzread( outfile, TextDrawWork, sizeof(BYTE) * ( 1024*1024 ) ) ;
gzread( outfile, TextDirtyLine, sizeof(BYTE) * ( 1024 ) ) ;
gzread( outfile, TextDrawPattern, sizeof(BYTE) * ( 2048*4 ) ) ;
gzread( outfile, Text_TrFlag, sizeof(BYTE) * ( 1024 ) ) ;
gzread( outfile, path_tbl, sizeof(path_buff_s) * ( MAX_PATH_TBL ) ) ;
gzread( outfile, win_drvs, sizeof(char) * ( 32 ) ) ;
gzread( outfile, files_tbl, sizeof(files_buff_s) * ( MAX_FILES_TBL ) ) ;
gzread( outfile, JoyState0, sizeof(BYTE) * ( 2 ) ) ;
gzread( outfile, JoyState1, sizeof(BYTE) * ( 2 ) ) ;
gzread( outfile, JoyPortData, sizeof(BYTE) * ( 2 ) ) ;
gzread( outfile, KeyBuf, sizeof(BYTE) * ( KeyBufSize ) ) ;
gzread( outfile, Draw_BitMask, sizeof(BYTE) * ( 800 ) ) ;
gzread( outfile, Draw_TextBitMask, sizeof(BYTE) * ( 800 ) ) ;

gzread( outfile, TONEBANK, sizeof(BYTE) * ( 3*128 ) ) ;
gzread( outfile, TONEMAP, sizeof(BYTE) * ( 3*128 ) ) ;
gzread( outfile, RTC_Regs, sizeof(BYTE) * ( 2*16 ) ) ;
gzread( outfile, gr_buf, sizeof(char) * ( 16*256 ) ) ;

gzread( outfile, MEM, 0xc00000 ) ;
gzread( outfile, IPL, 0x40000 ) ;
gzread( outfile, FONT, 0xc0000 ) ;


gzread( outfile, &val, sizeof(int) ) ;

switch ( val )
{
	case 1 : OP_ROM = MEM ; break ;
	case 2 : OP_ROM = GVRAM-0xc00000 ; break ;
	case 3 : OP_ROM = SRAM-0xed0000 ; break ;
	case 4 : OP_ROM = TVRAM-0xe00000 ; break ;
	case 5 : OP_ROM = SCSIIPL - 0x0ea0000 ; break ;
	case 6 : OP_ROM = IPL-0xfc0000 ; break ;
	default : OP_ROM = (BYTE*)val ; break ;
}



for ( i = 0 ; i < 4 ; i++ )
{
	gzread( outfile, &val, sizeof(int) ) ;
	if ( val )
		gzread( outfile, DIMImg[i], 1024*9*170+sizeof(DIM_HEADER) ) ;

	gzread( outfile, &val, sizeof(int) ) ;
	if ( val )
		gzread( outfile, XDFImg[i], 1261568 ) ;
}

for( i = 0 ; i < 8 ; i++ )
{
	gzread( outfile, &val, sizeof(int)) ;

	switch ( val )
	{
		case 1 : IRQH_CallBack[i] = &IRQH_DefaultVector ; break ;
		case 2 : IRQH_CallBack[i] = &DMA_Int ; break ; 
		case 3 : IRQH_CallBack[i] = &FDC_Int ; break ; 
		case 4 : IRQH_CallBack[i] = &FDD_Int ; break ; 
		case 5 : IRQH_CallBack[i] = &Mcry_IntCB ; break ; 
		case 6 : IRQH_CallBack[i] = &MFP_IntCallback ; break ; 
		case 7 : IRQH_CallBack[i] = &MIDI_Int ; break ; 
		case 8 : IRQH_CallBack[i] = &SASI_Int ; break ; 
		case 9 : IRQH_CallBack[i] = &SCC_Int ; break ; 
		default : IRQH_CallBack[i] = (void*)val ; break ; 
	}

}


gzread( outfile, &regs, sizeof(m68k_regs) ) ;


	gzread( outfile, &val, sizeof(int)) ;

	switch ( val )
	{
		case 1 : regs.irq_callback = &IRQH_DefaultVector ; break ;
		case 2 : regs.irq_callback = &DMA_Int ; break ; 
		case 3 : regs.irq_callback = &FDC_Int ; break ; 
		case 4 : regs.irq_callback = &FDD_Int ; break ; 
		case 5 : regs.irq_callback = &Mcry_IntCB ; break ; 
		case 6 : regs.irq_callback = &MFP_IntCallback ; break ; 
		case 7 : regs.irq_callback = &MIDI_Int ; break ; 
		case 8 : regs.irq_callback = &SASI_Int ; break ; 
		case 9 : regs.irq_callback = &SCC_Int ; break ; 
		default : regs.irq_callback = (void*)val ; break ; 
	}



	gzread( outfile, &numbytes, sizeof(int)) ;

	buf = malloc( numbytes ) ;

	gzread( outfile, buf, numbytes) ;

	OPM_loadcontext( buf ) ;

	free(buf ) ;



	gzread( outfile, &numbytes, sizeof(int)) ;

	buf = malloc( numbytes ) ;

	gzread( outfile, buf, numbytes) ;

	M288_loadcontextA( buf ) ;

	free(buf ) ;



	gzread( outfile, &numbytes, sizeof(int)) ;

	buf = malloc( numbytes ) ;

	gzread( outfile, buf, numbytes) ;

	M288_loadcontextB( buf ) ;

	free(buf ) ;



	gzclose( outfile ) ;

#if 0



//extern D88_SECTINFO* D88Cur[4] ;
//extern D88_SECTINFO* D88Top[4] ;
//extern D88_SECTINFO* D88Trks[4][164];


#endif

}
