// ---------------------------------------------------------------------------
//	PSG-like sound generator
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//	$Id: psg.h,v 1.6 2000/09/08 13:45:57 cisc Exp $

#ifndef PSG_H
#define PSG_H

#include "types.h"

//#define PSG_SAMPLETYPE		int32		// int32 or int16
#define PSG_SAMPLETYPE		int16		// int32 or int16

// ---------------------------------------------------------------------------
//	class PSG
//	PSG ɗǂ𐶐鉹jbg
//	
//	interface:
//	bool SetClock(uint clock, uint rate)
//		D̃NXgpOɂȂ炸ĂłƁD
//		PSG ̃NbN PCM [gݒ肷
//
//		clock:	PSG ̓NbN
//		rate:	 PCM ̃[g
//		retval	ɐ true
//
//	void Mix(Sample* dest, int nsamples)
//		PCM  nsamples C dest Ŏn܂zɉ(Z)
//		܂ŉZȂ̂ŁCŏɔz[NAKv
//	
//	void Reset()
//		Zbg
//
//	void SetReg(uint reg, uint8 data)
//		WX^ reg  data 
//	
//	uint GetReg(uint reg)
//		WX^ reg ̓eǂݏo
//	
//	void SetVolume(int db)
//		ẻʂ𒲐߂
//		Pʂ͖ 1/2 dB
//
class PSG
{
public:
	typedef PSG_SAMPLETYPE Sample;
	
	enum
	{
		noisetablesize = 1 << 10,	// gpʂ炵Ȃ猸炵
		toneshift = 24,
		envshift = 22,
		noiseshift = 14,
		oversampling = 2,		//  葬xDȂ猸炷Ƃ
	};

public:
	PSG();
	~PSG();

	void Mix(Sample* dest, int nsamples);
	void SetClock(int clock, int rate);
	int     savecontext_psg( unsigned char *buf ) ;
	int     loadcontext_psg( unsigned char *buf ) ;
	
	void SetVolume(int vol);
	void SetChannelMask(int c);
	
	void Reset();
	void SetReg(uint regnum, uint8 data);
	uint GetReg(uint regnum) { return reg[regnum & 0x0f]; }

protected:
	void MakeNoiseTable();
	void MakeEnvelopTable();
	static void StoreSample(Sample& dest, int32 data);
	
	uint8 reg[16];

	const uint* envelop;
	uint olevel[3];
	uint32 scount[3], speriod[3];
	uint32 ecount, eperiod;
	uint32 ncount, nperiod;
	uint32 tperiodbase;
	uint32 eperiodbase;
	uint32 nperiodbase;
	int volume;
	int mask;

	static uint enveloptable[16][64];
	static uint noisetable[noisetablesize];
	static int EmitTable[32];
};

#define WRITEDATA( src, size ) \
	memcpy( ptr, src, size ) ;\
	ptr += size ;

inline int PSG::savecontext_psg( unsigned char *buf )
{
	unsigned char *ptr = buf ;
	unsigned int i ;

WRITEDATA( reg, sizeof(uint8)*16);
WRITEDATA( olevel, sizeof(uint)*3);
WRITEDATA( scount, sizeof(uint32)*3);
WRITEDATA( speriod, sizeof(uint32)*3);
WRITEDATA( &ecount, sizeof(uint32));
WRITEDATA( &eperiod, sizeof(uint32));
WRITEDATA( &ncount, sizeof(uint32));
WRITEDATA( &nperiod, sizeof(uint32));
WRITEDATA( &tperiodbase, sizeof(uint32));
WRITEDATA( &eperiodbase, sizeof(uint32));
WRITEDATA( &nperiodbase, sizeof(uint32));
WRITEDATA( &volume, sizeof(int));
WRITEDATA( &mask, sizeof(int));
WRITEDATA( enveloptable, sizeof(uint)*16*64);
WRITEDATA( noisetable, sizeof(uint)*noisetablesize);
WRITEDATA( EmitTable, sizeof(int)*32);

for ( i = 0 ; i < 16 ; i++ )
{
	if ( envelop == enveloptable[i] )
	{
		break ;
	}
}

WRITEDATA( &i, sizeof(unsigned int) ) ;

	return ptr-buf ;

}


#define READDATA( dst, size ) \
	memcpy( dst, ptr, size ) ;\
	ptr += size ;

inline int PSG::loadcontext_psg( unsigned char *buf )
{
	unsigned char *ptr = buf ;
	unsigned int i;

READDATA( reg, sizeof(uint8)*16);
READDATA( olevel, sizeof(uint)*3);
READDATA( scount, sizeof(uint32)*3);
READDATA( speriod, sizeof(uint32)*3);
READDATA( &ecount, sizeof(uint32));
READDATA( &eperiod, sizeof(uint32));
READDATA( &ncount, sizeof(uint32));
READDATA( &nperiod, sizeof(uint32));
READDATA( &tperiodbase, sizeof(uint32));
READDATA( &eperiodbase, sizeof(uint32));
READDATA( &nperiodbase, sizeof(uint32));
READDATA( &volume, sizeof(int));
READDATA( &mask, sizeof(int));
READDATA( enveloptable, sizeof(uint)*16*64);
READDATA( noisetable, sizeof(uint)*noisetablesize);
READDATA( EmitTable, sizeof(int)*32);

READDATA( &i, sizeof(unsigned int) ) ;

envelop = enveloptable[i&0x0f];


	return ptr-buf ;

}



#endif // PSG_H
