// ---------------------------------------------------------------------------
//	FM Sound Generator
//	Copyright (C) cisc 1998, 2001.
// ---------------------------------------------------------------------------
//	$Id: fmgen.h,v 1.26 2001/03/30 01:05:52 cisc Exp $

#ifndef FM_GEN_H
#define FM_GEN_H

#include "types.h"
#include "memory.h"

// ---------------------------------------------------------------------------
//	o̓Tv̌^
//
//#define FM_SAMPLETYPE	int32				// int16 or int32
#define FM_SAMPLETYPE	int16				// int16 or int32

// ---------------------------------------------------------------------------
//	萔̂P
//	ÓIe[ũTCY

#define FM_LFOBITS		8					// ύXs
#define FM_TLBITS		7

// ---------------------------------------------------------------------------

#define FM_TLENTS		(1 << FM_TLBITS)
#define FM_LFOENTS		(1 << FM_LFOBITS)
#define FM_TLPOS		(FM_TLENTS/4)

// ---------------------------------------------------------------------------

namespace FM
{	
	//	Types ----------------------------------------------------------------
	typedef FM_SAMPLETYPE	Sample;
	typedef int32 			ISample;

	enum OpType { typeN=0, typeM=1 };
	
	//	Tables (O[oȂ̂ asm QƂ̓) -----------------
	void MakeTable();
int savecontext_fmgen( unsigned char *buf );
int loadcontext_fmgen( unsigned char *buf );
	void MakeTimeTable(uint ratio);
	extern uint32 tltable[];
	extern int32  cltable[];
	extern uint32 dltable[];
	extern int    pmtable[2][8][FM_LFOENTS];
	extern uint   amtable[2][4][FM_LFOENTS];
	extern uint   aml, pml;
	extern int    pmv;		// LFO ωx

	void StoreSample(ISample& dest, int data);

	//	Operator -------------------------------------------------------------
	class Operator
	{
	public:
		Operator();
		static void MakeTable();
		static void	MakeTimeTable(uint ratio);
		
		ISample	Calc(ISample in);
		ISample	CalcL(ISample in);
		ISample CalcFB(uint fb);
		ISample CalcFBL(uint fb);
		ISample CalcN(uint noise);
		int savecontext_operator( unsigned char *buf ) ;
		int loadcontext_operator( unsigned char *buf ) ;
		void	Prepare();
		void	KeyOn();
		void	KeyOff();
		void	Reset();
		void	ResetFB();
		int		IsOn();

		void	SetDT(uint dt);
		void	SetDT2(uint dt2);
		void	SetMULTI(uint multi);
		void	SetTL(uint tl, bool csm);
		void	SetKS(uint ks);
		void	SetAR(uint ar);
		void	SetDR(uint dr);
		void	SetSR(uint sr);
		void	SetRR(uint rr);
		void	SetSL(uint sl);
		void	SetSSGEC(uint ssgec);
		void	SetFNum(uint fnum);
		void	SetDPBN(uint dp, uint bn);
		void	SetMode(bool modulator);
		void	SetAMON(bool on);
		void	SetMS(uint ms);
		void	Mute(bool);
		
		static void SetAML(uint l);
		static void SetPML(uint l);
		
	private:
		typedef uint32 Counter;
		
		ISample	out, out2;

	//	Phase Generator ------------------------------------------------------
		uint32	PGCalc();
		uint32	PGCalcL();

		uint	dp;			// P
		uint	detune;		// Detune
		uint	detune2;	// DT2
		uint	multiple;	// Multiple
		uint32	pgcount;	// Phase ݒl
		uint32	pgdcount;	// Phase l
		int32	pgdcountl;	// Phase l >> x

	//	Envelope Generator ---------------------------------------------------
		enum	EGPhase { next, attack, decay, sustain, release, off };
		
		void	EGCalc();
		void	ShiftPhase(EGPhase nextphase);
		void	ShiftPhase2();
		void	SetEGRate(uint);
		void	EGUpdate();
		
		OpType	type;		// OP ̎ (M, N...)
		uint	bn;			// Block/Note
		int		eglevel;	// EG ̏o͒l
		int		eglvnext;	//  phase Ɉڂl
		int32	egstep;		// EG ̎̕ψڂ܂ł̎
		int32	egstepd;	// egstep ̎ԍ
		int		egtransa;	// EG ω̊ (for attack)
		int		egtransd;	// EG ω̊ (for decay)
		int		egout;		// EG+TL 킹o͒l
		int		tlout;		// TL ̏o͒l
		int		pmd;		// PM depth
		int		amd;		// AM depth

		uint	ksr;		// key scale rate
		EGPhase	phase;
		uint*	ams;
		uint8	ms;

		bool	keyon;		// current key state
		
		uint8	tl;			// Total Level	 (0-127)
		uint8	tll;		// Total Level Latch (for CSM mode)
		uint8	ar;			// Attack Rate   (0-63)
		uint8	dr;			// Decay Rate    (0-63)
		uint8	sr;			// Sustain Rate  (0-63)
		uint8	sl;			// Sustain Level (0-127)
		uint8	rr;			// Release Rate  (0-63)
		uint8	ks;			// Keyscale      (0-3)
		uint8	ssgtype;	// SSG-Type Envelop Control

		bool	amon;		// enable Amplitude Modulation
		bool	paramchanged;	// p[^XVꂽ
		bool	mute;
		
	//	Tables ---------------------------------------------------------------
		enum TableIndex { dldecay = 0, dlattack = 0x400, };
		
		static Counter ratetable[64];
		static uint32 multable[4][16];

	//	friends --------------------------------------------------------------
		friend class Channel4;
		friend void __stdcall FM_NextPhase(Operator* op);
	};
	

#define WRITEDATA( src, size ) \
	memcpy( ptr, src, size ) ;\
	ptr += size ;

inline int Operator::savecontext_operator( unsigned char *buf )
{
	unsigned int val;
	unsigned char *ptr = buf ;


WRITEDATA( &out, sizeof(ISample));
WRITEDATA( &out2, sizeof(ISample));
WRITEDATA( &dp, sizeof(uint));
WRITEDATA( &detune, sizeof(uint));
WRITEDATA( &detune2, sizeof(uint));
WRITEDATA( &multiple, sizeof(uint));
WRITEDATA( &pgcount, sizeof(uint32));
WRITEDATA( &pgdcount, sizeof(uint32));
WRITEDATA( &pgdcountl, sizeof(int32));
WRITEDATA( &type, sizeof(OpType));
WRITEDATA( &bn, sizeof(uint));
WRITEDATA( &eglevel, sizeof(int));
WRITEDATA( &eglvnext, sizeof(int));
WRITEDATA( &egstep, sizeof(int32));
WRITEDATA( &egstepd, sizeof(int32));
WRITEDATA( &egtransa, sizeof(int));
WRITEDATA( &egtransd, sizeof(int));
WRITEDATA( &egout, sizeof(int));
WRITEDATA( &tlout, sizeof(int));
WRITEDATA( &pmd, sizeof(int));
WRITEDATA( &amd, sizeof(int));
WRITEDATA( &ksr, sizeof(uint));
WRITEDATA( &phase, sizeof(EGPhase));
WRITEDATA( &ms, sizeof(uint8));
WRITEDATA( &keyon, sizeof(bool));
WRITEDATA( &tl, sizeof(uint8));
WRITEDATA( &tll, sizeof(uint8));
WRITEDATA( &ar, sizeof(uint8));
WRITEDATA( &dr, sizeof(uint8));
WRITEDATA( &sr, sizeof(uint8));
WRITEDATA( &sl, sizeof(uint8));
WRITEDATA( &rr, sizeof(uint8));
WRITEDATA( &ks, sizeof(uint8));
WRITEDATA( &ssgtype, sizeof(uint8));
WRITEDATA( &amon, sizeof(bool));
WRITEDATA( &paramchanged, sizeof(bool));
WRITEDATA( &mute, sizeof(bool));


WRITEDATA( ratetable, 64*sizeof(Counter) ) ;
WRITEDATA( multable, 16*4*sizeof(uint32) ) ;
		
	val = (unsigned int)ams - (unsigned int)amtable ;

	WRITEDATA( &val, sizeof(unsigned int) ) ;

	return ptr-buf ;

}


#define READDATA( dst, size ) \
	memcpy( dst, ptr, size ) ;\
	ptr += size ;

inline int Operator::loadcontext_operator( unsigned char *buf )
{
	unsigned int val;
	unsigned char *ptr = buf ;


READDATA( &out, sizeof(ISample));
READDATA( &out2, sizeof(ISample));
READDATA( &dp, sizeof(uint));
READDATA( &detune, sizeof(uint));
READDATA( &detune2, sizeof(uint));
READDATA( &multiple, sizeof(uint));
READDATA( &pgcount, sizeof(uint32));
READDATA( &pgdcount, sizeof(uint32));
READDATA( &pgdcountl, sizeof(int32));
READDATA( &type, sizeof(OpType));
READDATA( &bn, sizeof(uint));
READDATA( &eglevel, sizeof(int));
READDATA( &eglvnext, sizeof(int));
READDATA( &egstep, sizeof(int32));
READDATA( &egstepd, sizeof(int32));
READDATA( &egtransa, sizeof(int));
READDATA( &egtransd, sizeof(int));
READDATA( &egout, sizeof(int));
READDATA( &tlout, sizeof(int));
READDATA( &pmd, sizeof(int));
READDATA( &amd, sizeof(int));
READDATA( &ksr, sizeof(uint));
READDATA( &phase, sizeof(EGPhase));
READDATA( &ms, sizeof(uint8));
READDATA( &keyon, sizeof(bool));
READDATA( &tl, sizeof(uint8));
READDATA( &tll, sizeof(uint8));
READDATA( &ar, sizeof(uint8));
READDATA( &dr, sizeof(uint8));
READDATA( &sr, sizeof(uint8));
READDATA( &sl, sizeof(uint8));
READDATA( &rr, sizeof(uint8));
READDATA( &ks, sizeof(uint8));
READDATA( &ssgtype, sizeof(uint8));
READDATA( &amon, sizeof(bool));
READDATA( &paramchanged, sizeof(bool));
READDATA( &mute, sizeof(bool));


READDATA( ratetable, 64*sizeof(Counter) ) ;
READDATA( multable, 16*4*sizeof(uint32) ) ;
		
	READDATA( &val, sizeof(unsigned int) ) ;
	ams = (uint*)((unsigned int)amtable + val) ;


	return ptr-buf ;

}




	//	4-op Channel ---------------------------------------------------------
	class Channel4
	{
	public:
		Channel4();
		void SetType(OpType type);
		
		ISample Calc();
		ISample CalcL();
		ISample CalcN(uint noise);
		ISample CalcLN(uint noise);
		int savecontext_channel4( unsigned char *bbuf ) ;
		int loadcontext_channel4( unsigned char *bbuf ) ;
		void SetFNum(uint fnum);
		void SetFB(uint fb);
		void SetKCKF(uint kc, uint kf);
		void SetAlgorithm(uint algo);
		int Prepare();
		void KeyControl(uint key);
		void Reset();
		void SetMS(uint ms);
		void Mute(bool);
		void Refresh();
		
	private:
		static const uint8 fbtable[8];
		uint	fb;
		int		buf[4];
		int*	in[3];			// e OP ̓̓|C^
		int*	out[3];			// e OP ̏o̓|C^
		int*	pms;

	public:
		Operator op[4];
	};

#define WRITEDATA( src, size ) \
	memcpy( ptr, src, size ) ;\
	ptr += size ;

inline int Channel4::savecontext_channel4( unsigned char *bbuf )
{
	int i ;
	unsigned int val ;
	unsigned char *ptr = bbuf ;

	WRITEDATA( buf, sizeof(int)*4 ) ;
	WRITEDATA( &fb, sizeof(uint) ) ;


	for ( i = 0 ; i < 3 ; i++ )
	{
		val = (unsigned int)(in[i]) - (unsigned int)buf ;
		WRITEDATA( &val, sizeof(unsigned int) ) ;
		val = (unsigned int)(out[i]) - (unsigned int)buf ;
		WRITEDATA( &val, sizeof(unsigned int) ) ;
	}

	val = (unsigned int)pms - (unsigned int)pmtable ;
	WRITEDATA( &val, sizeof(unsigned int) ) ;


	for ( i = 0 ; i < 4 ; i++ )
	{
		ptr += op[i].savecontext_operator( ptr ) ;
	}



	return ptr-bbuf ;

}


#define READDATA( dst, size ) \
	memcpy( dst, ptr, size ) ;\
	ptr += size ;

inline int Channel4::loadcontext_channel4( unsigned char *bbuf )
{
	int i ;
	unsigned int val ;
	unsigned char *ptr = bbuf ;

	READDATA( buf, sizeof(int)*4 ) ;
	READDATA( &fb, sizeof(uint) ) ;


	for ( i = 0 ; i < 3 ; i++ )
	{
		READDATA( &val, sizeof(unsigned int) ) ;
		in[i] = (int*)((unsigned int)buf + val) ;
		READDATA( &val, sizeof(unsigned int) ) ;
		out[i] = (int*)((unsigned int)buf + val) ;
	}

	READDATA( &val, sizeof(unsigned int) ) ;
	pms = (int*)((unsigned int)pmtable + val) ;


	for ( i = 0 ; i < 4 ; i++ )
	{
		ptr += op[i].loadcontext_operator( ptr ) ;
	}



	return ptr-bbuf ;

}


}

#endif // FM_GEN_H
