void CXBoxSample::xboxScreenshot() 
{
	mainprog_info wpng_info;
	char scr_filename[MAX_PATH] ;
	char scr_prefix[MAX_PATH] ;
	char dir[MAX_PATH] ;
	int maxnum = 0 ;
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;

	CreateDirectory( m_screenshotDir, NULL ) ;

	sprintf( scr_prefix, "%s\\%s", m_screenshotDir, PLATFORM_NAME ) ; 

	CreateDirectory( scr_prefix, NULL ) ;

	sprintf( scr_prefix, "%s\\%s\\%s", m_screenshotDir, PLATFORM_NAME, strrchr(g_saveprefix, '\\')+1 ) ;

	CreateDirectory( scr_prefix, NULL ) ;

	sprintf( dir, "%s\\*.png", scr_prefix ) ;

	hFind = FindFirstFile( dir, &oFindData);

	if ( hFind != INVALID_HANDLE_VALUE) 
	{
		do
		{
			strcpy( scr_filename, oFindData.cFileName ) ;

			if ( strchr( scr_filename, '.' ) == NULL )
				continue ;

			*(strchr( scr_filename, '.' )) = 0 ;

			//sprintfx( "%s %u %s\r\n", scr_filename, strlen(scr_prefix), scr_filename + strlen(scr_prefix) ) ;

			if ( atoi( scr_filename ) > maxnum )
			{
				maxnum = atoi( scr_filename ) ;
			}
			
		} while (FindNextFile(hFind, &oFindData) ) ;
		FindClose( hFind );
	}

	maxnum++ ;

	if ( maxnum > 9999 )
		return ;

	sprintf( scr_filename, "%s\\%04.4u.png", scr_prefix, maxnum ) ;


	memset( &wpng_info, 0, sizeof( wpng_info ) ) ;

	wpng_info.width = ((float)m_nScreenMaxX/m_gameVecScale.x);
	wpng_info.height = ((float)m_nScreenMaxY/m_gameVecScale.y) ;

	wpng_info.sample_depth = 8;

	wpng_info.bpp = 24 ;

	wpng_info.outfile = NULL;
	wpng_info.image_data = NULL;
	wpng_info.row_pointers = NULL;
	wpng_info.interlaced = false;
	wpng_info.have_bg = false;
	wpng_info.have_time = false;
	wpng_info.have_text = 0;
	wpng_info.gamma = 1.0;

    /* open the output file, or register an error and abort */
	if ((wpng_info.outfile = fopen( scr_filename, "wb") ) == NULL)
	{
		return ;
    }
	
	// allocate libpng stuff, initialize transformations, write pre-IDAT data
	

	int rc ;
	if ((rc=writepng_init(&wpng_info)) != 0)
	{
		fclose( wpng_info.outfile )  ;
		return ; 
		/*
		switch (rc)
		{
			case 2:
				fprintf(stderr, "WritePNG: libpng initialization problem (longjmp)\n");
			break;
			case 4:
				fprintf(stderr, "WritePNG: insufficient memory\n");
				break;
			case 11:
				fprintf(stderr, "WritePNG: internal logic error (unexpected PNM type)\n");
				break;
			default:
				fprintf(stderr, "WritePNG: unknown writepng_init() error\n");
				break;
        }
        exit(rc); */
    }
	
	long j;
	
	wpng_info.image_data = (unsigned char *)malloc( (wpng_info.bpp/8) * wpng_info.width);
		
	if (wpng_info.image_data == NULL)
	{
		writepng_cleanup(&wpng_info);
		fclose( wpng_info.outfile )  ;
		return ; 
		/*
		fprintf(stderr, "WritePNG:  insufficient memory for row data\n");
		writepng_cleanup(&wpng_info);
		cleanup();
		exit(5);
		*/
	}
		
	unsigned char *data ;

	
	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = theHeight-1 ;
	rectSource.right  = theWidth-1 ;

	// Lock the rect in our texture
	D3DLOCKED_RECT d3dlr;
	Texture->LockRect(0, &d3dlr, &rectSource, 0);


	data = (unsigned char*)d3dlr.pBits;

	WORD pixel ;
		
	for (j = wpng_info.height;  j > 0L;  --j)
	{
		unsigned char* img_data = wpng_info.image_data;
		WORD *wdata = (WORD*)data;

		int i=0;

		for ( i = 0 ; i < wpng_info.width ; i++ )
		{
			pixel = wdata[i] ;
			img_data[2] = (pixel<<3) & 0xFF ;
			img_data[1] = ((pixel>>5)<<2) & 0xFF ;
			img_data[0] = ((pixel>>11)<<3) & 0xFF ;
			img_data += 3 ;
		}

		data += xbox_get_pitch();
			
	
			
		if( writepng_encode_row(&wpng_info) != 0)
		{
			writepng_cleanup(&wpng_info);
			free(wpng_info.image_data) ;
			fclose( wpng_info.outfile )  ;
			Texture->UnlockRect(0) ;
			return ; 

/*			fprintf(stderr, "WritePNG:  libpng problem (longjmp) while writing row %ld\n",
			wpng_info.height-j);
			++error;
			break;*/
		}
	}
	Texture->UnlockRect(0) ;
		
		/*
	if (error)
	{
		writepng_cleanup(&wpng_info);
		cleanup();
		exit(2);
	}
	*/
	if (writepng_encode_finish(&wpng_info) != 0)
	{
		//fprintf(stderr, "WritePNG:  error on final libpng call\n");
		writepng_cleanup(&wpng_info);
		free(wpng_info.image_data) ;
		fclose( wpng_info.outfile )  ;
		return ;
	}
	
	/* OK, we're done (successfully):  clean up all resources and quit */

	writepng_cleanup(&wpng_info);
	free(wpng_info.image_data) ;
	fclose( wpng_info.outfile )  ;

	sprintf( global_error_message, "%s", scr_filename) ;
	m_msgDelay = 120 ;
}

void CXBoxSample::fillPresentationParams()
{
    ZeroMemory( &m_d3dpp, sizeof(m_d3dpp) );

	m_d3dpp.BackBufferWidth        = 640;
    m_d3dpp.BackBufferHeight       = 480;
    m_d3dpp.BackBufferCount        = 1;
	//m_d3dpp.EnableAutoDepthStencil					= TRUE;
    //m_d3dpp.AutoDepthStencilFormat	=	D3DFMT_D16;
    m_d3dpp.SwapEffect             = D3DSWAPEFFECT_DISCARD;
    //m_d3dpp.MultiSampleType			=	D3DMULTISAMPLE_NONE;
	m_d3dpp.Flags = D3DPRESENTFLAG_INTERLACED ;
	m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;


	bool bProgressive=false;

	DWORD videoFlags = XGetVideoFlags();

	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//set pal60 if available.
		if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)
			m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			m_d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}
	else
		m_d3dpp.FullScreen_RefreshRateInHz = 60 ;



	m_d3dpp.BackBufferFormat        = D3DFMT_LIN_R5G6B5 ;


}

int recreate( D3DPRESENT_PARAMETERS *pparams )
{
	char tmpfilename[500] ;

	SAFE_RELEASE( g_app->Sprite ) ;
	SAFE_RELEASE( g_app->MenuSprite ) ;
	SAFE_RELEASE( g_app->m_plaything.m_gSprite) ;
	//SAFE_RELEASE( g_app->Texture ) ;
	//g_app->Texture = NULL ;

	if ( g_app->m_pd3dDevice )
		g_app->m_pd3dDevice->Release();

				//g_app->fillPresentationParams() ;

				if( FAILED( g_app->m_pD3D->CreateDevice( 0, D3DDEVTYPE_HAL, NULL, 
													   D3DCREATE_HARDWARE_VERTEXPROCESSING, 
													   pparams, &g_app->m_pd3dDevice ) ) )
				{
					return 0 ;
				}
				else
				{
					g_pd3dDevice = g_app->m_pd3dDevice ;

					g_app->m_pnlBackgroundMain.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlBackgroundSelect.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlBackgroundOther.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlSplashEmu.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlSplashGame.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlPopup.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlGameScreen.Recreate( g_app->m_pd3dDevice );
					m_pnlKeyboard.Recreate( g_app->m_pd3dDevice );

					sprintf( tmpfilename, "%s\\%s\\%s", g_app->m_szSkinDir, g_app->m_szSkin, g_app->m_skin.font ) ;
					g_app->m_Font.Initialize( g_app->m_pd3dDevice, tmpfilename, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;
					g_app->m_plaything.Initialize( g_app->m_pd3dDevice, &g_app->m_Font, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;
					m_bRecreated = 1 ;
					return 1 ;

				}
}

struct vidmodes
{
	char name[100] ;
	unsigned int width ;
	unsigned int height ;
	char progressive ;
	float multx ;
	float multy ;
} VIDEOMODES[] = 
{
	{ "Standard 480i", 640, 480, 0, 1.0f, 1.0f },
	{ "480p", 640, 480, 1, 1.0f, 1.0f },
	{ "720p", 1280, 720, 1, 2.0f, 1.5f },
	{ "1080i", 1920, 1080, 0, 3.0f, 2.25f },
	{ "720x480", 720, 480, 0, 1.125f, 1.0f },
	{ "720x576", 720, 576, 0, 1.125f, 1.2f },
} ;


	if ( ! ( m_bInitVideo  ) )
	{
		DWORD videoFlags = XGetVideoFlags();

		if ( XGetAVPack() == XC_AV_PACK_HDTV)
		{
			if ( videoFlags & XC_VIDEO_FLAGS_HDTV_480p )
			{
				m_bInitVideo = true ;
				m_xboxVidmode = 1 ;
			}
			else if ( videoFlags & XC_VIDEO_FLAGS_HDTV_720p )
			{
				m_bInitVideo = true ;
				m_xboxVidmode = 2 ;
			}
			else if ( videoFlags & XC_VIDEO_FLAGS_HDTV_1080i )
			{
				m_bInitVideo = true ;
				m_xboxVidmode = 3 ;
			}
		}

	}

	D3DPRESENT_PARAMETERS newpp ;
	memcpy( &newpp, &m_d3dpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;
	newpp.BackBufferFormat        = D3DFMT_LIN_R5G6B5 ;
	//newpp.BackBufferFormat       = D3DFMT_A8R8G8B8 ;

	if ( ( m_bInitVideo && m_xboxVidmode ) || ( m_bForcePal50 ) )
	{
		DWORD isValid = 1 ;
		DWORD XVidMode = XGetVideoFlags();




			switch ( m_xboxVidmode )
			{
				case 1 : 
				{
					if ( ( XVidMode & XC_VIDEO_FLAGS_HDTV_480p ) == 0 )
					{
						isValid = 0 ;
					}
					else
					{
						newpp.Flags = D3DPRESENTFLAG_PROGRESSIVE ;
						newpp.BackBufferFormat       = D3DFMT_A8R8G8B8 ;
					}
					break ;
				}
				case 2 : 
				{
					//newpp.Flags = D3DPRESENTFLAG_WIDESCREEN ;
					if ( ( XVidMode & XC_VIDEO_FLAGS_HDTV_720p ) == 0 )
					{
						isValid = 0 ;
					}
					else
					{
						newpp.Flags = D3DPRESENTFLAG_PROGRESSIVE | D3DPRESENTFLAG_WIDESCREEN ;
						newpp.BackBufferFormat       = D3DFMT_A8R8G8B8 ;
					}
					break ;
				}
				case 3 : 
				{
					if ( ( XVidMode & XC_VIDEO_FLAGS_HDTV_1080i ) == 0 )
					{
						isValid = 0 ;
					}
					else
					{
						newpp.Flags = D3DPRESENTFLAG_WIDESCREEN | D3DPRESENTFLAG_INTERLACED ;
					}
					break ;
				}
				case 4 :
				{
					if (XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I) 
					{
						if ( XGetVideoFlags() & XC_VIDEO_FLAGS_PAL_60Hz) 
						{
						}
						else
						{
							isValid = 0 ;
						}
					}
					break ;
				}
				case 5 :
				{
					if (XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I) 
					{
						newpp.FullScreen_RefreshRateInHz = 50 ;
					}
					else
					{
						isValid = 0 ;
					}
					break ;
				}
				default :
				{
					isValid = 0 ;
					break ;
				}
			}

			if ( !isValid )
			{
				m_xboxVidmode = 0 ;
			}

			newpp.BackBufferWidth        = VIDEOMODES[m_xboxVidmode].width;
			newpp.BackBufferHeight       = VIDEOMODES[m_xboxVidmode].height;

			if ( m_bForcePal50 )
			{
				if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
				{
					newpp.FullScreen_RefreshRateInHz = 50 ;
				}
			}

			if ( m_bForcePal50 || isValid )
			{


			}
	}
	else
	{
	}



				memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;

				recreate( &m_d3dpp ) ;
				memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;
				m_pd3dDevice->Reset(&newpp);
				memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;

				g_app->m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
									0x00000000, 0.0f, 0L );
				g_app->m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				g_app->m_pd3dDevice->SetFlickerFilter( m_nFlickerLevel ) ;
				if ( m_bSoften )
					g_app->m_pd3dDevice->SetSoftDisplayFilter( TRUE ) ;
