// DGen v1.10+
// Megadrive C++ module saving and loading

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "md.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "m68kcpu.h"

#ifdef __cplusplus
}
#endif


/*
gs0 genecyst save file INfo

GST\0 to start with

80-9f = d0-d7 almost certain
a0-bf = a0-a7 almost certain
c8    = pc    fairly certain
d0    = sr    fairly certain


112 Start of cram len 0x80
192 Start of vsram len 0x50
1e2-474 UNKNOWN sound info?
Start of z80 ram at 474 (they store 2000)
Start of RAM at 2478 almost certain (BYTE SWAPPED)
Start of VRAM at 12478
end of VRAM
*/

// NB - for load and save you don't need to use star_mz80_on/off
// Because stars/mz80 isn't actually used
#define fput(x,y) { if (fwrite(x,1,y,hand)!=y) goto save_error; }
#define fget(x,y) if (fread(x,1,y,hand)!=y) goto load_error;

extern int byteswap_memory(unsigned char *start,int len);


#ifdef __cplusplus
extern "C" {
#endif

FILE *saveloadfile ;

void save_value(char *cpuname, unsigned int cpuvalue)
{
	fwrite( &cpuvalue, sizeof(cpuvalue), 1, saveloadfile ) ;
}

unsigned int load_value(char *cpuname)
{
	unsigned int cpuvalue ;
	fread( &cpuvalue, sizeof(unsigned int), 1, saveloadfile ) ;

	return cpuvalue ;
}

#ifdef __cplusplus
}
#endif


int md::import_gst(FILE *hand)
{
#ifdef COMPILE_WITH_STAR
  if (cpu_emu==0)
  {
    fseek(hand,0x80,SEEK_SET);
    fget(cpu.dreg,8*4);
    fget(cpu.areg,8*4);
    fseek(hand,0xc8,SEEK_SET);
    fget(&cpu.pc,4);
    fseek(hand,0xd0,SEEK_SET);
    fget(&cpu.sr,4);
  }
#endif

#ifdef COMPILE_WITH_MUSA
  if (cpu_emu==1)
  {
    int i,t;
	void *z80context ;

	saveloadfile = hand ;

	fget( &m68ki_cpu, sizeof(m68ki_cpu) ) ;

	//m68k_load_context( &load_value ) ;


	z80context = malloc( z80_get_context_size() ) ;

	fget( z80context, z80_get_context_size() ) ;

	z80_set_context( z80context ) ;


	free( z80context ) ;

	fget( mem, 0x20000 ) ;

	fget( &z80_bank68k, sizeof( z80_bank68k ) ) ;
	fget( &z80_online, sizeof(z80_online) ) ;

	fget( &hint_countdown, sizeof(hint_countdown)) ;
	fget( &z80_extra_cycles, sizeof(z80_extra_cycles)) ;
	fget( &coo_waiting, sizeof(coo_waiting)) ;
	fget( &coo_cmd, sizeof(coo_cmd)) ;
	fget( &aoo3_toggle, sizeof(aoo3_toggle)) ;
	fget( &aoo5_toggle, sizeof(aoo5_toggle)) ;
	fget( &aoo3_six, sizeof(aoo3_six)) ;
	fget( &aoo5_six, sizeof(aoo5_six)) ;
	fget( &aoo3_six_timeout, sizeof(aoo3_six_timeout)) ;
	fget( &aoo5_six_timeout, sizeof(aoo5_six_timeout)) ;

  //int fm_sel[2],fm_tover[2],ras_fm_ticker[4];
  //signed short fm_reg[2][0x100]; // ALL of them (-1 = not defined yet)

	fget( fm_sel, 2*sizeof(int)) ;
	fget( fm_tover, 2*sizeof(int)) ;
	fget( ras_fm_ticker, 4*sizeof(int)) ;
	fget( fm_reg, 0x200 * sizeof(signed short)) ;
	

	fget( &dac_data, sizeof(dac_data)) ;
	fget( &dac_enable, sizeof(dac_enable)) ;
	fget( &odo, sizeof(odo)) ;
	fget( &odo_line_start, sizeof(odo_line_start)) ;
	fget( &odo_line_len, sizeof(odo_line_len)) ;
	fget( &ras, sizeof(ras)) ;
	fget( &z80_int_pending, sizeof(z80_int_pending)) ;
	fget( &mjazz, sizeof(mjazz)) ;
	fget( &layer_sel, sizeof(layer_sel)) ;
	fget( &coo4, sizeof(coo4)) ;
	fget( &coo5, sizeof(coo5)) ;



	fget( vdp.mem, 0x10100+0x35 ) ;
	fget( vdp.highpal, 64*sizeof(unsigned int)) ;
	fget(vdp.reg,0x20);

	fget(&(vdp.rw_mode), sizeof( vdp.rw_mode)) ;
	fget( &(vdp.rw_addr), sizeof( vdp.rw_addr)) ;
	fget( &(vdp.rw_dma), sizeof(vdp.rw_dma)) ;

	fget( vdp.sprite_order, 0x101 ) ;
	fget( &(vdp.sprite_count), sizeof(vdp.sprite_count)) ;

	int holder ;

	fget( &holder, sizeof(holder) ) ;

	vdp.sprite_base = holder + vdp.vram ;


	memset(vdp.dirt,0xff,0x35); // mark everything as changed

/*












	fget(vdp.reg,0x18);

	fget(vdp.cram ,0x00080);
	byteswap_memory(vdp.cram,0x80);
	fget(vdp.vsram,0x00050);
	//  byteswap_memory(vdp.vsram,0x50);

	fget(z80ram,   0x02000);

	fget(ram,      0x10000);
	byteswap_memory(ram,0x10000);

	fget(vdp.vram ,0x10000);

	memset(vdp.dirt,0xff,0x35); // mark everything as changed

*/
    
/*

	fseek(hand,0x80,SEEK_SET);

	fget(&t,4);
	m68k_set_reg( M68K_REG_D0, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_D1, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_D2, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_D3, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_D4, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_D5, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_D6, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_D7, t );


	fget(&t,4);
	m68k_set_reg( M68K_REG_A0, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_A1, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_A2, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_A3, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_A4, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_A5, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_A6, t );
	fget(&t,4);
	m68k_set_reg( M68K_REG_A7, t );
    
    fseek(hand,0xc8,SEEK_SET);
	fget(&t,4);
	m68k_set_reg( M68K_REG_PC, t );

    fseek(hand,0xd0,SEEK_SET);
	fget(&t,4);
	m68k_set_reg( M68K_REG_SR, t );
*/
	  /*
    for (i=0;i<8;i++)
    { fget(&t,4); m68k_poke_dr(i,t); }
    for (i=0;i<8;i++)
    { fget(&t,4); m68k_poke_ar(i,t); }

    fget(&t,4); m68k_poke_pc(t);

    fseek(hand,0xd0,SEEK_SET);
    fget(&t,4); m68k_poke_sr(t);
	*/
  }
#endif
/*
  fseek(hand,0xfa,SEEK_SET);
  fget(vdp.reg,0x18);

  fseek(hand,0x112,SEEK_SET);
  fget(vdp.cram ,0x00080);
  byteswap_memory(vdp.cram,0x80);
  fget(vdp.vsram,0x00050);
//  byteswap_memory(vdp.vsram,0x50);

  fseek(hand,0x474,SEEK_SET);
  fget(z80ram,   0x02000);

  fseek(hand,0x2478,SEEK_SET);
  fget(ram,      0x10000);
  byteswap_memory(ram,0x10000);

  fget(vdp.vram ,0x10000);

  memset(vdp.dirt,0xff,0x35); // mark everything as changed
*/
  return 0;
load_error:
  return 1;
}


int md::export_gst(FILE *hand)
{
  int i;

#ifdef COMPILE_WITH_STAR
  if (cpu_emu==0)
  {
    fput(cpu.dreg,8*4);
    fput(cpu.areg,8*4);
    fput(&cpu.pc,4);
    fput(&cpu.sr,4);
  }
#endif
#ifdef COMPILE_WITH_MUSA
  if (cpu_emu==1)
  {
    int i,t;
	void *z80context ;

	saveloadfile = hand ;


	fput( &m68ki_cpu, sizeof(m68ki_cpu) ) ;

	//m68k_save_context( &save_value ) ;

	z80context = malloc( z80_get_context_size() ) ;
	z80_get_context( z80context ) ;

	fput( z80context, z80_get_context_size() ) ;

	free( z80context ) ;

	fput( mem, 0x20000 ) ;

	fput( &z80_bank68k, sizeof( z80_bank68k ) ) ;
	fput( &z80_online, sizeof(z80_online) ) ;

	fput( &hint_countdown, sizeof(hint_countdown)) ;
	fput( &z80_extra_cycles, sizeof(z80_extra_cycles)) ;
	fput( &coo_waiting, sizeof(coo_waiting)) ;
	fput( &coo_cmd, sizeof(coo_cmd)) ;
	fput( &aoo3_toggle, sizeof(aoo3_toggle)) ;
	fput( &aoo5_toggle, sizeof(aoo5_toggle)) ;
	fput( &aoo3_six, sizeof(aoo3_six)) ;
	fput( &aoo5_six, sizeof(aoo5_six)) ;
	fput( &aoo3_six_timeout, sizeof(aoo3_six_timeout)) ;
	fput( &aoo5_six_timeout, sizeof(aoo5_six_timeout)) ;

  //int fm_sel[2],fm_tover[2],ras_fm_ticker[4];
  //signed short fm_reg[2][0x100]; // ALL of them (-1 = not defined yet)

	fput( fm_sel, 2*sizeof(int)) ;
	fput( fm_tover, 2*sizeof(int)) ;
	fput( ras_fm_ticker, 4*sizeof(int)) ;
	fput( fm_reg, 0x200 * sizeof(signed short)) ;
	

	fput( &dac_data, sizeof(dac_data)) ;
	fput( &dac_enable, sizeof(dac_enable)) ;
	fput( &odo, sizeof(odo)) ;
	fput( &odo_line_start, sizeof(odo_line_start)) ;
	fput( &odo_line_len, sizeof(odo_line_len)) ;
	fput( &ras, sizeof(ras)) ;
	fput( &z80_int_pending, sizeof(z80_int_pending)) ;
	fput( &mjazz, sizeof(mjazz)) ;
	fput( &layer_sel, sizeof(layer_sel)) ;
	fput( &coo4, sizeof(coo4)) ;
	fput( &coo5, sizeof(coo5)) ;



	fput( vdp.mem, 0x10100+0x35 ) ;
	fput( vdp.highpal, 64*sizeof(unsigned int)) ;
	fput(vdp.reg,0x20);

	fput(&(vdp.rw_mode), sizeof( vdp.rw_mode)) ;
	fput( &(vdp.rw_addr), sizeof( vdp.rw_addr)) ;
	fput( &(vdp.rw_dma), sizeof(vdp.rw_dma)) ;

	fput( vdp.sprite_order, 0x101 ) ;
	fput( &(vdp.sprite_count), sizeof(vdp.sprite_count)) ;


	int holder ;

	holder = vdp.sprite_base - vdp.vram ;

	fput( &holder, sizeof(holder) ) ;

//  unsigned char sprite_order[0x101], *sprite_base;
//  unsigned sprite_count, Bpp, Bpp_times8;
//  unsigned char *dest;

/*

	byteswap_memory(vdp.cram,0x80);
	fput(vdp.cram ,0x00080);
	byteswap_memory(vdp.cram,0x80);
	fput(vdp.vsram,0x00050);

	fput(z80ram,   0x02000);

	byteswap_memory(ram,0x10000);
	fput(ram,      0x10000);
	byteswap_memory(ram,0x10000);

	fput(vdp.vram ,0x10000);
*/
  /*
    fseek(hand,0x80,SEEK_SET);
    for (i=0;i<8;i++)
    { t=m68k_peek_dr(i); fput(&t,4);}
    for (i=0;i<8;i++)
    { t=m68k_peek_ar(i); fput(&t,4);}

    fseek(hand,0xc8,SEEK_SET);
    t=m68k_peek_pc(); fput(&t,4);

    fseek(hand,0xd0,SEEK_SET);
    t=m68k_peek_sr(); fput(&t,4);
*/
  }
#endif

/*


  static unsigned char gst_head[0x80]=
  {
       0x47,0x53,0x54,0,0,0,0xe0,0x40

  //     00 00 00 00 00 00 00 00 00 00 00 00 00 21 80 fa   <.............!..>
  };
  unsigned char *zeros=gst_head+0x40; // 0x40 zeros

  fseek(hand,0x00,SEEK_SET);
  // Make file size 0x22478 with zeros
  for (i=0;i<0x22440;i+=0x40) fput(zeros,0x40);
  fput(zeros,0x38);

  fseek(hand,0x00,SEEK_SET);
  fput(gst_head,0x80);


  fseek(hand,0xfa,SEEK_SET);
  fput(vdp.reg,0x18);

  fseek(hand,0x112,SEEK_SET);
  byteswap_memory(vdp.cram,0x80);
  fput(vdp.cram ,0x00080);
  byteswap_memory(vdp.cram,0x80);
//  byteswap_memory(vdp.vsram,0x50);
  fput(vdp.vsram,0x00050);
//  byteswap_memory(vdp.vsram,0x50);

  fseek(hand,0x474,SEEK_SET);
  fput(z80ram,   0x02000);

  fseek(hand,0x2478,SEEK_SET);
  byteswap_memory(ram,0x10000);
  fput(ram,      0x10000);
  byteswap_memory(ram,0x10000);

  fput(vdp.vram ,0x10000);
*/
  return 0;
save_error:
  return 1;
}

